/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.CharIterator;
import kotlin.Charsets;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinMultifileClassPart(version={1, 0, 1}, abiVersion=32, data={"1\u0004)\u0001!B\u0001\r\u0003\u0015\t\u0001bB\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0013\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\rQ!\u0001E\r\u000b\u0001)\u0011\u0001#\u0006\u0006\u0003\u0011)Q!\u0001E\u0006\u000b\u0005!\u0019!B\u0001\t\u000e\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0005\u0007\u000b\u0005!1!B\u0001\r\u0003\u0015\u0001Q!\u0001E\t\u000b\u0005A\u0001!B\u0001\u0005\u0007\u0015\t\u0001\"A\u0003\u0002\t3)\u0011\u0001\u0003\t\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001#\u0002\u0006\u0003\u0011\u0019Q!\u0001\u0005\u0004\u000b\u0001)\u0011\u0001c\u0002\u0006\u0003\u0011\tQ!\u0001E\u0005\u000b\u0005!!!B\u0001\t\u000b\u0015\u0001Q\u0012\u0003E\u0004\u001b\u0005A\u0012!G\u0002\t\t5\t\u0001\u0014\u0002+\u0004\u00075E\u0001rA\u0007\u00021\u0005I2\u0001C\u0003\u000e\u0003a-AkA\u0002\u000e\u0012!\u001dQ\"\u0001\r\u00023\rAa!D\u0001\u0019\u000eQ\u001b1!$\u0007\t\b5\t\u0001$A\r\u0004\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\b)\u000e\u0019Q\u0012\u0005E\u0004\u001b\u0005A\u0012!G\u0002\t\r5\t\u0001TB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!IQ\"\u0001M\t)\u000e\u0019Q\u0012\u0006E\u0004\u001b\u0005A\u0012!G\u0002\t\r5\t\u0001TB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!IQ\"\u0001M\t3\rAq!D\u0001\u0019\u0010Q\u001b1!$\u000b\t\b5\t\u0001$A\r\u0004\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!AQ\"\u0001M\t3\rA\u0011\"D\u0001\u0019\u0012e\u0019\u00012C\u0007\u00021\u0005!6aAG\r\u0011\u000fi\u0011\u0001G\u0001\u001a\u0007!1Q\"\u0001M\u00073\rA\u0019\"D\u0001\u0019\u0003Q\u001b1!$\u0005\t\b5\t\u0001$A\r\u0004\u0011)i\u0011\u0001'\u0006U\u0007\ri\t\u0003c\u0002\u000e\u0003a\t\u0011d\u0001\u0005\u000b\u001b\u0005A*\"G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011%i\u0011\u0001'\u0005U\u0007\ri\t\u0003c\u0002\u000e\u0003a\t\u0011d\u0001\u0005\f\u001b\u0005A:\"G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011%i\u0011\u0001'\u0005U\u0007\rii\u0001\u0003\u0007\u000e\u0003a\tQ#\u0001\r\u0002)\u000e\u0019Q\u0002\u0004E\r\u001b\u0005A\n\"F\u0001\u0019\u0003e%\u0001\"D\u0007\u00021#\u00016\u0011\u0001+\u0004\u00075a\u00012D\u0007\u00021#)\u0012\u0001G\u0001\u001a\n!iQ\"\u0001M\t!\u000e\u0005AkA\u0002\u000e$!qQ\"\u0001M\t+\u0005A\u0012!'\u0003\t\u001e5\t\u0001\u0014\u0003)\u0004\u0002e%\u0001bD\u0007\u00021#\u00016!\u0001+\u0004\u00075\u0015\u0002rD\u0007\u00021#)\u0012\u0001G\u0001\u001a\n!\u0001R\"\u0001\r\u0002!\u000e\u0005\u00114\u0002\u0003\u0002\u0011Ci\u0011\u0001G\tQ\u0007\u0005!6aA\u0007\r\u0011Gi\u0011\u0001G\u0001\u0016\u0003a\t\u0011\u0014\u0002\u0005\u0011\u001b\u0005A\u0012\u0001UB\u0001)\u000e\u0019Q\u0002\u0004\u0005\u0013\u001b\u0005A\u0012#F\u0001\u0019\u0003e%\u0001\"B\u0007\u00021\u0013\u00016\u0011\u0001+\u0004\u00075a\u0001BE\u0007\u00021E)\u0012\u0001G\u0001\u001a\n!\u0015R\"\u0001\r\u0014!\u000e\u0005AkA\u0002\u000e\u000e!\u001dR\"\u0001\r\u0002+\u0005A\u0012\u0001V\u0002\u0004\u001b\u0003\"1\t\u0005\u0005\u0015\u001b\u0005!K#\u0005\u0003\u0005\u0001!%R#\u0001\r\u0016+\u0005A2#'\u0003\t,5\tA\u0015\u0006)\u0004\u0002eU\u0001BF\u0007\b\u0013\tI\u0011\u0001G\f\n\u0005%\t\u0001$\u0005M\u0017!\u000e\t\u0011kA\u0001\t0Q\u001b1!$\n\t15\t\u0001$E\u000b\u00021\u0005IJ\u0001#\r\u000e\u0003a\t\u0001k!\u0001\u001a\f\u0011\t\u0001\u0012E\u0007\u00021E\u00016!\u0001+\u0004\u00075%\u0002\"G\u0007\u00021E)\"\u0001$\u0001\u0019\u0003e-\u0001\u0002E\u0007\u0003\u0019\u0003A\u0012\u0001UB\u00013\u0017!\u0011\u0001#\t\u000e\u0003a\t\u0002kA\u0001U\u0007\riA\u0004c\r\u000e\u0003a\tQ#\u0001\r\u00023\u0013A!$D\u0001\u00196A\u001b\t!'\u0007\t751\u0011\u0002\u0002C\u0001\u0013\ta\t\u0001\u0007\u000f\u00198E\u0011A\u0012\u0001\r\u001d!\u000e\t\u0011kA\u0001\t:Q\u001b1!$\f\t45\t\u0001$A\u000b\u00021\u0005IJ\u0002C\u000e\u000e\r%!A\u0011A\u0005\u0003\u0019\u0003AB\u0004g\u000e\u0012\u00051\u0005\u0001\u0004\b)\u0004\u0002E\u001b\u0011\u0001C\u000fU\u0007\ri1\u0003b\"\u0005\u0011wi\u0011\u0001G\n\u0016\u0003a\u0019\u0012\u0014\u0002\u0005\u001f\u001b\u0005A\n\u0002UB\u00013\u0013Ai$D\u0001\u0019\u0012A\u001b\u0011\u0001V\u0002\u0004\u001bw!9\u0001C\u0010\u000e\u0003a}R#\u0001\r\u00023\u0013A\u0001%D\u0001\u0019\u0012A\u001b\t!'\u0003\tB5\t\u0001\u0014\u0003)\u0004\u0003e%\u0001\"I\u0007\u00021+\u000161AM\u0005\u0011\u0007j\u0011\u0001'\u0005Q\u0007\t!6aAG\u0007\u0011\tj\u0011\u0001G\u0001\u0016\u0003a\tAkA\u0002\u000e\u000e!\u0015S\"\u0001\r\u0012+\u0005A2\u0003V\u0002\u0004\u001bK!\u0001\u0001C\u0012\u000e\u0003aEQ#\u0001\r\u00023\u0013A9%D\u0001\u0019/A\u001b\t!'\u0003\tI5\t\u0001\u0014\u0003)\u0004\u0003Q\u001b1!$\n\u0005\u0001!\u0019S\"\u0001M\t+\u0005A\u0012!'\u0003\tJ5\t\u0001$\u0001)\u0004\u0002e%\u0001\u0002J\u0007\u00021#\u00016!\u0001+\u0004\u00075\u0015B\u0001\u0001\u0005&\u001b\u0005A\n\"F\u0001\u0019\u0003e%\u0001rI\u0007\u00021]\u00016\u0011AM\u0005\u0011\u0011j\u0011\u0001'\u0005Q\u0007\u0005!6aAG\u0013\t\u0001AQ%D\u0001\u0019\u0012U\t\u0001$AM\u0005\u0011\u0013j\u0011\u0001G\u0001Q\u0007\u0003IJ\u0001\u0003\u0013\u000e\u0003aE\u0001kA\u0001U\u0007\ri\u0019\u0003c\u0013\u000e\u0003aEQ#\u0001\r\u00023\u0013AQ\"D\u0001\u0019\u0012A\u001b\t!'\u0003\tM5\t\u0001\u0014\u0003)\u0004\u0003Q\u001b1!D\u0012\tN5\t\u0001$E\u000b\u00021MIJ\u0001C\u0014\u000e\u0003aE\u0001k!\u0001\u001a\n!\u0001R\"\u0001\r\u0014!\u000e\t\u0011\u0014\u0002E(\u001b\u0005A\n\u0002UB\u00023\u0013A\u0011\"D\u0001\u0019\u0012A\u001b!!g\u0003\u0005\u0003!\u0005R\"\u0001\r\u0012!\u000e\u0015AkA\u0002\u000eG!5S\"\u0001\r\u0012+\u0005A\u0012!'\u0003\tO5\t\u0001\u0014\u0003)\u0004\u0002e%\u0001\u0002E\u0007\u00021\u0005\u00016!AM\u0005\u0011\u001fj\u0011\u0001'\u0005Q\u0007\u0007IJ\u0001C\u0005\u000e\u0003aE\u0001k\u0001\u0002\u001a\f\u0011\t\u0001\u0012E\u0007\u00021E\u00016Q\u0001+\u0004\u00075a\u0001\u0002K\u0007\u00021\u0005)\u0012\u0001G\n\u001a\n!ES\"\u0001M\t!\u000e\u0005AkA\u0002\u000e1!IS\"\u0001\r\u0002+\u0005A\u0012!'\u0003\tT5\t\u0001d\u0006)\u0004\u0002e%\u0001BK\u0007\u00021]\u00016!AM\u0006\t\u0005A\t#D\u0001\u0019#A\u001b\u0019\u0001V\u0002\u0004\u001baA\u0011&D\u0001\u0019\u0003U\t\u0001$AM\u0005\u0011+j\u0011\u0001G\u0001Q\u0007\u0003IJ\u0001C\u0016\u000e\u0003a\t\u0001kA\u0001\u001a\f\u0011\t\u0001\u0012E\u0007\u00021E\u000161\u0001+\u0004\u00075A\u0002rK\u0007\u00021\u0005)\u0012\u0001G\u0001\u001a\n!MS\"\u0001\r\u0018!\u000e\u0005\u0011\u0014\u0002\u0005+\u001b\u0005Ar\u0003U\u0002\u00023\u0017!\u0011\u0001#\t\u000e\u0003a\t\u0002ka\u0001U\u0007\ri\u0001\u0004c\u0016\u000e\u0003a\tQ#\u0001\r\u00023\u0013A)&D\u0001\u0019\u0003A\u001b\t!'\u0003\tW5\t\u0001$\u0001)\u0004\u0003e-A!\u0001E\u0011\u001b\u0005A\u0012\u0003UB\u0002)\u000e\u0019Q2\u0006\u0005-\u001b\u0011I!!C\u0001\u0019\u0003aeS#\u0001\r\u00143\u0013AQ&D\u0001\u0019\\A\u001b\t!g\u0003\u0005\u0003!qS\"\u0001M\t!\u000e\tAkA\u0002\u000e&!uS\"\u0001\r\u0012+\u0005A\u0012!'\u0003\t_5\t\u0001$\u0001)\u0004\u0002e-A!\u0001E\u0011\u001b\u0005A\u0012\u0003U\u0002\u0002)\u000e\u0019Q\u0002\u0007E/\u001b\u0005A\u0012#F\u0001\u0019\u0003e%\u0001bL\u0007\u00021\u0005\u00016\u0011AM\u0005\u0011?j\u0011\u0001'\u0005Q\u0007\u0005IZ\u0001B\u0001\t\"5\t\u0001$\u0005)\u0004\u0004Q\u001b1!\u0004\u0007\ta5\t\u0001$A\u000b\u00021\u0005IJ\u0001c\u0018\u000e\u0003aE\u0001k!\u0001U\u0007\ri\u0019\u0003\u0003\u0019\u000e\u0003a\tQ#\u0001\r\u00023\u0013Ay&D\u0001\u0019\u0012A\u001b\t!'\u0003\t\u001f5\t\u0001\u0014\u0003)\u0004\u0003Q\u001b1!$\u0011\u0005\u0007BA\t'D\u0001%*E!A\u0001\u0001E\u0015+\u0005AR#F\u0001\u0019'e%\u00012F\u0007\u0002IS\u00016\u0011AM\u000b\u0011Yiq!\u0003\u0002\n\u0003a9\u0012BA\u0005\u00021EAj\u0003U\u0002\u0002#\u000e\t\u0001r\u0006+\u0004\u000755\u0001\"M\u0007\u00021E)\u0012\u0001G\u0001U\u0007\rii\u0001c\u0019\u000e\u0003a\u0011T#\u0001\r\u0002)\u000e\u0019Q\"\u0004E3\u001b\u0005Aj!F\u0001\u0019\u0003e-A!\u0001\u0005\b\u001b\u0005Az\u0001UB\u0001)\u000e\u0019Q\u0002\u0004E3\u001b\u0005Aj!F\u0001\u0019\u0003e%\u0001bB\u0007\u00021\u0005\u00016\u0011\u0001+\u0004\u000755\u0001bM\u0007\u00021+)\u0012\u0001G\u0001U\u0007\riy\u0004C\u001a\u000e\u0003aUQ#\u0001\r\u00023\u0013A9'D\u0001\u0019\u0016A\u001b\t!g\u0003\u0005\u0003!!T\"\u0001M\t!\u000e\t\u00114\u0002\u0003\u0002\u0011?j\u0011\u0001'\u0005Q\u0007\u0007IZ\u0001B\u0001\t\u001f5\t\u0001\u0014\u0003)\u0004\u0005Q\u001b1!$\u0006\u0005\b!%T\u0002B\u0005\u0003\u0013\u0005Ar\u0003'\u0017\u0016\u0003a\tAkA\u0002\u000e\u000e!)T\"\u0001M6+\u0005A\u0012\u0001V\u0002\u0004\u001b\u001bAa'D\u0001\u0019nU\t\u0001$\u0001+\u0004\u000755\u0001bN\u0007\u00021#)\u0012\u0001G\u0001U\u0007\rii\u0001c\u001c\u000e\u0003aAT#\u0001\r\u0002)\u000e\u0019QR\u0002E9\u001b\u0005A\u0012!F\u0001\u0019\u0003Q\u001b1!\u0004\u0007\tr5\t\u0001$A\u000b\u00021\u0005IJ\u0001\u0003\u000e\u000e\u0003aU\u0002k!\u0001U\u0007\riQ\u0002C\u001d\u000e\u0003amS#\u0001\r\u00023\u0017!\u0011\u0001c\u001d\u000e\u0003aE\u0001k!\u0001U\u0007\rii\u0001\u0003\u001e\u000e\u0003aUT#\u0001\r\u0002)\u000e\u0019QR\u0002\u0005<\u001b\u0005A\u0012!F\u0001\u0019\u0003Q\u001b1!\u0004\u0007\tw5\t\u0001$A\u000b\u00021\u0005IJ\u0001\u0003\u000e\u000e\u0003aU\u0002k!\u0001U\u0007\r\t\n\u0003B\"\t\u0011\u0001iA!\u0003\u0002\n\u0003a\t\u0001\u0014A\u000b\u00021\u0007a2%U\u0002\u0004\u001b\t!!\u0001#\u0002U\u0007\r\u0001"}, strings={"CASE_INSENSITIVE_ORDER", "Ljava/util/Comparator;", "", "Lkotlin/String$Companion;", "getCASE_INSENSITIVE_ORDER", "(Lkotlin/jvm/internal/StringCompanionObject;)Ljava/util/Comparator;", "StringsKt__StringsJVMKt", "String", "stringBuffer", "Ljava/lang/StringBuffer;", "stringBuilder", "Ljava/lang/StringBuilder;", "bytes", "", "charset", "Ljava/nio/charset/Charset;", "offset", "", "length", "charsetName", "chars", "", "codePoints", "", "capitalize", "codePointAt", "index", "codePointBefore", "codePointCount", "beginIndex", "endIndex", "compareTo", "other", "ignoreCase", "", "concat", "contentEquals", "charSequence", "", "decapitalize", "dropWhileTo", "T", "Ljava/lang/Appendable;", "result", "predicate", "Lkotlin/Function1;", "", "(Ljava/lang/CharSequence;Ljava/lang/Appendable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Appendable;", "endsWith", "suffix", "equals", "format", "locale", "Ljava/util/Locale;", "args", "", "", "(Ljava/lang/String;Ljava/util/Locale;[Ljava/lang/Object;)Ljava/lang/String;", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "get", "start", "end", "getChars", "", "srcBegin", "srcEnd", "dst", "dstBegin", "intern", "isBlank", "nativeIndexOf", "ch", "fromIndex", "str", "nativeLastIndexOf", "offsetByCodePoints", "codePointOffset", "regionMatches", "thisOffset", "otherOffset", "repeat", "n", "replace", "oldChar", "newChar", "oldValue", "newValue", "replaceFirst", "split", "", "regex", "Ljava/util/regex/Pattern;", "limit", "startsWith", "prefix", "startIndex", "substring", "takeWhileTo", "toBoolean", "toByte", "", "toByteArray", "toCharArray", "destination", "destinationOffset", "toCharList", "toDouble", "", "toFloat", "", "toInt", "toLong", "", "toLowerCase", "toPattern", "flags", "toShort", "", "toUpperCase"}, multifileClassName="kotlin/text/StringsKt")
final class StringsKt__StringsJVMKt {
    public static final int nativeIndexOf(String $receiver, char ch, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.indexOf(ch, fromIndex);
    }

    public static final int nativeIndexOf(String $receiver, @NotNull String str, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.indexOf(str, fromIndex);
    }

    public static final int nativeLastIndexOf(String $receiver, char ch, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.lastIndexOf(ch, fromIndex);
    }

    public static final int nativeLastIndexOf(String $receiver, @NotNull String str, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.lastIndexOf(str, fromIndex);
    }

    public static final boolean equals(String $receiver, @Nullable String other, boolean ignoreCase) {
        boolean bl;
        if ($receiver == null) {
            return other == null;
        }
        if (!ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string.equals(other);
        } else {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string.equalsIgnoreCase(other);
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean equals$default(String string, String string2, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.equals(string, string2, bl);
    }

    @NotNull
    public static final String replace(String $receiver, char oldChar, char newChar, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.replace(oldChar, newChar);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026replace(oldChar, newChar)");
            return string2;
        }
        int n = 0;
        char[] cArray = new char[]{oldChar};
        boolean bl = ignoreCase;
        return SequencesKt.joinToString$default(StringsKt.splitToSequence$default((CharSequence)$receiver, cArray, bl, n, 4), (CharSequence)String.valueOf(newChar), null, null, 0, null, null, 62);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String replace$default(String string, char c, char c2, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return StringsKt.replace(string, c, c2, bl);
    }

    @NotNull
    public static final String replace(String $receiver, @NotNull String oldValue, @NotNull String newValue, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        int n = 0;
        String[] stringArray = new String[]{oldValue};
        boolean bl = ignoreCase;
        return SequencesKt.joinToString$default(StringsKt.splitToSequence$default((CharSequence)$receiver, stringArray, bl, n, 4), (CharSequence)newValue, null, null, 0, null, null, 62);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String replace$default(String string, String string2, String string3, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return StringsKt.replace(string, string2, string3, bl);
    }

    @NotNull
    public static final String replaceFirst(String $receiver, char oldChar, char newChar, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int index = StringsKt.indexOf$default((CharSequence)$receiver, oldChar, 0, ignoreCase, 2);
        return index < 0 ? $receiver : StringsKt.replaceRange($receiver, index, index + 1, (CharSequence)String.valueOf(newChar));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String replaceFirst$default(String string, char c, char c2, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return StringsKt.replaceFirst(string, c, c2, bl);
    }

    @NotNull
    public static final String replaceFirst(String $receiver, @NotNull String oldValue, @NotNull String newValue, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        int index = StringsKt.indexOf$default((CharSequence)$receiver, oldValue, 0, ignoreCase, 2);
        return index < 0 ? $receiver : StringsKt.replaceRange($receiver, index, index + oldValue.length(), (CharSequence)newValue);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String replaceFirst$default(String string, String string2, String string3, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return StringsKt.replaceFirst(string, string2, string3, bl);
    }

    @NotNull
    public static final String toUpperCase(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        return string2;
    }

    @NotNull
    public static final String toLowerCase(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    @NotNull
    public static final char[] toCharArray(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        return cArray;
    }

    @NotNull
    public static final char[] toCharArray(String $receiver, @NotNull char[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        string.getChars(startIndex, endIndex, destination, destinationOffset);
        return destination;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ char[] toCharArray$default(String string, char[] cArray, int n, int n2, int n3, int n4) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = string.length();
        }
        return StringsKt.toCharArray(string, cArray, n, n2, n3);
    }

    @NotNull
    public static final String format(String $receiver, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String string = String.format($receiver, Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(this, *args)");
        return string;
    }

    @NotNull
    public static final String format(String $receiver, @NotNull Locale locale, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        String string = String.format(locale, $receiver, Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(locale, this, *args)");
        return string;
    }

    @NotNull
    public static final List<String> split(CharSequence $receiver, @NotNull Pattern regex, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        boolean value$iv = limit >= 0;
        if (!value$iv) {
            String message$iv = "Limit must be non-negative, but was " + limit;
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
        return ArraysKt.asList((Object[])regex.split($receiver, limit == 0 ? -1 : limit));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List split$default(CharSequence charSequence, Pattern pattern, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return StringsKt.split(charSequence, pattern, n);
    }

    @NotNull
    public static final String substring(String $receiver, int startIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(startIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        return string2;
    }

    @NotNull
    public static final String substring(String $receiver, int startIndex, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public static final boolean startsWith(String $receiver, @NotNull String prefix, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        if (!ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            return string.startsWith(prefix);
        }
        return StringsKt.regionMatches($receiver, 0, prefix, 0, prefix.length(), ignoreCase);
    }

    public static /* bridge */ /* synthetic */ boolean startsWith$default(String string, String string2, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(string, string2, bl);
    }

    public static final boolean startsWith(String $receiver, @NotNull String prefix, int startIndex, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        if (!ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            return string.startsWith(prefix, startIndex);
        }
        return StringsKt.regionMatches($receiver, startIndex, prefix, 0, prefix.length(), ignoreCase);
    }

    public static /* bridge */ /* synthetic */ boolean startsWith$default(String string, String string2, int n, boolean bl, int n2) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(string, string2, n, bl);
    }

    public static final boolean endsWith(String $receiver, @NotNull String suffix, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        if (!ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            return string.endsWith(suffix);
        }
        return StringsKt.regionMatches($receiver, $receiver.length() - suffix.length(), suffix, 0, suffix.length(), true);
    }

    public static /* bridge */ /* synthetic */ boolean endsWith$default(String string, String string2, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.endsWith(string, string2, bl);
    }

    @NotNull
    public static final String String(@NotNull byte[] bytes, int offset, int length, @NotNull String charsetName) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)charsetName, (String)"charsetName");
        return new String(bytes, offset, length, charsetName);
    }

    @NotNull
    public static final String String(@NotNull byte[] bytes, int offset, int length, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return new String(bytes, offset, length, charset);
    }

    @NotNull
    public static final String String(@NotNull byte[] bytes, @NotNull String charsetName) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)charsetName, (String)"charsetName");
        return new String(bytes, charsetName);
    }

    @NotNull
    public static final String String(@NotNull byte[] bytes, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return new String(bytes, charset);
    }

    @NotNull
    public static final String String(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return new String(bytes, offset, length, Charsets.getUTF_8());
    }

    @NotNull
    public static final String String(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return new String(bytes, Charsets.getUTF_8());
    }

    @NotNull
    public static final String String(@NotNull char[] chars) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return new String(chars);
    }

    @NotNull
    public static final String String(@NotNull char[] chars, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return new String(chars, offset, length);
    }

    @NotNull
    public static final String String(@NotNull int[] codePoints, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)codePoints, (String)"codePoints");
        return new String(codePoints, offset, length);
    }

    @NotNull
    public static final String String(@NotNull StringBuffer stringBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)stringBuffer, (String)"stringBuffer");
        return new String(stringBuffer);
    }

    @NotNull
    public static final String String(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)stringBuilder, (String)"stringBuilder");
        return new String(stringBuilder);
    }

    public static final int codePointAt(String $receiver, int index) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.codePointAt(index);
    }

    public static final int codePointBefore(String $receiver, int index) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.codePointBefore(index);
    }

    public static final int codePointCount(String $receiver, int beginIndex, int endIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.codePointCount(beginIndex, endIndex);
    }

    public static final int compareTo(String $receiver, @NotNull String other, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            return string.compareToIgnoreCase(other);
        }
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.compareTo(other);
    }

    public static /* bridge */ /* synthetic */ int compareTo$default(String string, String string2, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.compareTo(string, string2, bl);
    }

    @NotNull
    public static final String concat(String $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.concat(other);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).concat(other)");
        return string2;
    }

    public static final boolean contentEquals(String $receiver, @NotNull CharSequence charSequence) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.contentEquals(charSequence);
    }

    public static final boolean contentEquals(String $receiver, @NotNull StringBuffer stringBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)stringBuilder, (String)"stringBuilder");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.contentEquals(stringBuilder);
    }

    @Deprecated(message="Use toCharArray() instead.", replaceWith=@ReplaceWith(imports={}, expression="toCharArray(dst, dstBegin, srcBegin, srcEnd)"))
    public static final void getChars(String $receiver, int srcBegin, int srcEnd, @NotNull char[] dst, int dstBegin) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        string.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @NotNull
    public static final String intern(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.intern();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).intern()");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBlank(CharSequence $receiver) {
        Object element$iv;
        int it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.length() == 0) return true;
        Iterable $receiver$iv = (Iterable)StringsKt.getIndices($receiver);
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (CharsKt.isWhitespace($receiver.charAt(it = ((Number)(element$iv = iterator2.next())).intValue())));
        return false;
    }

    public static final int offsetByCodePoints(String $receiver, int index, int codePointOffset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        return string.offsetByCodePoints(index, codePointOffset);
    }

    public static final boolean regionMatches(CharSequence $receiver, int thisOffset, @NotNull CharSequence other, int otherOffset, int length, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if ($receiver instanceof String && other instanceof String) {
            return StringsKt.regionMatches((String)$receiver, thisOffset, (String)other, otherOffset, length, ignoreCase);
        }
        return StringsKt.regionMatchesImpl($receiver, thisOffset, other, otherOffset, length, ignoreCase);
    }

    public static /* bridge */ /* synthetic */ boolean regionMatches$default(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3, boolean bl, int n4) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        return StringsKt.regionMatches(charSequence, n, charSequence2, n2, n3, bl);
    }

    public static final boolean regionMatches(String $receiver, int thisOffset, @NotNull String other, int otherOffset, int length, boolean ignoreCase) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (!ignoreCase) {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string.regionMatches(thisOffset, other, otherOffset, length);
        } else {
            String string = $receiver;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string.regionMatches(ignoreCase, thisOffset, other, otherOffset, length);
        }
        return bl;
    }

    public static /* bridge */ /* synthetic */ boolean regionMatches$default(String string, int n, String string2, int n2, int n3, boolean bl, int n4) {
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        return StringsKt.regionMatches(string, n, string2, n2, n3, bl);
    }

    @NotNull
    public static final String toLowerCase(String $receiver, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        return string2;
    }

    @NotNull
    public static final String toUpperCase(String $receiver, @NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
        return string2;
    }

    public static final boolean toBoolean(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Boolean.parseBoolean($receiver);
    }

    public static final byte toByte(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Byte.parseByte($receiver);
    }

    public static final short toShort(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Short.parseShort($receiver);
    }

    public static final int toInt(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Integer.parseInt($receiver);
    }

    public static final long toLong(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Long.parseLong($receiver);
    }

    public static final float toFloat(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Float.parseFloat($receiver);
    }

    public static final double toDouble(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Double.parseDouble($receiver);
    }

    @Deprecated(message="Use toList() instead.", replaceWith=@ReplaceWith(imports={}, expression="toList()"))
    @NotNull
    public static final List<Character> toCharList(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ArraysKt.toList(StringsKt.toCharArray($receiver));
    }

    @Deprecated(message="Use subSequence(start, end) instead.", replaceWith=@ReplaceWith(imports={}, expression="subSequence(start, end)"))
    @NotNull
    public static final CharSequence get(CharSequence $receiver, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.subSequence(start, end);
    }

    @NotNull
    public static final byte[] toByteArray(String $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public static final byte[] toByteArray(String $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String string = $receiver;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ byte[] toByteArray$default(String string, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return StringsKt.toByteArray(string, charset);
    }

    @NotNull
    public static final Pattern toPattern(String $receiver, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Pattern pattern = Pattern.compile($receiver, flags);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
        return pattern;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Pattern toPattern$default(String string, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return StringsKt.toPattern(string, n);
    }

    @NotNull
    public static final String capitalize(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.isNotEmpty((CharSequence)$receiver) && CharsKt.isLowerCase(CollectionsKt.charAt($receiver, 0)) ? StringsKt.toUpperCase(StringsKt.substring($receiver, 0, 1)) + StringsKt.substring($receiver, 1) : $receiver;
    }

    @NotNull
    public static final String decapitalize(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.isNotEmpty((CharSequence)$receiver) && CharsKt.isUpperCase(CollectionsKt.charAt($receiver, 0)) ? StringsKt.toLowerCase(StringsKt.substring($receiver, 0, 1)) + StringsKt.substring($receiver, 1) : $receiver;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String repeat(CharSequence $receiver, int n) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (n < 0) {
            throw (Throwable)new IllegalArgumentException("Value should be non-negative, but was " + n);
        }
        StringBuilder sb = new StringBuilder(n * $receiver.length());
        int n2 = 1;
        int n3 = n;
        if (n2 <= n3) {
            while (true) {
                void i;
                sb.append($receiver);
                if (i == n3) break;
                ++i;
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final <T extends Appendable> T dropWhileTo(CharSequence $receiver, @NotNull T result, @NotNull Function1<? super Character, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        boolean start = true;
        CharIterator charIterator = StringsKt.iterator($receiver);
        while (charIterator.hasNext()) {
            char element = charIterator.nextChar();
            if (start && ((Boolean)predicate.invoke((Object)Character.valueOf(element))).booleanValue()) continue;
            start = false;
            result.append(element);
        }
        return result;
    }

    @NotNull
    public static final <T extends Appendable> T takeWhileTo(CharSequence $receiver, @NotNull T result, @NotNull Function1<? super Character, Boolean> predicate) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        CharIterator charIterator = StringsKt.iterator($receiver);
        while (charIterator.hasNext() && ((Boolean)predicate.invoke((Object)Character.valueOf(c = charIterator.nextChar()))).booleanValue()) {
            result.append(c);
        }
        return result;
    }

    @NotNull
    public static final Comparator<String> getCASE_INSENSITIVE_ORDER(StringCompanionObject $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Comparator comparator2 = String.CASE_INSENSITIVE_ORDER;
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"java.lang.String.CASE_INSENSITIVE_ORDER");
        return comparator2;
    }
}

