/*
 * Decompiled with CFR 0.152.
 */
package kotlin.test;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.Asserter;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u001a4\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u001a\u0012\u0010\r\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0001\u00a8\u0006\u0011"}, d2={"checkAbsoluteTolerance", "", "absoluteTolerance", "", "checkDoublesAreEqual", "expected", "actual", "message", "", "shouldFail", "", "checkFloatsAreEqual", "", "messagePrefix", "overrideAsserter", "Lkotlin/test/Asserter;", "value", "kotlin-test"})
public final class UtilsKt {
    @NotNull
    public static final String messagePrefix(@Nullable String message) {
        return message == null ? "" : Intrinsics.stringPlus((String)message, (Object)". ");
    }

    @PublishedApi
    @Nullable
    public static final Asserter overrideAsserter(@Nullable Asserter value) {
        Asserter asserter;
        Asserter it = asserter = AssertionsKt.get_asserter();
        boolean bl = false;
        AssertionsKt.set_asserter(value);
        return asserter;
    }

    private static final void checkAbsoluteTolerance(double absoluteTolerance) {
        boolean bl;
        boolean bl2 = bl = absoluteTolerance >= 0.0;
        if (!bl) {
            boolean $i$a$-require-UtilsKt$checkAbsoluteTolerance$32 = false;
            String $i$a$-require-UtilsKt$checkAbsoluteTolerance$32 = "Illegal negative absolute tolerance <" + absoluteTolerance + ">.";
            throw new IllegalArgumentException($i$a$-require-UtilsKt$checkAbsoluteTolerance$32.toString());
        }
        boolean bl3 = bl = !Double.isNaN(absoluteTolerance);
        if (!bl) {
            boolean bl4 = false;
            String string = "Illegal NaN absolute tolerance <" + absoluteTolerance + ">.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void checkDoublesAreEqual(double expected, double actual, double absoluteTolerance, @Nullable String message, boolean shouldFail) {
        UtilsKt.checkAbsoluteTolerance(absoluteTolerance);
        boolean equal = Double.doubleToLongBits(expected) == Double.doubleToLongBits(actual) || Math.abs(expected - actual) <= absoluteTolerance;
        AssertionsKt.getAsserter().assertTrue((Function0<String>)((Function0)new Function0<String>(message, expected, absoluteTolerance, actual){
            final /* synthetic */ String $message;
            final /* synthetic */ double $expected;
            final /* synthetic */ double $absoluteTolerance;
            final /* synthetic */ double $actual;
            {
                this.$message = $message;
                this.$expected = $expected;
                this.$absoluteTolerance = $absoluteTolerance;
                this.$actual = $actual;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return UtilsKt.messagePrefix(this.$message) + "Expected <" + this.$expected + "> with absolute tolerance <" + this.$absoluteTolerance + ">, actual <" + this.$actual + ">.";
            }
        }), equal != shouldFail);
    }

    public static /* synthetic */ void checkDoublesAreEqual$default(double d, double d2, double d3, String string, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        UtilsKt.checkDoublesAreEqual(d, d2, d3, string, bl);
    }

    public static final void checkFloatsAreEqual(float expected, float actual, float absoluteTolerance, @Nullable String message, boolean shouldFail) {
        UtilsKt.checkAbsoluteTolerance(absoluteTolerance);
        boolean equal = Float.floatToIntBits(expected) == Float.floatToIntBits(actual) || Math.abs(expected - actual) <= absoluteTolerance;
        AssertionsKt.getAsserter().assertTrue((Function0<String>)((Function0)new Function0<String>(message, expected, absoluteTolerance, actual){
            final /* synthetic */ String $message;
            final /* synthetic */ float $expected;
            final /* synthetic */ float $absoluteTolerance;
            final /* synthetic */ float $actual;
            {
                this.$message = $message;
                this.$expected = $expected;
                this.$absoluteTolerance = $absoluteTolerance;
                this.$actual = $actual;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return UtilsKt.messagePrefix(this.$message) + "Expected <" + this.$expected + "> with absolute tolerance <" + this.$absoluteTolerance + ">, actual <" + this.$actual + ">.";
            }
        }), equal != shouldFail);
    }

    public static /* synthetic */ void checkFloatsAreEqual$default(float f, float f2, float f3, String string, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        UtilsKt.checkFloatsAreEqual(f, f2, f3, string, bl);
    }
}

