/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.metadata.resolver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolverKt;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinLibraryResolver;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.library.metadata.resolver.impl.KotlinLibraryResolverResultImpl;
import org.jetbrains.kotlin.library.metadata.resolver.impl.KotlinResolvedLibraryImpl;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.util.WithLogger;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001f\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0012\u0010\u001f\u001a\u00020 *\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\t\u0010!\u001a\u00020\"X\u0096\u0005\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/library/metadata/resolver/impl/KotlinLibraryResolverImpl;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/metadata/resolver/KotlinLibraryResolver;", "Lorg/jetbrains/kotlin/util/WithLogger;", "searchPathResolver", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "resolveManifestDependenciesLenient", "", "<init>", "(Lorg/jetbrains/kotlin/library/SearchPathResolver;Z)V", "getSearchPathResolver", "()Lorg/jetbrains/kotlin/library/SearchPathResolver;", "getResolveManifestDependenciesLenient", "()Z", "resolveWithoutDependencies", "", "unresolvedLibraries", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "findLibraries", "leaveDistinct", "omitDuplicateNames", "warnOnLibraryDuplicates", "", "duplicatedPaths", "", "", "warnOnLibraryDuplicateNames", "resolveDependencies", "Lorg/jetbrains/kotlin/library/metadata/resolver/KotlinLibraryResolveResult;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "kotlin-util-klib-metadata"})
@SourceDebugExtension(value={"SMAP\nKotlinLibraryResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLibraryResolverImpl.kt\norg/jetbrains/kotlin/library/metadata/resolver/impl/KotlinLibraryResolverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,169:1\n1477#2:170\n1502#2,3:171\n1505#2,3:181\n1477#2:195\n1502#2,3:196\n1505#2,3:206\n1855#2,2:220\n1855#2,2:222\n1549#2:224\n1620#2,3:225\n1549#2:228\n1620#2,3:229\n1549#2:232\n1620#2,3:233\n372#3,7:174\n526#3:184\n511#3,6:185\n372#3,7:199\n526#3:209\n511#3,6:210\n125#4:191\n152#4,3:192\n125#4:216\n152#4,3:217\n*S KotlinDebug\n*F\n+ 1 KotlinLibraryResolverImpl.kt\norg/jetbrains/kotlin/library/metadata/resolver/impl/KotlinLibraryResolverImpl\n*L\n72#1:170\n72#1:171,3\n72#1:181,3\n83#1:195\n83#1:196,3\n83#1:206,3\n89#1:220,2\n93#1:222,2\n104#1:224\n104#1:225,3\n111#1:228\n111#1:229,3\n115#1:232\n115#1:233,3\n72#1:174,7\n73#1:184\n73#1:185,6\n83#1:199,7\n84#1:209\n84#1:210,6\n74#1:191\n74#1:192,3\n85#1:216\n85#1:217,3\n*E\n"})
public final class KotlinLibraryResolverImpl<L extends KotlinLibrary>
implements KotlinLibraryResolver<L>,
WithLogger {
    @NotNull
    private final SearchPathResolver<L> searchPathResolver;
    private final boolean resolveManifestDependenciesLenient;

    public KotlinLibraryResolverImpl(@NotNull SearchPathResolver<L> searchPathResolver, boolean resolveManifestDependenciesLenient) {
        Intrinsics.checkNotNullParameter(searchPathResolver, (String)"searchPathResolver");
        this.searchPathResolver = searchPathResolver;
        this.resolveManifestDependenciesLenient = resolveManifestDependenciesLenient;
    }

    @Override
    @NotNull
    public SearchPathResolver<L> getSearchPathResolver() {
        return this.searchPathResolver;
    }

    @NotNull
    public Logger getLogger() {
        return this.searchPathResolver.getLogger();
    }

    public final boolean getResolveManifestDependenciesLenient() {
        return this.resolveManifestDependenciesLenient;
    }

    @Override
    @NotNull
    public List<KotlinLibrary> resolveWithoutDependencies(@NotNull List<? extends UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        Intrinsics.checkNotNullParameter(unresolvedLibraries, (String)"unresolvedLibraries");
        return this.omitDuplicateNames(this.leaveDistinct(this.findLibraries(unresolvedLibraries, noStdLib, noDefaultLibs, noEndorsedLibs)));
    }

    private final List<KotlinLibrary> findLibraries(List<? extends UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        List userProvidedLibraries2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)unresolvedLibraries), (Function1)new Function1<UnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final L invoke(UnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (L)SearchPathResolverKt.resolve(this.this$0.getSearchPathResolver(), (UnresolvedLibrary)it);
            }
        }));
        List defaultLibraries = this.getSearchPathResolver().defaultLinks(noStdLib, noDefaultLibs, noEndorsedLibs);
        return CollectionsKt.plus((Collection)userProvidedLibraries2, (Iterable)defaultLibraries);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> leaveDistinct(List<? extends KotlinLibrary> $this$leaveDistinct) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$leaveDistinct;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary it = (KotlinLibrary)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = it.getLibraryFile().getAbsolutePath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map groupedByAbsolutePath = destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = groupedByAbsolutePath;
        Object object = this;
        boolean $i$f$filter = false;
        element$iv$iv2 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry it = element$iv$iv3 = iterator.next();
            boolean bl3 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        ((KotlinLibraryResolverImpl)object).warnOnLibraryDuplicates(destination$iv$iv2.keySet());
        Map $this$map$iv = groupedByAbsolutePath;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry it = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl4 = false;
            object.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> omitDuplicateNames(List<? extends KotlinLibrary> $this$omitDuplicateNames) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$omitDuplicateNames;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary it = (KotlinLibrary)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)it));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map groupedByUniqName = destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = groupedByUniqName;
        Object object = this;
        boolean $i$f$filter = false;
        element$iv$iv2 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry it = element$iv$iv3 = iterator.next();
            boolean bl3 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        ((KotlinLibraryResolverImpl)object).warnOnLibraryDuplicateNames(destination$iv$iv2.keySet());
        Map $this$map$iv = groupedByUniqName;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry it = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl4 = false;
            object.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
        }
        return (List)destination$iv$iv2;
    }

    private final void warnOnLibraryDuplicates(Iterable<String> duplicatedPaths) {
        Iterable<String> $this$forEach$iv = duplicatedPaths;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.getLogger().warning("library included more than once: " + it);
        }
    }

    private final void warnOnLibraryDuplicateNames(Iterable<String> duplicatedPaths) {
        Iterable<String> $this$forEach$iv = duplicatedPaths;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            boolean bl = false;
            this.getLogger().warning("duplicate library name: " + it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KotlinLibraryResolveResult resolveDependencies(@NotNull List<? extends KotlinLibrary> $this$resolveDependencies) {
        Collection destination$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$resolveDependencies, (String)"<this>");
        Iterable $this$map$iv2 = $this$resolveDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new KotlinResolvedLibraryImpl((KotlinLibrary)it));
        }
        List rootLibraries = (List)destination$iv$iv2;
        KotlinLibraryResolverResultImpl result = new KotlinLibraryResolverResultImpl(rootLibraries);
        Map cache = new LinkedHashMap();
        $this$mapTo$iv$iv2 = rootLibraries;
        object = cache;
        boolean $i$f$map2 = false;
        void $i$f$mapTo22 = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl = (KotlinResolvedLibraryImpl)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getLibrary().getLibraryFile().getFileKey(), (Object)it));
        }
        MapsKt.putAll((Map)object, (Iterable)((List)destination$iv$iv3));
        List newDependencies = rootLibraries;
        do {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = newDependencies;
            boolean $i$f$map3 = false;
            destination$iv$iv3 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void library;
                KotlinResolvedLibraryImpl bl = (KotlinResolvedLibraryImpl)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)KotlinLibraryKt.unresolvedDependencies((BaseKotlinLibrary)((BaseKotlinLibrary)library.getLibrary()), (boolean)this.resolveManifestDependenciesLenient)), (Function1)((Function1)new Function1<UnresolvedLibrary, Boolean>(this){
                    final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Boolean invoke(UnresolvedLibrary it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.getSearchPathResolver().isProvidedByDefault(it);
                    }
                })), (Function1)((Function1)new Function1<UnresolvedLibrary, KotlinResolvedLibraryImpl>(this){
                    final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final KotlinResolvedLibraryImpl invoke(UnresolvedLibrary it) {
                        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        KotlinLibrary kotlinLibrary = SearchPathResolverKt.resolve(this.this$0.getSearchPathResolver(), (UnresolvedLibrary)it);
                        if (kotlinLibrary != null) {
                            KotlinLibrary p0 = kotlinLibrary;
                            boolean bl = false;
                            kotlinResolvedLibraryImpl = new KotlinResolvedLibraryImpl(p0);
                        } else {
                            kotlinResolvedLibraryImpl = null;
                        }
                        return kotlinResolvedLibraryImpl;
                    }
                })), (Function1)((Function1)new Function1<KotlinResolvedLibraryImpl, KotlinResolvedLibraryImpl>((Map<Object, KotlinResolvedLibrary>)cache, (KotlinResolvedLibraryImpl)library){
                    final /* synthetic */ Map<Object, KotlinResolvedLibrary> $cache;
                    final /* synthetic */ KotlinResolvedLibraryImpl $library;
                    {
                        this.$cache = $cache;
                        this.$library = $library;
                        super(1);
                    }

                    public final KotlinResolvedLibraryImpl invoke(KotlinResolvedLibraryImpl resolved) {
                        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
                        Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
                        Object fileKey = resolved.getLibrary().getLibraryFile().getFileKey();
                        if (this.$cache.containsKey(fileKey)) {
                            KotlinResolvedLibrary kotlinResolvedLibrary = this.$cache.get(fileKey);
                            Intrinsics.checkNotNull((Object)kotlinResolvedLibrary);
                            this.$library.addDependency$kotlin_util_klib_metadata(kotlinResolvedLibrary);
                            kotlinResolvedLibraryImpl = null;
                        } else {
                            this.$cache.put(fileKey, resolved);
                            this.$library.addDependency$kotlin_util_klib_metadata(resolved);
                            kotlinResolvedLibraryImpl = resolved;
                        }
                        return kotlinResolvedLibraryImpl;
                    }
                })))));
            }
        } while (!((Collection)(newDependencies = CollectionsKt.flatten((Iterable)((List)destination$iv$iv)))).isEmpty());
        return result;
    }
}

