/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.locks;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.atomicfu.locks.ParkingSupport;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0005\u001f !\"#B7\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0005J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkotlinx/atomicfu/locks/NativeMutex;", "", "park", "Lkotlin/Function1;", "Lkotlin/time/Duration;", "", "unpark", "Ljava/lang/Thread;", "Lkotlinx/atomicfu/locks/ParkingHandle;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getPark", "()Lkotlin/jvm/functions/Function1;", "getUnpark", "parkingQueue", "Lkotlinx/atomicfu/locks/NativeMutex$ParkingQueue;", "owningThread", "Lkotlinx/atomicfu/AtomicRef;", "state", "Lkotlinx/atomicfu/AtomicInt;", "holdCount", "lock", "tryLock", "", "duration", "tryLock-LRDsOJo", "(J)Z", "unlock", "getQueueSize", "", "getQueueSize$atomicfu", "ParkingQueue", "Node", "Empty", "Awoken", "TimedOut", "atomicfu"})
@SourceDebugExtension(value={"SMAP\nNativeMutex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeMutex.kt\nkotlinx/atomicfu/locks/NativeMutex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public final class NativeMutex {
    @NotNull
    private final Function1<Duration, Unit> park;
    @NotNull
    private final Function1<Thread, Unit> unpark;
    @NotNull
    private final ParkingQueue parkingQueue;
    @NotNull
    private final AtomicRef<Thread> owningThread;
    @NotNull
    private final AtomicInt state;
    @NotNull
    private final AtomicInt holdCount;

    public NativeMutex(@NotNull Function1<? super Duration, Unit> park, @NotNull Function1<? super Thread, Unit> unpark) {
        Intrinsics.checkNotNullParameter(park, (String)"park");
        Intrinsics.checkNotNullParameter(unpark, (String)"unpark");
        this.park = park;
        this.unpark = unpark;
        this.parkingQueue = new ParkingQueue();
        this.owningThread = AtomicFU.atomic(null);
        this.state = AtomicFU.atomic(0);
        this.holdCount = AtomicFU.atomic(0);
    }

    public /* synthetic */ NativeMutex(Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = NativeMutex::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            function12 = (Function1)new Function1<Thread, Unit>((Object)ParkingSupport.INSTANCE){

                public final void invoke(Thread p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ParkingSupport)this.receiver).unpark(p0);
                }
            };
        }
        this((Function1<? super Duration, Unit>)function1, (Function1<? super Thread, Unit>)function12);
    }

    @NotNull
    public final Function1<Duration, Unit> getPark() {
        return this.park;
    }

    @NotNull
    public final Function1<Thread, Unit> getUnpark() {
        return this.unpark;
    }

    public final void lock() {
        this.tryLock-LRDsOJo(Duration.Companion.getINFINITE-UwyO8pc());
    }

    public final boolean tryLock-LRDsOJo(long duration) {
        Thread currentParkingHandle = ParkingSupport.INSTANCE.currentThreadHandle();
        if (this.holdCount.getValue() > 0 && Intrinsics.areEqual((Object)currentParkingHandle, (Object)this.owningThread.getValue())) {
            this.holdCount.incrementAndGet();
            return true;
        }
        int newState = this.state.incrementAndGet();
        if (!(newState > 0)) {
            boolean bl = false;
            String string = "Negative mutex state should not be possible";
            throw new IllegalStateException(string.toString());
        }
        if (newState == 1) {
            this.owningThread.setValue(currentParkingHandle);
            this.holdCount.incrementAndGet();
            return true;
        }
        Node prevNode = this.parkingQueue.enqueue();
        if (!prevNode.nodeWait-LRDsOJo(duration)) {
            return false;
        }
        this.parkingQueue.dequeue();
        this.owningThread.setValue(currentParkingHandle);
        this.holdCount.incrementAndGet();
        return true;
    }

    public final void unlock() {
        Thread currentOwnerId;
        Thread currentThreadId = ParkingSupport.INSTANCE.currentThreadHandle();
        if (!Intrinsics.areEqual((Object)currentThreadId, (Object)(currentOwnerId = this.owningThread.getValue()))) {
            boolean $i$a$-check-NativeMutex$unlock$42 = false;
            String $i$a$-check-NativeMutex$unlock$42 = "Thread is not holding the lock";
            throw new IllegalStateException($i$a$-check-NativeMutex$unlock$42.toString());
        }
        if (!(this.holdCount.getValue() > 0)) {
            boolean $i$a$-check-NativeMutex$unlock$52 = false;
            String $i$a$-check-NativeMutex$unlock$52 = "Thread unlocked more than it locked";
            throw new IllegalStateException($i$a$-check-NativeMutex$unlock$52.toString());
        }
        int newHoldCount = this.holdCount.decrementAndGet();
        if (newHoldCount > 0) {
            return;
        }
        int currentState = this.state.decrementAndGet();
        if (currentState == 0) {
            return;
        }
        if (!(currentState > 0)) {
            boolean bl = false;
            String string = "Negative mutex state should not be possible";
            throw new IllegalStateException(string.toString());
        }
        Node nextParker = this.parkingQueue.getHead();
        while (!nextParker.nodeWake()) {
            this.parkingQueue.dequeue();
            nextParker = this.parkingQueue.getHead();
            if (this.state.decrementAndGet() != 0) continue;
            return;
        }
    }

    public final boolean tryLock() {
        Thread currentThreadId = ParkingSupport.INSTANCE.currentThreadHandle();
        if (this.holdCount.getValue() > 0 && Intrinsics.areEqual((Object)this.owningThread.getValue(), (Object)currentThreadId) || this.state.compareAndSet(0, 1)) {
            this.owningThread.setValue(currentThreadId);
            this.holdCount.incrementAndGet();
            return true;
        }
        return false;
    }

    public final int getQueueSize$atomicfu() {
        int size = 0;
        Node node = this.parkingQueue.getHead();
        while (node != null) {
            node = node.getNext().getValue();
            ++size;
        }
        return size;
    }

    private static final Unit _init_$lambda$0(Duration it) {
        ParkingSupport.INSTANCE.park-LRDsOJo(it.unbox-impl());
        return Unit.INSTANCE;
    }

    public NativeMutex() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lkotlinx/atomicfu/locks/NativeMutex$Awoken;", "", "<init>", "()V", "atomicfu"})
    private static final class Awoken {
        @NotNull
        public static final Awoken INSTANCE = new Awoken();

        private Awoken() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lkotlinx/atomicfu/locks/NativeMutex$Empty;", "", "<init>", "()V", "atomicfu"})
    private static final class Empty {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0018\u00010\u0000R\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lkotlinx/atomicfu/locks/NativeMutex$Node;", "", "<init>", "(Lkotlinx/atomicfu/locks/NativeMutex;)V", "state", "Lkotlinx/atomicfu/AtomicRef;", "getState", "()Lkotlinx/atomicfu/AtomicRef;", "next", "Lkotlinx/atomicfu/locks/NativeMutex;", "getNext", "nodeWait", "", "duration", "Lkotlin/time/Duration;", "nodeWait-LRDsOJo", "(J)Z", "nodeWake", "atomicfu"})
    public final class Node {
        @NotNull
        private final AtomicRef<Object> state = AtomicFU.atomic(Empty.INSTANCE);
        @NotNull
        private final AtomicRef<Node> next = AtomicFU.atomic(null);

        @NotNull
        public final AtomicRef<Object> getState() {
            return this.state;
        }

        @NotNull
        public final AtomicRef<Node> getNext() {
            return this.next;
        }

        public final boolean nodeWait-LRDsOJo(long duration) {
            long deadline = TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)duration);
            while (true) {
                Object object;
                if (Intrinsics.areEqual((Object)(object = this.state.getValue()), (Object)Empty.INSTANCE)) {
                    if (!this.state.compareAndSet(Empty.INSTANCE, ParkingSupport.INSTANCE.currentThreadHandle())) continue;
                    NativeMutex.this.getPark().invoke((Object)Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)deadline, (long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto())));
                    if (TimeSource.Monotonic.ValueTimeMark.compareTo-6eNON_k((long)deadline, (long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()) >= 0) continue;
                    this.state.compareAndSet(ParkingSupport.INSTANCE.currentThreadHandle(), TimedOut.INSTANCE);
                    continue;
                }
                if (object instanceof Thread) {
                    NativeMutex.this.getPark().invoke((Object)Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)deadline, (long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto())));
                    if (TimeSource.Monotonic.ValueTimeMark.compareTo-6eNON_k((long)deadline, (long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()) >= 0) continue;
                    this.state.compareAndSet(ParkingSupport.INSTANCE.currentThreadHandle(), TimedOut.INSTANCE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)object, (Object)Awoken.INSTANCE)) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)object, (Object)TimedOut.INSTANCE)) break;
            }
            return false;
        }

        public final boolean nodeWake() {
            while (true) {
                Object currentState;
                if (Intrinsics.areEqual((Object)(currentState = this.state.getValue()), (Object)Empty.INSTANCE)) {
                    if (!this.state.compareAndSet(Empty.INSTANCE, Awoken.INSTANCE)) continue;
                    return true;
                }
                if (currentState instanceof Thread) {
                    if (!this.state.compareAndSet(currentState, Awoken.INSTANCE)) continue;
                    NativeMutex.this.getUnpark().invoke(currentState);
                    return true;
                }
                if (Intrinsics.areEqual((Object)currentState, (Object)Awoken.INSTANCE)) {
                    throw new IllegalStateException("Node is already woken");
                }
                if (Intrinsics.areEqual((Object)currentState, (Object)TimedOut.INSTANCE)) break;
            }
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\t\u001a\u00060\u0006R\u00020\u0007J\n\u0010\n\u001a\u00060\u0006R\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fR\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkotlinx/atomicfu/locks/NativeMutex$ParkingQueue;", "", "<init>", "(Lkotlinx/atomicfu/locks/NativeMutex;)V", "head", "Lkotlinx/atomicfu/AtomicRef;", "Lkotlinx/atomicfu/locks/NativeMutex$Node;", "Lkotlinx/atomicfu/locks/NativeMutex;", "tail", "getHead", "enqueue", "dequeue", "", "atomicfu"})
    public final class ParkingQueue {
        @NotNull
        private final AtomicRef<Node> head;
        @NotNull
        private final AtomicRef<Node> tail;

        public ParkingQueue() {
            Node first = new Node();
            this.head = AtomicFU.atomic(first);
            this.tail = AtomicFU.atomic(first);
        }

        @NotNull
        public final Node getHead() {
            return this.head.getValue();
        }

        @NotNull
        public final Node enqueue() {
            while (true) {
                Node node = new Node();
                Node curTail = this.tail.getValue();
                if (curTail.getNext().compareAndSet(null, node)) {
                    this.tail.compareAndSet(curTail, node);
                    return curTail;
                }
                Node node2 = curTail.getNext().getValue();
                Intrinsics.checkNotNull((Object)node2);
                this.tail.compareAndSet(curTail, node2);
            }
        }

        public final void dequeue() {
            Node currentHeadNext;
            Node currentHead;
            do {
                if ((currentHead = this.head.getValue()).getNext().getValue() != null) continue;
                throw new IllegalStateException("Dequeing parker but already empty, should not be possible");
            } while (!this.head.compareAndSet(currentHead, currentHeadNext));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lkotlinx/atomicfu/locks/NativeMutex$TimedOut;", "", "<init>", "()V", "atomicfu"})
    private static final class TimedOut {
        @NotNull
        public static final TimedOut INSTANCE = new TimedOut();

        private TimedOut() {
        }
    }
}

