/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.transformer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.transformer.AbortKt;
import kotlinx.atomicfu.transformer.AbortTransform;
import kotlinx.atomicfu.transformer.AsmUtilKt;
import kotlinx.atomicfu.transformer.AtomicFUTransformer;
import kotlinx.atomicfu.transformer.AtomicFUTransformerBase;
import kotlinx.atomicfu.transformer.AtomicFUTransformerKt;
import kotlinx.atomicfu.transformer.FieldId;
import kotlinx.atomicfu.transformer.FieldInfo;
import kotlinx.atomicfu.transformer.FlowAnalyzer;
import kotlinx.atomicfu.transformer.MetadataTransformer;
import kotlinx.atomicfu.transformer.MethodId;
import kotlinx.atomicfu.transformer.TransformerException;
import kotlinx.atomicfu.transformer.TypeInfo;
import kotlinx.atomicfu.transformer.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u00002\u00020\u0001:\u00066789:;B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\"\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020&H\u0002J\u0014\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020\u0004H\u0002J \u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u001dH\u0002J\b\u00102\u001a\u00020\u001aH\u0016J \u00103\u001a\u0002042\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u00105\u001a\u0002042\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006<"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase;", "classpath", "", "", "inputDir", "Ljava/io/File;", "outputDir", "variant", "Lkotlinx/atomicfu/transformer/Variant;", "(Ljava/util/List;Ljava/io/File;Ljava/io/File;Lkotlinx/atomicfu/transformer/Variant;)V", "accessors", "", "Lkotlinx/atomicfu/transformer/MethodId;", "Lkotlinx/atomicfu/transformer/FieldInfo;", "classPathLoader", "Ljava/net/URLClassLoader;", "fields", "Lkotlinx/atomicfu/transformer/FieldId;", "removeMethods", "", "getVariant", "()Lkotlinx/atomicfu/transformer/Variant;", "setVariant", "(Lkotlinx/atomicfu/transformer/Variant;)V", "analyzeFileForFields", "", "file", "analyzeFileForRefs", "", "vh", "analyzeFilesForFields", "files", "analyzeFilesForRefs", "", "descToName", "desc", "getPotentialAccessorType", "Lorg/objectweb/asm/Type;", "access", "", "className", "methodType", "loadClass", "Ljava/lang/Class;", "type", "registerField", "field", "fieldType", "isStatic", "transform", "transformFile", "", "bytes", "AccessorCollectorMV", "CV", "CW", "FieldsCollectorCV", "TransformerCV", "TransformerMV", "atomicfu-transformer"})
public final class AtomicFUTransformer
extends AtomicFUTransformerBase {
    private final URLClassLoader classPathLoader;
    private final Map<FieldId, FieldInfo> fields;
    private final Map<MethodId, FieldInfo> accessors;
    private final Set<MethodId> removeMethods;
    @NotNull
    private Variant variant;

    @Override
    public void transform() {
        AtomicFUTransformerBase.info$default(this, "Analyzing in " + this.getInputDir(), null, 2, null);
        List files2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.getInputDir(), null, (int)1, null)), (Function1)transform.files.1.INSTANCE));
        boolean needTransform = this.analyzeFilesForFields(files2);
        if (needTransform || Intrinsics.areEqual((Object)this.getOutputDir(), (Object)this.getInputDir())) {
            boolean vh = this.variant == Variant.VH;
            Set<File> needsTransform = this.analyzeFilesForRefs(files2, vh);
            AtomicFUTransformerBase.info$default(this, "Transforming to " + this.getOutputDir(), null, 2, null);
            Iterable $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                byte[] bytes = FilesKt.readBytes((File)file);
                byte[] outBytes = this.isClassFile(file) && needsTransform.contains(file) ? this.transformFile(file, bytes, vh) : bytes;
                File outFile = this.toOutputFile(file);
                this.mkdirsAndWrite(outFile, outBytes);
                if (this.variant != Variant.BOTH || outBytes == bytes) continue;
                byte[] vhBytes = this.transformFile(file, bytes, true);
                File file2 = this.div(this.div(this.div(this.getOutputDir(), "META-INF"), "versions"), "9");
                String string = FilesKt.relativeTo((File)file, (File)this.getInputDir()).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.relativeTo(inputDir).toString()");
                File vhFile = this.div(file2, string);
                this.mkdirsAndWrite(vhFile, vhBytes);
            }
        } else {
            AtomicFUTransformerBase.info$default(this, "Nothing to transform -- all classes are up to date", null, 2, null);
        }
    }

    private final boolean analyzeFilesForFields(List<? extends File> files2) {
        boolean needTransform = false;
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long outTime;
            File file = (File)element$iv;
            boolean bl = false;
            long inpTime = file.lastModified();
            if (inpTime > (outTime = this.toOutputFile(file).lastModified())) {
                needTransform = true;
            }
            if (!this.isClassFile(file)) continue;
            this.analyzeFileForFields(file);
        }
        if (this.getLastError() != null) {
            throw (Throwable)new TransformerException("Encountered errors while analyzing fields", this.getLastError());
        }
        return needTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void analyzeFileForFields(File file) {
        Object object = file;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl3 = false;
            new ClassReader((InputStream)it).accept((ClassVisitor)new FieldsCollectorCV(), 4);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final Set<File> analyzeFilesForRefs(List<? extends File> files2, boolean vh) {
        HashSet result = new HashSet();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            if (!this.isClassFile(file) || !this.analyzeFileForRefs(file, vh)) continue;
            Collection collection = result;
            boolean bl2 = false;
            collection.add(file);
        }
        if (this.getLastError() != null) {
            throw (Throwable)new TransformerException("Encountered errors while analyzing references", this.getLastError());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean analyzeFileForRefs(File file, boolean vh) {
        boolean bl;
        Object object = file;
        boolean bl2 = false;
        object = new FileInputStream((File)object);
        bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            block7: {
                FileInputStream input = (FileInputStream)object;
                boolean bl4 = false;
                this.setTransformed(false);
                TransformerCV cv = new TransformerCV(null, vh, true);
                try {
                    new ClassReader((InputStream)input).accept((ClassVisitor)cv, 4);
                }
                catch (Exception e) {
                    this.error("Failed to analyze: " + e, cv.getSourceInfo());
                    e.printStackTrace(System.out);
                    if (this.getLastError() != null) break block7;
                    this.setLastError(e);
                }
            }
            bl = this.getTransformed();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return bl;
    }

    private final byte[] transformFile(File file, byte[] bytes, boolean vh) {
        CW cw;
        block4: {
            this.setTransformed(false);
            cw = new CW();
            TransformerCV cv = new TransformerCV((ClassVisitor)cw, vh, false);
            try {
                new ClassReader((InputStream)new ByteArrayInputStream(bytes)).accept((ClassVisitor)cv, 4);
            }
            catch (Exception e) {
                this.error("Failed to transform: " + e, cv.getSourceInfo());
                e.printStackTrace(System.out);
                if (this.getLastError() != null) break block4;
                this.setLastError(e);
            }
        }
        if (!this.getTransformed()) {
            AtomicFUTransformerBase.error$default(this, "Invoked transformFile on a file that does not need transformation: " + file, null, 2, null);
        }
        if (this.getLastError() != null) {
            throw (Throwable)new TransformerException("Encountered errors while transforming: " + file, this.getLastError());
        }
        AtomicFUTransformerBase.info$default(this, "Transformed " + file, null, 2, null);
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    private final FieldInfo registerField(FieldId field, Type fieldType, boolean isStatic) {
        FieldInfo result;
        FieldInfo fieldInfo;
        Map<FieldId, FieldInfo> $this$getOrPut$iv = this.fields;
        boolean $i$f$getOrPut = false;
        FieldInfo value$iv = $this$getOrPut$iv.get(field);
        if (value$iv == null) {
            boolean bl = false;
            FieldInfo answer$iv = new FieldInfo(field, fieldType, isStatic);
            $this$getOrPut$iv.put(field, answer$iv);
            fieldInfo = answer$iv;
        } else {
            fieldInfo = value$iv;
        }
        if (Intrinsics.areEqual((Object)(result = fieldInfo).getFieldType(), (Object)fieldType) ^ true) {
            Void void_ = AbortKt.abort$default(field + " type mismatch between " + fieldType + " and " + result.getFieldType(), null, 2, null);
            throw null;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Type getPotentialAccessorType(int access, String className, Type methodType) {
        Type type;
        Type[] typeArray = AtomicFUTransformerKt.access$getAFU_TYPES$p();
        Type type2 = methodType.getReturnType();
        boolean bl = false;
        Type[] typeArray2 = typeArray;
        boolean bl2 = false;
        if (!typeArray2.containsKey(type2)) {
            return null;
        }
        if ((access & 8) != 0) {
            if ((access & 0x10) != 0) {
                Type[] typeArray3 = methodType.getArgumentTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeArray3, (String)"methodType.argumentTypes");
                typeArray = typeArray3;
                boolean bl3 = false;
                if (typeArray.length == 0) {
                    type = Type.getObjectType((String)className);
                    return type;
                }
            }
            if (methodType.getArgumentTypes().length != 1) return null;
            Type type3 = methodType.getArgumentTypes()[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"methodType.argumentTypes[0]");
            if (type3.getSort() != 10) return null;
            type = methodType.getArgumentTypes()[0];
            return type;
        }
        if ((access & 0x10) == 0) return null;
        Type[] typeArray4 = methodType.getArgumentTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeArray4, (String)"methodType.argumentTypes");
        typeArray = typeArray4;
        boolean bl4 = false;
        if (typeArray.length != 0) return null;
        boolean bl5 = true;
        if (!bl5) return null;
        type = Type.getObjectType((String)className);
        return type;
    }

    private final String descToName(String desc) {
        return StringsKt.dropLast((String)StringsKt.drop((String)desc, (int)1), (int)1);
    }

    private final Class<?> loadClass(String type) {
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName(StringsKt.replace$default((String)type, (char)'/', (char)'.', (boolean)false, (int)4, null), false, this.classPathLoader);
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"Class.forName(type.repla\u2026, false, classPathLoader)");
            clazz = clazz2;
        }
        catch (Exception e) {
            throw (Throwable)new TransformerException("Failed to load class for '" + type + '\'', e);
        }
        return clazz;
    }

    @NotNull
    public final Variant getVariant() {
        return this.variant;
    }

    public final void setVariant(@NotNull Variant variant) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)variant), (String)"<set-?>");
        this.variant = variant;
    }

    public AtomicFUTransformer(@NotNull List<String> classpath, @NotNull File inputDir, @NotNull File outputDir, @NotNull Variant variant) {
        File it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull(classpath, (String)"classpath");
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)((Object)variant), (String)"variant");
        super(inputDir, outputDir);
        this.variant = variant;
        Iterable iterable = classpath;
        Collection collection = CollectionsKt.listOf((Object)inputDir);
        AtomicFUTransformer atomicFUTransformer = this;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)((Object)it));
            object.add(file);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.minus((Iterable)((Iterable)object), (Object)outputDir));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.toURI().toURL();
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        URL[] uRLArray2 = uRLArray;
        atomicFUTransformer.classPathLoader = new URLClassLoader(uRLArray2);
        boolean bl = false;
        this.fields = new LinkedHashMap();
        bl = false;
        this.accessors = new LinkedHashMap();
        bl = false;
        this.removeMethods = new LinkedHashSet();
    }

    public /* synthetic */ AtomicFUTransformer(List list, File file, File file2, Variant variant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file2 = file;
        }
        if ((n & 8) != 0) {
            variant = Variant.FU;
        }
        this(list, file, file2, variant);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003JK\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CV;", "Lorg/objectweb/asm/ClassVisitor;", "cv", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Lorg/objectweb/asm/ClassVisitor;)V", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "atomicfu-transformer"})
    private abstract class CV
    extends ClassVisitor {
        @NotNull
        public String className;

        @NotNull
        public final String getClassName() {
            String string = this.className;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"className");
            }
            return string;
        }

        public final void setClassName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.className = string;
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.className = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public CV(ClassVisitor cv) {
            super(327680, cv);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J6\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016JC\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$FieldsCollectorCV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;)V", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "access", "", "name", "", "desc", "signature", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "atomicfu-transformer"})
    private final class FieldsCollectorCV
    extends CV {
        @Nullable
        public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
            Type fieldType;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Type type = fieldType = Type.getType((String)desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"fieldType");
            if (type.getSort() == 10) {
                Map map = AtomicFUTransformerKt.access$getAFU_CLASSES$p();
                String string = fieldType.getInternalName();
                boolean bl = false;
                Map map2 = map;
                boolean bl2 = false;
                if (map2.containsKey(string)) {
                    FieldId field = new FieldId(this.getClassName(), name, desc);
                    AtomicFUTransformerBase.info$default(AtomicFUTransformer.this, field + " field found", null, 2, null);
                    if (AtomicFUTransformerKt.access$contains(access, 1)) {
                        AtomicFUTransformerBase.error$default(AtomicFUTransformer.this, field + " field cannot be public", null, 2, null);
                    }
                    if (!AtomicFUTransformerKt.access$contains(access, 16)) {
                        AtomicFUTransformerBase.error$default(AtomicFUTransformer.this, field + " field must be final", null, 2, null);
                    }
                    AtomicFUTransformer.this.registerField(field, fieldType, AtomicFUTransformerKt.access$contains(access, 8));
                }
            }
            return null;
        }

        @Nullable
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            boolean bl;
            Type methodType;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                Type type = methodType = Type.getMethodType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"methodType");
                Type[] typeArray = type.getArgumentTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeArray, (String)"methodType.argumentTypes");
                Type[] $this$any$iv = typeArray;
                boolean $i$f$any = false;
                Type[] typeArray2 = $this$any$iv;
                int n = typeArray2.length;
                for (int i = 0; i < n; ++i) {
                    Type element$iv;
                    Type it = element$iv = typeArray2[i];
                    boolean bl2 = false;
                    Map map = AtomicFUTransformerKt.access$getAFU_TYPES$p();
                    boolean bl3 = false;
                    Map map2 = map;
                    boolean bl4 = false;
                    if (!map2.containsKey(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                MethodId methodId = new MethodId(this.getClassName(), name, desc, AsmUtilKt.accessToInvokeOpcode(access));
                AtomicFUTransformerBase.info$default(AtomicFUTransformer.this, methodId + " method to be removed", null, 2, null);
                Collection collection = AtomicFUTransformer.this.removeMethods;
                boolean bl5 = false;
                collection.add(methodId);
            }
            Type type = AtomicFUTransformer.this.getPotentialAccessorType(access, this.getClassName(), methodType);
            if (type != null) {
                Type type2 = type;
                boolean bl6 = false;
                boolean bl7 = false;
                Type onType = type2;
                boolean bl8 = false;
                String string = onType.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"onType.internalName");
                return (MethodVisitor)new AccessorCollectorMV(string, access, name, desc, signature, exceptions);
            }
            return null;
        }

        public FieldsCollectorCV() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0003\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$AccessorCollectorMV;", "Lorg/objectweb/asm/tree/MethodNode;", "className", "", "access", "", "name", "desc", "signature", "exceptions", "", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "", "atomicfu-transformer"})
    private final class AccessorCollectorMV
    extends MethodNode {
        private final String className;

        public void visitEnd() {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            List<AbstractInsnNode> insns = AsmUtilKt.listUseful(insnList, 4);
            if (insns.size() == 3 && AsmUtilKt.isAload(insns.get(0), 0) && AsmUtilKt.isGetField(insns.get(1), this.className) && AsmUtilKt.isAreturn(insns.get(2)) || insns.size() == 2 && AsmUtilKt.isGetStatic(insns.get(0), this.className) && AsmUtilKt.isAreturn(insns.get(1))) {
                String fieldName;
                boolean isStatic = insns.size() == 2;
                AbstractInsnNode abstractInsnNode = isStatic ? insns.get(0) : insns.get(1);
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
                }
                FieldInsnNode fi = (FieldInsnNode)abstractInsnNode;
                String string = fieldName = fi.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldName");
                String string2 = fi.desc;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fi.desc");
                FieldId field = new FieldId(this.className, string, string2);
                Type fieldType = Type.getType((String)fi.desc);
                String string3 = this.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                String string4 = this.desc;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"desc");
                MethodId accessorMethod = new MethodId(this.className, string3, string4, AsmUtilKt.accessToInvokeOpcode(this.access));
                AtomicFUTransformerBase.info$default(AtomicFUTransformer.this, field + " accessor " + this.name + " found", null, 2, null);
                Type type = fieldType;
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"fieldType");
                FieldInfo fieldInfo = AtomicFUTransformer.this.registerField(field, type, isStatic);
                Collection collection = fieldInfo.getAccessors();
                boolean bl = false;
                collection.add(accessorMethod);
                AtomicFUTransformer.this.accessors.put(accessorMethod, fieldInfo);
            }
        }

        public AccessorCollectorMV(String className, @NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, String[] exceptions) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            super(327680, access, name, desc, signature, exceptions);
            this.className = className;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\fJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J6\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u000f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016JC\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u000f2\u0010\u0010,\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010.J\u001c\u0010/\u001a\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u00100\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$TransformerCV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CV;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformer;", "cv", "Lorg/objectweb/asm/ClassVisitor;", "vh", "", "analyzePhase2", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Lorg/objectweb/asm/ClassVisitor;ZZ)V", "metadata", "Lorg/objectweb/asm/tree/AnnotationNode;", "newClinit", "Lorg/objectweb/asm/tree/MethodNode;", "originalClinit", "source", "", "sourceInfo", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "getSourceInfo", "()Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "setSourceInfo", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;)V", "fuField", "", "protection", "", "f", "Lkotlinx/atomicfu/transformer/FieldInfo;", "getOrCreateNewClinit", "vhField", "visitAnnotation", "Lorg/objectweb/asm/AnnotationVisitor;", "desc", "visible", "visitEnd", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "access", "name", "signature", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "visitSource", "debug", "atomicfu-transformer"})
    private final class TransformerCV
    extends CV {
        private String source;
        @Nullable
        private AtomicFUTransformerBase.SourceInfo sourceInfo;
        private AnnotationNode metadata;
        private MethodNode originalClinit;
        private MethodNode newClinit;
        private final boolean vh;
        private final boolean analyzePhase2;

        @Nullable
        public final AtomicFUTransformerBase.SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        public final void setSourceInfo(@Nullable AtomicFUTransformerBase.SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
        }

        private final MethodNode newClinit() {
            return new MethodNode(327680, 8, "<clinit>", "()V", null, null);
        }

        @NotNull
        public final MethodNode getOrCreateNewClinit() {
            MethodNode methodNode = this.newClinit;
            if (methodNode == null) {
                MethodNode methodNode2 = this.newClinit();
                boolean bl = false;
                boolean bl2 = false;
                MethodNode it = methodNode2;
                boolean bl3 = false;
                this.newClinit = it;
                methodNode = methodNode2;
            }
            return methodNode;
        }

        public void visitSource(@Nullable String source, @Nullable String debug) {
            this.source = source;
            super.visitSource(source, debug);
        }

        @Nullable
        public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
            Type fieldType;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Type type = fieldType = Type.getType((String)desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"fieldType");
            if (type.getSort() == 10) {
                Map map = AtomicFUTransformerKt.access$getAFU_CLASSES$p();
                String string = fieldType.getInternalName();
                boolean bl = false;
                Map map2 = map;
                boolean bl2 = false;
                if (map2.containsKey(string)) {
                    FieldVisitor fv;
                    FieldVisitor fieldVisitor;
                    FieldId fieldId = new FieldId(this.getClassName(), name, desc);
                    Object v = AtomicFUTransformer.this.fields.get(fieldId);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    FieldInfo f = (FieldInfo)v;
                    int protection = f.isStatic() && !this.vh ? 4120 : (f.isStatic() && this.vh ? 4104 : (f.getHasExternalAccess() ? 4097 : (f.getAccessors().isEmpty() ? 2 : 0)));
                    Type primitiveType = f.getPrimitiveType(this.vh);
                    if (f.isArray() && !this.vh) {
                        fieldVisitor = super.visitField(protection, f.getName(), f.getFuType().getDescriptor(), null, null);
                    } else if (f.isStatic() && !this.vh) {
                        String string2 = f.getStaticRefVolatileField();
                        Type type2 = Type.getObjectType((String)f.getRefVolatileClassName());
                        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"getObjectType(f.refVolatileClassName)");
                        fieldVisitor = super.visitField(protection, string2, type2.getDescriptor(), null, null);
                    } else {
                        fieldVisitor = fv = super.visitField(protection | 0x40, f.getName(), primitiveType.getDescriptor(), null, null);
                    }
                    if (this.vh) {
                        if (f.getHasAtomicOps() || f.isArray()) {
                            this.vhField(protection, f);
                        }
                    } else if (f.getHasAtomicOps() && !f.isArray()) {
                        this.fuField(protection, f);
                    }
                    AtomicFUTransformer.this.setTransformed(true);
                    return fv;
                }
            }
            return super.visitField(access, name, desc, signature, value);
        }

        private final void vhField(int protection, FieldInfo f) {
            String string = f.getFuName();
            Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"VH_TYPE");
            super.visitField(protection | 0x10 | 8, string, type.getDescriptor(), null, null);
            MethodVisitor mv$iv = (MethodVisitor)this.getOrCreateNewClinit();
            boolean $i$f$code = false;
            InstructionAdapter $this$code = new InstructionAdapter(mv$iv);
            boolean bl = false;
            if (!f.isArray()) {
                $this$code.invokestatic(AtomicFUTransformerKt.access$getMETHOD_HANDLES$p(), "lookup", "()L" + AtomicFUTransformerKt.access$getLOOKUP$p() + ';', false);
                $this$code.aconst((Object)Type.getObjectType((String)this.getClassName()));
                $this$code.aconst((Object)f.getName());
                Type primitiveType = f.getPrimitiveType(this.vh);
                if (primitiveType.getSort() == 10) {
                    $this$code.aconst((Object)primitiveType);
                } else {
                    String wrapper = (String)MapsKt.getValue((Map)AtomicFUTransformerKt.access$getWRAPPER$p(), (Object)primitiveType);
                    Type type2 = AtomicFUTransformerKt.access$getCLASS_TYPE$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"CLASS_TYPE");
                    $this$code.getstatic(wrapper, "TYPE", type2.getDescriptor());
                }
                String findVHName = f.isStatic() ? "findStaticVarHandle" : "findVarHandle";
                $this$code.invokevirtual(AtomicFUTransformerKt.access$getLOOKUP$p(), findVHName, Type.getMethodDescriptor((Type)AtomicFUTransformerKt.access$getVH_TYPE$p(), (Type[])new Type[]{AtomicFUTransformerKt.access$getCLASS_TYPE$p(), AtomicFUTransformerKt.access$getSTRING_TYPE$p(), AtomicFUTransformerKt.access$getCLASS_TYPE$p()}), false);
                String string2 = this.getClassName();
                String string3 = f.getFuName();
                Type type3 = AtomicFUTransformerKt.access$getVH_TYPE$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"VH_TYPE");
                $this$code.putstatic(string2, string3, type3.getDescriptor());
            } else {
                $this$code.aconst((Object)f.getPrimitiveType(this.vh));
                $this$code.invokestatic(AtomicFUTransformerKt.access$getMETHOD_HANDLES$p(), "arrayElementVarHandle", Type.getMethodDescriptor((Type)AtomicFUTransformerKt.access$getVH_TYPE$p(), (Type[])new Type[]{AtomicFUTransformerKt.access$getCLASS_TYPE$p()}), false);
                String string4 = this.getClassName();
                String string5 = f.getFuName();
                Type type4 = AtomicFUTransformerKt.access$getVH_TYPE$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"VH_TYPE");
                $this$code.putstatic(string4, string5, type4.getDescriptor());
            }
        }

        private final void fuField(int protection, FieldInfo f) {
            boolean bl;
            super.visitField(protection | 0x10 | 8, f.getFuName(), f.getFuType().getDescriptor(), null, null);
            MethodVisitor mv$iv = (MethodVisitor)this.getOrCreateNewClinit();
            boolean $i$f$code = false;
            InstructionAdapter $this$code = new InstructionAdapter(mv$iv);
            boolean bl2 = false;
            boolean bl3 = false;
            List params = new ArrayList();
            Collection collection = params;
            Object object = AtomicFUTransformerKt.access$getCLASS_TYPE$p();
            boolean bl4 = false;
            collection.add(object);
            if (!f.isStatic()) {
                $this$code.aconst((Object)Type.getObjectType((String)this.getClassName()));
            } else {
                $this$code.aconst((Object)Type.getObjectType((String)f.getRefVolatileClassName()));
            }
            Type primitiveType = f.getPrimitiveType(this.vh);
            if (primitiveType.getSort() == 10) {
                object = params;
                Type type = AtomicFUTransformerKt.access$getCLASS_TYPE$p();
                bl = false;
                object.add(type);
                $this$code.aconst((Object)primitiveType);
            }
            object = params;
            Type type = AtomicFUTransformerKt.access$getSTRING_TYPE$p();
            bl = false;
            object.add(type);
            $this$code.aconst((Object)f.getName());
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
            if (typeArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$code.invokestatic(f.getFuType().getInternalName(), "newUpdater", Type.getMethodDescriptor((Type)f.getFuType(), (Type[])Arrays.copyOf(typeArray, typeArray.length)), false);
            $this$code.putstatic(this.getClassName(), f.getFuName(), f.getFuType().getDescriptor());
        }

        @Nullable
        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            MethodId methodId = new MethodId(this.getClassName(), name, desc, AsmUtilKt.accessToInvokeOpcode(access));
            Map map = AtomicFUTransformer.this.accessors;
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            if (map2.containsKey(methodId) || AtomicFUTransformer.this.removeMethods.contains(methodId)) {
                AtomicFUTransformer.this.setTransformed(true);
                return null;
            }
            AtomicFUTransformerBase.SourceInfo sourceInfo = new AtomicFUTransformerBase.SourceInfo(methodId, this.source, null, null, 12, null);
            if (Intrinsics.areEqual((Object)name, (Object)"<clinit>") && Intrinsics.areEqual((Object)desc, (Object)"()V")) {
                if ((access & 8) == 0) {
                    Void void_ = AbortKt.abort$default("<clinit> method not marked as static", null, 2, null);
                    throw null;
                }
                MethodNode node = new MethodNode(327680, access, name, desc, signature, exceptions);
                if (this.originalClinit != null) {
                    Void void_ = AbortKt.abort$default("Multiple <clinit> methods found", null, 2, null);
                    throw null;
                }
                this.originalClinit = node;
                methodVisitor = (MethodVisitor)node;
            } else {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            }
            MethodVisitor superMV = methodVisitor;
            TransformerMV mv = new TransformerMV(sourceInfo, access, name, desc, signature, exceptions, superMV, AsmUtilKt.getOwnerPackageName(this.getClassName()), this.vh, this.analyzePhase2);
            this.sourceInfo = mv.getSourceInfo();
            return (MethodVisitor)mv;
        }

        @Nullable
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            if (Intrinsics.areEqual((Object)desc, (Object)"Lkotlin/Metadata;")) {
                boolean bl = false;
                boolean bl2 = false;
                if (!visible) {
                    boolean bl3 = false;
                    String string = "Expected run-time visible Lkotlin/Metadata; annotation";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                bl = this.metadata == null;
                bl2 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Only one Lkotlin/Metadata; annotation is expected";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                AnnotationNode annotationNode = new AnnotationNode(desc);
                bl2 = false;
                bl4 = false;
                AnnotationNode it = annotationNode;
                boolean bl6 = false;
                this.metadata = it;
                return (AnnotationVisitor)annotationNode;
            }
            return super.visitAnnotation(desc, visible);
        }

        public void visitEnd() {
            AnnotationNode annotationNode = this.metadata;
            if (annotationNode != null) {
                AnnotationNode annotationNode2 = annotationNode;
                boolean bl = false;
                boolean bl2 = false;
                AnnotationNode it = annotationNode2;
                boolean bl3 = false;
                MetadataTransformer mt = new MetadataTransformer(AtomicFUTransformer.this.fields.keySet(), SetsKt.plus(AtomicFUTransformer.this.accessors.keySet(), (Iterable)AtomicFUTransformer.this.removeMethods));
                if (mt.transformMetadata(it)) {
                    AtomicFUTransformer.this.setTransformed(true);
                }
                if (this.cv != null) {
                    it.accept(this.cv.visitAnnotation("Lkotlin/Metadata;", true));
                }
            }
            if (this.analyzePhase2) {
                return;
            }
            if (this.originalClinit != null || this.newClinit != null) {
                MethodNode newClinit = this.newClinit;
                if (newClinit == null) {
                    MethodNode methodNode = this.originalClinit;
                    if (methodNode == null) {
                        Intrinsics.throwNpe();
                    }
                    methodNode.accept(this.cv);
                } else {
                    MethodNode methodNode = this.originalClinit;
                    if (methodNode == null) {
                        MethodNode methodNode2 = this.newClinit();
                        boolean it = false;
                        boolean bl = false;
                        MethodNode it2 = methodNode2;
                        boolean bl4 = false;
                        boolean $i$f$code = false;
                        InstructionAdapter $this$code = new InstructionAdapter((MethodVisitor)it2);
                        boolean bl5 = false;
                        $this$code.visitInsn(177);
                        methodNode = methodNode2;
                    }
                    MethodNode originalClinit = methodNode;
                    InsnList insnList = originalClinit.instructions;
                    Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"originalClinit.instructions");
                    AbstractInsnNode last = insnList.getLast();
                    AbstractInsnNode ret = AsmUtilKt.getThisOrPrevUseful(last);
                    if (ret == null || !AsmUtilKt.isReturn(ret)) {
                        Void void_ = AbortKt.abort("Last instruction in <clinit> shall be RETURN", ret);
                        throw null;
                    }
                    originalClinit.instructions.insertBefore(ret, newClinit.instructions);
                    originalClinit.accept(this.cv);
                }
            }
            super.visitEnd();
        }

        public TransformerCV(ClassVisitor cv, boolean vh, boolean analyzePhase2) {
            super(cv);
            this.vh = vh;
            this.analyzePhase2 = analyzePhase2;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%H\u0002J*\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J2\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010%H\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020)H\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J2\u0010.\u001a\u0004\u0018\u00010\u001c2\u0006\u0010/\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010%H\u0002J\"\u00100\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u00101\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u00104\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00105\u001a\u000206H\u0002J(\u00107\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00108\u001a\u0002062\u0006\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u001cH\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\u001c2\u0006\u0010<\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010=\u001a\u0004\u0018\u00010\u001c2\u0006\u0010>\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020!H\u0002J\"\u0010@\u001a\u0004\u0018\u00010\u001c2\u0006\u0010A\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020!H\u0002J\"\u0010B\u001a\u0004\u0018\u00010\u001c2\u0006\u0010C\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020!H\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010E\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001cH\u0002J \u0010F\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010G\u001a\u00020\u0018H\u0016J0\u0010H\u001a\u00020\u00182\u0006\u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0010H\u0016J\u000e\u0010L\u001a\u0004\u0018\u00010M*\u00020!H\u0002R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$TransformerMV;", "Lorg/objectweb/asm/tree/MethodNode;", "sourceInfo", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "access", "", "name", "", "desc", "signature", "exceptions", "", "mv", "Lorg/objectweb/asm/MethodVisitor;", "packageName", "vh", "", "analyzePhase2", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Lorg/objectweb/asm/MethodVisitor;Ljava/lang/String;ZZ)V", "bumpedLocals", "getSourceInfo", "()Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "tempLocal", "bumpLocals", "", "n", "checkDataFlowComplexity", "i", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "fixupArrayElementLoad", "f", "Lkotlinx/atomicfu/transformer/FieldInfo;", "ld", "Lorg/objectweb/asm/tree/FieldInsnNode;", "otherLd", "Lorg/objectweb/asm/tree/VarInsnNode;", "arrayElementInfo", "", "fixupInvokeVirtual", "onArrayElement", "iv", "Lorg/objectweb/asm/tree/MethodInsnNode;", "fixupLoad", "fixupLoadedArrayElement", "getter", "fixupLoadedAtomicVar", "fixupOperationOnAtomicVar", "operation", "fixupVarLoad", "fuOperation", "typeInfo", "Lkotlinx/atomicfu/transformer/TypeInfo;", "generateRefVolatileClass", "arg", "Lorg/objectweb/asm/Type;", "initRefVolatile", "argType", "firstInitInsn", "lastInitInsn", "insertPureVhArray", "getVarHandleInsn", "putJucaAtomicArray", "arrayfactoryInsn", "next", "putPrimitiveTypeWrapper", "factoryInsn", "putPureVhArray", "arrayFactoryInsn", "transform", "tryEraseUncheckedCast", "vhOperation", "visitEnd", "visitMethodInsn", "opcode", "owner", "itf", "checkPutFieldOrPutStatic", "Lkotlinx/atomicfu/transformer/FieldId;", "atomicfu-transformer"})
    private final class TransformerMV
    extends MethodNode {
        @NotNull
        private final AtomicFUTransformerBase.SourceInfo sourceInfo;
        private int tempLocal;
        private int bumpedLocals;
        private final String packageName;
        private final boolean vh;
        private final boolean analyzePhase2;

        @NotNull
        public final AtomicFUTransformerBase.SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        private final void bumpLocals(int n) {
            if (this.bumpedLocals == 0) {
                this.tempLocal = this.maxLocals;
            }
            while (n > this.bumpedLocals) {
                this.bumpedLocals = n;
            }
            this.maxLocals = this.tempLocal + this.bumpedLocals;
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc, boolean itf) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            MethodId methodId = new MethodId(owner, name, desc, opcode);
            FieldInfo fieldInfo = (FieldInfo)AtomicFUTransformer.this.accessors.get(methodId);
            if (fieldInfo != null && Intrinsics.areEqual((Object)AsmUtilKt.getOwnerPackageName(methodId.getOwner()), (Object)this.packageName) ^ true) {
                if (this.analyzePhase2) {
                    fieldInfo.setHasExternalAccess(true);
                } else {
                    boolean bl = fieldInfo.getHasExternalAccess();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitEnd() {
            boolean hasErrors = false;
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            AbstractInsnNode i = insnList.getFirst();
            while (i != null) {
                try {
                    i = this.transform(i);
                }
                catch (AbortTransform e) {
                    String string = e.getMessage();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    AtomicFUTransformer.this.error(string, AtomicFUTransformerBase.SourceInfo.copy$default(this.sourceInfo, null, null, e.getI(), null, 11, null));
                    i = i.getNext();
                    hasErrors = true;
                }
            }
            if (!hasErrors && !this.analyzePhase2) {
                this.accept(this.mv);
            }
        }

        private final FieldId checkPutFieldOrPutStatic(FieldInsnNode $this$checkPutFieldOrPutStatic) {
            if ($this$checkPutFieldOrPutStatic.getOpcode() != 181 && $this$checkPutFieldOrPutStatic.getOpcode() != 179) {
                return null;
            }
            String string = $this$checkPutFieldOrPutStatic.owner;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"owner");
            String string2 = $this$checkPutFieldOrPutStatic.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            String string3 = $this$checkPutFieldOrPutStatic.desc;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"desc");
            FieldId fieldId = new FieldId(string, string2, string3);
            Map map = AtomicFUTransformer.this.fields;
            boolean bl = false;
            Map map2 = map;
            boolean bl2 = false;
            return map2.containsKey(fieldId) ? fieldId : null;
        }

        private final AbstractInsnNode fixupInvokeVirtual(FieldInsnNode ld, boolean onArrayElement, MethodInsnNode iv, FieldInfo f) {
            boolean setInsn;
            TypeInfo typeInfo;
            TypeInfo typeInfo2;
            boolean bl = f.isArray() || !onArrayElement;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl42 = false;
                String string = "Cannot fix array element access on non array fields";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (onArrayElement) {
                typeInfo2 = f.getTypeInfo();
            } else {
                Map map = AtomicFUTransformerKt.access$getAFU_CLASSES$p();
                String string = iv.owner;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"iv.owner");
                typeInfo2 = typeInfo = (TypeInfo)MapsKt.getValue((Map)map, (Object)string);
            }
            if (Intrinsics.areEqual((Object)iv.name, (Object)"getValue") || Intrinsics.areEqual((Object)iv.name, (Object)"setValue")) {
                bl2 = !f.isArray() || onArrayElement;
                bl3 = false;
                boolean bl42 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String bl42 = "getValue/setValue can only be called on elements of arrays";
                    throw (Throwable)new IllegalStateException(bl42.toString());
                }
                setInsn = Intrinsics.areEqual((Object)iv.name, (Object)"setValue");
                if (!onArrayElement) {
                    String owner;
                    this.instructions.remove((AbstractInsnNode)ld);
                    Type primitiveType = f.getPrimitiveType(this.vh);
                    String string = owner = !this.vh && f.isStatic() ? f.getRefVolatileClassName() : f.getOwner();
                    if (!this.vh && f.isStatic()) {
                        String string2 = f.getOwner();
                        String string3 = f.getStaticRefVolatileField();
                        Type type = Type.getObjectType((String)owner);
                        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"getObjectType(owner)");
                        FieldInsnNode getOwnerClass = new FieldInsnNode(178, string2, string3, type.getDescriptor());
                        this.instructions.insertBefore((AbstractInsnNode)iv, (AbstractInsnNode)getOwnerClass);
                    }
                    FieldInsnNode j = new FieldInsnNode(Intrinsics.areEqual((Object)iv.name, (Object)"getValue") ? (f.isStatic() && this.vh ? 178 : 180) : (f.isStatic() && this.vh ? 179 : 181), owner, f.getName(), primitiveType.getDescriptor());
                    this.instructions.set((AbstractInsnNode)iv, (AbstractInsnNode)j);
                    return j.getNext();
                }
                Type methodType = Type.getMethodType((String)iv.desc);
                if (Intrinsics.areEqual((Object)f.getTypeInfo().getOriginalType(), (Object)f.getTypeInfo().getTransformedType()) ^ true && !this.vh) {
                    String string;
                    Type ret = f.getTypeInfo().getTransformedType().getElementType();
                    if (setInsn) {
                        Type type = methodType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"methodType");
                        string = Type.getMethodDescriptor((Type)type.getReturnType(), (Type[])new Type[]{ret});
                    } else {
                        Type type = methodType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"methodType");
                        Type[] typeArray = type.getArgumentTypes();
                        string = Type.getMethodDescriptor((Type)ret, (Type[])Arrays.copyOf(typeArray, typeArray.length));
                    }
                    iv.desc = string;
                    methodType = Type.getMethodType((String)iv.desc);
                }
                String string = iv.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"iv.name");
                String string4 = string;
                int j = 0;
                int n = 3;
                boolean bl6 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(j, n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                iv.name = string6;
                if (!this.vh) {
                    String string7 = f.getFuType().getDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"f.fuType.descriptor");
                    iv.owner = AtomicFUTransformer.this.descToName(string7);
                    Type type = methodType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"methodType");
                    Type type2 = type.getReturnType();
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)Type.INT_TYPE);
                    spreadBuilder.addSpread((Object)methodType.getArgumentTypes());
                    iv.desc = Type.getMethodDescriptor((Type)type2, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
                } else {
                    Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"VH_TYPE");
                    String string8 = type.getDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"VH_TYPE.descriptor");
                    iv.owner = AtomicFUTransformer.this.descToName(string8);
                    Type type3 = methodType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"methodType");
                    Type type4 = type3.getReturnType();
                    SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                    spreadBuilder.add((Object)f.getPrimitiveType(this.vh));
                    spreadBuilder.add((Object)Type.INT_TYPE);
                    spreadBuilder.addSpread((Object)methodType.getArgumentTypes());
                    iv.desc = Type.getMethodDescriptor((Type)type4, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
                }
                return (AbstractInsnNode)iv;
            }
            if (f.isArray() && Intrinsics.areEqual((Object)iv.name, (Object)"get")) {
                return this.fixupLoadedArrayElement(f, ld, iv);
            }
            setInsn = f.isArray() == onArrayElement;
            bl3 = false;
            boolean bl7 = false;
            if (!setInsn) {
                boolean bl8 = false;
                String string = "Atomic operations can be performed on atomic elements only";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (this.analyzePhase2) {
                f.setHasAtomicOps(true);
            } else {
                setInsn = f.getHasAtomicOps();
                bl3 = false;
                bl7 = false;
                bl7 = false;
                boolean bl9 = false;
                if (!setInsn) {
                    boolean bl10 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            if (this.vh) {
                this.vhOperation(iv, typeInfo, f);
            } else {
                this.fuOperation(iv, typeInfo, f);
            }
            if (f.isStatic() && !onArrayElement) {
                if (!this.vh) {
                    String string = f.getOwner();
                    String string9 = f.getStaticRefVolatileField();
                    Type type = Type.getObjectType((String)f.getRefVolatileClassName());
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"getObjectType(f.refVolatileClassName)");
                    FieldInsnNode aload = new FieldInsnNode(178, string, string9, type.getDescriptor());
                    this.instructions.insert((AbstractInsnNode)ld, (AbstractInsnNode)aload);
                }
                return iv.getNext();
            }
            if (!onArrayElement) {
                InsnNode swap = new InsnNode(95);
                this.instructions.insert((AbstractInsnNode)ld, (AbstractInsnNode)swap);
                return swap.getNext();
            }
            return iv.getNext();
        }

        /*
         * WARNING - void declaration
         */
        private final void vhOperation(MethodInsnNode iv, TypeInfo typeInfo, FieldInfo f) {
            List list;
            Type methodType;
            Type type = methodType = Type.getMethodType((String)iv.desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"methodType");
            Type[] args = type.getArgumentTypes();
            Type type2 = AtomicFUTransformerKt.access$getVH_TYPE$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"VH_TYPE");
            iv.owner = type2.getInternalName();
            if (!f.isArray() && !f.isStatic()) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                Type type3 = InstructionAdapter.OBJECT_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"OBJECT_TYPE");
                spreadBuilder.add((Object)type3);
                Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
                spreadBuilder.addSpread((Object)args);
                list = CollectionsKt.mutableListOf((Object[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
            } else if (!f.isArray() && f.isStatic()) {
                Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
                list = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(args, args.length));
            } else {
                SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)typeInfo.getOriginalType());
                Type type4 = Type.INT_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"INT_TYPE");
                spreadBuilder.add((Object)type4);
                Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
                spreadBuilder.addSpread((Object)args);
                list = CollectionsKt.mutableListOf((Object[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
            }
            List params = list;
            Type elementType = f.isArray() ? typeInfo.getOriginalType().getElementType() : typeInfo.getOriginalType();
            boolean bl = Intrinsics.areEqual((Object)elementType, (Object)Type.LONG_TYPE);
            String string = iv.name;
            if (string != null) {
                switch (string) {
                    case "lazySet": {
                        iv.name = "setRelease";
                        break;
                    }
                    case "getAndIncrement": {
                        void $this$insns;
                        boolean $i$f$insns22 = false;
                        MethodNode node$iv22 = new MethodNode(327680);
                        InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)node$iv22);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl2 = false;
                        if (bl) {
                            $this$insns.lconst(1L);
                        } else {
                            $this$insns.iconst(1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList2 = node$iv22.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList2, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList2);
                        Collection $i$f$insns22 = params;
                        boolean node$iv22 = false;
                        $i$f$insns22.add(elementType);
                        iv.name = "getAndAdd";
                        break;
                    }
                    case "getAndDecrement": {
                        boolean $i$f$insns32 = false;
                        MethodNode node$iv32 = new MethodNode(327680);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv32);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl3 = false;
                        if (bl) {
                            $this$insns.lconst(-1L);
                        } else {
                            $this$insns.iconst(-1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList3 = node$iv32.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList3, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList3);
                        Collection $i$f$insns32 = params;
                        boolean node$iv32 = false;
                        $i$f$insns32.add(elementType);
                        iv.name = "getAndAdd";
                        break;
                    }
                    case "addAndGet": {
                        this.bumpLocals(bl ? 2 : 1);
                        boolean $i$f$insns = false;
                        MethodNode node$iv = new MethodNode(327680);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl4 = false;
                        if (bl) {
                            $this$insns.dup2();
                        } else {
                            $this$insns.dup();
                        }
                        $this$insns.store(this.tempLocal, elementType);
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList4 = node$iv.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList4, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList4);
                        iv.name = "getAndAdd";
                        $i$f$insns = false;
                        node$iv = new MethodNode(327680);
                        $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        abstractInsnNode = (AbstractInsnNode)iv;
                        insnList = this.instructions;
                        boolean bl5 = false;
                        $this$insns.load(this.tempLocal, elementType);
                        $this$insns.add(elementType);
                        unit = Unit.INSTANCE;
                        InsnList insnList5 = node$iv.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList5, (String)"node.instructions");
                        insnList.insert(abstractInsnNode, insnList5);
                        break;
                    }
                    case "incrementAndGet": {
                        boolean $i$f$insns42 = false;
                        MethodNode node$iv42 = new MethodNode(327680);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv42);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl6 = false;
                        if (bl) {
                            $this$insns.lconst(1L);
                        } else {
                            $this$insns.iconst(1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList6 = node$iv42.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList6, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList6);
                        Collection $i$f$insns42 = params;
                        boolean node$iv42 = false;
                        $i$f$insns42.add(elementType);
                        iv.name = "getAndAdd";
                        boolean $i$f$insns = false;
                        MethodNode node$iv = new MethodNode(327680);
                        $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        abstractInsnNode = (AbstractInsnNode)iv;
                        insnList = this.instructions;
                        boolean bl7 = false;
                        if (bl) {
                            $this$insns.lconst(1L);
                        } else {
                            $this$insns.iconst(1);
                        }
                        $this$insns.add(elementType);
                        unit = Unit.INSTANCE;
                        InsnList insnList7 = node$iv.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList7, (String)"node.instructions");
                        insnList.insert(abstractInsnNode, insnList7);
                        break;
                    }
                    case "decrementAndGet": {
                        boolean $i$f$insns52 = false;
                        MethodNode node$iv52 = new MethodNode(327680);
                        InstructionAdapter $this$insns = new InstructionAdapter((MethodVisitor)node$iv52);
                        AbstractInsnNode abstractInsnNode = (AbstractInsnNode)iv;
                        InsnList insnList = this.instructions;
                        boolean bl8 = false;
                        if (bl) {
                            $this$insns.lconst(-1L);
                        } else {
                            $this$insns.iconst(-1);
                        }
                        Unit unit = Unit.INSTANCE;
                        InsnList insnList8 = node$iv52.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList8, (String)"node.instructions");
                        insnList.insertBefore(abstractInsnNode, insnList8);
                        Collection $i$f$insns52 = params;
                        boolean node$iv52 = false;
                        $i$f$insns52.add(elementType);
                        iv.name = "getAndAdd";
                        boolean $i$f$insns = false;
                        MethodNode node$iv = new MethodNode(327680);
                        $this$insns = new InstructionAdapter((MethodVisitor)node$iv);
                        abstractInsnNode = (AbstractInsnNode)iv;
                        insnList = this.instructions;
                        boolean bl9 = false;
                        if (bl) {
                            $this$insns.lconst(-1L);
                        } else {
                            $this$insns.iconst(-1);
                        }
                        $this$insns.add(elementType);
                        unit = Unit.INSTANCE;
                        InsnList insnList9 = node$iv.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList9, (String)"node.instructions");
                        insnList.insert(abstractInsnNode, insnList9);
                        break;
                    }
                }
            }
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
            if (typeArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            iv.desc = Type.getMethodDescriptor((Type)methodType.getReturnType(), (Type[])Arrays.copyOf(typeArray, typeArray.length));
        }

        /*
         * WARNING - void declaration
         */
        private final void fuOperation(MethodInsnNode iv, TypeInfo typeInfo, FieldInfo f) {
            Type methodType = Type.getMethodType((String)iv.desc);
            Type originalElementType = f.isArray() ? typeInfo.getOriginalType().getElementType() : typeInfo.getOriginalType();
            Type transformedElementType = f.isArray() ? typeInfo.getTransformedType().getElementType() : typeInfo.getTransformedType();
            boolean trans = Intrinsics.areEqual((Object)originalElementType, (Object)transformedElementType) ^ true;
            Type type = methodType;
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"methodType");
            Type[] args = type.getArgumentTypes();
            Type ret = methodType.getReturnType();
            if (trans) {
                Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
                Type[] $this$forEachIndexed$iv = args;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Type item$iv : $this$forEachIndexed$iv) {
                    void type2;
                    int n = index$iv++;
                    Type type3 = item$iv;
                    int i = n;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)type2, (Object)originalElementType)) continue;
                    args[i] = transformedElementType;
                }
                if (Intrinsics.areEqual((Object)iv.name, (Object)"getAndSet")) {
                    ret = transformedElementType;
                }
            }
            if (f.isArray()) {
                iv.owner = typeInfo.getFuType().getInternalName();
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)Type.INT_TYPE);
                spreadBuilder.addSpread((Object)args);
                iv.desc = Type.getMethodDescriptor((Type)ret, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
                return;
            }
            iv.owner = typeInfo.getFuType().getInternalName();
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)InstructionAdapter.OBJECT_TYPE);
            spreadBuilder.addSpread((Object)args);
            iv.desc = Type.getMethodDescriptor((Type)ret, (Type[])((Type[])spreadBuilder.toArray((Object[])new Type[spreadBuilder.size()])));
        }

        private final void tryEraseUncheckedCast(AbstractInsnNode getter) {
            AbstractInsnNode abstractInsnNode = getter.getNext();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"getter.next");
            if (abstractInsnNode.getOpcode() == 89) {
                AbstractInsnNode abstractInsnNode2 = getter.getNext();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"getter.next");
                AbstractInsnNode abstractInsnNode3 = abstractInsnNode2.getNext();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode3, (String)"getter.next.next");
                if (abstractInsnNode3.getOpcode() == 199) {
                    AbstractInsnNode abstractInsnNode4 = getter.getNext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode4, (String)"getter.next");
                    AbstractInsnNode abstractInsnNode5 = abstractInsnNode4.getNext();
                    if (abstractInsnNode5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.objectweb.asm.tree.JumpInsnNode");
                    }
                    JumpInsnNode ifnonnull = (JumpInsnNode)abstractInsnNode5;
                    AbstractInsnNode abstractInsnNode6 = getter.getNext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode6, (String)"getter.next");
                    AbstractInsnNode i = abstractInsnNode6;
                    while (true) {
                        if (i instanceof LabelNode) {
                            Label label = ((LabelNode)i).getLabel();
                            LabelNode labelNode = ifnonnull.label;
                            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"ifnonnull.label");
                            if (Intrinsics.areEqual((Object)label, (Object)labelNode.getLabel())) break;
                        }
                        AbstractInsnNode next = i.getNext();
                        this.instructions.remove(i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)next, (String)"next");
                    }
                }
            }
        }

        private final AbstractInsnNode fixupLoadedAtomicVar(FieldInfo f, FieldInsnNode ld) {
            if (Intrinsics.areEqual((Object)f.getFieldType(), (Object)AtomicFUTransformerKt.access$getREF_TYPE$p())) {
                this.tryEraseUncheckedCast((AbstractInsnNode)ld);
            }
            AbstractInsnNode j = new FlowAnalyzer(ld.getNext()).execute();
            return this.fixupOperationOnAtomicVar(j, f, ld, null);
        }

        private final AbstractInsnNode fixupLoadedArrayElement(FieldInfo f, FieldInsnNode ld, MethodInsnNode getter) {
            if (Intrinsics.areEqual((Object)f.getFieldType(), (Object)AtomicFUTransformerKt.access$getATOMIC_ARRAY_TYPE$p())) {
                this.tryEraseUncheckedCast((AbstractInsnNode)getter);
            }
            boolean bl = false;
            List arrayElementInfo = new ArrayList();
            if (this.vh) {
                AbstractInsnNode abstractInsnNode = ld.getPrevious();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"ld.previous");
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode.getPrevious();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"ld.previous.previous");
                arrayElementInfo.add(abstractInsnNode2);
                AbstractInsnNode abstractInsnNode3 = ld.getPrevious();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode3, (String)"ld.previous");
                arrayElementInfo.add(abstractInsnNode3);
            }
            AbstractInsnNode i = (AbstractInsnNode)ld;
            while (Intrinsics.areEqual((Object)i, (Object)getter) ^ true) {
                arrayElementInfo.add(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)i.getNext(), (String)"i.next");
            }
            AbstractInsnNode args = getter.getNext();
            this.instructions.remove((AbstractInsnNode)getter);
            AbstractInsnNode arrayElementOperation = new FlowAnalyzer(args).execute();
            return this.fixupOperationOnAtomicVar(arrayElementOperation, f, ld, arrayElementInfo);
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode fixupOperationOnAtomicVar(AbstractInsnNode operation, FieldInfo f, FieldInsnNode ld, List<? extends AbstractInsnNode> arrayElementInfo) {
            AbstractInsnNode abstractInsnNode = operation;
            if (abstractInsnNode instanceof MethodInsnNode) {
                AtomicFUTransformer.this.debug("invoke " + f + '.' + ((MethodInsnNode)operation).name, AtomicFUTransformerBase.SourceInfo.copy$default(this.sourceInfo, null, null, operation, null, 11, null));
                return this.fixupInvokeVirtual(ld, arrayElementInfo != null, (MethodInsnNode)operation, f);
            }
            if (abstractInsnNode instanceof VarInsnNode) {
                boolean onArrayElement = arrayElementInfo != null;
                boolean bl = f.isArray() == onArrayElement;
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int v = ((VarInsnNode)operation).var;
                AbstractInsnNode next = ((VarInsnNode)operation).getNext();
                if (onArrayElement) {
                    List<? extends AbstractInsnNode> list = arrayElementInfo;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AbstractInsnNode it = (AbstractInsnNode)element$iv;
                        boolean bl6 = false;
                        this.instructions.remove(it);
                    }
                } else {
                    this.instructions.remove((AbstractInsnNode)ld);
                }
                LocalVariableNode lv = AsmUtilKt.localVar(this, v, operation);
                if (lv != null) {
                    void start$iv;
                    if (Intrinsics.areEqual((Object)lv.desc, (Object)f.getFieldType().getDescriptor()) ^ true && !onArrayElement) {
                        Void void_ = AbortKt.abort$default("field " + f + " was stored to a local variable #" + v + " \"" + lv.name + "\" with unexpected type: " + lv.desc, null, 2, null);
                        throw null;
                    }
                    lv.desc = f.getOwnerType().getDescriptor();
                    lv.signature = null;
                    LabelNode labelNode = lv.start;
                    Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"lv.start");
                    LabelNode $i$f$forEach = labelNode;
                    LabelNode labelNode2 = lv.end;
                    Intrinsics.checkExpressionValueIsNotNull((Object)labelNode2, (String)"lv.end");
                    LabelNode end$iv = labelNode2;
                    boolean $i$f$forVarLoads = false;
                    AbstractInsnNode cur$iv = (AbstractInsnNode)start$iv;
                    while (cur$iv != null && cur$iv != end$iv) {
                        if (cur$iv instanceof VarInsnNode && ((VarInsnNode)cur$iv).getOpcode() == 25 && ((VarInsnNode)cur$iv).var == v) {
                            VarInsnNode otherLd = (VarInsnNode)cur$iv;
                            boolean bl7 = false;
                            cur$iv = this.fixupLoad(f, ld, otherLd, arrayElementInfo);
                            continue;
                        }
                        cur$iv = cur$iv.getNext();
                    }
                } else {
                    AbstractInsnNode abstractInsnNode2 = next;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"next");
                    this.fixupLoad(f, ld, AsmUtilKt.nextVarLoad(v, abstractInsnNode2), arrayElementInfo);
                }
                return next;
            }
            Void void_ = AbortKt.abort$default("cannot happen", null, 2, null);
            throw null;
        }

        private final AbstractInsnNode fixupLoad(FieldInfo f, FieldInsnNode ld, VarInsnNode otherLd, List<? extends AbstractInsnNode> arrayElementInfo) {
            return arrayElementInfo != null ? this.fixupArrayElementLoad(f, ld, otherLd, arrayElementInfo) : this.fixupVarLoad(f, ld, otherLd);
        }

        private final AbstractInsnNode fixupVarLoad(FieldInfo f, FieldInsnNode ld, VarInsnNode otherLd) {
            AbstractInsnNode abstractInsnNode = ld.clone(null);
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.objectweb.asm.tree.FieldInsnNode");
            }
            FieldInsnNode ldCopy = (FieldInsnNode)abstractInsnNode;
            this.instructions.insert((AbstractInsnNode)otherLd, (AbstractInsnNode)ldCopy);
            return this.fixupLoadedAtomicVar(f, ldCopy);
        }

        private final AbstractInsnNode fixupArrayElementLoad(FieldInfo f, FieldInsnNode ld, VarInsnNode otherLd, List<? extends AbstractInsnNode> arrayElementInfo) {
            AbstractInsnNode it;
            if (Intrinsics.areEqual((Object)f.getFieldType(), (Object)AtomicFUTransformerKt.access$getATOMIC_ARRAY_TYPE$p())) {
                this.tryEraseUncheckedCast((AbstractInsnNode)otherLd);
            }
            List index = CollectionsKt.drop((Iterable)arrayElementInfo, (int)(this.vh ? 3 : 1));
            for (AbstractInsnNode indexInsn : index) {
                this.checkDataFlowComplexity(indexInsn);
            }
            AbstractInsnNode args = otherLd.getNext();
            AbstractInsnNode operationOnArrayElement = new FlowAnalyzer(args).execute();
            boolean bl = false;
            List arrayElementInfoCopy = new ArrayList();
            Iterable $this$forEach$iv = arrayElementInfo;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl2 = false;
                AbstractInsnNode abstractInsnNode = it.clone(null);
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"it.clone(null)");
                arrayElementInfoCopy.add(abstractInsnNode);
            }
            $this$forEach$iv = arrayElementInfoCopy;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl3 = false;
                this.instructions.insertBefore(args, it);
            }
            return this.fixupOperationOnAtomicVar(operationOnArrayElement, f, ld, arrayElementInfo);
        }

        public final void checkDataFlowComplexity(@NotNull AbstractInsnNode i) {
            Intrinsics.checkParameterIsNotNull((Object)i, (String)"i");
            AbstractInsnNode abstractInsnNode = i;
            if (abstractInsnNode instanceof MethodInsnNode) {
                Void void_ = AbortKt.abort("No method invocations are allowed for calculation of an array element index at the point of loading the reference to this element.\nExtract index calculation to the local variable.", i);
                throw null;
            }
            if (!(abstractInsnNode instanceof LdcInsnNode)) {
                switch (i.getOpcode()) {
                    case 96: 
                    case 100: 
                    case 104: 
                    case 108: 
                    case 112: 
                    case 120: 
                    case 122: 
                    case 124: 
                    case 126: 
                    case 128: 
                    case 130: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 21: 
                    case 46: {
                        break;
                    }
                    case 178: 
                    case 180: {
                        break;
                    }
                    default: {
                        Void void_ = AbortKt.abort("Complex data flow is not allowed for calculation of an array element index at the point of loading the reference to this element.\nExtract index calculation to the local variable.", i);
                        throw null;
                    }
                }
            }
        }

        private final AbstractInsnNode putPrimitiveTypeWrapper(MethodInsnNode factoryInsn, FieldInfo f, FieldInsnNode next) {
            Type factoryArg;
            Type type = Type.getMethodType((String)factoryInsn.desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"getMethodType(factoryInsn.desc)");
            Type type2 = factoryArg = type.getArgumentTypes()[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"factoryArg");
            this.generateRefVolatileClass(f, type2);
            AbstractInsnNode firstInitInsn = new FlowAnalyzer((AbstractInsnNode)next).getInitStart();
            AbstractInsnNode afterPutStatic = next.getNext();
            this.instructions.remove((AbstractInsnNode)factoryInsn);
            this.instructions.remove((AbstractInsnNode)next);
            AbstractInsnNode abstractInsnNode = afterPutStatic;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"afterPutStatic");
            this.initRefVolatile(f, factoryArg, firstInitInsn, abstractInsnNode);
            return afterPutStatic;
        }

        private final AbstractInsnNode putJucaAtomicArray(MethodInsnNode arrayfactoryInsn, FieldInfo f, FieldInsnNode next) {
            AbstractInsnNode initStart;
            String jucaAtomicArrayDesc = f.getTypeInfo().getFuType().getDescriptor();
            AbstractInsnNode abstractInsnNode = initStart = new FlowAnalyzer((AbstractInsnNode)next).getInitStart().getNext();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"initStart");
            if (abstractInsnNode.getOpcode() == 187) {
                TypeInsnNode typeInsnNode = (TypeInsnNode)initStart;
                String string = jucaAtomicArrayDesc;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jucaAtomicArrayDesc");
                typeInsnNode.desc = AtomicFUTransformer.this.descToName(string);
                arrayfactoryInsn.owner = AtomicFUTransformer.this.descToName(jucaAtomicArrayDesc);
            } else {
                String string = jucaAtomicArrayDesc;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jucaAtomicArrayDesc");
                TypeInsnNode newInsn = new TypeInsnNode(187, AtomicFUTransformer.this.descToName(string));
                this.instructions.insert(initStart.getPrevious(), (AbstractInsnNode)newInsn);
                this.instructions.insert((AbstractInsnNode)newInsn, (AbstractInsnNode)new InsnNode(89));
                MethodInsnNode jucaArrayFactory = new MethodInsnNode(183, AtomicFUTransformer.this.descToName(jucaAtomicArrayDesc), "<init>", "(I)V", false);
                this.instructions.set((AbstractInsnNode)arrayfactoryInsn, (AbstractInsnNode)jucaArrayFactory);
            }
            next.desc = jucaAtomicArrayDesc;
            next.name = f.getName();
            AtomicFUTransformer.this.setTransformed(true);
            return next.getNext();
        }

        private final AbstractInsnNode putPureVhArray(MethodInsnNode arrayFactoryInsn, FieldInfo f, FieldInsnNode next) {
            AbstractInsnNode abstractInsnNode;
            AbstractInsnNode initStart;
            AbstractInsnNode abstractInsnNode2 = initStart = new FlowAnalyzer((AbstractInsnNode)next).getInitStart().getNext();
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode2, (String)"initStart");
            if (abstractInsnNode2.getOpcode() == 187) {
                this.instructions.remove(initStart.getNext());
                this.instructions.remove(initStart);
            }
            Type primitiveType = f.getPrimitiveType(this.vh);
            Integer primitiveElementType = (Integer)AtomicFUTransformerKt.access$getARRAY_ELEMENT_TYPE$p().get(f.getTypeInfo().getOriginalType());
            if (primitiveElementType != null) {
                abstractInsnNode = (AbstractInsnNode)new IntInsnNode(188, primitiveElementType.intValue());
            } else {
                Type type = primitiveType.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"primitiveType.elementType");
                String string = type.getDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"primitiveType.elementType.descriptor");
                abstractInsnNode = (AbstractInsnNode)new TypeInsnNode(189, AtomicFUTransformer.this.descToName(string));
            }
            AbstractInsnNode newArray = abstractInsnNode;
            this.instructions.set((AbstractInsnNode)arrayFactoryInsn, newArray);
            next.desc = primitiveType.getDescriptor();
            next.name = f.getName();
            AtomicFUTransformer.this.setTransformed(true);
            return next.getNext();
        }

        private final AbstractInsnNode transform(AbstractInsnNode i) {
            AbstractInsnNode abstractInsnNode = i;
            if (abstractInsnNode instanceof MethodInsnNode) {
                Object f;
                String string = ((MethodInsnNode)i).owner;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"i.owner");
                String string2 = ((MethodInsnNode)i).name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"i.name");
                String string3 = ((MethodInsnNode)i).desc;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"i.desc");
                MethodId methodId = new MethodId(string, string2, string3, ((MethodInsnNode)i).getOpcode());
                if (AtomicFUTransformerKt.access$getFACTORIES$p().contains(methodId)) {
                    Object object;
                    if (Intrinsics.areEqual((Object)this.name, (Object)"<init>") ^ true && Intrinsics.areEqual((Object)this.name, (Object)"<clinit>") ^ true) {
                        Void void_ = AbortKt.abort$default("factory " + methodId + " is used outside of constructor or class initialisation", null, 2, null);
                        throw null;
                    }
                    AbstractInsnNode next = AsmUtilKt.getNextUseful(i);
                    AbstractInsnNode abstractInsnNode2 = next;
                    if (!(abstractInsnNode2 instanceof FieldInsnNode)) {
                        abstractInsnNode2 = null;
                    }
                    if ((object = (FieldInsnNode)abstractInsnNode2) == null || (object = this.checkPutFieldOrPutStatic((FieldInsnNode)object)) == null) {
                        Void void_ = AbortKt.abort$default("factory " + methodId + " invocation must be followed by putfield", null, 2, null);
                        throw null;
                    }
                    Object fieldId = object;
                    Object v = AtomicFUTransformer.this.fields.get(fieldId);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    FieldInfo f2 = (FieldInfo)v;
                    if (!this.vh && f2.isStatic() && !f2.isArray()) {
                        return this.putPrimitiveTypeWrapper((MethodInsnNode)i, f2, (FieldInsnNode)next);
                    }
                    if (f2.isArray()) {
                        return this.vh ? this.putPureVhArray((MethodInsnNode)i, f2, (FieldInsnNode)next) : this.putJucaAtomicArray((MethodInsnNode)i, f2, (FieldInsnNode)next);
                    }
                    this.instructions.remove(i);
                    AtomicFUTransformer.this.setTransformed(true);
                    Type primitiveType = f2.getPrimitiveType(this.vh);
                    ((FieldInsnNode)next).desc = primitiveType.getDescriptor();
                    ((FieldInsnNode)next).name = f2.getName();
                    return ((FieldInsnNode)next).getNext();
                }
                Map next = AtomicFUTransformer.this.accessors;
                boolean fieldId = false;
                Map map = next;
                boolean bl = false;
                if (map.containsKey(methodId)) {
                    String string4;
                    Object v = AtomicFUTransformer.this.accessors.get(methodId);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    f = (FieldInfo)v;
                    String string5 = ((FieldInfo)f).getOwner();
                    String string6 = ((FieldInfo)f).getFuName();
                    if (this.vh) {
                        Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"VH_TYPE");
                        string4 = type.getDescriptor();
                    } else {
                        string4 = ((FieldInfo)f).getFuType().getDescriptor();
                    }
                    FieldInsnNode j = new FieldInsnNode(178, string5, string6, string4);
                    if (!this.vh && ((FieldInfo)f).isArray()) {
                        j.setOpcode(!((FieldInfo)f).isStatic() ? 180 : 178);
                        j.name = ((FieldInfo)f).getName();
                    }
                    this.instructions.set(i, (AbstractInsnNode)j);
                    if (this.vh && ((FieldInfo)f).isArray()) {
                        return this.insertPureVhArray(j, (FieldInfo)f);
                    }
                    AtomicFUTransformer.this.setTransformed(true);
                    return this.fixupLoadedAtomicVar((FieldInfo)f, j);
                }
                if (AtomicFUTransformer.this.removeMethods.contains(methodId)) {
                    Void void_ = AbortKt.abort("invocation of method " + methodId + " on atomic types. " + "Make the later method 'inline' to use it", i);
                    throw null;
                }
                if (((MethodInsnNode)i).getOpcode() == 182) {
                    f = AtomicFUTransformerKt.access$getAFU_CLASSES$p();
                    String j = ((MethodInsnNode)i).owner;
                    boolean bl2 = false;
                    Object object = f;
                    boolean bl3 = false;
                    if (object.containsKey(j)) {
                        Void void_ = AbortKt.abort("standalone invocation of " + methodId + " that was not traced to previous field load", i);
                        throw null;
                    }
                }
            } else if (abstractInsnNode instanceof FieldInsnNode) {
                String string = ((FieldInsnNode)i).owner;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"i.owner");
                String string7 = ((FieldInsnNode)i).name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"i.name");
                String string8 = ((FieldInsnNode)i).desc;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"i.desc");
                FieldId fieldId = new FieldId(string, string7, string8);
                if (((FieldInsnNode)i).getOpcode() == 180 || ((FieldInsnNode)i).getOpcode() == 178) {
                    Object f = AtomicFUTransformer.this.fields;
                    boolean j = false;
                    Map map = f;
                    boolean bl = false;
                    if (map.containsKey(fieldId)) {
                        String string9;
                        boolean isArray;
                        Object v = AtomicFUTransformer.this.fields.get(fieldId);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        boolean bl4 = isArray = ((FieldInfo)(f = (FieldInfo)v)).getPrimitiveType(this.vh).getSort() == 9;
                        if (!isArray || this.vh) {
                            if (Intrinsics.areEqual((Object)((FieldInsnNode)i).desc, (Object)((FieldInfo)f).getFieldType().getDescriptor()) ^ true) {
                                return ((FieldInsnNode)i).getNext();
                            }
                            ((FieldInsnNode)i).setOpcode(178);
                            ((FieldInsnNode)i).name = ((FieldInfo)f).getFuName();
                        }
                        if (!this.vh && isArray && ((FieldInfo)f).getHasExternalAccess()) {
                            ((FieldInsnNode)i).name = ((FieldInfo)f).getName();
                        }
                        if (this.vh) {
                            Type type = AtomicFUTransformerKt.access$getVH_TYPE$p();
                            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"VH_TYPE");
                            string9 = type.getDescriptor();
                        } else {
                            string9 = ((FieldInsnNode)i).desc = ((FieldInfo)f).getFuType().getDescriptor();
                        }
                        if (this.vh && ((FieldInfo)f).getPrimitiveType(this.vh).getSort() == 9) {
                            return this.insertPureVhArray((FieldInsnNode)i, (FieldInfo)f);
                        }
                        AtomicFUTransformer.this.setTransformed(true);
                        return this.fixupLoadedAtomicVar((FieldInfo)f, (FieldInsnNode)i);
                    }
                }
            }
            return i.getNext();
        }

        private final AbstractInsnNode insertPureVhArray(FieldInsnNode getVarHandleInsn, FieldInfo f) {
            FieldInsnNode getPureArray = new FieldInsnNode(180, f.getOwner(), f.getName(), f.getPrimitiveType(this.vh).getDescriptor());
            if (!f.isStatic()) {
                InsnNode swap = new InsnNode(95);
                this.instructions.insert((AbstractInsnNode)getVarHandleInsn, (AbstractInsnNode)swap);
                this.instructions.insert((AbstractInsnNode)swap, (AbstractInsnNode)getPureArray);
            } else {
                getPureArray.setOpcode(178);
                this.instructions.insert((AbstractInsnNode)getVarHandleInsn, (AbstractInsnNode)getPureArray);
            }
            AtomicFUTransformer.this.setTransformed(true);
            return this.fixupLoadedAtomicVar(f, getPureArray);
        }

        private final void generateRefVolatileClass(FieldInfo f, Type arg) {
            MethodVisitor cons;
            if (this.analyzePhase2) {
                return;
            }
            ClassWriter cw = new ClassWriter(0);
            cw.visit(50, 4097, f.getRefVolatileClassName(), null, "java/lang/Object", null);
            MethodVisitor methodVisitor = cons = cw.visitMethod(1, "<init>", '(' + arg.getDescriptor() + ")V", null, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"cons");
            MethodVisitor mv$iv = methodVisitor;
            boolean $i$f$code = false;
            InstructionAdapter $this$code = new InstructionAdapter(mv$iv);
            boolean bl = false;
            $this$code.visitVarInsn(25, 0);
            $this$code.invokespecial("java/lang/Object", "<init>", "()V", false);
            $this$code.visitVarInsn(25, 0);
            $this$code.load(1, arg);
            $this$code.putfield(f.getRefVolatileClassName(), f.getName(), f.getPrimitiveType(this.vh).getDescriptor());
            $this$code.visitInsn(177);
            $this$code.visitMaxs(3, 3);
            int protection = 64;
            cw.visitField(protection, f.getName(), f.getPrimitiveType(this.vh).getDescriptor(), null, null);
            File genFile = AtomicFUTransformer.this.div(AtomicFUTransformer.this.getOutputDir(), f.getRefVolatileClassName() + ".class");
            byte[] byArray = cw.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
            AtomicFUTransformer.this.mkdirsAndWrite(genFile, byArray);
        }

        private final void initRefVolatile(FieldInfo f, Type argType, AbstractInsnNode firstInitInsn, AbstractInsnNode lastInitInsn) {
            TypeInsnNode typeInsnNode = new TypeInsnNode(187, f.getRefVolatileClassName());
            InsnNode dup = new InsnNode(89);
            this.instructions.insertBefore(firstInitInsn, (AbstractInsnNode)typeInsnNode);
            this.instructions.insertBefore(firstInitInsn, (AbstractInsnNode)dup);
            MethodInsnNode invokespecial = new MethodInsnNode(183, f.getRefVolatileClassName(), "<init>", '(' + argType.getDescriptor() + ")V", false);
            String string = f.getOwner();
            String string2 = f.getStaticRefVolatileField();
            Type type = Type.getObjectType((String)f.getRefVolatileClassName());
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"getObjectType(f.refVolatileClassName)");
            FieldInsnNode putstatic = new FieldInsnNode(179, string, string2, type.getDescriptor());
            this.instructions.insertBefore(lastInitInsn, (AbstractInsnNode)invokespecial);
            this.instructions.insert((AbstractInsnNode)invokespecial, (AbstractInsnNode)putstatic);
        }

        public TransformerMV(AtomicFUTransformerBase.SourceInfo sourceInfo, @NotNull int access, @NotNull String name, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions, @NotNull MethodVisitor mv, String packageName, boolean vh, boolean analyzePhase2) {
            Intrinsics.checkParameterIsNotNull((Object)sourceInfo, (String)"sourceInfo");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            super(327680, access, name, desc, signature, exceptions);
            this.packageName = packageName;
            this.vh = vh;
            this.analyzePhase2 = analyzePhase2;
            this.mv = mv;
            this.sourceInfo = AtomicFUTransformerBase.SourceInfo.copy$default(sourceInfo, null, null, null, this.instructions, 7, null);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0014\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformer$CW;", "Lorg/objectweb/asm/ClassWriter;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformer;)V", "getCommonSuperClass", "", "type1", "type2", "atomicfu-transformer"})
    private final class CW
    extends ClassWriter {
        @NotNull
        protected String getCommonSuperClass(@NotNull String type1, @NotNull String type2) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)type1, (String)"type1");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type2");
            Class c = AtomicFUTransformer.this.loadClass(type1);
            Class d = AtomicFUTransformer.this.loadClass(type2);
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                string = "java/lang/Object";
            } else {
                do {
                    Intrinsics.checkExpressionValueIsNotNull(c.getSuperclass(), (String)"c.superclass");
                } while (!c.isAssignableFrom(d));
                String string2 = c.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"c.name");
                string = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            return string;
        }

        public CW() {
            super(3);
        }
    }
}

