/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.transformer;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.transformer.AsmUtilKt;
import kotlinx.atomicfu.transformer.MethodId;
import kotlinx.atomicfu.transformer.TransformerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0004J\u001c\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0004J\u001c\u0010%\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001c\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0004J\b\u0010'\u001a\u00020\u001fH&J\u0015\u0010(\u001a\u00020\u0003*\u00020\u00032\u0006\u0010)\u001a\u00020!H\u0084\u0002J\f\u0010*\u001a\u00020\u0016*\u00020\u0003H\u0004J\u0014\u0010+\u001a\u00020\u001f*\u00020\u00032\u0006\u0010,\u001a\u00020-H\u0004J\f\u0010.\u001a\u00020\u0003*\u00020\u0003H\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\tR\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001a\u00a8\u00060"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase;", "", "inputDir", "Ljava/io/File;", "outputDir", "(Ljava/io/File;Ljava/io/File;)V", "getInputDir", "()Ljava/io/File;", "setInputDir", "(Ljava/io/File;)V", "lastError", "", "getLastError", "()Ljava/lang/Throwable;", "setLastError", "(Ljava/lang/Throwable;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getOutputDir", "setOutputDir", "transformed", "", "getTransformed", "()Z", "setTransformed", "(Z)V", "verbose", "getVerbose", "setVerbose", "debug", "", "message", "", "sourceInfo", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "error", "format", "info", "transform", "div", "child", "isClassFile", "mkdirsAndWrite", "outBytes", "", "toOutputFile", "SourceInfo", "atomicfu-transformer"})
public abstract class AtomicFUTransformerBase {
    private final Logger logger;
    private boolean verbose;
    @Nullable
    private Throwable lastError;
    private boolean transformed;
    @NotNull
    private File inputDir;
    @NotNull
    private File outputDir;

    @NotNull
    protected final File div(@NotNull File $this$div, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)$this$div, (String)"$this$div");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        return new File($this$div, child);
    }

    @NotNull
    protected final File toOutputFile(@NotNull File $this$toOutputFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toOutputFile, (String)"$this$toOutputFile");
        String string = FilesKt.relativeTo((File)$this$toOutputFile, (File)this.inputDir).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativeTo(inputDir).toString()");
        return this.div(this.outputDir, string);
    }

    protected final void mkdirsAndWrite(@NotNull File $this$mkdirsAndWrite, @NotNull byte[] outBytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$mkdirsAndWrite, (String)"$this$mkdirsAndWrite");
        Intrinsics.checkParameterIsNotNull((Object)outBytes, (String)"outBytes");
        $this$mkdirsAndWrite.getParentFile().mkdirs();
        FilesKt.writeBytes((File)$this$mkdirsAndWrite, (byte[])outBytes);
    }

    protected final boolean isClassFile(@NotNull File $this$isClassFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isClassFile, (String)"$this$isClassFile");
        String string = $this$isClassFile.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toString()");
        return StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Nullable
    protected final Throwable getLastError() {
        return this.lastError;
    }

    protected final void setLastError(@Nullable Throwable throwable) {
        this.lastError = throwable;
    }

    protected final boolean getTransformed() {
        return this.transformed;
    }

    protected final void setTransformed(boolean bl) {
        this.transformed = bl;
    }

    private final String format(String message, SourceInfo sourceInfo) {
        String loc;
        String string = loc = sourceInfo == null ? "" : sourceInfo.toString() + ": ";
        if (this.verbose && sourceInfo != null && sourceInfo.getI() != null) {
            loc = loc + AsmUtilKt.atIndex(sourceInfo.getI(), sourceInfo.getInsnList());
        }
        return loc + message;
    }

    static /* synthetic */ String format$default(AtomicFUTransformerBase atomicFUTransformerBase, String string, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: format");
        }
        if ((n & 2) != 0) {
            sourceInfo = null;
        }
        return atomicFUTransformerBase.format(string, sourceInfo);
    }

    protected final void info(@NotNull String message, @Nullable SourceInfo sourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.logger.info(this.format(message, sourceInfo));
    }

    public static /* synthetic */ void info$default(AtomicFUTransformerBase atomicFUTransformerBase, String string, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: info");
        }
        if ((n & 2) != 0) {
            sourceInfo = null;
        }
        atomicFUTransformerBase.info(string, sourceInfo);
    }

    protected final void debug(@NotNull String message, @Nullable SourceInfo sourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.logger.debug(this.format(message, sourceInfo));
    }

    public static /* synthetic */ void debug$default(AtomicFUTransformerBase atomicFUTransformerBase, String string, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debug");
        }
        if ((n & 2) != 0) {
            sourceInfo = null;
        }
        atomicFUTransformerBase.debug(string, sourceInfo);
    }

    protected final void error(@NotNull String message, @Nullable SourceInfo sourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.logger.error(this.format(message, sourceInfo));
        if (this.lastError == null) {
            this.lastError = new TransformerException(message, null, 2, null);
        }
    }

    public static /* synthetic */ void error$default(AtomicFUTransformerBase atomicFUTransformerBase, String string, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
        }
        if ((n & 2) != 0) {
            sourceInfo = null;
        }
        atomicFUTransformerBase.error(string, sourceInfo);
    }

    public abstract void transform();

    @NotNull
    public final File getInputDir() {
        return this.inputDir;
    }

    public final void setInputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.inputDir = file;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    public AtomicFUTransformerBase(@NotNull File inputDir, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.verbose = true;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase$SourceInfo;", "", "method", "Lkotlinx/atomicfu/transformer/MethodId;", "source", "", "i", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "insnList", "Lorg/objectweb/asm/tree/InsnList;", "(Lkotlinx/atomicfu/transformer/MethodId;Ljava/lang/String;Lorg/objectweb/asm/tree/AbstractInsnNode;Lorg/objectweb/asm/tree/InsnList;)V", "getI", "()Lorg/objectweb/asm/tree/AbstractInsnNode;", "getInsnList", "()Lorg/objectweb/asm/tree/InsnList;", "getMethod", "()Lkotlinx/atomicfu/transformer/MethodId;", "getSource", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "atomicfu-transformer"})
    public static final class SourceInfo {
        @NotNull
        private final MethodId method;
        @Nullable
        private final String source;
        @Nullable
        private final AbstractInsnNode i;
        @Nullable
        private final InsnList insnList;

        @NotNull
        public String toString() {
            Object object;
            boolean bl;
            boolean bl2;
            String string;
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl7 = false;
            String string2 = this.source;
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                String it = string;
                boolean bl8 = false;
                $this$buildString.append(it + ':');
            }
            if ((object = this.i) != null && (object = AsmUtilKt.getLine(object)) != null) {
                string = object;
                bl2 = false;
                bl = false;
                int it = ((Number)((Object)string)).intValue();
                boolean bl9 = false;
                $this$buildString.append("" + it + ':');
            }
            $this$buildString.append("" + ' ' + this.method);
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            return string3;
        }

        @NotNull
        public final MethodId getMethod() {
            return this.method;
        }

        @Nullable
        public final String getSource() {
            return this.source;
        }

        @Nullable
        public final AbstractInsnNode getI() {
            return this.i;
        }

        @Nullable
        public final InsnList getInsnList() {
            return this.insnList;
        }

        public SourceInfo(@NotNull MethodId method, @Nullable String source, @Nullable AbstractInsnNode i, @Nullable InsnList insnList) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            this.method = method;
            this.source = source;
            this.i = i;
            this.insnList = insnList;
        }

        public /* synthetic */ SourceInfo(MethodId methodId, String string, AbstractInsnNode abstractInsnNode, InsnList insnList, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                abstractInsnNode = null;
            }
            if ((n & 8) != 0) {
                insnList = null;
            }
            this(methodId, string, abstractInsnNode, insnList);
        }

        @NotNull
        public final MethodId component1() {
            return this.method;
        }

        @Nullable
        public final String component2() {
            return this.source;
        }

        @Nullable
        public final AbstractInsnNode component3() {
            return this.i;
        }

        @Nullable
        public final InsnList component4() {
            return this.insnList;
        }

        @NotNull
        public final SourceInfo copy(@NotNull MethodId method, @Nullable String source, @Nullable AbstractInsnNode i, @Nullable InsnList insnList) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            return new SourceInfo(method, source, i, insnList);
        }

        public static /* synthetic */ SourceInfo copy$default(SourceInfo sourceInfo, MethodId methodId, String string, AbstractInsnNode abstractInsnNode, InsnList insnList, int n, Object object) {
            if ((n & 1) != 0) {
                methodId = sourceInfo.method;
            }
            if ((n & 2) != 0) {
                string = sourceInfo.source;
            }
            if ((n & 4) != 0) {
                abstractInsnNode = sourceInfo.i;
            }
            if ((n & 8) != 0) {
                insnList = sourceInfo.insnList;
            }
            return sourceInfo.copy(methodId, string, abstractInsnNode, insnList);
        }

        public int hashCode() {
            MethodId methodId = this.method;
            String string = this.source;
            AbstractInsnNode abstractInsnNode = this.i;
            InsnList insnList = this.insnList;
            return (((methodId != null ? ((Object)methodId).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (abstractInsnNode != null ? abstractInsnNode.hashCode() : 0)) * 31 + (insnList != null ? insnList.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SourceInfo)) break block3;
                    SourceInfo sourceInfo = (SourceInfo)object;
                    if (!Intrinsics.areEqual((Object)this.method, (Object)sourceInfo.method) || !Intrinsics.areEqual((Object)this.source, (Object)sourceInfo.source) || !Intrinsics.areEqual((Object)this.i, (Object)sourceInfo.i) || !Intrinsics.areEqual((Object)this.insnList, (Object)sourceInfo.insnList)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

