/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.transformer;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.transformer.AtomicFUTransformerBase;
import kotlinx.atomicfu.transformer.AtomicFUTransformerJS;
import kotlinx.atomicfu.transformer.AtomicFUTransformerJSKt;
import kotlinx.atomicfu.transformer.EmptyLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0005!\"#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\b*\u00020\u0011H\u0002J*\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0014*\u00020\u0003H\u0002J\f\u0010\u001b\u001a\u00020\u0014*\u00020\u0011H\u0002J\f\u0010\u001c\u001a\u00020\b*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\b*\u00020\u0011H\u0002J\u0014\u0010\u001f\u001a\u00020\f*\u00020\u00152\u0006\u0010 \u001a\u00020\bH\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase;", "inputDir", "Ljava/io/File;", "outputDir", "(Ljava/io/File;Ljava/io/File;)V", "atomicArrayConstructors", "", "", "atomicConstructors", "", "transform", "", "transformFile", "", "file", "eraseAtomicFieldFromUncheckedCast", "Lorg/mozilla/javascript/ast/AstNode;", "eraseGetValue", "inlineAtomicOperation", "", "Lorg/mozilla/javascript/ast/FunctionCall;", "funcName", "field", "args", "", "isJsFile", "isThisNode", "resolvePropName", "Lorg/mozilla/javascript/ast/PropertyGet;", "scopedSource", "setImpl", "code", "AtomicConstructorDetector", "AtomicOperationsInliner", "DependencyEraser", "ReceiverResolver", "TransformVisitor", "atomicfu-transformer"})
public final class AtomicFUTransformerJS
extends AtomicFUTransformerBase {
    private final Set<String> atomicConstructors;
    private final Map<String, String> atomicArrayConstructors;

    @Override
    public void transform() {
        AtomicFUTransformerBase.info$default(this, "Transforming to " + this.getOutputDir(), null, 2, null);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.getInputDir(), null, (int)1, null)), (Function1)transform.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            File file = (File)element$iv;
            boolean bl = false;
            if (this.isJsFile(file)) {
                String string = "Transforming file: " + file.getCanonicalPath();
                boolean bl2 = false;
                System.out.println((Object)string);
                byArray = this.transformFile(file);
            } else {
                byArray = FilesKt.readBytes((File)file);
            }
            byte[] outBytes = byArray;
            this.mkdirsAndWrite(this.toOutputFile(file), outBytes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJsFile(File $this$isJsFile) {
        String string = $this$isJsFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)".js", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isJsFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        if (StringsKt.endsWith$default((String)string2, (String)".meta.js", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final byte[] transformFile(File file) {
        Parser p = new Parser(new CompilerEnvirons());
        AstRoot root = p.parse((Reader)new FileReader(file), null, 0);
        root.visit((NodeVisitor)new DependencyEraser());
        root.visit((NodeVisitor)new AtomicConstructorDetector());
        root.visit((NodeVisitor)new TransformVisitor());
        root.visit((NodeVisitor)new AtomicOperationsInliner());
        AstRoot astRoot = root;
        Intrinsics.checkExpressionValueIsNotNull((Object)astRoot, (String)"root");
        String string = this.eraseGetValue((AstNode)astRoot);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    private final String eraseGetValue(AstNode $this$eraseGetValue) {
        boolean bl;
        CharSequence charSequence;
        String res = $this$eraseGetValue.toSource();
        Regex primitiveGetValue = AtomicFUTransformerJSKt.access$getMANGLE_VALUE_REGEX$p();
        Regex arrayGetElement = AtomicFUTransformerJSKt.access$getARRAY_GET_ELEMENT_REGEX$p();
        while (true) {
            String string = res;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"res");
            charSequence = string;
            boolean bl2 = false;
            if (!arrayGetElement.containsMatchIn(charSequence)) break;
            charSequence = res;
            Function1 function1 = eraseGetValue.1.INSTANCE;
            bl = false;
            res = arrayGetElement.replace(charSequence, function1);
        }
        charSequence = res;
        Function1 function1 = eraseGetValue.2.INSTANCE;
        bl = false;
        return primitiveGetValue.replace(charSequence, function1);
    }

    private final AstNode eraseAtomicFieldFromUncheckedCast(AstNode $this$eraseAtomicFieldFromUncheckedCast) {
        if ($this$eraseAtomicFieldFromUncheckedCast instanceof ParenthesizedExpression && ((ParenthesizedExpression)$this$eraseAtomicFieldFromUncheckedCast).getExpression() instanceof ConditionalExpression) {
            AstNode astNode = ((ParenthesizedExpression)$this$eraseAtomicFieldFromUncheckedCast).getExpression();
            if (astNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.ConditionalExpression");
            }
            AstNode testExpression = ((ConditionalExpression)astNode).getTestExpression();
            if (testExpression instanceof FunctionCall && Intrinsics.areEqual((Object)((FunctionCall)testExpression).getTarget().toSource(), (Object)"Kotlin.isType")) {
                AstNode typeToCast;
                AstNode astNode2 = typeToCast = (AstNode)((FunctionCall)testExpression).getArguments().get(1);
                if (astNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.Name");
                }
                if (Intrinsics.areEqual((Object)((Name)astNode2).getIdentifier(), (Object)"AtomicRef")) {
                    Object e = ((FunctionCall)testExpression).getArguments().get(0);
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                    }
                    return ((Assignment)e).getRight();
                }
            }
        }
        return null;
    }

    private final boolean isThisNode(AstNode $this$isThisNode) {
        boolean bl;
        AstNode astNode = $this$isThisNode;
        if (astNode instanceof PropertyGet) {
            AstNode astNode2 = ((PropertyGet)$this$isThisNode).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)astNode2, (String)"target");
            bl = this.isThisNode(astNode2);
        } else if (astNode instanceof FunctionCall) {
            AstNode astNode3 = ((FunctionCall)$this$isThisNode).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)astNode3, (String)"target");
            bl = this.isThisNode(astNode3);
        } else {
            bl = $this$isThisNode.getType() == 43;
        }
        return bl;
    }

    private final String resolvePropName(PropertyGet $this$resolvePropName) {
        String string;
        AstNode target = $this$resolvePropName.getTarget();
        if (target instanceof PropertyGet) {
            string = this.resolvePropName((PropertyGet)target) + '.' + $this$resolvePropName.getProperty().toSource();
        } else {
            String string2 = $this$resolvePropName.getProperty().toSource();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"property.toSource()");
        }
        return string;
    }

    private final String scopedSource(AstNode $this$scopedSource) {
        if (this.isThisNode($this$scopedSource)) {
            if ($this$scopedSource instanceof PropertyGet) {
                String property = this.resolvePropName((PropertyGet)$this$scopedSource);
                return "scope." + property;
            }
            if ($this$scopedSource instanceof FunctionCall && ((FunctionCall)$this$scopedSource).getTarget() instanceof PropertyGet) {
                if (((FunctionCall)$this$scopedSource).getTarget() instanceof PropertyGet) {
                    AstNode astNode = ((FunctionCall)$this$scopedSource).getTarget();
                    if (astNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    }
                    String funcName = ((PropertyGet)astNode).getProperty().toSource();
                    Regex regex = new Regex("get\\$atomicfu");
                    String string = funcName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"funcName");
                    if (regex.matches((CharSequence)string)) {
                        AstNode astNode2 = ((FunctionCall)$this$scopedSource).getTarget();
                        if (astNode2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        }
                        String property = this.resolvePropName((PropertyGet)astNode2);
                        return "scope." + property + '(' + ((AstNode)((FunctionCall)$this$scopedSource).getArguments().get(0)).toSource() + ')';
                    }
                }
            } else if ($this$scopedSource.getType() == 43) {
                return "scope";
            }
        }
        String string = $this$scopedSource.toSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.toSource()");
        return string;
    }

    private final boolean inlineAtomicOperation(FunctionCall $this$inlineAtomicOperation, String funcName, AstNode field, List<? extends AstNode> args) {
        String code;
        String f = this.scopedSource(field);
        switch (funcName) {
            case "getAndSet$atomicfu": {
                String arg = args.get(0).toSource();
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + arg + "; return oldValue;})()";
                break;
            }
            case "compareAndSet$atomicfu": {
                String expected = this.scopedSource(args.get(0));
                String updated = this.scopedSource(args.get(1));
                String equals = Intrinsics.areEqual((Object)expected, (Object)"null") ? "==" : "===";
                String string = "(function(scope) {return " + f + ' ' + equals + ' ' + expected + " ? function() { " + f + " = " + updated + "; return true }() : false})()";
                break;
            }
            case "getAndIncrement$atomicfu": {
                String string = "(function(scope) {return " + f + "++;})()";
                break;
            }
            case "getAndIncrement$atomicfu$long": {
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".inc(); return oldValue;})()";
                break;
            }
            case "getAndDecrement$atomicfu": {
                String string = "(function(scope) {return " + f + "--;})()";
                break;
            }
            case "getAndDecrement$atomicfu$long": {
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".dec(); return oldValue;})()";
                break;
            }
            case "getAndAdd$atomicfu": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " += " + arg + "; return oldValue;})()";
                break;
            }
            case "getAndAdd$atomicfu$long": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".add(" + arg + "); return oldValue;})()";
                break;
            }
            case "addAndGet$atomicfu": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {" + f + " += " + arg + "; return " + f + ";})()";
                break;
            }
            case "addAndGet$atomicfu$long": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {" + f + " = " + f + ".add(" + arg + "); return " + f + ";})()";
                break;
            }
            case "incrementAndGet$atomicfu": {
                String string = "(function(scope) {return ++" + f + ";})()";
                break;
            }
            case "incrementAndGet$atomicfu$long": {
                String string = "(function(scope) {return " + f + " = " + f + ".inc();})()";
                break;
            }
            case "decrementAndGet$atomicfu": {
                String string = "(function(scope) {return --" + f + ";})()";
                break;
            }
            case "decrementAndGet$atomicfu$long": {
                String string = "(function(scope) {return " + f + " = " + f + ".dec();})()";
                break;
            }
            default: {
                String string = code = null;
            }
        }
        if (code != null) {
            this.setImpl($this$inlineAtomicOperation, code);
            return true;
        }
        return false;
    }

    private final void setImpl(FunctionCall $this$setImpl, String code) {
        AstRoot node;
        Parser p = new Parser(new CompilerEnvirons());
        AstRoot astRoot = node = p.parse(code, null, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)astRoot, (String)"node");
        if (astRoot.getFirstChild() != null) {
            AstRoot thisNode;
            AstNode expr;
            Node node2 = node.getFirstChild();
            if (node2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            }
            AstNode astNode = expr = ((ExpressionStatement)node2).getExpression();
            if (astNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
            }
            $this$setImpl.setTarget(((FunctionCall)astNode).getTarget());
            AstRoot astRoot2 = thisNode = new Parser(new CompilerEnvirons()).parse("this", null, 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)astRoot2, (String)"thisNode");
            Node node3 = astRoot2.getFirstChild();
            if (node3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            }
            $this$setImpl.setArguments(CollectionsKt.listOf((Object)((ExpressionStatement)node3).getExpression()));
        }
    }

    public AtomicFUTransformerJS(@NotNull File inputDir, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        super(inputDir, outputDir);
        boolean bl = false;
        this.atomicConstructors = new LinkedHashSet();
        bl = false;
        this.atomicArrayConstructors = new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$DependencyEraser;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "isAtomicfuDependency", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "isAtomicfuModule", "visit", "atomicfu-transformer"})
    public final class DependencyEraser
    implements NodeVisitor {
        private final boolean isAtomicfuDependency(AstNode node) {
            return node.getType() == 41 && Intrinsics.areEqual((Object)node.toSource(), (Object)"'kotlinx-atomicfu'");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtomicfuModule(AstNode node) {
            if (node.getType() != 39) return false;
            String string = node.toSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.toSource()");
            CharSequence charSequence = string;
            Regex regex = new Regex("\\$module\\$kotlinx_atomicfu");
            boolean bl = false;
            if (!regex.matches(charSequence)) return false;
            return true;
        }

        public boolean visit(@NotNull AstNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            switch (node.getType()) {
                case 66: {
                    List list = ((ArrayLiteral)node).getElements();
                    if (list == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<org.mozilla.javascript.ast.AstNode!>");
                    }
                    List elements = TypeIntrinsics.asMutableList((Object)list);
                    ListIterator it = elements.listIterator();
                    while (it.hasNext()) {
                        AstNode arg;
                        AstNode astNode = arg = (AstNode)it.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)astNode, (String)"arg");
                        if (!this.isAtomicfuDependency(astNode)) continue;
                        it.remove();
                    }
                    break;
                }
                case 110: {
                    if (!(node instanceof FunctionNode)) break;
                    ListIterator it = ((FunctionNode)node).getParams().listIterator();
                    while (it.hasNext()) {
                        Object e = it.next();
                        Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.next()");
                        if (!this.isAtomicfuModule((AstNode)e)) continue;
                        it.remove();
                    }
                    break;
                }
                case 38: {
                    if (!(node instanceof FunctionCall) || !Intrinsics.areEqual((Object)((FunctionCall)node).getTarget().toSource(), (Object)"factory")) break;
                    ListIterator it = ((FunctionCall)node).getArguments().listIterator();
                    while (it.hasNext()) {
                        AstNode arg;
                        AstNode astNode = arg = (AstNode)it.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)astNode, (String)"arg");
                        switch (astNode.getType()) {
                            case 36: {
                                AstNode astNode2 = ((ElementGet)arg).getElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)astNode2, (String)"(arg as ElementGet).element");
                                if (!this.isAtomicfuDependency(astNode2)) break;
                                it.remove();
                                break;
                            }
                            case 38: {
                                if (!Intrinsics.areEqual((Object)((FunctionCall)arg).getTarget().toSource(), (Object)"require")) break;
                                Object e = ((FunctionCall)arg).getArguments().get(0);
                                Intrinsics.checkExpressionValueIsNotNull(e, (String)"arg.arguments[0]");
                                if (!this.isAtomicfuDependency((AstNode)e)) break;
                                it.remove();
                                break;
                            }
                        }
                    }
                    break;
                }
                case 36: {
                    AstNode enclosingNode;
                    AstNode astNode = ((ElementGet)node).getElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode, (String)"(node as ElementGet).element");
                    if (!this.isAtomicfuDependency(astNode)) break;
                    AstNode astNode3 = enclosingNode = ((ElementGet)node).getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode3, (String)"enclosingNode");
                    if (astNode3.getType() != 32) break;
                    AstNode astNode4 = enclosingNode.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode4, (String)"enclosingNode.parent");
                    AstNode astNode5 = astNode4.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode5, (String)"enclosingNode.parent.parent");
                    if (astNode5.getType() != 113) break;
                    AstNode astNode6 = enclosingNode.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode6, (String)"enclosingNode.parent");
                    AstNode astNode7 = astNode6.getParent();
                    if (astNode7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.IfStatement");
                    }
                    IfStatement ifStatement = (IfStatement)astNode7;
                    KeywordLiteral falseKeyword = new KeywordLiteral();
                    falseKeyword.setType(44);
                    ifStatement.setCondition((AstNode)falseKeyword);
                    Block oneLineBlock = new Block();
                    oneLineBlock.addStatement((AstNode)new EmptyLine());
                    ifStatement.setThenPart((AstNode)oneLineBlock);
                    break;
                }
                case 130: {
                    for (Node stmt : node) {
                        AstNode expr;
                        if (!(stmt instanceof ExpressionStatement) || !((expr = ((ExpressionStatement)stmt).getExpression()) instanceof Assignment) || !(((Assignment)expr).getLeft() instanceof ElementGet)) continue;
                        AstNode astNode = ((Assignment)expr).getLeft();
                        if (astNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.ElementGet");
                        }
                        AstNode astNode8 = ((ElementGet)astNode).getElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)astNode8, (String)"(expr.left as ElementGet).element");
                        if (!this.isAtomicfuDependency(astNode8)) continue;
                        node.replaceChild(stmt, (Node)new EmptyLine());
                    }
                    break;
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicConstructorDetector;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "kotlinxAtomicfuModuleName", "", "name", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class AtomicConstructorDetector
    implements NodeVisitor {
        private final String kotlinxAtomicfuModuleName(String name) {
            return "\\$module\\$kotlinx_atomicfu.kotlinx.atomicfu." + name;
        }

        /*
         * WARNING - void declaration
         */
        public boolean visit(@Nullable AstNode node) {
            Object object;
            Object object2;
            String initializer;
            Object object3;
            if (node instanceof Block) {
                for (Node stmt : node) {
                    String initializer2;
                    if (!(stmt instanceof VariableDeclaration)) continue;
                    Object e = ((VariableDeclaration)stmt).getVariables().get(0);
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.VariableInitializer");
                    }
                    VariableInitializer varInit = (VariableInitializer)e;
                    if (!(varInit.getInitializer() instanceof PropertyGet)) continue;
                    String string = initializer2 = ((PropertyGet)varInit.getInitializer()).toSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"initializer");
                    object3 = string;
                    Regex regex = new Regex(this.kotlinxAtomicfuModuleName("(atomic\\$(ref|int|long|boolean)\\$|Atomic(Ref|Int|Long|Boolean))"));
                    boolean bl = false;
                    if (regex.matches((CharSequence)object3)) {
                        Set set = AtomicFUTransformerJS.this.atomicConstructors;
                        String string2 = varInit.getTarget().toSource();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"varInit.target.toSource()");
                        set.add(string2);
                        node.replaceChild(stmt, (Node)new EmptyLine());
                        continue;
                    }
                    object3 = initializer2;
                    regex = new Regex(this.kotlinxAtomicfuModuleName("locks"));
                    bl = false;
                    if (!regex.matches((CharSequence)object3)) continue;
                    node.replaceChild(stmt, (Node)new EmptyLine());
                }
            }
            if (node instanceof VariableInitializer && ((VariableInitializer)node).getInitializer() instanceof PropertyGet) {
                String string = initializer = ((PropertyGet)((VariableInitializer)node).getInitializer()).toSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"initializer");
                object2 = string;
                object = new Regex("locks.reentrantLock\\$atomicfu");
                boolean bl = false;
                if (object.matches((CharSequence)object2)) {
                    ((VariableInitializer)node).setInitializer((AstNode)null);
                }
                object2 = initializer;
                object = new Regex(this.kotlinxAtomicfuModuleName("(atomic\\$(ref|int|long|boolean)\\$|Atomic(Ref|Int|Long|Boolean))"));
                bl = false;
                if (object.matches((CharSequence)object2)) {
                    Set set = AtomicFUTransformerJS.this.atomicConstructors;
                    String string3 = ((VariableInitializer)node).getTarget().toSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.target.toSource()");
                    set.add(string3);
                    ((VariableInitializer)node).setInitializer((AstNode)null);
                }
                object2 = initializer;
                object = new Regex(this.kotlinxAtomicfuModuleName("Atomic(Ref|Int|Long|Boolean)Array\\$(ref|int|long|boolean|ofNulls)"));
                bl = false;
                if (object.matches((CharSequence)object2)) {
                    String string4;
                    switch (StringsKt.substringAfterLast$default((String)initializer, (char)'$', null, (int)2, null)) {
                        case "int": {
                            string4 = "0";
                            break;
                        }
                        case "long": {
                            string4 = "0";
                            break;
                        }
                        case "boolean": {
                            string4 = "false";
                            break;
                        }
                        default: {
                            string4 = null;
                        }
                    }
                    String initialValue = string4;
                    Map map = AtomicFUTransformerJS.this.atomicArrayConstructors;
                    String string5 = ((VariableInitializer)node).getTarget().toSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"node.target.toSource()");
                    map.put(string5, initialValue);
                    ((VariableInitializer)node).setInitializer((AstNode)null);
                }
                return false;
            }
            if (node instanceof Assignment && ((Assignment)node).getRight() instanceof PropertyGet) {
                String string = initializer = ((PropertyGet)((Assignment)node).getRight()).toSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"initializer");
                object2 = string;
                object = new Regex("locks.reentrantLock\\$atomicfu");
                boolean bl = false;
                if (object.matches((CharSequence)object2)) {
                    void it;
                    object2 = new Name();
                    boolean bl2 = false;
                    bl = false;
                    object3 = object2;
                    Assignment assignment = (Assignment)node;
                    boolean bl3 = false;
                    it.setIdentifier("null");
                    Unit unit = Unit.INSTANCE;
                    assignment.setRight((AstNode)object2);
                    return false;
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$TransformVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "getArrayElement", "Lorg/mozilla/javascript/ast/AstNode;", "getterCall", "Lorg/mozilla/javascript/ast/FunctionCall;", "visit", "", "node", "atomicfu-transformer"})
    public final class TransformVisitor
    implements NodeVisitor {
        public boolean visit(@NotNull AstNode node) {
            block17: {
                boolean bl;
                block18: {
                    String functionName;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    if (node instanceof FunctionCall) {
                        functionName = ((FunctionCall)node).getTarget().toSource();
                        if (AtomicFUTransformerJS.this.atomicConstructors.contains(functionName)) {
                            if (((FunctionCall)node).getParent() instanceof Assignment) {
                                AstNode valueNode = (AstNode)((FunctionCall)node).getArguments().get(0);
                                AstNode astNode = ((FunctionCall)node).getParent();
                                if (astNode == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.InfixExpression");
                                }
                                ((InfixExpression)astNode).setRight(valueNode);
                            }
                            return true;
                        }
                        Map valueNode = AtomicFUTransformerJS.this.atomicArrayConstructors;
                        bl = false;
                        Map map = valueNode;
                        boolean bl2 = false;
                        if (map.containsKey(functionName)) {
                            Name arrayConstructor = new Name();
                            arrayConstructor.setIdentifier("Array");
                            ((FunctionCall)node).setTarget((AstNode)arrayConstructor);
                            String string = (String)AtomicFUTransformerJS.this.atomicArrayConstructors.get(functionName);
                            if (string != null) {
                                String string2 = string;
                                boolean bl3 = false;
                                bl2 = false;
                                String it = string2;
                                boolean bl4 = false;
                                FunctionCall arrayConsCall = new FunctionCall();
                                arrayConsCall.setTarget(((FunctionCall)node).getTarget());
                                arrayConsCall.setArguments(((FunctionCall)node).getArguments());
                                PropertyGet target = new PropertyGet();
                                Name fill = new Name();
                                fill.setIdentifier("fill");
                                target.setTarget((AstNode)arrayConsCall);
                                target.setProperty(fill);
                                ((FunctionCall)node).setTarget((AstNode)target);
                                Name initialValue = new Name();
                                initialValue.setIdentifier(it);
                                ((FunctionCall)node).setArguments(CollectionsKt.listOf((Object)initialValue));
                            }
                            return true;
                        }
                        if (((FunctionCall)node).getTarget() instanceof PropertyGet) {
                            AstNode astNode = ((FunctionCall)node).getTarget();
                            if (astNode == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            }
                            if (((PropertyGet)astNode).getTarget() instanceof FunctionCall) {
                                AstNode astNode2 = ((FunctionCall)node).getTarget();
                                if (astNode2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                                }
                                PropertyGet atomicOperationTarget = (PropertyGet)astNode2;
                                AstNode astNode3 = atomicOperationTarget.getTarget();
                                if (astNode3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                                }
                                FunctionCall funcCall = (FunctionCall)astNode3;
                                if (funcCall.getTarget() instanceof PropertyGet) {
                                    AstNode astNode4 = funcCall.getTarget();
                                    if (astNode4 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                                    }
                                    Name getterCall = ((PropertyGet)astNode4).getProperty();
                                    Regex regex = new Regex("get\\$atomicfu");
                                    String string = getterCall.toSource();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getterCall.toSource()");
                                    if (regex.matches((CharSequence)string)) {
                                        AstNode getter = this.getArrayElement(funcCall);
                                        atomicOperationTarget.setTarget(getter);
                                    }
                                }
                            }
                        }
                    }
                    if (!(node instanceof PropertyGet) || !Intrinsics.areEqual((Object)((PropertyGet)node).getProperty().toSource(), (Object)"kotlinx$atomicfu$value")) break block17;
                    AstNode astNode = ((PropertyGet)node).getTarget();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode, (String)"node.target");
                    AstNode astNode5 = AtomicFUTransformerJS.this.eraseAtomicFieldFromUncheckedCast(astNode);
                    if (astNode5 != null) {
                        functionName = astNode5;
                        boolean atomicOperationTarget = false;
                        boolean funcCall = false;
                        String it = functionName;
                        boolean bl5 = false;
                        ((PropertyGet)node).setTarget((AstNode)it);
                    }
                    AstNode astNode6 = ((PropertyGet)node).getTarget();
                    Intrinsics.checkExpressionValueIsNotNull((Object)astNode6, (String)"node.target");
                    if (astNode6.getType() != 33) break block18;
                    AstNode astNode7 = ((PropertyGet)node).getTarget();
                    if (astNode7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    }
                    PropertyGet clearField = (PropertyGet)astNode7;
                    AstNode targetNode = clearField.getTarget();
                    Name clearProperety = clearField.getProperty();
                    ((PropertyGet)node).setLeftAndRight(targetNode, (AstNode)clearProperety);
                    break block17;
                }
                if (!Intrinsics.areEqual((Object)((PropertyGet)node).getTarget().toSource(), (Object)"$receiver")) break block17;
                ReceiverResolver rr = new ReceiverResolver();
                ((PropertyGet)node).getEnclosingFunction().visit((NodeVisitor)rr);
                AstNode astNode = rr.getReceiver();
                if (astNode != null) {
                    AstNode astNode8 = astNode;
                    bl = false;
                    boolean bl6 = false;
                    AstNode it = astNode8;
                    boolean bl7 = false;
                    ((PropertyGet)node).setTarget(it);
                }
            }
            return true;
        }

        private final AstNode getArrayElement(FunctionCall getterCall) {
            AstNode astNode;
            AstNode astNode2;
            boolean isStatic;
            AstNode index = (AstNode)getterCall.getArguments().get(0);
            AstNode astNode3 = getterCall.getTarget();
            if (astNode3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
            }
            AstNode arrayField = ((PropertyGet)astNode3).getTarget();
            boolean bl = isStatic = !(arrayField instanceof PropertyGet);
            if (isStatic) {
                astNode2 = arrayField;
            } else {
                AstNode astNode4 = arrayField;
                if (astNode4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                astNode2 = (AstNode)((PropertyGet)astNode4).getProperty();
            }
            AstNode arrName = astNode2;
            ElementGet getter = new ElementGet(arrName, index);
            if (isStatic) {
                astNode = (AstNode)getter;
            } else {
                PropertyGet call = new PropertyGet();
                AstNode astNode5 = arrayField;
                if (astNode5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                call.setTarget(((PropertyGet)astNode5).getTarget());
                Name name = new Name();
                name.setIdentifier(getter.toSource());
                call.setProperty(name);
                astNode = (AstNode)call;
            }
            return astNode;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$ReceiverResolver;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "receiver", "Lorg/mozilla/javascript/ast/AstNode;", "getReceiver", "()Lorg/mozilla/javascript/ast/AstNode;", "setReceiver", "(Lorg/mozilla/javascript/ast/AstNode;)V", "visit", "", "node", "atomicfu-transformer"})
    public final class ReceiverResolver
    implements NodeVisitor {
        @Nullable
        private AstNode receiver;

        @Nullable
        public final AstNode getReceiver() {
            return this.receiver;
        }

        public final void setReceiver(@Nullable AstNode astNode) {
            this.receiver = astNode;
        }

        public boolean visit(@NotNull AstNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (node instanceof VariableInitializer && Intrinsics.areEqual((Object)((VariableInitializer)node).getTarget().toSource(), (Object)"$receiver")) {
                this.receiver = ((VariableInitializer)node).getInitializer();
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicOperationsInliner;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class AtomicOperationsInliner
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof FunctionCall && ((FunctionCall)node).getTarget() instanceof PropertyGet) {
                ReceiverResolver rr;
                AstNode astNode = ((FunctionCall)node).getTarget();
                if (astNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                Name funcName = ((PropertyGet)astNode).getProperty();
                AstNode astNode2 = ((FunctionCall)node).getTarget();
                if (astNode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                }
                Object field = ((PropertyGet)astNode2).getTarget();
                if (Intrinsics.areEqual((Object)field.toSource(), (Object)"$receiver")) {
                    rr = new ReceiverResolver();
                    ((FunctionCall)node).getEnclosingFunction().visit((NodeVisitor)rr);
                    if (rr.getReceiver() != null) {
                        field = rr.getReceiver();
                    }
                }
                AstNode astNode3 = field;
                Intrinsics.checkExpressionValueIsNotNull((Object)astNode3, (String)"field");
                AstNode astNode4 = AtomicFUTransformerJS.this.eraseAtomicFieldFromUncheckedCast(astNode3);
                if (astNode4 != null) {
                    rr = astNode4;
                    boolean bl = false;
                    boolean bl2 = false;
                    ReceiverResolver it = rr;
                    boolean bl3 = false;
                    field = it;
                }
                List args = ((FunctionCall)node).getArguments();
                FunctionCall functionCall = (FunctionCall)node;
                String string = funcName.toSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"funcName.toSource()");
                Object object = field;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"field");
                List list = args;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"args");
                boolean inlined = AtomicFUTransformerJS.this.inlineAtomicOperation(functionCall, string, object, list);
                return !inlined;
            }
            return true;
        }
    }
}

