/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.transformer;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.atomicfu.transformer.AbortKt;
import kotlinx.atomicfu.transformer.AtomicFUTransformerBase;
import kotlinx.atomicfu.transformer.AtomicFUTransformerJS;
import kotlinx.atomicfu.transformer.AtomicFUTransformerJSKt;
import kotlinx.atomicfu.transformer.EmptyLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\b*+,-./01B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\b*\u00020\u0016H\u0002J*\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0019*\u00020\u0003H\u0002J\f\u0010 \u001a\u00020\u0019*\u00020\u0016H\u0002J\u001c\u0010!\u001a\u00020\u0011*\u00020\"2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\fH\u0002J\f\u0010%\u001a\u00020\b*\u00020&H\u0002J\f\u0010'\u001a\u00020\b*\u00020\u0016H\u0002J\u0014\u0010(\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010)\u001a\u00020\bH\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;", "Lkotlinx/atomicfu/transformer/AtomicFUTransformerBase;", "inputDir", "Ljava/io/File;", "outputDir", "(Ljava/io/File;Ljava/io/File;)V", "atomicArrayConstructors", "", "", "atomicConstructors", "", "delegateToOriginalAtomicField", "Lorg/mozilla/javascript/ast/Name;", "topLevelDelegatedFieldAccessorToOriginalField", "traceConstructors", "traceFormatObjects", "transform", "", "transformFile", "", "file", "eraseAtomicFieldFromUncheckedCast", "Lorg/mozilla/javascript/ast/AstNode;", "eraseGetValue", "inlineAtomicOperation", "", "Lorg/mozilla/javascript/ast/FunctionCall;", "funcName", "field", "args", "", "isJsFile", "isThisNode", "replaceAccessedField", "Lorg/mozilla/javascript/ast/FunctionNode;", "isGetter", "newField", "resolvePropName", "Lorg/mozilla/javascript/ast/PropertyGet;", "scopedSource", "setImpl", "code", "AtomicConstructorDetector", "AtomicOperationsInliner", "DelegatedPropertyAccessorsVisitor", "DependencyEraser", "FieldDelegatesVisitor", "ReceiverResolver", "TopLevelDelegatedFieldsAccessorVisitor", "TransformVisitor", "atomicfu-transformer"})
@SourceDebugExtension(value={"SMAP\nAtomicFUTransformerJS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicFUTransformerJS.kt\nkotlinx/atomicfu/transformer/AtomicFUTransformerJS\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,728:1\n1295#2,2:729\n*S KotlinDebug\n*F\n+ 1 AtomicFUTransformerJS.kt\nkotlinx/atomicfu/transformer/AtomicFUTransformerJS\n*L\n63#1:729,2\n*E\n"})
public final class AtomicFUTransformerJS
extends AtomicFUTransformerBase {
    @NotNull
    private final Set<String> atomicConstructors;
    @NotNull
    private final Map<String, Name> delegateToOriginalAtomicField;
    @NotNull
    private final Map<String, Name> topLevelDelegatedFieldAccessorToOriginalField;
    @NotNull
    private final Map<String, String> atomicArrayConstructors;
    @NotNull
    private final Set<String> traceConstructors;
    @NotNull
    private final Set<String> traceFormatObjects;

    public AtomicFUTransformerJS(@NotNull File inputDir, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        super(inputDir, outputDir);
        this.atomicConstructors = new LinkedHashSet();
        this.delegateToOriginalAtomicField = new LinkedHashMap();
        this.topLevelDelegatedFieldAccessorToOriginalField = new LinkedHashMap();
        this.atomicArrayConstructors = new LinkedHashMap();
        this.traceConstructors = new LinkedHashSet();
        this.traceFormatObjects = new LinkedHashSet();
    }

    @Override
    public void transform() {
        AtomicFUTransformerBase.info$default(this, "Transforming to " + this.getOutputDir(), null, 2, null);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)this.getInputDir(), null, (int)1, null)), (Function1)transform.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            File file = (File)element$iv;
            boolean bl = false;
            if (this.isJsFile(file)) {
                System.out.println((Object)("Transforming file: " + file.getCanonicalPath()));
                byArray = this.transformFile(file);
            } else {
                byArray = FilesKt.readBytes((File)file);
            }
            byte[] outBytes = byArray;
            this.mkdirsAndWrite(this.toOutputFile(file), outBytes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJsFile(File $this$isJsFile) {
        String string = $this$isJsFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)".js", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isJsFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        if (StringsKt.endsWith$default((String)string2, (String)".meta.js", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final byte[] transformFile(File file) {
        Parser p = new Parser(new CompilerEnvirons());
        AstRoot root = p.parse((Reader)new FileReader(file), null, 0);
        root.visit((NodeVisitor)new DependencyEraser());
        root.visit((NodeVisitor)new AtomicConstructorDetector());
        root.visit((NodeVisitor)new FieldDelegatesVisitor());
        root.visit((NodeVisitor)new DelegatedPropertyAccessorsVisitor());
        root.visit((NodeVisitor)new TopLevelDelegatedFieldsAccessorVisitor());
        root.visit((NodeVisitor)new TransformVisitor());
        root.visit((NodeVisitor)new AtomicOperationsInliner());
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        String string = this.eraseGetValue((AstNode)root);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    private final String eraseGetValue(AstNode $this$eraseGetValue) {
        Function1 function1;
        CharSequence charSequence;
        String res = $this$eraseGetValue.toSource();
        Regex primitiveGetValue = AtomicFUTransformerJSKt.access$getMANGLE_VALUE_REGEX$p();
        Regex arrayGetElement = AtomicFUTransformerJSKt.access$getARRAY_GET_ELEMENT_REGEX$p();
        while (true) {
            String string = res;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res");
            if (!arrayGetElement.containsMatchIn((CharSequence)string)) break;
            String string2 = res;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"res");
            charSequence = string2;
            function1 = eraseGetValue.1.INSTANCE;
            res = arrayGetElement.replace(charSequence, function1);
        }
        String string = res;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res");
        charSequence = string;
        function1 = eraseGetValue.2.INSTANCE;
        return primitiveGetValue.replace(charSequence, function1);
    }

    private final void replaceAccessedField(FunctionNode $this$replaceAccessedField, boolean isGetter, Name newField) {
        PropertyGet propertyGet;
        PropertyGet propertyGet2;
        if (isGetter) {
            Node node = $this$replaceAccessedField.getBody().getFirstChild();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ReturnStatement");
            AstNode astNode = ((ReturnStatement)node).getReturnValue();
            Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
            propertyGet2 = (PropertyGet)astNode;
        } else {
            Node node = $this$replaceAccessedField.getBody().getFirstChild();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            AstNode astNode = ((ExpressionStatement)node).getExpression();
            Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
            AstNode astNode2 = ((Assignment)astNode).getLeft();
            Intrinsics.checkNotNull((Object)astNode2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
            propertyGet2 = propertyGet = (PropertyGet)astNode2;
        }
        if (propertyGet.getTarget() instanceof PropertyGet) {
            AstNode astNode = propertyGet.getTarget();
            Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
            ((PropertyGet)astNode).setProperty(newField);
        } else {
            propertyGet.setTarget((AstNode)newField);
        }
    }

    private final AstNode eraseAtomicFieldFromUncheckedCast(AstNode $this$eraseAtomicFieldFromUncheckedCast) {
        if ($this$eraseAtomicFieldFromUncheckedCast instanceof ParenthesizedExpression && ((ParenthesizedExpression)$this$eraseAtomicFieldFromUncheckedCast).getExpression() instanceof ConditionalExpression) {
            AstNode astNode = ((ParenthesizedExpression)$this$eraseAtomicFieldFromUncheckedCast).getExpression();
            Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ConditionalExpression");
            AstNode testExpression = ((ConditionalExpression)astNode).getTestExpression();
            if (testExpression instanceof FunctionCall && Intrinsics.areEqual((Object)((FunctionCall)testExpression).getTarget().toSource(), (Object)"Kotlin.isType")) {
                AstNode typeToCast = (AstNode)((FunctionCall)testExpression).getArguments().get(1);
                Intrinsics.checkNotNull((Object)typeToCast, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Name");
                if (Intrinsics.areEqual((Object)((Name)typeToCast).getIdentifier(), (Object)"AtomicRef")) {
                    Object e = ((FunctionCall)testExpression).getArguments().get(0);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                    return ((Assignment)e).getRight();
                }
            }
        }
        return null;
    }

    private final boolean isThisNode(AstNode $this$isThisNode) {
        boolean bl;
        AstNode astNode = $this$isThisNode;
        if (astNode instanceof PropertyGet) {
            AstNode astNode2 = ((PropertyGet)$this$isThisNode).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)astNode2, (String)"target");
            bl = this.isThisNode(astNode2);
        } else if (astNode instanceof FunctionCall) {
            AstNode astNode3 = ((FunctionCall)$this$isThisNode).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)astNode3, (String)"target");
            bl = this.isThisNode(astNode3);
        } else {
            bl = $this$isThisNode.getType() == 43;
        }
        return bl;
    }

    private final String resolvePropName(PropertyGet $this$resolvePropName) {
        String string;
        AstNode target = $this$resolvePropName.getTarget();
        if (target instanceof PropertyGet) {
            string = this.resolvePropName((PropertyGet)target) + '.' + $this$resolvePropName.getProperty().toSource();
        } else {
            String string2 = $this$resolvePropName.getProperty().toSource();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            property.toSource()\n        }");
        }
        return string;
    }

    private final String scopedSource(AstNode $this$scopedSource) {
        if (this.isThisNode($this$scopedSource)) {
            if ($this$scopedSource instanceof PropertyGet) {
                String property = this.resolvePropName((PropertyGet)$this$scopedSource);
                return "scope." + property;
            }
            if ($this$scopedSource instanceof FunctionCall && ((FunctionCall)$this$scopedSource).getTarget() instanceof PropertyGet) {
                if (((FunctionCall)$this$scopedSource).getTarget() instanceof PropertyGet) {
                    AstNode astNode = ((FunctionCall)$this$scopedSource).getTarget();
                    Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    String funcName = ((PropertyGet)astNode).getProperty().toSource();
                    Regex regex = new Regex("atomicfu\\$get");
                    Intrinsics.checkNotNullExpressionValue((Object)funcName, (String)"funcName");
                    if (regex.matches((CharSequence)funcName)) {
                        AstNode astNode2 = ((FunctionCall)$this$scopedSource).getTarget();
                        Intrinsics.checkNotNull((Object)astNode2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        String property = this.resolvePropName((PropertyGet)astNode2);
                        return "scope." + property + '(' + ((AstNode)((FunctionCall)$this$scopedSource).getArguments().get(0)).toSource() + ')';
                    }
                }
            } else if ($this$scopedSource.getType() == 43) {
                return "scope";
            }
        }
        String string = $this$scopedSource.toSource();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.toSource()");
        return string;
    }

    private final boolean inlineAtomicOperation(FunctionCall $this$inlineAtomicOperation, String funcName, AstNode field, List<? extends AstNode> args) {
        String code;
        String f = this.scopedSource(field);
        switch (funcName) {
            case "atomicfu$getAndSet": {
                String arg = args.get(0).toSource();
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + arg + "; return oldValue;})()";
                break;
            }
            case "atomicfu$compareAndSet": {
                String expected = this.scopedSource(args.get(0));
                String updated = this.scopedSource(args.get(1));
                String equals = Intrinsics.areEqual((Object)expected, (Object)"null") ? "==" : "===";
                String string = "(function(scope) {return " + f + ' ' + equals + ' ' + expected + " ? function() { " + f + " = " + updated + "; return true }() : false})()";
                break;
            }
            case "atomicfu$getAndIncrement": {
                String string = "(function(scope) {return " + f + "++;})()";
                break;
            }
            case "atomicfu$getAndIncrement$long": {
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".inc(); return oldValue;})()";
                break;
            }
            case "atomicfu$getAndDecrement": {
                String string = "(function(scope) {return " + f + "--;})()";
                break;
            }
            case "atomicfu$getAndDecrement$long": {
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".dec(); return oldValue;})()";
                break;
            }
            case "atomicfu$getAndAdd": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " += " + arg + "; return oldValue;})()";
                break;
            }
            case "atomicfu$getAndAdd$long": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {var oldValue = " + f + "; " + f + " = " + f + ".add(" + arg + "); return oldValue;})()";
                break;
            }
            case "atomicfu$addAndGet": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {" + f + " += " + arg + "; return " + f + ";})()";
                break;
            }
            case "atomicfu$addAndGet$long": {
                String arg = this.scopedSource(args.get(0));
                String string = "(function(scope) {" + f + " = " + f + ".add(" + arg + "); return " + f + ";})()";
                break;
            }
            case "atomicfu$incrementAndGet": {
                String string = "(function(scope) {return ++" + f + ";})()";
                break;
            }
            case "atomicfu$incrementAndGet$long": {
                String string = "(function(scope) {return " + f + " = " + f + ".inc();})()";
                break;
            }
            case "atomicfu$decrementAndGet": {
                String string = "(function(scope) {return --" + f + ";})()";
                break;
            }
            case "atomicfu$decrementAndGet$long": {
                String string = "(function(scope) {return " + f + " = " + f + ".dec();})()";
                break;
            }
            default: {
                String string = code = null;
            }
        }
        if (code != null) {
            this.setImpl($this$inlineAtomicOperation, code);
            return true;
        }
        return false;
    }

    private final void setImpl(FunctionCall $this$setImpl, String code) {
        Parser p = new Parser(new CompilerEnvirons());
        AstRoot node = p.parse(code, null, 0);
        if (node.getFirstChild() != null) {
            Node node2 = node.getFirstChild();
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            AstNode expr = ((ExpressionStatement)node2).getExpression();
            Intrinsics.checkNotNull((Object)expr, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
            $this$setImpl.setTarget(((FunctionCall)expr).getTarget());
            AstRoot thisNode = new Parser(new CompilerEnvirons()).parse("this", null, 0);
            Node node3 = thisNode.getFirstChild();
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ExpressionStatement");
            $this$setImpl.setArguments(CollectionsKt.listOf((Object)((ExpressionStatement)node3).getExpression()));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicConstructorDetector;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "kotlinxAtomicfuModuleName", "", "name", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    @SourceDebugExtension(value={"SMAP\nAtomicFUTransformerJS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicFUTransformerJS.kt\nkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicConstructorDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,728:1\n1#2:729\n*E\n"})
    public final class AtomicConstructorDetector
    implements NodeVisitor {
        private final String kotlinxAtomicfuModuleName(String name) {
            return "\\$module\\$kotlinx_atomicfu.kotlinx.atomicfu." + name;
        }

        public boolean visit(@Nullable AstNode node) {
            String initializer;
            Object it;
            PropertyGet propertyGet;
            block25: {
                block26: {
                    String string;
                    VariableInitializer varInit;
                    Object stmt2;
                    if (node instanceof Block) {
                        for (Object stmt2 : (Block)node) {
                            if (!(stmt2 instanceof VariableDeclaration)) continue;
                            Object e = ((VariableDeclaration)stmt2).getVariables().get(0);
                            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.VariableInitializer");
                            varInit = (VariableInitializer)e;
                            if (!(varInit.getInitializer() instanceof PropertyGet)) continue;
                            String initializer2 = varInit.getInitializer().toSource();
                            Intrinsics.checkNotNullExpressionValue((Object)initializer2, (String)"initializer");
                            CharSequence charSequence = initializer2;
                            if (new Regex(this.kotlinxAtomicfuModuleName("((atomic\\$(ref|int|long|boolean)\\$|Atomic(Ref|Int|Long|Boolean))|(atomic\\$(ref|int|long|boolean)\\$1))")).matches(charSequence)) {
                                Set set = AtomicFUTransformerJS.this.atomicConstructors;
                                String string2 = varInit.getTarget().toSource();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"varInit.target.toSource()");
                                set.add(string2);
                                ((Block)node).replaceChild(stmt2, (Node)new EmptyLine());
                                continue;
                            }
                            charSequence = initializer2;
                            if (new Regex(this.kotlinxAtomicfuModuleName("atomicfu\\$Trace")).matches(charSequence)) {
                                Set set = AtomicFUTransformerJS.this.traceConstructors;
                                String string3 = varInit.getTarget().toSource();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"varInit.target.toSource()");
                                set.add(string3);
                                ((Block)node).replaceChild(stmt2, (Node)new EmptyLine());
                                continue;
                            }
                            charSequence = initializer2;
                            if (!new Regex(this.kotlinxAtomicfuModuleName("(locks|atomicfu\\$TraceFormat|atomicfu\\$TraceBase|atomicfu\\$Trace\\$named)")).matches(charSequence)) continue;
                            ((Block)node).replaceChild(stmt2, (Node)new EmptyLine());
                        }
                    }
                    if (node instanceof PropertyGet) {
                        String string4 = ((PropertyGet)node).getProperty().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"node.property.toSource()");
                        CharSequence charSequence = string4;
                        if (new Regex("atomicfu\\$TraceFormat\\$format").matches(charSequence)) {
                            AstNode target = ((PropertyGet)node).getTarget();
                            stmt2 = new Name();
                            varInit = stmt2;
                            propertyGet = (PropertyGet)node;
                            boolean bl = false;
                            it.setIdentifier("emptyProperty");
                            propertyGet.setProperty((Name)stmt2);
                            if (target instanceof PropertyGet) {
                                String string5 = ((PropertyGet)target).getProperty().toSource();
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"target.property.toSource()");
                                stmt2 = string5;
                                if (new Regex("prototype").matches((CharSequence)stmt2)) {
                                    Set set = AtomicFUTransformerJS.this.traceFormatObjects;
                                    String string6 = ((PropertyGet)target).getTarget().toSource();
                                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"target.target.toSource()");
                                    set.add(string6);
                                }
                            }
                        }
                    }
                    if (!(node instanceof VariableInitializer) || !(((VariableInitializer)node).getInitializer() instanceof PropertyGet)) break block25;
                    initializer = ((VariableInitializer)node).getInitializer().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)initializer, (String)"initializer");
                    stmt2 = initializer;
                    if (new Regex("locks.atomicfu\\$reentrantLock").matches((CharSequence)stmt2)) {
                        ((VariableInitializer)node).setInitializer(null);
                    }
                    stmt2 = initializer;
                    if (new Regex(this.kotlinxAtomicfuModuleName("((atomic\\$(ref|int|long|boolean)\\$|Atomic(Ref|Int|Long|Boolean))|(atomic\\$(ref|int|long|boolean)\\$1))")).matches((CharSequence)stmt2)) {
                        Set set = AtomicFUTransformerJS.this.atomicConstructors;
                        String string7 = ((VariableInitializer)node).getTarget().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"node.target.toSource()");
                        set.add(string7);
                        ((VariableInitializer)node).setInitializer(null);
                    }
                    stmt2 = initializer;
                    if (!new Regex(this.kotlinxAtomicfuModuleName("(atomicfu)\\$(Atomic(Ref|Int|Long|Boolean)Array)\\$(ref|int|long|boolean|ofNulls)")).matches((CharSequence)stmt2)) break block26;
                    switch (StringsKt.substringAfterLast$default((String)initializer, (char)'$', null, (int)2, null)) {
                        case "int": {
                            string = "0";
                            break;
                        }
                        case "long": {
                            string = "0";
                            break;
                        }
                        case "boolean": {
                            string = "false";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    String initialValue = string;
                    it = AtomicFUTransformerJS.this.atomicArrayConstructors;
                    String string8 = ((VariableInitializer)node).getTarget().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"node.target.toSource()");
                    it.put(string8, initialValue);
                    ((VariableInitializer)node).setInitializer(null);
                }
                return false;
            }
            if (node instanceof Assignment && ((Assignment)node).getRight() instanceof PropertyGet) {
                initializer = ((Assignment)node).getRight().toSource();
                Intrinsics.checkNotNullExpressionValue((Object)initializer, (String)"initializer");
                CharSequence charSequence = initializer;
                if (new Regex("locks.atomicfu\\$reentrantLock").matches(charSequence)) {
                    charSequence = new Name();
                    it = charSequence;
                    propertyGet = (Assignment)node;
                    boolean bl = false;
                    it.setIdentifier("null");
                    propertyGet.setRight((AstNode)charSequence);
                    return false;
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicOperationsInliner;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    @SourceDebugExtension(value={"SMAP\nAtomicFUTransformerJS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicFUTransformerJS.kt\nkotlinx/atomicfu/transformer/AtomicFUTransformerJS$AtomicOperationsInliner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,728:1\n1#2:729\n*E\n"})
    public final class AtomicOperationsInliner
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof FunctionCall && ((FunctionCall)node).getTarget() instanceof PropertyGet) {
                AstNode astNode = ((FunctionCall)node).getTarget();
                Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                Name funcName = ((PropertyGet)astNode).getProperty();
                AstNode field = null;
                AstNode astNode2 = ((FunctionCall)node).getTarget();
                Intrinsics.checkNotNull((Object)astNode2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                field = ((PropertyGet)astNode2).getTarget();
                String string = field.toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.toSource()");
                CharSequence charSequence = string;
                if (new Regex("(\\$(receiver)(_\\d+)?)").matches(charSequence)) {
                    String receiverName = field.toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)receiverName, (String)"receiverName");
                    ReceiverResolver rr = new ReceiverResolver(receiverName);
                    ((FunctionCall)node).getEnclosingFunction().visit((NodeVisitor)rr);
                    if (rr.getReceiver() != null) {
                        field = rr.getReceiver();
                    }
                }
                AstNode astNode3 = field;
                Intrinsics.checkNotNullExpressionValue((Object)astNode3, (String)"field");
                AstNode astNode4 = AtomicFUTransformerJS.this.eraseAtomicFieldFromUncheckedCast(astNode3);
                if (astNode4 != null) {
                    AstNode it = astNode4;
                    boolean bl = false;
                    field = it;
                }
                List args = ((FunctionCall)node).getArguments();
                FunctionCall functionCall = (FunctionCall)node;
                String string2 = funcName.toSource();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"funcName.toSource()");
                AstNode astNode5 = field;
                Intrinsics.checkNotNullExpressionValue((Object)astNode5, (String)"field");
                Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
                boolean inlined = AtomicFUTransformerJS.this.inlineAtomicOperation(functionCall, string2, astNode5, args);
                return !inlined;
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$DelegatedPropertyAccessorsVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class DelegatedPropertyAccessorsVisitor
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof ObjectLiteral && ((ObjectLiteral)node).getParent() instanceof FunctionCall && (((ObjectLiteral)node).getElements().size() == 2 && Intrinsics.areEqual((Object)((ObjectProperty)((ObjectLiteral)node).getElements().get(1)).getLeft().toSource(), (Object)"get") || ((ObjectLiteral)node).getElements().size() == 3 && Intrinsics.areEqual((Object)((ObjectProperty)((ObjectLiteral)node).getElements().get(1)).getLeft().toSource(), (Object)"get") && Intrinsics.areEqual((Object)((ObjectProperty)((ObjectLiteral)node).getElements().get(2)).getLeft().toSource(), (Object)"set")) && ((ObjectProperty)((ObjectLiteral)node).getElements().get(1)).getRight() instanceof FunctionNode) {
                AstNode astNode = ((ObjectProperty)((ObjectLiteral)node).getElements().get(1)).getRight();
                Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionNode");
                FunctionNode getter = (FunctionNode)astNode;
                if (getter.getBody().hasChildren() && getter.getBody().getFirstChild() instanceof ReturnStatement) {
                    Node node2 = getter.getBody().getFirstChild();
                    Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ReturnStatement");
                    ReturnStatement returnStmt = (ReturnStatement)node2;
                    if (returnStmt.getReturnValue() instanceof PropertyGet) {
                        AstNode astNode2 = returnStmt.getReturnValue();
                        Intrinsics.checkNotNull((Object)astNode2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        if (Intrinsics.areEqual((Object)((PropertyGet)astNode2).getProperty().toSource(), (Object)"kotlinx$atomicfu$value")) {
                            AstNode astNode3 = returnStmt.getReturnValue();
                            Intrinsics.checkNotNull((Object)astNode3, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            AstNode astNode4 = ((PropertyGet)astNode3).getTarget();
                            Intrinsics.checkNotNull((Object)astNode4, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            String delegateField = ((PropertyGet)astNode4).getProperty().toSource();
                            AstNode astNode5 = ((ObjectLiteral)node).getParent();
                            Intrinsics.checkNotNull((Object)astNode5, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                            Object e = ((FunctionCall)astNode5).getArguments().get(0);
                            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            String ownerClassName = ((PropertyGet)e).getTarget().toSource();
                            String key = delegateField + '$' + ownerClassName;
                            Name name = (Name)AtomicFUTransformerJS.this.delegateToOriginalAtomicField.get(key);
                            if (name != null) {
                                Name name2 = name;
                                AtomicFUTransformerJS atomicFUTransformerJS = AtomicFUTransformerJS.this;
                                Name atomicField = name2;
                                boolean bl = false;
                                atomicFUTransformerJS.replaceAccessedField(getter, true, atomicField);
                                if (((ObjectLiteral)node).getElements().size() == 3) {
                                    AstNode astNode6 = ((ObjectProperty)((ObjectLiteral)node).getElements().get(2)).getRight();
                                    Intrinsics.checkNotNull((Object)astNode6, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionNode");
                                    FunctionNode setter = (FunctionNode)astNode6;
                                    atomicFUTransformerJS.replaceAccessedField(setter, false, atomicField);
                                }
                            }
                        }
                    }
                }
            }
            if (node instanceof ObjectLiteral && ((ObjectLiteral)node).getParent() instanceof FunctionCall && (((ObjectLiteral)node).getElements().size() == 1 && Intrinsics.areEqual((Object)((ObjectProperty)((ObjectLiteral)node).getElements().get(0)).getLeft().toSource(), (Object)"get") || ((ObjectLiteral)node).getElements().size() == 2 && Intrinsics.areEqual((Object)((ObjectProperty)((ObjectLiteral)node).getElements().get(0)).getLeft().toSource(), (Object)"get") && Intrinsics.areEqual((Object)((ObjectProperty)((ObjectLiteral)node).getElements().get(1)).getLeft().toSource(), (Object)"set"))) {
                AstNode astNode = ((ObjectLiteral)node).getParent();
                Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                FunctionCall parent = (FunctionCall)astNode;
                if (parent.getArguments().size() == 3 && parent.getArguments().get(1) instanceof StringLiteral) {
                    Object e = parent.getArguments().get(1);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.StringLiteral");
                    String topLevelDelegatedFieldName = ((StringLiteral)e).getValue();
                    if (AtomicFUTransformerJS.this.delegateToOriginalAtomicField.containsKey(topLevelDelegatedFieldName)) {
                        Object v = AtomicFUTransformerJS.this.delegateToOriginalAtomicField.get(topLevelDelegatedFieldName);
                        Intrinsics.checkNotNull(v);
                        Name originalAtomicFieldName = (Name)v;
                        String getterName = ((ObjectProperty)((ObjectLiteral)node).getElements().get(0)).getRight().toSource();
                        Map map = AtomicFUTransformerJS.this.topLevelDelegatedFieldAccessorToOriginalField;
                        Intrinsics.checkNotNullExpressionValue((Object)getterName, (String)"getterName");
                        map.put(getterName, originalAtomicFieldName);
                        if (((ObjectLiteral)node).getElements().size() == 2) {
                            String setterName = ((ObjectProperty)((ObjectLiteral)node).getElements().get(1)).getRight().toSource();
                            Map map2 = AtomicFUTransformerJS.this.topLevelDelegatedFieldAccessorToOriginalField;
                            Intrinsics.checkNotNullExpressionValue((Object)setterName, (String)"setterName");
                            map2.put(setterName, originalAtomicFieldName);
                        }
                    }
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$DependencyEraser;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "isAtomicfuDependency", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "isAtomicfuModule", "visit", "atomicfu-transformer"})
    public final class DependencyEraser
    implements NodeVisitor {
        private final boolean isAtomicfuDependency(AstNode node) {
            return node.getType() == 41 && Intrinsics.areEqual((Object)node.toSource(), (Object)"'kotlinx-atomicfu'");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAtomicfuModule(AstNode node) {
            if (node.getType() != 39) return false;
            String string = node.toSource();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.toSource()");
            CharSequence charSequence = string;
            if (!new Regex("\\$module\\$kotlinx_atomicfu").matches(charSequence)) return false;
            return true;
        }

        public boolean visit(@NotNull AstNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            switch (node.getType()) {
                case 66: {
                    List list = ((ArrayLiteral)node).getElements();
                    Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<@[FlexibleNullability] org.mozilla.javascript.ast.AstNode?>");
                    List elements = TypeIntrinsics.asMutableList((Object)list);
                    ListIterator it = elements.listIterator();
                    while (it.hasNext()) {
                        AstNode arg = (AstNode)it.next();
                        Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                        if (!this.isAtomicfuDependency(arg)) continue;
                        it.remove();
                    }
                    break;
                }
                case 110: {
                    if (!(node instanceof FunctionNode)) break;
                    ListIterator it = ((FunctionNode)node).getParams().listIterator();
                    while (it.hasNext()) {
                        Object e = it.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"it.next()");
                        if (!this.isAtomicfuModule((AstNode)e)) continue;
                        it.remove();
                    }
                    break;
                }
                case 38: {
                    if (!(node instanceof FunctionCall) || !Intrinsics.areEqual((Object)((FunctionCall)node).getTarget().toSource(), (Object)"factory")) break;
                    ListIterator it = ((FunctionCall)node).getArguments().listIterator();
                    while (it.hasNext()) {
                        AstNode arg = (AstNode)it.next();
                        switch (arg.getType()) {
                            case 36: {
                                Intrinsics.checkNotNull((Object)arg, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ElementGet");
                                AstNode astNode = ((ElementGet)arg).getElement();
                                Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"arg as ElementGet).element");
                                if (!this.isAtomicfuDependency(astNode)) break;
                                it.remove();
                                break;
                            }
                            case 38: {
                                Intrinsics.checkNotNull((Object)arg, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                                if (!Intrinsics.areEqual((Object)((FunctionCall)arg).getTarget().toSource(), (Object)"require")) break;
                                Object e = ((FunctionCall)arg).getArguments().get(0);
                                Intrinsics.checkNotNullExpressionValue(e, (String)"arg.arguments[0]");
                                if (!this.isAtomicfuDependency((AstNode)e)) break;
                                it.remove();
                            }
                        }
                    }
                    break;
                }
                case 36: {
                    AstNode enclosingNode;
                    AstNode astNode = ((ElementGet)node).getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"node as ElementGet).element");
                    if (!this.isAtomicfuDependency(astNode) || (enclosingNode = ((ElementGet)node).getParent()).getType() != 32 || enclosingNode.getParent().getParent().getType() != 113) break;
                    AstNode astNode2 = enclosingNode.getParent().getParent();
                    Intrinsics.checkNotNull((Object)astNode2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.IfStatement");
                    IfStatement ifStatement = (IfStatement)astNode2;
                    KeywordLiteral falseKeyword = new KeywordLiteral();
                    falseKeyword.setType(44);
                    ifStatement.setCondition((AstNode)falseKeyword);
                    Block oneLineBlock = new Block();
                    oneLineBlock.addStatement((AstNode)new EmptyLine());
                    ifStatement.setThenPart((AstNode)oneLineBlock);
                    break;
                }
                case 130: {
                    for (Node stmt : node) {
                        AstNode expr;
                        if (!(stmt instanceof ExpressionStatement) || !((expr = ((ExpressionStatement)stmt).getExpression()) instanceof Assignment) || !(((Assignment)expr).getLeft() instanceof ElementGet)) continue;
                        AstNode astNode = ((Assignment)expr).getLeft();
                        Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ElementGet");
                        AstNode astNode3 = ((ElementGet)astNode).getElement();
                        Intrinsics.checkNotNullExpressionValue((Object)astNode3, (String)"expr.left as ElementGet).element");
                        if (!this.isAtomicfuDependency(astNode3)) continue;
                        node.replaceChild(stmt, (Node)new EmptyLine());
                    }
                    break;
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$FieldDelegatesVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class FieldDelegatesVisitor
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof FunctionCall) {
                String functionName = ((FunctionCall)node).getTarget().toSource();
                if (AtomicFUTransformerJS.this.atomicConstructors.contains(functionName) && ((FunctionCall)node).getParent() instanceof Assignment) {
                    AstNode astNode = ((FunctionCall)node).getParent();
                    Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                    Assignment assignment = (Assignment)astNode;
                    AstNode atomicField = assignment.getLeft();
                    AstNode astNode2 = ((FunctionCall)node).getParent().getParent();
                    ExpressionStatement expressionStatement = astNode2 instanceof ExpressionStatement ? (ExpressionStatement)astNode2 : null;
                    AstNode astNode3 = expressionStatement != null ? expressionStatement.getParent() : null;
                    Block block = astNode3 instanceof Block ? (Block)astNode3 : null;
                    if (block == null) {
                        AbortKt.abort$default("Incorrect tree structure of the constructor block initializing " + ((FunctionCall)node).getParent().toSource(), null, 2, null);
                        throw new KotlinNothingValueException();
                    }
                    Block constructorBlock = block;
                    for (Node stmt : constructorBlock) {
                        String delegateFieldName;
                        if (!(stmt instanceof ExpressionStatement) || !(((ExpressionStatement)stmt).getExpression() instanceof Assignment)) continue;
                        AstNode astNode4 = ((ExpressionStatement)stmt).getExpression();
                        Intrinsics.checkNotNull((Object)astNode4, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                        Assignment delegateAssignment = (Assignment)astNode4;
                        AstNode initializer = delegateAssignment.getRight();
                        if (!Intrinsics.areEqual((Object)initializer.toSource(), (Object)atomicField.toSource())) continue;
                        if (delegateAssignment.getRight() instanceof PropertyGet) {
                            Name name;
                            AstNode astNode5 = delegateAssignment.getLeft();
                            Intrinsics.checkNotNull((Object)astNode5, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            delegateFieldName = ((PropertyGet)astNode5).getProperty().toSource();
                            String ownerClassName = constructorBlock.getEnclosingFunction().getFunctionName().getIdentifier();
                            Map map = AtomicFUTransformerJS.this.delegateToOriginalAtomicField;
                            String string = delegateFieldName + '$' + ownerClassName;
                            Intrinsics.checkNotNull((Object)atomicField, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            Intrinsics.checkNotNullExpressionValue((Object)((PropertyGet)atomicField).getProperty(), (String)"atomicField as PropertyGet).property");
                            map.put(string, name);
                            continue;
                        }
                        delegateFieldName = delegateAssignment.getLeft().toSource();
                        Map map = AtomicFUTransformerJS.this.delegateToOriginalAtomicField;
                        Intrinsics.checkNotNullExpressionValue((Object)delegateFieldName, (String)"delegateFieldName");
                        Intrinsics.checkNotNull((Object)atomicField, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Name");
                        map.put(delegateFieldName, (Name)atomicField);
                    }
                }
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$ReceiverResolver;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "receiverName", "", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;Ljava/lang/String;)V", "receiver", "Lorg/mozilla/javascript/ast/AstNode;", "getReceiver", "()Lorg/mozilla/javascript/ast/AstNode;", "setReceiver", "(Lorg/mozilla/javascript/ast/AstNode;)V", "visit", "", "node", "atomicfu-transformer"})
    public final class ReceiverResolver
    implements NodeVisitor {
        @NotNull
        private final String receiverName;
        @Nullable
        private AstNode receiver;

        public ReceiverResolver(String receiverName) {
            Intrinsics.checkNotNullParameter((Object)receiverName, (String)"receiverName");
            this.receiverName = receiverName;
        }

        @Nullable
        public final AstNode getReceiver() {
            return this.receiver;
        }

        public final void setReceiver(@Nullable AstNode astNode) {
            this.receiver = astNode;
        }

        public boolean visit(@NotNull AstNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof VariableInitializer && Intrinsics.areEqual((Object)((VariableInitializer)node).getTarget().toSource(), (Object)this.receiverName)) {
                this.receiver = ((VariableInitializer)node).getInitializer();
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$TopLevelDelegatedFieldsAccessorVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "visit", "", "node", "Lorg/mozilla/javascript/ast/AstNode;", "atomicfu-transformer"})
    public final class TopLevelDelegatedFieldsAccessorVisitor
    implements NodeVisitor {
        public boolean visit(@Nullable AstNode node) {
            if (node instanceof FunctionNode && AtomicFUTransformerJS.this.topLevelDelegatedFieldAccessorToOriginalField.containsKey(((FunctionNode)node).getName().toString())) {
                String accessorName = ((FunctionNode)node).getName().toString();
                Object v = AtomicFUTransformerJS.this.topLevelDelegatedFieldAccessorToOriginalField.get(accessorName);
                Intrinsics.checkNotNull(v);
                Name atomicField = (Name)v;
                AtomicFUTransformerJS.this.replaceAccessedField((FunctionNode)node, StringsKt.startsWith$default((String)accessorName, (String)"get", (boolean)false, (int)2, null), atomicField);
            }
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS$TransformVisitor;", "Lorg/mozilla/javascript/ast/NodeVisitor;", "(Lkotlinx/atomicfu/transformer/AtomicFUTransformerJS;)V", "getArrayElement", "Lorg/mozilla/javascript/ast/AstNode;", "getterCall", "Lorg/mozilla/javascript/ast/FunctionCall;", "visit", "", "node", "atomicfu-transformer"})
    @SourceDebugExtension(value={"SMAP\nAtomicFUTransformerJS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomicFUTransformerJS.kt\nkotlinx/atomicfu/transformer/AtomicFUTransformerJS$TransformVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,728:1\n1#2:729\n*E\n"})
    public final class TransformVisitor
    implements NodeVisitor {
        /*
         * WARNING - void declaration
         */
        public boolean visit(@NotNull AstNode node) {
            PropertyGet left;
            PropertyGet propertyGet;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof FunctionCall) {
                String functionName = ((FunctionCall)node).getTarget().toSource();
                if (AtomicFUTransformerJS.this.atomicConstructors.contains(functionName)) {
                    if (((FunctionCall)node).getParent() instanceof Assignment) {
                        AstNode valueNode = (AstNode)((FunctionCall)node).getArguments().get(0);
                        AstNode astNode = ((FunctionCall)node).getParent();
                        Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                        ((Assignment)astNode).setRight(valueNode);
                    }
                    return true;
                }
                if (AtomicFUTransformerJS.this.atomicArrayConstructors.containsKey(functionName)) {
                    Name arrayConstructor = new Name();
                    arrayConstructor.setIdentifier("Array");
                    ((FunctionCall)node).setTarget((AstNode)arrayConstructor);
                    String string = (String)AtomicFUTransformerJS.this.atomicArrayConstructors.get(functionName);
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        FunctionCall arrayConsCall = new FunctionCall();
                        arrayConsCall.setTarget(((FunctionCall)node).getTarget());
                        arrayConsCall.setArguments(((FunctionCall)node).getArguments());
                        PropertyGet target = new PropertyGet();
                        Name fill = new Name();
                        fill.setIdentifier("fill");
                        target.setTarget((AstNode)arrayConsCall);
                        target.setProperty(fill);
                        ((FunctionCall)node).setTarget((AstNode)target);
                        Name initialValue = new Name();
                        initialValue.setIdentifier(it);
                        ((FunctionCall)node).setArguments(CollectionsKt.listOf((Object)initialValue));
                    }
                    return true;
                }
                if (((FunctionCall)node).getTarget() instanceof PropertyGet) {
                    AstNode astNode = ((FunctionCall)node).getTarget();
                    Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                    if (((PropertyGet)astNode).getTarget() instanceof FunctionCall) {
                        AstNode astNode2 = ((FunctionCall)node).getTarget();
                        Intrinsics.checkNotNull((Object)astNode2, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        PropertyGet atomicOperationTarget = (PropertyGet)astNode2;
                        AstNode astNode3 = atomicOperationTarget.getTarget();
                        Intrinsics.checkNotNull((Object)astNode3, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                        FunctionCall funcCall = (FunctionCall)astNode3;
                        if (funcCall.getTarget() instanceof PropertyGet) {
                            AstNode astNode4 = funcCall.getTarget();
                            Intrinsics.checkNotNull((Object)astNode4, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                            Name getterCall = ((PropertyGet)astNode4).getProperty();
                            Regex regex = new Regex("atomicfu\\$get");
                            String string = getterCall.toSource();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getterCall.toSource()");
                            if (regex.matches((CharSequence)string)) {
                                AstNode getter = this.getArrayElement(funcCall);
                                atomicOperationTarget.setTarget(getter);
                            }
                        }
                    }
                }
            }
            if (node instanceof PropertyGet) {
                Object rr;
                Object receiverName;
                if (Intrinsics.areEqual((Object)((PropertyGet)node).getProperty().toSource(), (Object)"kotlinx$atomicfu$value")) {
                    Object clearField;
                    AstNode astNode = ((PropertyGet)node).getTarget();
                    Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"node.target");
                    AstNode astNode5 = AtomicFUTransformerJS.this.eraseAtomicFieldFromUncheckedCast(astNode);
                    if (astNode5 != null) {
                        AstNode it = astNode5;
                        boolean bl = false;
                        ((PropertyGet)node).setTarget(it);
                    }
                    if (((PropertyGet)node).getTarget().getType() == 33) {
                        AstNode astNode6 = ((PropertyGet)node).getTarget();
                        Intrinsics.checkNotNull((Object)astNode6, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                        clearField = (PropertyGet)astNode6;
                        AstNode targetNode = clearField.getTarget();
                        Name clearProperety = clearField.getProperty();
                        ((PropertyGet)node).setLeftAndRight(targetNode, (AstNode)clearProperety);
                    } else {
                        String string = ((PropertyGet)node).getTarget().toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.target.toSource()");
                        clearField = string;
                        if (new Regex("(\\$(receiver)(_\\d+)?)").matches((CharSequence)clearField)) {
                            receiverName = ((PropertyGet)node).getTarget().toSource();
                            Intrinsics.checkNotNullExpressionValue((Object)receiverName, (String)"receiverName");
                            rr = new ReceiverResolver((String)receiverName);
                            ((PropertyGet)node).getEnclosingFunction().visit((NodeVisitor)rr);
                            AstNode astNode7 = ((ReceiverResolver)rr).getReceiver();
                            if (astNode7 != null) {
                                AstNode it = astNode7;
                                boolean bl = false;
                                ((PropertyGet)node).setTarget(it);
                            }
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)((PropertyGet)node).getProperty().toSource(), (Object)"atomicfu$size")) {
                    void it;
                    rr = receiverName = new Name();
                    propertyGet = (PropertyGet)node;
                    boolean bl = false;
                    it.setIdentifier("length");
                    propertyGet.setProperty((Name)receiverName);
                }
            }
            if (node instanceof Block) {
                for (Object stmt : node) {
                    CharSequence functionName;
                    if (!(stmt instanceof ExpressionStatement)) continue;
                    if (((ExpressionStatement)stmt).getExpression() instanceof Assignment) {
                        AstNode astNode = ((ExpressionStatement)stmt).getExpression();
                        Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.Assignment");
                        Assignment assignment = (Assignment)astNode;
                        if (assignment.getRight() instanceof FunctionCall) {
                            AstNode astNode8 = assignment.getRight();
                            Intrinsics.checkNotNull((Object)astNode8, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                            functionName = ((FunctionCall)astNode8).getTarget().toSource();
                            if (AtomicFUTransformerJS.this.traceConstructors.contains(functionName)) {
                                node.replaceChild((Node)stmt, (Node)new EmptyLine());
                            }
                        }
                    }
                    if (!(((ExpressionStatement)stmt).getExpression() instanceof FunctionCall)) continue;
                    AstNode astNode = ((ExpressionStatement)stmt).getExpression();
                    Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                    AstNode funcNode = ((FunctionCall)astNode).getTarget();
                    if (!(funcNode instanceof PropertyGet)) continue;
                    String string = ((PropertyGet)funcNode).getProperty().toSource();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"funcNode.property.toSource()");
                    functionName = string;
                    if (!new Regex("(atomicfu)\\$(Trace)\\$(append)\\$([1234])").matches(functionName)) continue;
                    node.replaceChild((Node)stmt, (Node)new EmptyLine());
                }
            }
            if (node instanceof Assignment && ((Assignment)node).getLeft() instanceof PropertyGet) {
                AstNode astNode = ((Assignment)node).getLeft();
                Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                left = (PropertyGet)astNode;
                if (AtomicFUTransformerJS.this.traceFormatObjects.contains(left.getTarget().toSource()) && ((Assignment)node).getRight() instanceof FunctionCall) {
                    void it;
                    Object stmt;
                    AstNode astNode9 = ((Assignment)node).getRight();
                    Intrinsics.checkNotNull((Object)astNode9, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.FunctionCall");
                    Object funcNode = stmt = new Name();
                    propertyGet = (FunctionCall)astNode9;
                    boolean bl = false;
                    it.setIdentifier("null");
                    propertyGet.setArguments(CollectionsKt.listOf((Object)stmt));
                }
            }
            if (node instanceof FunctionNode && AtomicFUTransformerJS.this.traceFormatObjects.contains(((FunctionNode)node).getName())) {
                AstNode body = ((FunctionNode)node).getBody();
                for (Node stmt : body) {
                    body.replaceChild(stmt, (Node)new EmptyLine());
                }
            }
            if (node instanceof Assignment && ((Assignment)node).getLeft() instanceof PropertyGet && ((Assignment)node).getRight() instanceof ObjectLiteral) {
                AstNode astNode = ((Assignment)node).getLeft();
                Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                left = (PropertyGet)astNode;
                AstNode astNode10 = ((Assignment)node).getRight();
                Intrinsics.checkNotNull((Object)astNode10, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ObjectLiteral");
                ObjectLiteral metadata = (ObjectLiteral)astNode10;
                if (AtomicFUTransformerJS.this.traceFormatObjects.contains(left.getTarget().toSource())) {
                    for (ObjectProperty e : metadata.getElements()) {
                        if (!(e.getRight() instanceof ArrayLiteral)) continue;
                        AstNode astNode11 = e.getRight();
                        Intrinsics.checkNotNull((Object)astNode11, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ArrayLiteral");
                        String array = ((ArrayLiteral)astNode11).toSource();
                        Intrinsics.checkNotNullExpressionValue((Object)array, (String)"array");
                        if (!StringsKt.contains$default((CharSequence)array, (CharSequence)"TraceFormat", (boolean)false, (int)2, null)) continue;
                        AstNode astNode12 = e.getRight();
                        Intrinsics.checkNotNull((Object)astNode12, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.ArrayLiteral");
                        ((ArrayLiteral)astNode12).setElements(CollectionsKt.emptyList());
                    }
                }
            }
            return true;
        }

        private final AstNode getArrayElement(FunctionCall getterCall) {
            AstNode astNode;
            AstNode astNode2;
            boolean isStatic;
            AstNode index = (AstNode)getterCall.getArguments().get(0);
            AstNode astNode3 = getterCall.getTarget();
            Intrinsics.checkNotNull((Object)astNode3, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
            AstNode arrayField = ((PropertyGet)astNode3).getTarget();
            boolean bl = isStatic = !(arrayField instanceof PropertyGet);
            if (isStatic) {
                astNode2 = arrayField;
            } else {
                Intrinsics.checkNotNull((Object)arrayField, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                astNode2 = (AstNode)((PropertyGet)arrayField).getProperty();
            }
            AstNode arrName = astNode2;
            ElementGet getter = new ElementGet(arrName, index);
            if (isStatic) {
                astNode = (AstNode)getter;
            } else {
                PropertyGet call = new PropertyGet();
                Intrinsics.checkNotNull((Object)arrayField, (String)"null cannot be cast to non-null type org.mozilla.javascript.ast.PropertyGet");
                call.setTarget(((PropertyGet)arrayField).getTarget());
                Name name = new Name();
                name.setIdentifier(getter.toSource());
                call.setProperty(name);
                astNode = (AstNode)call;
            }
            return astNode;
        }
    }
}

