/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.validation.KotlinApiCompareTask;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\u001cH\u0007J\f\u0010\"\u001a\u00020\u0010*\u00020\u0006H\u0002R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\bR \u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\nR\u0016\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkotlinx/validation/KotlinApiCompareTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "apiBuildDir", "Ljava/io/File;", "getApiBuildDir", "()Ljava/io/File;", "setApiBuildDir", "(Ljava/io/File;)V", "dummyOutputFile", "getDummyOutputFile$annotations", "()V", "getDummyOutputFile", "nonExistingProjectApiDir", "", "getNonExistingProjectApiDir", "()Ljava/lang/String;", "setNonExistingProjectApiDir", "(Ljava/lang/String;)V", "projectApiDir", "getProjectApiDir", "setProjectApiDir", "projectName", "kotlin.jvm.PlatformType", "rootDir", "compareApiDumps", "", "apiReferenceDir", "compareFiles", "checkFile", "builtFile", "verify", "relativeDirPath", "binary-compatibility-validator"})
public class KotlinApiCompareTask
extends DefaultTask {
    @Optional
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Nullable
    private File projectApiDir;
    @Input
    @Optional
    @Nullable
    private String nonExistingProjectApiDir;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File apiBuildDir;
    @OutputFile
    @Optional
    @Nullable
    private final File dummyOutputFile;
    private final String projectName;
    private final File rootDir;
    private final ObjectFactory objects;

    @Nullable
    public final File getProjectApiDir() {
        return this.projectApiDir;
    }

    public final void setProjectApiDir(@Nullable File file) {
        this.projectApiDir = file;
    }

    @Nullable
    public final String getNonExistingProjectApiDir() {
        return this.nonExistingProjectApiDir;
    }

    public final void setNonExistingProjectApiDir(@Nullable String string) {
        this.nonExistingProjectApiDir = string;
    }

    public final void compareApiDumps(@NotNull File apiReferenceDir, @NotNull File apiBuildDir2) {
        Intrinsics.checkNotNullParameter((Object)apiReferenceDir, (String)"apiReferenceDir");
        Intrinsics.checkNotNullParameter((Object)apiBuildDir2, (String)"apiBuildDir");
        if (apiReferenceDir.exists()) {
            this.projectApiDir = apiReferenceDir;
        } else {
            this.projectApiDir = null;
            this.nonExistingProjectApiDir = apiReferenceDir.toString();
        }
        this.apiBuildDir = apiBuildDir2;
    }

    @NotNull
    public final File getApiBuildDir() {
        File file = this.apiBuildDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        return file;
    }

    public final void setApiBuildDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.apiBuildDir = file;
    }

    public static /* synthetic */ void getDummyOutputFile$annotations() {
    }

    @Nullable
    public final File getDummyOutputFile() {
        return this.dummyOutputFile;
    }

    @TaskAction
    public final void verify() {
        Collection collection;
        File file = this.projectApiDir;
        if (file == null) {
            String string = "Expected folder with API declarations '" + this.nonExistingProjectApiDir + "' does not exist.\n" + "Please ensure that ':apiDump' was executed in order to get API dump to compare the build against";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File projectApiDir = file;
        String subject = this.projectName;
        verify.1 $fun$caseInsensitiveMap$1 = verify.1.INSTANCE;
        Object apiBuildDirFiles = $fun$caseInsensitiveMap$1.invoke();
        Object expectedApiFiles = $fun$caseInsensitiveMap$1.invoke();
        ConfigurableFileTree configurableFileTree = this.objects.fileTree();
        File file2 = this.apiBuildDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        configurableFileTree.from((Object)file2).visit(new Action((TreeMap)apiBuildDirFiles){
            final /* synthetic */ TreeMap $apiBuildDirFiles;

            public final void execute(FileVisitDetails file) {
                Map map = this.$apiBuildDirFiles;
                FileVisitDetails fileVisitDetails = file;
                Intrinsics.checkNotNullExpressionValue((Object)fileVisitDetails, (String)"file");
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"file.relativePath");
                RelativePath relativePath2 = file.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath2, (String)"file.relativePath");
                map.put(relativePath, relativePath2);
            }
            {
                this.$apiBuildDirFiles = treeMap;
            }
        });
        this.objects.fileTree().from((Object)projectApiDir).visit(new Action((TreeMap)expectedApiFiles){
            final /* synthetic */ TreeMap $expectedApiFiles;

            public final void execute(FileVisitDetails file) {
                Map map = this.$expectedApiFiles;
                FileVisitDetails fileVisitDetails = file;
                Intrinsics.checkNotNullExpressionValue((Object)fileVisitDetails, (String)"file");
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"file.relativePath");
                RelativePath relativePath2 = file.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)relativePath2, (String)"file.relativePath");
                map.put(relativePath, relativePath2);
            }
            {
                this.$expectedApiFiles = treeMap;
            }
        });
        if (((TreeMap)apiBuildDirFiles).size() != 1) {
            String string = "Expected a single file " + subject + ".api, but found: " + expectedApiFiles;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Set set = ((TreeMap)apiBuildDirFiles).keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"apiBuildDirFiles.keys");
        Object object = CollectionsKt.single((Iterable)set);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiBuildDirFiles.keys.single()");
        RelativePath expectedApiDeclaration = (RelativePath)object;
        Object object2 = (Map)expectedApiFiles;
        Map map = object2;
        boolean bl = false;
        if (!map.containsKey(expectedApiDeclaration)) {
            object2 = "File " + expectedApiDeclaration.getLastName() + " is missing from " + this.relativeDirPath(projectApiDir) + ", please run " + ':' + subject + ":apiDump task to generate one";
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        expectedApiDeclaration = (RelativePath)MapsKt.getValue((Map)((Map)expectedApiFiles), (Object)expectedApiDeclaration);
        RelativePath actualApiDeclaration = (RelativePath)MapsKt.getValue((Map)((Map)apiBuildDirFiles), (Object)expectedApiDeclaration);
        Set diffSet = new LinkedHashSet();
        File expectedFile = expectedApiDeclaration.getFile(projectApiDir);
        File file3 = this.apiBuildDir;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        File actualFile = actualApiDeclaration.getFile(file3);
        File file4 = expectedFile;
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"expectedFile");
        File file5 = actualFile;
        Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"actualFile");
        String diff = this.compareFiles(file4, file5);
        if (diff != null) {
            diffSet.add(diff);
        }
        if (!(collection = (Collection)diffSet).isEmpty()) {
            String diffText = CollectionsKt.joinToString$default((Iterable)diffSet, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            String string = "API check failed for project " + subject + ".\n" + diffText + "\n\n You can run :" + subject + ":apiDump task to overwrite API declarations";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final String relativeDirPath(File $this$relativeDirPath) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.rootDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir");
        return stringBuilder.append(FilesKt.toRelativeString((File)$this$relativeDirPath, (File)file)).append(File.separator).toString();
    }

    private final String compareFiles(File checkFile, File builtFile) {
        List diff;
        List builtLines;
        String checkText = FilesKt.readText$default((File)checkFile, null, (int)1, null);
        String builtText = FilesKt.readText$default((File)builtFile, null, (int)1, null);
        List checkLines = StringsKt.lines((CharSequence)checkText);
        if (Intrinsics.areEqual((Object)checkLines, (Object)(builtLines = StringsKt.lines((CharSequence)builtText)))) {
            return null;
        }
        Patch patch = DiffUtils.diff((List)checkLines, (List)builtLines);
        List list = diff = DiffUtils.generateUnifiedDiff((String)checkFile.toString(), (String)builtFile.toString(), (List)checkLines, (Patch)patch, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"diff");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Inject
    public KotlinApiCompareTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.objects = objects;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.projectName = project.getName();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Project project3 = project2.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project.rootProject");
        this.rootDir = project3.getRootDir();
    }
}

