/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\f\u0010\u0014\u001a\u00020\u000f*\u00020\u0004H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001e\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\b\u00a8\u0006\u0015"}, d2={"Lkotlinx/validation/ApiCompareCompareTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apiBuildDir", "Ljava/io/File;", "getApiBuildDir", "()Ljava/io/File;", "setApiBuildDir", "(Ljava/io/File;)V", "dummyOutputFile", "getDummyOutputFile", "projectApiDir", "getProjectApiDir", "setProjectApiDir", "compareFiles", "", "checkFile", "builtFile", "verify", "", "relativePath", "binary-compatibility-validator"})
public class ApiCompareCompareTask
extends DefaultTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public File projectApiDir;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public File apiBuildDir;
    @OutputFile
    @Optional
    @Nullable
    private final File dummyOutputFile;

    @NotNull
    public final File getProjectApiDir() {
        File file = this.projectApiDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectApiDir");
        }
        return file;
    }

    public final void setProjectApiDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.projectApiDir = file;
    }

    @NotNull
    public final File getApiBuildDir() {
        File file = this.apiBuildDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        return file;
    }

    public final void setApiBuildDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.apiBuildDir = file;
    }

    @Nullable
    public final File getDummyOutputFile() {
        return this.dummyOutputFile;
    }

    @TaskAction
    public final void verify() {
        File file = this.projectApiDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectApiDir");
        }
        if (!file.exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Expected folder with API declarations '");
            File file2 = this.projectApiDir;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectApiDir");
            }
            String string = stringBuilder.append(file2).append("' does not exist").toString();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File file3 = this.apiBuildDir;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        if (!file3.exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Folder with built API declarations '");
            File file4 = this.apiBuildDir;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
            }
            String string = stringBuilder.append(file4).append("' does not exist").toString();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String subject = project.getName();
        boolean bl = false;
        Set apiBuildDirFiles = new LinkedHashSet();
        boolean bl2 = false;
        Set expectedApiFiles = new LinkedHashSet();
        Project project2 = this.getProject();
        File file5 = this.apiBuildDir;
        if (file5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        project2.fileTree((Object)file5).visit((Action)new Action<FileVisitDetails>(apiBuildDirFiles){
            final /* synthetic */ Set $apiBuildDirFiles;

            public final void execute(FileVisitDetails file) {
                FileVisitDetails fileVisitDetails = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileVisitDetails, (String)"file");
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"file.relativePath");
                this.$apiBuildDirFiles.add(relativePath);
            }
            {
                this.$apiBuildDirFiles = set;
            }
        });
        Project project3 = this.getProject();
        File file6 = this.projectApiDir;
        if (file6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectApiDir");
        }
        project3.fileTree((Object)file6).visit((Action)new Action<FileVisitDetails>(expectedApiFiles){
            final /* synthetic */ Set $expectedApiFiles;

            public final void execute(FileVisitDetails file) {
                FileVisitDetails fileVisitDetails = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileVisitDetails, (String)"file");
                RelativePath relativePath = fileVisitDetails.getRelativePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"file.relativePath");
                this.$expectedApiFiles.add(relativePath);
            }
            {
                this.$expectedApiFiles = set;
            }
        });
        if (apiBuildDirFiles.size() != 1) {
            String string = "Expected a single file " + subject + ".api, but found: " + expectedApiFiles;
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RelativePath expectedApiDeclaration = (RelativePath)CollectionsKt.single((Iterable)apiBuildDirFiles);
        if (!expectedApiFiles.contains(expectedApiDeclaration)) {
            StringBuilder stringBuilder = new StringBuilder().append("File ").append(expectedApiDeclaration.getLastName()).append(" is missing from ");
            File file7 = this.projectApiDir;
            if (file7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectApiDir");
            }
            String string = stringBuilder.append(this.relativePath(file7)).append(", please run ").append(':').append(subject).append(":apiDump task to generate one").toString();
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean bl5 = false;
        Set diffSet = new LinkedHashSet();
        File file8 = this.projectApiDir;
        if (file8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectApiDir");
        }
        File expectedFile = expectedApiDeclaration.getFile(file8);
        File file9 = this.apiBuildDir;
        if (file9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiBuildDir");
        }
        File actualFile = expectedApiDeclaration.getFile(file9);
        File file10 = expectedFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file10, (String)"expectedFile");
        File file11 = actualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file11, (String)"actualFile");
        String diff = this.compareFiles(file10, file11);
        if (diff != null) {
            diffSet.add(diff);
        }
        Collection collection = diffSet;
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            String diffText = CollectionsKt.joinToString$default((Iterable)diffSet, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            String string = "API check failed for project " + subject + ".\n" + diffText + "\n\n You can run :" + subject + ":apiDump task to overwrite API declarations";
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final String relativePath(@NotNull File $this$relativePath) {
        StringBuilder stringBuilder = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        File file = project2.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootProject.rootDir");
        return stringBuilder.append(FilesKt.relativeTo((File)$this$relativePath, (File)file).toString()).append("/").toString();
    }

    private final String compareFiles(File checkFile, File builtFile) {
        List diff;
        List builtLines;
        String checkText = FilesKt.readText$default((File)checkFile, null, (int)1, null);
        String builtText = FilesKt.readText$default((File)builtFile, null, (int)1, null);
        List checkLines = StringsKt.lines((CharSequence)checkText);
        if (Intrinsics.areEqual((Object)checkLines, (Object)(builtLines = StringsKt.lines((CharSequence)builtText)))) {
            return null;
        }
        Patch patch = DiffUtils.diff((List)checkLines, (List)builtLines);
        List list = diff = DiffUtils.generateUnifiedDiff((String)checkFile.toString(), (String)builtFile.toString(), (List)checkLines, (Patch)patch, (int)3);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"diff");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

