/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.arrow.memory.RootAllocator;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.NullabilityOptions;
import org.jetbrains.kotlinx.dataframe.io.Allocator;
import org.jetbrains.kotlinx.dataframe.io.ArrowReadingImplKt;
import org.jetbrains.kotlinx.dataframe.io.CommonKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\r\u001a\u00020\u00152\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"readArrowFeather", "", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "file", "Ljava/io/File;", "nullability", "Lorg/jetbrains/kotlinx/dataframe/api/NullabilityOptions;", "stream", "Ljava/io/InputStream;", "url", "Ljava/net/URL;", "channel", "Ljava/nio/channels/SeekableByteChannel;", "allocator", "Lorg/apache/arrow/memory/RootAllocator;", "byteArray", "", "path", "readArrowIPC", "Ljava/nio/channels/ReadableByteChannel;", "dataframe-arrow"})
@SourceDebugExtension(value={"SMAP\narrowReading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 arrowReading.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowReadingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class ArrowReadingKt {
    @NotNull
    private static final String readArrowFeather = "readArrowFeather";

    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull ReadableByteChannel channel, @NotNull RootAllocator allocator, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingImplKt.readArrowIPCImpl($this$readArrowIPC, channel, allocator, nullability);
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, ReadableByteChannel readableByteChannel, RootAllocator rootAllocator, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            rootAllocator = Allocator.INSTANCE.getROOT();
        }
        if ((n & 4) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, readableByteChannel, rootAllocator, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull SeekableByteChannel channel, @NotNull RootAllocator allocator, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingImplKt.readArrowFeatherImpl($this$readArrowFeather, channel, allocator, nullability);
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, SeekableByteChannel seekableByteChannel, RootAllocator rootAllocator, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            rootAllocator = Allocator.INSTANCE.getROOT();
        }
        if ((n & 4) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, seekableByteChannel, rootAllocator, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull File file, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = Files.newByteChannel(file.toPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            dataFrame = ArrowReadingKt.readArrowIPC$default($this$readArrowIPC, it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, File file, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, file, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull byte[] byteArray, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = (Closeable)new SeekableInMemoryByteChannel(byteArray);
        Throwable throwable = null;
        try {
            SeekableInMemoryByteChannel it = (SeekableInMemoryByteChannel)closeable;
            boolean bl = false;
            dataFrame = ArrowReadingKt.readArrowIPC$default($this$readArrowIPC, (ReadableByteChannel)it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, byte[] byArray, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, byArray, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull InputStream stream, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = Channels.newChannel(stream);
        Throwable throwable = null;
        try {
            ReadableByteChannel it = (ReadableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            dataFrame = ArrowReadingKt.readArrowIPC$default($this$readArrowIPC, it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, InputStream inputStream, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, inputStream, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull URL url, @NotNull NullabilityOptions nullability) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        if (CommonKt.isFile((URL)url)) {
            dataFrame = ArrowReadingKt.readArrowIPC($this$readArrowIPC, CommonKt.urlAsFile((URL)url), nullability);
        } else if (CommonKt.isProtocolSupported((URL)url)) {
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                DataFrame<?> dataFrame2 = ArrowReadingKt.readArrowIPC($this$readArrowIPC, it, nullability);
                dataFrame = dataFrame2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw new IllegalArgumentException("Invalid protocol for url " + url);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, URL uRL, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, uRL, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull String path, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return CommonKt.isURL((String)path) ? ArrowReadingKt.readArrowIPC($this$readArrowIPC, new URL(path), nullability) : ArrowReadingKt.readArrowIPC($this$readArrowIPC, new File(path), nullability);
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, String string, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, string, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull File file, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = Files.newByteChannel(file.toPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            dataFrame = ArrowReadingKt.readArrowFeather$default($this$readArrowFeather, it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, File file, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, file, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull byte[] byteArray, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = (Closeable)new SeekableInMemoryByteChannel(byteArray);
        Throwable throwable = null;
        try {
            SeekableInMemoryByteChannel it = (SeekableInMemoryByteChannel)closeable;
            boolean bl = false;
            dataFrame = ArrowReadingKt.readArrowFeather$default($this$readArrowFeather, (SeekableByteChannel)it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, byte[] byArray, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, byArray, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull InputStream stream, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingKt.readArrowFeather($this$readArrowFeather, ByteStreamsKt.readBytes((InputStream)stream), nullability);
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, InputStream inputStream, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, inputStream, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull URL url, @NotNull NullabilityOptions nullability) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        if (CommonKt.isFile((URL)url)) {
            dataFrame = ArrowReadingKt.readArrowFeather($this$readArrowFeather, CommonKt.urlAsFile((URL)url), nullability);
        } else if (CommonKt.isProtocolSupported((URL)url)) {
            dataFrame = ArrowReadingKt.readArrowFeather($this$readArrowFeather, TextStreamsKt.readBytes((URL)url), nullability);
        } else {
            throw new IllegalArgumentException("Invalid protocol for url " + url);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, URL uRL, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, uRL, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull String path, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return CommonKt.isURL((String)path) ? ArrowReadingKt.readArrowFeather($this$readArrowFeather, new URL(path), nullability) : ArrowReadingKt.readArrowFeather($this$readArrowFeather, new File(path), nullability);
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, String string, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, string, nullabilityOptions);
    }
}

