/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriterImpl;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriterKt;
import org.jetbrains.kotlinx.dataframe.io.ConvertingMismatch;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000 #2\u00020\u0001:\u0002#$J\b\u0010\u0014\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010!\u001a\u00020\"H\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0016\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001e\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter;", "Ljava/lang/AutoCloseable;", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getDataFrame", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "mismatchSubscriber", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/io/ConvertingMismatch;", "", "getMismatchSubscriber", "()Lkotlin/jvm/functions/Function1;", "mode", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "getMode", "()Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "targetSchema", "Lorg/apache/arrow/vector/types/pojo/Schema;", "getTargetSchema", "()Lorg/apache/arrow/vector/types/pojo/Schema;", "allocateVectorSchemaRoot", "Lorg/apache/arrow/vector/VectorSchemaRoot;", "saveArrowFeatherToByteArray", "", "saveArrowIPCToByteArray", "writeArrowFeather", "file", "Ljava/io/File;", "stream", "Ljava/io/OutputStream;", "channel", "Ljava/nio/channels/WritableByteChannel;", "writeArrowIPC", "append", "", "Companion", "Mode", "dataframe-arrow"})
public interface ArrowWriter
extends AutoCloseable {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.io.ArrowWriter$Companion.$$INSTANCE;

    @NotNull
    public DataFrame<?> getDataFrame();

    @NotNull
    public Schema getTargetSchema();

    @NotNull
    public Mode getMode();

    @NotNull
    public Function1<ConvertingMismatch, Unit> getMismatchSubscriber();

    @NotNull
    public VectorSchemaRoot allocateVectorSchemaRoot();

    public void writeArrowIPC(@NotNull WritableByteChannel var1);

    public void writeArrowIPC(@NotNull OutputStream var1);

    public void writeArrowIPC(@NotNull File var1, boolean var2);

    @NotNull
    public byte[] saveArrowIPCToByteArray();

    public void writeArrowFeather(@NotNull WritableByteChannel var1);

    public void writeArrowFeather(@NotNull OutputStream var1);

    public void writeArrowFeather(@NotNull File var1);

    @NotNull
    public byte[] saveArrowFeatherToByteArray();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter;", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "targetSchema", "Lorg/apache/arrow/vector/types/pojo/Schema;", "mode", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "mismatchSubscriber", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/io/ConvertingMismatch;", "", "dataframe-arrow"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final ArrowWriter create(@NotNull DataFrame<?> dataFrame, @NotNull Schema targetSchema, @NotNull Mode mode, @NotNull Function1<? super ConvertingMismatch, Unit> mismatchSubscriber) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)targetSchema, (String)"targetSchema");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter(mismatchSubscriber, (String)"mismatchSubscriber");
            return new ArrowWriterImpl(dataFrame, targetSchema, mode, mismatchSubscriber);
        }

        public static /* synthetic */ ArrowWriter create$default(Companion companion, DataFrame dataFrame, Schema schema, Mode mode, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = ArrowWriterKt.getIgnoreMismatchMessage();
            }
            return companion.create(dataFrame, schema, mode, function1);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeArrowIPC(@NotNull ArrowWriter $this, @NotNull WritableByteChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            AutoCloseable autoCloseable = (AutoCloseable)$this.allocateVectorSchemaRoot();
            Throwable throwable = null;
            try {
                VectorSchemaRoot vectorSchemaRoot = (VectorSchemaRoot)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = (AutoCloseable)new ArrowStreamWriter(vectorSchemaRoot, null, channel);
                Throwable throwable2 = null;
                try {
                    ArrowStreamWriter writer = (ArrowStreamWriter)autoCloseable2;
                    boolean bl2 = false;
                    writer.writeBatch();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public static void writeArrowIPC(@NotNull ArrowWriter $this, @NotNull OutputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            WritableByteChannel writableByteChannel = Channels.newChannel(stream);
            Intrinsics.checkNotNullExpressionValue((Object)writableByteChannel, (String)"newChannel(stream)");
            $this.writeArrowIPC(writableByteChannel);
        }

        public static void writeArrowIPC(@NotNull ArrowWriter $this, @NotNull File file, boolean append) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            $this.writeArrowIPC(new FileOutputStream(file, append));
        }

        public static /* synthetic */ void writeArrowIPC$default(ArrowWriter arrowWriter, File file, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeArrowIPC");
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            arrowWriter.writeArrowIPC(file, bl);
        }

        @NotNull
        public static byte[] saveArrowIPCToByteArray(@NotNull ArrowWriter $this) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            $this.writeArrowIPC(stream);
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeArrowFeather(@NotNull ArrowWriter $this, @NotNull WritableByteChannel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            AutoCloseable autoCloseable = (AutoCloseable)$this.allocateVectorSchemaRoot();
            Throwable throwable = null;
            try {
                VectorSchemaRoot vectorSchemaRoot = (VectorSchemaRoot)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = (AutoCloseable)new ArrowFileWriter(vectorSchemaRoot, null, channel);
                Throwable throwable2 = null;
                try {
                    ArrowFileWriter writer = (ArrowFileWriter)autoCloseable2;
                    boolean bl2 = false;
                    writer.writeBatch();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public static void writeArrowFeather(@NotNull ArrowWriter $this, @NotNull OutputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            WritableByteChannel writableByteChannel = Channels.newChannel(stream);
            Intrinsics.checkNotNullExpressionValue((Object)writableByteChannel, (String)"newChannel(stream)");
            $this.writeArrowFeather(writableByteChannel);
        }

        public static void writeArrowFeather(@NotNull ArrowWriter $this, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            $this.writeArrowFeather(new FileOutputStream(file));
        }

        @NotNull
        public static byte[] saveArrowFeatherToByteArray(@NotNull ArrowWriter $this) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            $this.writeArrowFeather(stream);
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
            return byArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "", "restrictWidening", "", "restrictNarrowing", "strictType", "strictNullable", "(ZZZZ)V", "getRestrictNarrowing", "()Z", "getRestrictWidening", "getStrictNullable", "getStrictType", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "dataframe-arrow"})
    public static final class Mode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean restrictWidening;
        private final boolean restrictNarrowing;
        private final boolean strictType;
        private final boolean strictNullable;
        @NotNull
        private static final Mode STRICT = new Mode(true, true, true, true);
        @NotNull
        private static final Mode LOYAL = new Mode(false, false, false, false);

        public Mode(boolean restrictWidening, boolean restrictNarrowing, boolean strictType, boolean strictNullable) {
            this.restrictWidening = restrictWidening;
            this.restrictNarrowing = restrictNarrowing;
            this.strictType = strictType;
            this.strictNullable = strictNullable;
        }

        public final boolean getRestrictWidening() {
            return this.restrictWidening;
        }

        public final boolean getRestrictNarrowing() {
            return this.restrictNarrowing;
        }

        public final boolean getStrictType() {
            return this.strictType;
        }

        public final boolean getStrictNullable() {
            return this.strictNullable;
        }

        public final boolean component1() {
            return this.restrictWidening;
        }

        public final boolean component2() {
            return this.restrictNarrowing;
        }

        public final boolean component3() {
            return this.strictType;
        }

        public final boolean component4() {
            return this.strictNullable;
        }

        @NotNull
        public final Mode copy(boolean restrictWidening, boolean restrictNarrowing, boolean strictType, boolean strictNullable) {
            return new Mode(restrictWidening, restrictNarrowing, strictType, strictNullable);
        }

        public static /* synthetic */ Mode copy$default(Mode mode, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = mode.restrictWidening;
            }
            if ((n & 2) != 0) {
                bl2 = mode.restrictNarrowing;
            }
            if ((n & 4) != 0) {
                bl3 = mode.strictType;
            }
            if ((n & 8) != 0) {
                bl4 = mode.strictNullable;
            }
            return mode.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Mode(restrictWidening=" + this.restrictWidening + ", restrictNarrowing=" + this.restrictNarrowing + ", strictType=" + this.strictType + ", strictNullable=" + this.strictNullable + ')';
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.restrictWidening ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.restrictNarrowing) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n3 = this.strictType ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.strictNullable ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mode)) {
                return false;
            }
            Mode mode = (Mode)other;
            if (this.restrictWidening != mode.restrictWidening) {
                return false;
            }
            if (this.restrictNarrowing != mode.restrictNarrowing) {
                return false;
            }
            if (this.strictType != mode.strictType) {
                return false;
            }
            return this.strictNullable == mode.strictNullable;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode$Companion;", "", "()V", "LOYAL", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "getLOYAL", "()Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "STRICT", "getSTRICT", "dataframe-arrow"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Mode getSTRICT() {
                return STRICT;
            }

            @NotNull
            public final Mode getLOYAL() {
                return LOYAL;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

