/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.NullabilityOptions;
import org.jetbrains.kotlinx.dataframe.io.Allocator;
import org.jetbrains.kotlinx.dataframe.io.ArrowReadingImplKt;
import org.jetbrains.kotlinx.dataframe.io.CommonKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a.\u0010\f\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\f\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\f\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\f\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\f\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\f\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a$\u0010\u0017\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\u001a\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\u00020\u00192\b\b\u0002\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"READ_ARROW_FEATHER", "", "readArrowIPC", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "channel", "Ljava/nio/channels/ReadableByteChannel;", "allocator", "Lorg/apache/arrow/memory/RootAllocator;", "nullability", "Lorg/jetbrains/kotlinx/dataframe/api/NullabilityOptions;", "readArrowFeather", "Ljava/nio/channels/SeekableByteChannel;", "file", "Ljava/io/File;", "byteArray", "", "stream", "Ljava/io/InputStream;", "url", "Ljava/net/URL;", "path", "readArrow", "reader", "Lorg/apache/arrow/vector/ipc/ArrowReader;", "toDataFrame", "dataframe-arrow"})
@SourceDebugExtension(value={"SMAP\narrowReading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 arrowReading.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowReadingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class ArrowReadingKt {
    @NotNull
    private static final String READ_ARROW_FEATHER = "readArrowFeather";

    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull ReadableByteChannel channel, @NotNull RootAllocator allocator, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingImplKt.readArrowIPCImpl($this$readArrowIPC, channel, allocator, nullability);
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, ReadableByteChannel readableByteChannel, RootAllocator rootAllocator, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            rootAllocator = Allocator.INSTANCE.getROOT();
        }
        if ((n & 4) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, readableByteChannel, rootAllocator, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull SeekableByteChannel channel, @NotNull RootAllocator allocator, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingImplKt.readArrowFeatherImpl($this$readArrowFeather, channel, allocator, nullability);
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, SeekableByteChannel seekableByteChannel, RootAllocator rootAllocator, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            rootAllocator = Allocator.INSTANCE.getROOT();
        }
        if ((n & 4) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, seekableByteChannel, rootAllocator, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull File file, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = Files.newByteChannel(file.toPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            dataFrame = ArrowReadingKt.readArrowIPC$default($this$readArrowIPC, it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, File file, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, file, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull byte[] byteArray, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = (Closeable)new SeekableInMemoryByteChannel(byteArray);
        Throwable throwable = null;
        try {
            SeekableInMemoryByteChannel it = (SeekableInMemoryByteChannel)closeable;
            boolean bl = false;
            dataFrame = ArrowReadingKt.readArrowIPC$default($this$readArrowIPC, (ReadableByteChannel)it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, byte[] byArray, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, byArray, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull InputStream stream, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = Channels.newChannel(stream);
        Throwable throwable = null;
        try {
            ReadableByteChannel it = (ReadableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            dataFrame = ArrowReadingKt.readArrowIPC$default($this$readArrowIPC, it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, InputStream inputStream, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, inputStream, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull URL url, @NotNull NullabilityOptions nullability) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        if (CommonKt.isFile((URL)url)) {
            dataFrame = ArrowReadingKt.readArrowIPC($this$readArrowIPC, CommonKt.urlAsFile((URL)url), nullability);
        } else if (CommonKt.isProtocolSupported((URL)url)) {
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                DataFrame<?> dataFrame2 = ArrowReadingKt.readArrowIPC($this$readArrowIPC, it, nullability);
                dataFrame = dataFrame2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw new IllegalArgumentException("Invalid protocol for url " + url);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, URL uRL, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, uRL, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowIPC(@NotNull DataFrame.Companion $this$readArrowIPC, @NotNull String path, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowIPC, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return CommonKt.isUrl((String)path) ? ArrowReadingKt.readArrowIPC($this$readArrowIPC, new URL(path), nullability) : ArrowReadingKt.readArrowIPC($this$readArrowIPC, new File(path), nullability);
    }

    public static /* synthetic */ DataFrame readArrowIPC$default(DataFrame.Companion companion, String string, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowIPC(companion, string, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull File file, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = Files.newByteChannel(file.toPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            dataFrame = ArrowReadingKt.readArrowFeather$default($this$readArrowFeather, it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, File file, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, file, nullabilityOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull byte[] byteArray, @NotNull NullabilityOptions nullability) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        Closeable closeable = (Closeable)new SeekableInMemoryByteChannel(byteArray);
        Throwable throwable = null;
        try {
            SeekableInMemoryByteChannel it = (SeekableInMemoryByteChannel)closeable;
            boolean bl = false;
            dataFrame = ArrowReadingKt.readArrowFeather$default($this$readArrowFeather, (SeekableByteChannel)it, null, nullability, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, byte[] byArray, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, byArray, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull InputStream stream, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingKt.readArrowFeather($this$readArrowFeather, ByteStreamsKt.readBytes((InputStream)stream), nullability);
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, InputStream inputStream, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, inputStream, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull URL url, @NotNull NullabilityOptions nullability) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        if (CommonKt.isFile((URL)url)) {
            dataFrame = ArrowReadingKt.readArrowFeather($this$readArrowFeather, CommonKt.urlAsFile((URL)url), nullability);
        } else if (CommonKt.isProtocolSupported((URL)url)) {
            dataFrame = ArrowReadingKt.readArrowFeather($this$readArrowFeather, TextStreamsKt.readBytes((URL)url), nullability);
        } else {
            throw new IllegalArgumentException("Invalid protocol for url " + url);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, URL uRL, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, uRL, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrowFeather(@NotNull DataFrame.Companion $this$readArrowFeather, @NotNull String path, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrowFeather, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return CommonKt.isUrl((String)path) ? ArrowReadingKt.readArrowFeather($this$readArrowFeather, new URL(path), nullability) : ArrowReadingKt.readArrowFeather($this$readArrowFeather, new File(path), nullability);
    }

    public static /* synthetic */ DataFrame readArrowFeather$default(DataFrame.Companion companion, String string, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrowFeather(companion, string, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> readArrow(@NotNull DataFrame.Companion $this$readArrow, @NotNull ArrowReader reader, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readArrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingImplKt.readArrowImpl($this$readArrow, reader, nullability);
    }

    public static /* synthetic */ DataFrame readArrow$default(DataFrame.Companion companion, ArrowReader arrowReader, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 2) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.readArrow(companion, arrowReader, nullabilityOptions);
    }

    @NotNull
    public static final DataFrame<?> toDataFrame(@NotNull ArrowReader $this$toDataFrame, @NotNull NullabilityOptions nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$toDataFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nullability, (String)"nullability");
        return ArrowReadingImplKt.readArrowImpl(DataFrame.Companion, $this$toDataFrame, nullability);
    }

    public static /* synthetic */ DataFrame toDataFrame$default(ArrowReader arrowReader, NullabilityOptions nullabilityOptions, int n, Object object) {
        if ((n & 1) != 0) {
            nullabilityOptions = NullabilityOptions.Infer;
        }
        return ArrowReadingKt.toDataFrame(arrowReader, nullabilityOptions);
    }
}

