/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedWidthVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VariableWidthVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.exceptions.CellConversionException;
import org.jetbrains.kotlinx.dataframe.exceptions.TypeConverterNotFoundException;
import org.jetbrains.kotlinx.dataframe.io.ArrowTypesMatchingKt;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriter;
import org.jetbrains.kotlinx.dataframe.io.ArrowWriterKt;
import org.jetbrains.kotlinx.dataframe.io.ConvertingException;
import org.jetbrains.kotlinx.dataframe.io.ConvertingMismatch;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u0004\u0018\u00010\u001e2\u000e\u0010!\u001a\n\u0012\u0002\b\u00030\"j\u0002`#H\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010&\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\"j\u0004\u0018\u0001`#2\u0012\u0010!\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\"j\u0004\u0018\u0001`#2\u0006\u0010'\u001a\u00020(H\u0002J,\u0010)\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u00030\"j\u0002`#\u0012\u0004\u0012\u00020+0*2\u000e\u0010!\u001a\n\u0012\u0002\b\u00030\"j\u0002`#H\u0002J \u0010,\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010!\u001a\n\u0012\u0002\b\u00030\"j\u0002`#H\u0002J4\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020+2\u0012\u0010!\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\"j\u0004\u0018\u0001`#2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J \u00102\u001a\b\u0012\u0004\u0012\u00020\u001a03*\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\"j\u0002`#03H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u000bH\u0016R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriterImpl;", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter;", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "targetSchema", "Lorg/apache/arrow/vector/types/pojo/Schema;", "mode", "Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "mismatchSubscriber", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/io/ConvertingMismatch;", "", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Lorg/apache/arrow/vector/types/pojo/Schema;Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;Lkotlin/jvm/functions/Function1;)V", "getDataFrame", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getTargetSchema", "()Lorg/apache/arrow/vector/types/pojo/Schema;", "getMode", "()Lorg/jetbrains/kotlinx/dataframe/io/ArrowWriter$Mode;", "getMismatchSubscriber", "()Lkotlin/jvm/functions/Function1;", "allocator", "Lorg/apache/arrow/memory/RootAllocator;", "allocateVector", "vector", "Lorg/apache/arrow/vector/FieldVector;", "size", "", "totalBytes", "", "(Lorg/apache/arrow/vector/FieldVector;ILjava/lang/Long;)V", "countTotalBytes", "column", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "(Lorg/jetbrains/kotlinx/dataframe/DataColumn;)Ljava/lang/Long;", "infillWithNulls", "convertColumnToTarget", "targetFieldType", "Lorg/apache/arrow/vector/types/pojo/ArrowType;", "convertColumnToCompatible", "Lkotlin/Pair;", "Lorg/apache/arrow/vector/types/pojo/Field;", "infillVector", "allocateVectorAndInfill", "field", "strictType", "", "strictNullable", "toVectors", "", "allocateVectorSchemaRoot", "Lorg/apache/arrow/vector/VectorSchemaRoot;", "close", "dataframe-arrow"})
@SourceDebugExtension(value={"SMAP\nArrowWriterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrowWriterImpl.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowWriterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 map.kt\norg/jetbrains/kotlinx/dataframe/api/MapKt\n+ 5 forEach.kt\norg/jetbrains/kotlinx/dataframe/api/ForEachKt\n*L\n1#1,423:1\n1#2:424\n1797#3,3:425\n1872#3,3:441\n1872#3,3:445\n1872#3,3:449\n1872#3,3:453\n1872#3,3:457\n1872#3,3:461\n1872#3,3:465\n1872#3,3:469\n1872#3,3:473\n1872#3,3:477\n1872#3,3:481\n1872#3,3:485\n1872#3,3:489\n1872#3,3:493\n1872#3,3:497\n1872#3,3:501\n1872#3,3:505\n1557#3:508\n1628#3,3:509\n1863#3,2:512\n774#3:514\n865#3,2:515\n1863#3,2:517\n1863#3,2:519\n32#4,6:428\n32#4,6:434\n12#5:440\n12#5:444\n12#5:448\n12#5:452\n12#5:456\n12#5:460\n12#5:464\n12#5:468\n12#5:472\n12#5:476\n12#5:480\n12#5:484\n12#5:488\n12#5:492\n12#5:496\n12#5:500\n12#5:504\n*S KotlinDebug\n*F\n+ 1 ArrowWriterImpl.kt\norg/jetbrains/kotlinx/dataframe/io/ArrowWriterImpl\n*L\n87#1:425,3\n162#1:441,3\n169#1:445,3\n176#1:449,3\n183#1:453,3\n190#1:457,3\n197#1:461,3\n204#1:465,3\n211#1:469,3\n218#1:473,3\n225#1:477,3\n232#1:481,3\n239#1:485,3\n246#1:489,3\n253#1:493,3\n260#1:497,3\n267#1:501,3\n274#1:505,3\n375#1:508\n375#1:509,3\n400#1:512,2\n405#1:514\n405#1:515,2\n408#1:517,2\n412#1:519,2\n113#1:428,6\n115#1:434,6\n162#1:440\n169#1:444\n176#1:448\n183#1:452\n190#1:456\n197#1:460\n204#1:464\n211#1:468\n218#1:472\n225#1:476\n232#1:480\n239#1:484\n246#1:488\n253#1:492\n260#1:496\n267#1:500\n274#1:504\n*E\n"})
public final class ArrowWriterImpl
implements ArrowWriter {
    @NotNull
    private final DataFrame<?> dataFrame;
    @NotNull
    private final Schema targetSchema;
    @NotNull
    private final ArrowWriter.Mode mode;
    @NotNull
    private final Function1<ConvertingMismatch, Unit> mismatchSubscriber;
    @NotNull
    private final RootAllocator allocator;

    public ArrowWriterImpl(@NotNull DataFrame<?> dataFrame, @NotNull Schema targetSchema, @NotNull ArrowWriter.Mode mode, @NotNull Function1<? super ConvertingMismatch, Unit> mismatchSubscriber) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)targetSchema, (String)"targetSchema");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(mismatchSubscriber, (String)"mismatchSubscriber");
        this.dataFrame = dataFrame;
        this.targetSchema = targetSchema;
        this.mode = mode;
        this.mismatchSubscriber = mismatchSubscriber;
        this.allocator = new RootAllocator();
    }

    public /* synthetic */ ArrowWriterImpl(DataFrame dataFrame, Schema schema, ArrowWriter.Mode mode, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = ArrowWriterKt.getIgnoreMismatchMessage();
        }
        this(dataFrame, schema, mode, function1);
    }

    @Override
    @NotNull
    public DataFrame<?> getDataFrame() {
        return this.dataFrame;
    }

    @Override
    @NotNull
    public Schema getTargetSchema() {
        return this.targetSchema;
    }

    @Override
    @NotNull
    public ArrowWriter.Mode getMode() {
        return this.mode;
    }

    @Override
    @NotNull
    public Function1<ConvertingMismatch, Unit> getMismatchSubscriber() {
        return this.mismatchSubscriber;
    }

    private final void allocateVector(FieldVector vector, int size, Long totalBytes) {
        FieldVector fieldVector = vector;
        if (fieldVector instanceof FixedWidthVector) {
            ((FixedWidthVector)vector).allocateNew(size);
        } else if (fieldVector instanceof VariableWidthVector) {
            Long l = totalBytes;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                ((VariableWidthVector)vector).allocateNew(it, size);
            } else {
                ((VariableWidthVector)vector).allocateNew(size);
            }
        } else {
            throw new IllegalArgumentException("Can not allocate " + vector.getClass().getCanonicalName());
        }
    }

    static /* synthetic */ void allocateVector$default(ArrowWriterImpl arrowWriterImpl, FieldVector fieldVector, int n, Long l, int n2, Object object) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        arrowWriterImpl.allocateVector(fieldVector, n, l);
    }

    /*
     * WARNING - void declaration
     */
    private final Long countTotalBytes(DataColumn<?> column) {
        Long l;
        KType columnType = column.type();
        if (KTypes.isSubtypeOf((KType)columnType, (KType)Reflection.nullableTypeOf(String.class))) {
            void $this$fold$iv;
            Iterable iterable = DataColumnKt.getValues(column);
            Long initial$iv = 0L;
            boolean $i$f$fold = false;
            Long accumulator$iv = initial$iv;
            Iterator iterator = $this$fold$iv.iterator();
            while (iterator.hasNext()) {
                void value;
                Object element$iv;
                Object t = element$iv = iterator.next();
                long totalBytes = ((Number)accumulator$iv).longValue();
                boolean bl = false;
                accumulator$iv = totalBytes + (long)(String.valueOf(value).length() * 4);
            }
            l = accumulator$iv;
        } else {
            l = null;
        }
        return l;
    }

    private final void infillWithNulls(FieldVector vector, int size) {
        FieldVector fieldVector = vector;
        if (fieldVector instanceof BaseFixedWidthVector) {
            for (int i = 0; i < size; ++i) {
                ((BaseFixedWidthVector)vector).setNull(i);
            }
        } else if (fieldVector instanceof BaseVariableWidthVector) {
            for (int i = 0; i < size; ++i) {
                ((BaseVariableWidthVector)vector).setNull(i);
            }
        } else {
            throw new IllegalArgumentException("Can not infill " + vector.getClass().getCanonicalName());
        }
        ((ValueVector)vector).setValueCount(size);
    }

    /*
     * WARNING - void declaration
     */
    private final DataColumn<?> convertColumnToTarget(DataColumn<?> column, ArrowType targetFieldType) {
        DataColumn dataColumn;
        if (column == null) {
            return null;
        }
        ArrowType arrowType = targetFieldType;
        if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Utf8())) {
            DataColumn<?> $this$map_u24default$iv = column;
            Infer infer$iv = Infer.Nulls;
            boolean $i$f$map = false;
            int n = $this$map_u24default$iv.size();
            Object[] objectArray = new String[n];
            for (int i = 0; i < n; ++i) {
                void it;
                int n2 = i;
                Object object = $this$map_u24default$iv.get(n2);
                int n3 = n2;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                void v0 = it;
                String string = v0 != null ? v0.toString() : null;
                objectArray2[n3] = string;
            }
            List newValues$iv = ArraysKt.asList((Object[])objectArray);
            dataColumn = DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(String.class), infer$iv);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.LargeUtf8())) {
            DataColumn<?> $this$map_u24default$iv = column;
            Infer infer$iv = Infer.Nulls;
            boolean $i$f$map = false;
            int n = $this$map_u24default$iv.size();
            Object[] objectArray = new String[n];
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                Object it = $this$map_u24default$iv.get(n4);
                int n5 = n4;
                Object[] objectArray3 = objectArray;
                boolean bl = false;
                Object object = it;
                String string = object != null ? object.toString() : null;
                objectArray3[n5] = string;
            }
            List newValues$iv = ArraysKt.asList((Object[])objectArray);
            dataColumn = DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(String.class), infer$iv);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Bool())) {
            dataColumn = ConvertKt.convertToBoolean(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(8, true))) {
            dataColumn = ConvertKt.convertToByte(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(16, true))) {
            dataColumn = ConvertKt.convertToShort(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(32, true))) {
            dataColumn = ConvertKt.convertToInt(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Int(64, true))) {
            dataColumn = ConvertKt.convertToLong(column);
        } else if (arrowType instanceof ArrowType.Decimal) {
            dataColumn = ConvertKt.convertToBigDecimal(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE))) {
            dataColumn = ConvertKt.convertToFloat((DataColumn)ConvertKt.convertToDouble(column));
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE))) {
            dataColumn = ConvertKt.convertToDouble(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Date(DateUnit.DAY))) {
            dataColumn = ConvertKt.convertToLocalDate(column);
        } else if (Intrinsics.areEqual((Object)arrowType, (Object)new ArrowType.Date(DateUnit.MILLISECOND))) {
            dataColumn = ConvertKt.convertToLocalDateTime(column);
        } else if (arrowType instanceof ArrowType.Time) {
            dataColumn = ConvertKt.convertToLocalTime(column);
        } else {
            throw new NotImplementedError("Saving " + targetFieldType.getClass().getCanonicalName() + " is currently not implemented");
        }
        return dataColumn;
    }

    private final Pair<DataColumn<?>, Field> convertColumnToCompatible(DataColumn<?> column) {
        DataColumn<?> dataColumn;
        Field actualField = ArrowTypesMatchingKt.toArrowField(column, this.getMismatchSubscriber());
        try {
            ArrowType arrowType = actualField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)arrowType, (String)"getType(...)");
            DataColumn<?> dataColumn2 = this.convertColumnToTarget(column, arrowType);
            Intrinsics.checkNotNull(dataColumn2);
            dataColumn = dataColumn2;
        }
        catch (Exception e) {
            dataColumn = column;
        }
        DataColumn<?> result = dataColumn;
        return TuplesKt.to(result, (Object)actualField);
    }

    /*
     * WARNING - void declaration
     */
    private final void infillVector(FieldVector vector, DataColumn<?> column) {
        FieldVector fieldVector = vector;
        if (fieldVector instanceof VarCharVector) {
            void $this$forEachIndexed$iv;
            DataColumn dataColumn = ConvertKt.convertToString(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                void value;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv;
                int i = n;
                boolean bl = false;
                Unit unit = value;
                if (unit != null) {
                    void var15_191;
                    void it = var15_191 = unit;
                    boolean bl2 = false;
                    ((VarCharVector)vector).set(i, new Text((String)value));
                    unit = var15_191;
                    if (unit != null) continue;
                }
                ((VarCharVector)vector).setNull(i);
                unit = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof LargeVarCharVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToString(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed3 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String value = (String)item$iv$iv;
                int i = n;
                boolean bl = false;
                String string = value;
                if (string != null) {
                    String string2;
                    String it = string2 = string;
                    boolean bl3 = false;
                    ((LargeVarCharVector)vector).set(i, new Text(value));
                    string = string2;
                    if (string != null) continue;
                }
                ((LargeVarCharVector)vector).setNull(i);
                string = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof BitVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToBoolean(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed4 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Boolean value = (Boolean)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Boolean bl4;
                    boolean it = bl4;
                    boolean bl5 = false;
                    ((BitVector)vector).set(i, Boolean.compare(value, false));
                    bl4.booleanValue();
                    continue;
                }
                ((BitVector)vector).setNull(i);
            }
        } else if (fieldVector instanceof TinyIntVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToInt(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed5 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Integer value = (Integer)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Integer n2;
                    int it = ((Number)n2).intValue();
                    boolean bl6 = false;
                    ((TinyIntVector)vector).set(i, value.intValue());
                    ((Number)n2).intValue();
                    continue;
                }
                ((TinyIntVector)vector).setNull(i);
            }
        } else if (fieldVector instanceof SmallIntVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToInt(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed6 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Integer value = (Integer)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Integer n3;
                    int it = ((Number)n3).intValue();
                    boolean bl7 = false;
                    ((SmallIntVector)vector).set(i, value.intValue());
                    ((Number)n3).intValue();
                    continue;
                }
                ((SmallIntVector)vector).setNull(i);
            }
        } else if (fieldVector instanceof IntVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToInt(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed7 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Integer value = (Integer)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Integer n4;
                    int it = ((Number)n4).intValue();
                    boolean bl8 = false;
                    ((IntVector)vector).set(i, value.intValue());
                    ((Number)n4).intValue();
                    continue;
                }
                ((IntVector)vector).setNull(i);
            }
        } else if (fieldVector instanceof BigIntVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLong(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed8 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Long value = (Long)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Long l;
                    long it = ((Number)l).longValue();
                    boolean bl9 = false;
                    ((BigIntVector)vector).set(i, value.longValue());
                    ((Number)l).longValue();
                    continue;
                }
                ((BigIntVector)vector).setNull(i);
            }
        } else if (fieldVector instanceof DecimalVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToBigDecimal(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed9 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BigDecimal value = (BigDecimal)item$iv$iv;
                int i = n;
                boolean bl = false;
                BigDecimal bigDecimal = value;
                if (bigDecimal != null) {
                    BigDecimal bigDecimal2;
                    BigDecimal it = bigDecimal2 = bigDecimal;
                    boolean bl10 = false;
                    ((DecimalVector)vector).set(i, value);
                    bigDecimal = bigDecimal2;
                    if (bigDecimal != null) continue;
                }
                ((DecimalVector)vector).setNull(i);
                bigDecimal = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof Decimal256Vector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToBigDecimal(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed10 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BigDecimal value = (BigDecimal)item$iv$iv;
                int i = n;
                boolean bl = false;
                BigDecimal bigDecimal = value;
                if (bigDecimal != null) {
                    BigDecimal bigDecimal3;
                    BigDecimal it = bigDecimal3 = bigDecimal;
                    boolean bl11 = false;
                    ((Decimal256Vector)vector).set(i, value);
                    bigDecimal = bigDecimal3;
                    if (bigDecimal != null) continue;
                }
                ((Decimal256Vector)vector).setNull(i);
                bigDecimal = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof Float8Vector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToDouble(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed11 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Double value = (Double)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Double d;
                    double it = ((Number)d).doubleValue();
                    boolean bl12 = false;
                    ((Float8Vector)vector).set(i, value.doubleValue());
                    ((Number)d).doubleValue();
                    continue;
                }
                ((Float8Vector)vector).setNull(i);
            }
        } else if (fieldVector instanceof Float4Vector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToFloat(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed12 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Float value = (Float)item$iv$iv;
                int i = n;
                boolean bl = false;
                if (value != null) {
                    Float f;
                    float it = ((Number)f).floatValue();
                    boolean bl13 = false;
                    ((Float4Vector)vector).set(i, value.floatValue());
                    ((Number)f).floatValue();
                    continue;
                }
                ((Float4Vector)vector).setNull(i);
            }
        } else if (fieldVector instanceof DateDayVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLocalDate(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed13 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalDate value = (LocalDate)item$iv$iv;
                int i = n;
                boolean bl = false;
                LocalDate localDate = value;
                if (localDate != null) {
                    LocalDate localDate2;
                    LocalDate it = localDate2 = localDate;
                    boolean bl14 = false;
                    ((DateDayVector)vector).set(i, value.toEpochDays());
                    localDate = localDate2;
                    if (localDate != null) continue;
                }
                ((DateDayVector)vector).setNull(i);
                localDate = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof DateMilliVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLocalDateTime(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed14 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalDateTime value = (LocalDateTime)item$iv$iv;
                int i = n;
                boolean bl = false;
                LocalDateTime localDateTime = value;
                if (localDateTime != null) {
                    LocalDateTime localDateTime2;
                    LocalDateTime it = localDateTime2 = localDateTime;
                    boolean bl15 = false;
                    ((DateMilliVector)vector).set(i, TimeZoneKt.toInstant((LocalDateTime)value, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
                    localDateTime = localDateTime2;
                    if (localDateTime != null) continue;
                }
                ((DateMilliVector)vector).setNull(i);
                localDateTime = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof TimeNanoVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLocalTime(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed15 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalTime value = (LocalTime)item$iv$iv;
                int i = n;
                boolean bl = false;
                LocalTime localTime = value;
                if (localTime != null) {
                    LocalTime localTime2;
                    LocalTime it = localTime2 = localTime;
                    boolean bl16 = false;
                    ((TimeNanoVector)vector).set(i, value.toNanosecondOfDay());
                    localTime = localTime2;
                    if (localTime != null) continue;
                }
                ((TimeNanoVector)vector).setNull(i);
                localTime = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof TimeMicroVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLocalTime(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed16 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalTime value = (LocalTime)item$iv$iv;
                int i = n;
                boolean bl = false;
                LocalTime localTime = value;
                if (localTime != null) {
                    LocalTime localTime3;
                    LocalTime it = localTime3 = localTime;
                    boolean bl17 = false;
                    ((TimeMicroVector)vector).set(i, value.toNanosecondOfDay() / (long)1000);
                    localTime = localTime3;
                    if (localTime != null) continue;
                }
                ((TimeMicroVector)vector).setNull(i);
                localTime = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof TimeMilliVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLocalTime(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed17 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalTime value = (LocalTime)item$iv$iv;
                int i = n;
                boolean bl = false;
                LocalTime localTime = value;
                if (localTime != null) {
                    LocalTime localTime4;
                    LocalTime it = localTime4 = localTime;
                    boolean bl18 = false;
                    ((TimeMilliVector)vector).set(i, (int)(value.toNanosecondOfDay() / (long)1000 / (long)1000));
                    localTime = localTime4;
                    if (localTime != null) continue;
                }
                ((TimeMilliVector)vector).setNull(i);
                localTime = Unit.INSTANCE;
            }
        } else if (fieldVector instanceof TimeSecVector) {
            DataColumn $this$forEachIndexed$iv = ConvertKt.convertToLocalTime(column);
            boolean $i$f$forEachIndexed = false;
            Iterable $this$forEachIndexed$iv$iv = $this$forEachIndexed$iv.values();
            boolean $i$f$forEachIndexed18 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LocalTime value = (LocalTime)item$iv$iv;
                int i = n;
                boolean bl = false;
                LocalTime localTime = value;
                if (localTime != null) {
                    LocalTime localTime5;
                    LocalTime it = localTime5 = localTime;
                    boolean bl19 = false;
                    ((TimeSecVector)vector).set(i, (int)(value.toNanosecondOfDay() / (long)1000 / (long)1000 / (long)1000));
                    localTime = localTime5;
                    if (localTime != null) continue;
                }
                ((TimeSecVector)vector).setNull(i);
                localTime = Unit.INSTANCE;
            }
        } else {
            throw new NotImplementedError("Saving to " + vector.getClass().getCanonicalName() + " is currently not implemented");
        }
        ((ValueVector)vector).setValueCount(this.getDataFrame().rowsCount());
    }

    private final FieldVector allocateVectorAndInfill(Field field, DataColumn<?> column, boolean strictType, boolean strictNullable) {
        FieldVector fieldVector;
        Pair<DataColumn<?>, Field> pair;
        boolean containNulls = column == null || column.hasNulls();
        try {
            ArrowType arrowType = field.getType();
            Intrinsics.checkNotNullExpressionValue((Object)arrowType, (String)"getType(...)");
            pair = TuplesKt.to(this.convertColumnToTarget(column, arrowType), (Object)field);
        }
        catch (CellConversionException e) {
            if (strictType) {
                Object object = e.getColumn();
                if (object == null || (object = object.name()) == null) {
                    object = "";
                }
                ConvertingMismatch.TypeConversionFail.ConversionFailError mismatch = new ConvertingMismatch.TypeConversionFail.ConversionFailError((String)object, e.getRow(), e);
                this.getMismatchSubscriber().invoke((Object)mismatch);
                throw new ConvertingException(mismatch);
            }
            Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
            Object object = e.getColumn();
            if (object == null || (object = object.name()) == null) {
                object = "";
            }
            function1.invoke((Object)new ConvertingMismatch.TypeConversionFail.ConversionFailIgnored((String)object, e.getRow(), e));
            DataColumn<?> dataColumn = column;
            Intrinsics.checkNotNull(dataColumn);
            pair = this.convertColumnToCompatible(dataColumn);
        }
        catch (TypeConverterNotFoundException e) {
            if (strictType) {
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                ConvertingMismatch.TypeConversionNotFound.ConversionNotFoundError mismatch = new ConvertingMismatch.TypeConversionNotFound.ConversionNotFoundError(string, e);
                this.getMismatchSubscriber().invoke((Object)mismatch);
                throw new ConvertingException(mismatch);
            }
            Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
            String string = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            function1.invoke((Object)new ConvertingMismatch.TypeConversionNotFound.ConversionNotFoundIgnored(string, e));
            DataColumn<?> dataColumn = column;
            Intrinsics.checkNotNull(dataColumn);
            pair = this.convertColumnToCompatible(dataColumn);
        }
        Pair<DataColumn<?>, Field> pair2 = pair;
        DataColumn convertedColumn = (DataColumn)pair2.component1();
        Field actualField = (Field)pair2.component2();
        if (!actualField.isNullable() && containNulls) {
            int n;
            Integer firstNullValue = null;
            DataColumn<?> dataColumn = column;
            int n2 = n = dataColumn != null ? dataColumn.size() : -1;
            for (int i = 0; i < n; ++i) {
                DataColumn<?> dataColumn2 = column;
                Intrinsics.checkNotNull(dataColumn2);
                if (dataColumn2.get(i) != null) continue;
                firstNullValue = i;
                break;
            }
            if (strictNullable) {
                String string = actualField.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                ConvertingMismatch.NullableMismatch.NullValueError mismatch = new ConvertingMismatch.NullableMismatch.NullValueError(string, firstNullValue);
                this.getMismatchSubscriber().invoke((Object)mismatch);
                throw new ConvertingException(mismatch);
            }
            Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
            String string = actualField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            function1.invoke((Object)new ConvertingMismatch.NullableMismatch.NullValueIgnored(string, firstNullValue));
            FieldVector fieldVector2 = new Field(actualField.getName(), new FieldType(true, actualField.getFieldType().getType(), actualField.getFieldType().getDictionary()), actualField.getChildren()).createVector((BufferAllocator)this.allocator);
            fieldVector = fieldVector2;
            Intrinsics.checkNotNull((Object)fieldVector2);
        } else {
            FieldVector fieldVector3 = actualField.createVector((BufferAllocator)this.allocator);
            fieldVector = fieldVector3;
            Intrinsics.checkNotNull((Object)fieldVector3);
        }
        FieldVector vector = fieldVector;
        if (convertedColumn == null) {
            if (!actualField.isNullable()) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            ArrowWriterImpl.allocateVector$default(this, vector, this.getDataFrame().rowsCount(), null, 4, null);
            this.infillWithNulls(vector, this.getDataFrame().rowsCount());
        } else {
            this.allocateVector(vector, this.getDataFrame().rowsCount(), this.countTotalBytes(convertedColumn));
            this.infillVector(vector, convertedColumn);
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldVector> toVectors(List<? extends DataColumn<?>> $this$toVectors) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toVectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Field field = ArrowTypesMatchingKt.toArrowField(it, this.getMismatchSubscriber());
            collection.add(this.allocateVectorAndInfill(field, (DataColumn<?>)it, true, true));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VectorSchemaRoot allocateVectorSchemaRoot() {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        LinkedHashMap mainVectors = new LinkedHashMap();
        try {
            for (Field field : this.getTargetSchema().getFields()) {
                DataFrame<?> dataFrame = this.getDataFrame();
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                DataColumn column = dataFrame.getColumnOrNull(string);
                if (column == null && !field.isNullable()) {
                    if (this.getMode().getRestrictNarrowing()) {
                        String string2 = field.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        ConvertingMismatch.NarrowingMismatch.NotPresentedColumnError mismatch = new ConvertingMismatch.NarrowingMismatch.NotPresentedColumnError(string2);
                        this.getMismatchSubscriber().invoke((Object)mismatch);
                        throw new ConvertingException(mismatch);
                    }
                    Function1<ConvertingMismatch, Unit> function1 = this.getMismatchSubscriber();
                    String string3 = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    function1.invoke((Object)new ConvertingMismatch.NarrowingMismatch.NotPresentedColumnIgnored(string3));
                    continue;
                }
                Intrinsics.checkNotNull((Object)field);
                FieldVector vector = this.allocateVectorAndInfill(field, column, this.getMode().getStrictType(), this.getMode().getStrictNullable());
                ((Map)mainVectors).put(field.getName(), vector);
            }
        }
        catch (Exception e) {
            Collection collection = mainVectors.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                FieldVector it = (FieldVector)element$iv;
                boolean bl = false;
                it.close();
            }
            throw e;
        }
        ArrayList vectors = new ArrayList();
        vectors.addAll(mainVectors.values());
        Iterable $this$filter$iv = this.getDataFrame().columns();
        boolean $i$f$filter = false;
        Iterable element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataColumn column = (DataColumn)element$iv$iv;
            boolean bl = false;
            if (!(!mainVectors.containsKey(column.name()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List otherColumns = (List)destination$iv$iv;
        if (!this.getMode().getRestrictWidening()) {
            vectors.addAll((Collection)this.toVectors(otherColumns));
            $this$forEach$iv = otherColumns;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                DataColumn it = (DataColumn)element$iv2;
                boolean bl = false;
                this.getMismatchSubscriber().invoke((Object)new ConvertingMismatch.WideningMismatch.AddedColumn(DataColumnKt.getName((DataColumn)it)));
            }
        } else {
            $this$forEach$iv = otherColumns;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                DataColumn it = (DataColumn)element$iv2;
                boolean bl = false;
                this.getMismatchSubscriber().invoke((Object)new ConvertingMismatch.WideningMismatch.RejectedColumn(DataColumnKt.getName((DataColumn)it)));
            }
        }
        return new VectorSchemaRoot((Iterable)vectors);
    }

    @Override
    public void close() {
        this.allocator.close();
    }

    @Override
    public void writeArrowIPC(@NotNull WritableByteChannel channel) {
        ArrowWriter.DefaultImpls.writeArrowIPC((ArrowWriter)this, channel);
    }

    @Override
    public void writeArrowIPC(@NotNull OutputStream stream) {
        ArrowWriter.DefaultImpls.writeArrowIPC((ArrowWriter)this, stream);
    }

    @Override
    public void writeArrowIPC(@NotNull File file, boolean append) {
        ArrowWriter.DefaultImpls.writeArrowIPC(this, file, append);
    }

    @Override
    @NotNull
    public byte[] saveArrowIPCToByteArray() {
        return ArrowWriter.DefaultImpls.saveArrowIPCToByteArray(this);
    }

    @Override
    public void writeArrowFeather(@NotNull WritableByteChannel channel) {
        ArrowWriter.DefaultImpls.writeArrowFeather((ArrowWriter)this, channel);
    }

    @Override
    public void writeArrowFeather(@NotNull OutputStream stream) {
        ArrowWriter.DefaultImpls.writeArrowFeather((ArrowWriter)this, stream);
    }

    @Override
    public void writeArrowFeather(@NotNull File file) {
        ArrowWriter.DefaultImpls.writeArrowFeather((ArrowWriter)this, file);
    }

    @Override
    @NotNull
    public byte[] saveArrowFeatherToByteArray() {
        return ArrowWriter.DefaultImpls.saveArrowFeatherToByteArray(this);
    }
}

