/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.ForEachKt;
import org.jetbrains.kotlinx.dataframe.api.SelectKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnSet;
import org.jetbrains.kotlinx.dataframe.exceptions.DuplicateColumnNamesException;
import org.jetbrains.kotlinx.dataframe.io.CsvKt;
import org.jetbrains.kotlinx.dataframe.io.JsonKt;
import org.jetbrains.kotlinx.dataframe.io.NameRepairStrategy;
import org.jetbrains.kotlinx.dataframe.io.WorkBookType;
import org.jetbrains.kotlinx.dataframe.io.XlsxKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001aW\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0018\u001aW\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011*\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001b\u001aW\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001e\u001aW\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011*\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010 \u001aK\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011*\u00020\u00122\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010#\u001aW\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0010j\u0002`\u0011*\u00020\u00122\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010&\u001a\u0014\u0010'\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010(\u001a\u00020\rH\u0002\u001a\u0014\u0010)\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0014\u0010,\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010-\u001a\u00020.H\u0002\u001a\u008c\u0001\u0010/\u001a\u00020\u000b\"\u0004\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00\u00102\u0006\u0010\u0013\u001a\u00020\u00142L\b\u0002\u00101\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H003\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H003\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\b\u0012\u0006\u0012\u0002\b\u00030702j\f\u0012\u0004\u0012\u0002H0\u0012\u0002\b\u0003`8\u00a2\u0006\u0002\b92\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020=\u001a\u0090\u0001\u0010/\u001a\u00020\u000b\"\u0004\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00\u00102\u0006\u0010>\u001a\u00020?2L\b\u0002\u00101\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H003\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H003\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\b\u0012\u0006\u0012\u0002\b\u00030702j\f\u0012\u0004\u0012\u0002H0\u0012\u0002\b\u0003`8\u00a2\u0006\u0002\b92\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010:\u001a\u00020;2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020%0A\u001a\u008c\u0001\u0010/\u001a\u00020\u000b\"\u0004\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00\u00102\u0006\u0010B\u001a\u00020\u00012L\b\u0002\u00101\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H003\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H003\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\b\u0012\u0006\u0012\u0002\b\u00030702j\f\u0012\u0004\u0012\u0002H0\u0012\u0002\b\u0003`8\u00a2\u0006\u0002\b92\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020=\u001a\u0082\u0001\u0010/\u001a\u00020\"\"\u0004\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00\u00102\u0006\u0010$\u001a\u00020%2L\b\u0002\u00101\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H003\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H003\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\b\u0012\u0006\u0012\u0002\b\u00030702j\f\u0012\u0004\u0012\u0002H0\u0012\u0002\b\u0003`8\u00a2\u0006\u0002\b92\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010:\u001a\u00020;\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"readExcel", "", "readExcelTempFolderPrefix", "repairNameIfRequired", "nameFromCell", "columnNameCounters", "", "", "nameRepairStrategy", "Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;", "setWorkbookTempDirectory", "", "cellValue", "", "Lorg/apache/poi/ss/usermodel/Cell;", "sheetName", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "file", "Ljava/io/File;", "skipRows", "columns", "rowsCount", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/File;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "inputStream", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/InputStream;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "url", "Ljava/net/URL;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/net/URL;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "fileOrUrl", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Lorg/apache/poi/ss/usermodel/Sheet;Ljava/lang/String;ILjava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "wb", "Lorg/apache/poi/ss/usermodel/Workbook;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Lorg/apache/poi/ss/usermodel/Workbook;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "setCellValueByGuessedType", "any", "setDate", "date", "Ljava/util/Date;", "setTime", "localDateTime", "Ljava/time/LocalDateTime;", "writeExcel", "T", "columnsSelector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnSet;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "Lkotlin/ExtensionFunctionType;", "writeHeader", "", "workBookType", "Lorg/jetbrains/kotlinx/dataframe/io/WorkBookType;", "outputStream", "Ljava/io/OutputStream;", "factory", "Lkotlin/Function0;", "path", "dataframe-excel"})
@SourceDebugExtension(value={"SMAP\nxlsx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 xlsx.kt\norg/jetbrains/kotlinx/dataframe/io/XlsxKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1#2:504\n1360#3:505\n1446#3,2:506\n1549#3:508\n1620#3,3:509\n1448#3,3:512\n1549#3:515\n1620#3,2:516\n1549#3:518\n1620#3,3:519\n1622#3:522\n1864#3,3:523\n*S KotlinDebug\n*F\n+ 1 xlsx.kt\norg/jetbrains/kotlinx/dataframe/io/XlsxKt\n*L\n201#1:505\n201#1:506,2\n203#1:508\n203#1:509,3\n201#1:512,3\n226#1:515\n226#1:516,2\n239#1:518\n239#1:519,3\n226#1:522\n365#1:523,3\n*E\n"})
public final class XlsxKt {
    @NotNull
    private static final String readExcel = "readExcel";
    @NotNull
    private static final String readExcelTempFolderPrefix = "dataframe-excel";

    private static final void setWorkbookTempDirectory() {
        File file;
        try {
            File it = file = Files.createTempDirectory(readExcelTempFolderPrefix, new FileAttribute[0]).toFile();
            boolean bl = false;
            it.deleteOnExit();
        }
        catch (Exception e) {
            return;
        }
        File tempDir = file;
        TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(tempDir)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull URL url, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        XlsxKt.setWorkbookTempDirectory();
        Workbook wb = WorkbookFactory.create((InputStream)url.openStream());
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)wb);
            dataFrame = XlsxKt.readExcel($this$readExcel, wb, sheetName, skipRows, columns, rowsCount, nameRepairStrategy);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, URL uRL, String string, int n, String string2, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, uRL, string, n, string2, n2, nameRepairStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull File file, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        XlsxKt.setWorkbookTempDirectory();
        Workbook wb = WorkbookFactory.create((File)file);
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            dataFrame = XlsxKt.readExcel($this$readExcel, it, sheetName, skipRows, columns, rowsCount, nameRepairStrategy);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, File file, String string, int n, String string2, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, file, string, n, string2, n2, nameRepairStrategy);
    }

    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull String fileOrUrl, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        return XlsxKt.readExcel($this$readExcel, CsvKt.asURL((String)fileOrUrl), sheetName, skipRows, columns, rowsCount, nameRepairStrategy);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, String string, String string2, int n, String string3, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string3 = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, string, string2, n, string3, n2, nameRepairStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull InputStream inputStream, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        XlsxKt.setWorkbookTempDirectory();
        Workbook wb = WorkbookFactory.create((InputStream)inputStream);
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            dataFrame = XlsxKt.readExcel($this$readExcel, it, sheetName, skipRows, columns, rowsCount, nameRepairStrategy);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, InputStream inputStream, String string, int n, String string2, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, inputStream, string, n, string2, n2, nameRepairStrategy);
    }

    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull Workbook wb, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        Sheet sheet;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        if (sheetName != null) {
            Sheet sheet2;
            String it = sheetName;
            boolean bl = false;
            Sheet sheet3 = sheet2 = wb.getSheet(it);
            if (sheet3 == null) {
                throw new IllegalStateException(("Sheet with name " + sheetName + " not found").toString());
            }
            Intrinsics.checkNotNull((Object)sheet3);
            sheet = sheet2;
        } else {
            Sheet sheet4 = wb.getSheetAt(0);
            sheet = sheet4;
            Intrinsics.checkNotNullExpressionValue((Object)sheet4, (String)"getSheetAt(...)");
        }
        Sheet sheet5 = sheet;
        return XlsxKt.readExcel($this$readExcel, sheet5, columns, skipRows, rowsCount, nameRepairStrategy);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, Workbook workbook, String string, int n, String string2, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, workbook, string, n, string2, n2, nameRepairStrategy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull Sheet sheet, @Nullable String columns, int skipRows, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        void $this$mapTo$iv$iv;
        int n;
        Row headerRow;
        Iterable iterable;
        int $i$f$mapTo;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        if (columns != null) {
            void $this$flatMapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$flatMap$iv = StringsKt.split$default((CharSequence)columns, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Iterable iterable3;
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)":", (boolean)false, (int)2, null)) {
                    void $this$mapTo$iv$iv2;
                    String[] stringArray2 = new String[]{":"};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable4 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = 0;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it2;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(CellReference.convertColStringToIndex((String)it2));
                    }
                    List list = (List)destination$iv$iv2;
                    int start = ((Number)list.get(0)).intValue();
                    int end = ((Number)list.get(1)).intValue();
                    iterable3 = (Iterable)new IntRange(start, end);
                } else {
                    iterable3 = CollectionsKt.listOf((Object)CellReference.convertColStringToIndex((String)it));
                }
                Iterable list$iv$iv = iterable3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            Row row = sheet.getRow(skipRows);
            if (row == null) {
                boolean $i$a$-checkNotNull-XlsxKt$readExcel$columnIndexes$headerRow$22 = false;
                String $i$a$-checkNotNull-XlsxKt$readExcel$columnIndexes$headerRow$22 = "Row number " + (skipRows + 1) + " (1-based index) is not defined on the sheet " + sheet.getSheetName();
                throw new IllegalStateException($i$a$-checkNotNull-XlsxKt$readExcel$columnIndexes$headerRow$22.toString());
            }
            headerRow = row;
            short firstCellNum = headerRow.getFirstCellNum();
            if (!(firstCellNum != -1)) {
                boolean $i$a$-check-XlsxKt$readExcel$columnIndexes$32 = false;
                String $i$a$-check-XlsxKt$readExcel$columnIndexes$32 = "There are no defined cells on header row number " + (skipRows + 1) + " (1-based index). Pass `columns` argument to specify what columns to read or make sure the index is correct";
                throw new IllegalStateException($i$a$-check-XlsxKt$readExcel$columnIndexes$32.toString());
            }
            iterable = (Iterable)RangesKt.until((short)headerRow.getFirstCellNum(), (short)headerRow.getLastCellNum());
        }
        Iterable columnIndexes = iterable;
        headerRow = sheet.getRow(skipRows);
        int first = skipRows + 1;
        Integer n2 = rowsCount;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = first + it - 1;
        } else {
            n = sheet.getLastRowNum();
        }
        int last = n;
        IntRange valueRowsRange = new IntRange(first, last);
        Map columnNameCounters = new LinkedHashMap();
        Iterable $this$map$iv = columnIndexes;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            Object object;
            void index;
            Cell headerCell;
            $i$f$mapTo = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Row row = headerRow;
            Cell cell = headerCell = row != null ? row.getCell((int)index) : null;
            if ((cell != null ? cell.getCellType() : null) == CellType.NUMERIC) {
                object = String.valueOf(headerCell.getNumericCellValue());
            } else {
                object = headerCell;
                if (object == null || (object = object.getStringCellValue()) == null) {
                    object = CellReference.convertNumToColString((int)index);
                }
            }
            Object nameFromCell = object;
            Intrinsics.checkNotNull((Object)nameFromCell);
            String name = XlsxKt.repairNameIfRequired((String)nameFromCell, columnNameCounters, nameRepairStrategy);
            columnNameCounters.put(nameFromCell, ((Number)columnNameCounters.getOrDefault(nameFromCell, 0)).intValue() + 1);
            Iterable $this$map$iv2 = (Iterable)valueRowsRange;
            boolean $i$f$map2 = false;
            Iterable iterable5 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            Iterator iterator = $this$mapTo$iv$iv3.iterator();
            while (iterator.hasNext()) {
                void it;
                Row row2;
                int item$iv$iv2;
                int n3 = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                Collection collection2 = destination$iv$iv3;
                boolean bl4 = false;
                Row row3 = row2 = sheet.getRow((int)it);
                Cell cell2 = row3 != null ? row3.getCell((int)index) : null;
                String string = sheet.getSheetName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSheetName(...)");
                collection2.add(XlsxKt.cellValue(cell2, string));
            }
            List values = (List)destination$iv$iv3;
            collection.add(DataColumn.Companion.createWithTypeInference$default((DataColumn.Companion)DataColumn.Companion, (String)name, (List)values, null, (int)4, null));
        }
        List columns2 = (List)destination$iv$iv;
        return ConstructorsKt.dataFrameOf((Iterable)columns2);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, Sheet sheet, String string, int n, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, sheet, string, n, n2, nameRepairStrategy);
    }

    /*
     * WARNING - void declaration
     */
    private static final String repairNameIfRequired(String nameFromCell, Map<String, Integer> columnNameCounters, NameRepairStrategy nameRepairStrategy) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[nameRepairStrategy.ordinal()]) {
            case 1: {
                string = nameFromCell;
                break;
            }
            case 2: {
                if (columnNameCounters.containsKey(nameFromCell)) {
                    throw new DuplicateColumnNamesException(CollectionsKt.toList((Iterable)columnNameCounters.keySet()));
                }
                string = nameFromCell;
                break;
            }
            case 3: {
                if (((CharSequence)nameFromCell).length() == 0) {
                    void var3_3;
                    String emptyName = "Unknown column";
                    if (columnNameCounters.containsKey(emptyName)) {
                        string = emptyName + columnNameCounters.get(emptyName);
                        break;
                    }
                    string = var3_3;
                    break;
                }
                if (columnNameCounters.containsKey(nameFromCell)) {
                    string = nameFromCell + columnNameCounters.get(nameFromCell);
                    break;
                }
                string = nameFromCell;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final Object cellValue(Cell $this$cellValue, String sheetName) {
        Comparable comparable;
        Cell cell = $this$cellValue;
        Object object = cell != null ? cell.getCellType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$1[object.ordinal()]) {
            case 1: {
                throw new IllegalStateException(("Cell " + $this$cellValue.getAddress() + " of sheet " + sheetName + " has a CellType that should only be used internally. This is a bug, please report https://github.com/Kotlin/dataframe/issues").toString());
            }
            case 2: {
                double number = $this$cellValue.getNumericCellValue();
                if (DateUtil.isCellDateFormatted((Cell)$this$cellValue)) {
                    LocalDateTime localDateTime = DateUtil.getLocalDateTime((double)number);
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getLocalDateTime(...)");
                    comparable = (Comparable)ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
                    break;
                }
                comparable = Double.valueOf(number);
                break;
            }
            case 3: {
                comparable = (Comparable)((Object)$this$cellValue.getStringCellValue());
                break;
            }
            case 4: {
                comparable = Double.valueOf($this$cellValue.getNumericCellValue());
                break;
            }
            case 5: {
                comparable = (Comparable)((Object)$this$cellValue.getStringCellValue());
                break;
            }
            case 6: {
                comparable = Boolean.valueOf($this$cellValue.getBooleanCellValue());
                break;
            }
            case 7: {
                comparable = Byte.valueOf($this$cellValue.getErrorCellValue());
                break;
            }
            case -1: {
                comparable = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return comparable;
    }

    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull String path, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull WorkBookType workBookType) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter((Object)((Object)workBookType), (String)"workBookType");
        XlsxKt.writeExcel($this$writeExcel, new File(path), columnsSelector, sheetName, writeHeader, workBookType);
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, String string, Function2 function2, String string2, boolean bl, WorkBookType workBookType, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            workBookType = WorkBookType.XLSX;
        }
        XlsxKt.writeExcel(dataFrame, string, function2, string2, bl, workBookType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull File file, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull WorkBookType workBookType) {
        Function0 function0;
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter((Object)((Object)workBookType), (String)"workBookType");
        switch (WhenMappings.$EnumSwitchMapping$2[workBookType.ordinal()]) {
            case 1: {
                function0 = writeExcel.factory.1.INSTANCE;
                break;
            }
            case 2: {
                function0 = writeExcel.factory.2.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Function0 factory2 = function0;
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            XlsxKt.writeExcel($this$writeExcel, it, columnsSelector, sheetName, writeHeader, (Function0<? extends Workbook>)factory2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, File file, Function2 function2, String string, boolean bl, WorkBookType workBookType, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.2.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            workBookType = WorkBookType.XLSX;
        }
        XlsxKt.writeExcel(dataFrame, file, function2, string, bl, workBookType);
    }

    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull OutputStream outputStream, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull Function0<? extends Workbook> factory2) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        Workbook wb = (Workbook)factory2.invoke();
        XlsxKt.writeExcel($this$writeExcel, wb, columnsSelector, sheetName, writeHeader);
        wb.write(outputStream);
        wb.close();
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, OutputStream outputStream, Function2 function2, String string, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.4.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        XlsxKt.writeExcel(dataFrame, outputStream, function2, string, bl, (Function0<? extends Workbook>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Sheet writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull Workbook wb, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Sheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
        Ref.IntRef i = new Ref.IntRef();
        DataFrame columns = SelectKt.select($this$writeExcel, columnsSelector);
        if (writeHeader) {
            Row row = sheet.createRow(i.element);
            Iterable $this$forEachIndexed$iv22 = columns.columnNames();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv22) {
                void s;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                Cell cell = row.createCell(index);
                cell.setCellValue((String)s);
            }
            int $this$forEachIndexed$iv22 = i.element;
            i.element = $this$forEachIndexed$iv22 + 1;
        }
        CreationHelper createHelper = wb.getCreationHelper();
        CellStyle cellStyleDate = wb.createCellStyle();
        CellStyle cellStyleDateTime = wb.createCellStyle();
        CellStyle cellStyleTime = wb.createCellStyle();
        cellStyleDate.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy"));
        cellStyleDateTime.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy hh:mm:ss"));
        cellStyleTime.setDataFormat(createHelper.createDataFormat().getFormat("hh:mm:ss"));
        ForEachKt.forEach((DataFrame)columns, (Function2)new Function2<DataRow<? extends T>, DataRow<? extends T>, Unit>(sheet, i, cellStyleDate, cellStyleDateTime, cellStyleTime){
            final /* synthetic */ Sheet $sheet;
            final /* synthetic */ Ref.IntRef $i;
            final /* synthetic */ CellStyle $cellStyleDate;
            final /* synthetic */ CellStyle $cellStyleDateTime;
            final /* synthetic */ CellStyle $cellStyleTime;
            {
                this.$sheet = $sheet;
                this.$i = $i;
                this.$cellStyleDate = $cellStyleDate;
                this.$cellStyleDateTime = $cellStyleDateTime;
                this.$cellStyleTime = $cellStyleTime;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DataRow<? extends T> $this$forEach, @NotNull DataRow<? extends T> it) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter($this$forEach, (String)"$this$forEach");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Row row = this.$sheet.createRow(this.$i.element);
                Iterable iterable = it.values();
                CellStyle cellStyle = this.$cellStyleDate;
                CellStyle cellStyle2 = this.$cellStyleDateTime;
                CellStyle cellStyle3 = this.$cellStyleTime;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void any;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T t = item$iv;
                    int index = n;
                    boolean bl = false;
                    if (any == null) continue;
                    Cell cell = row.createCell(index);
                    Intrinsics.checkNotNull((Object)cell);
                    XlsxKt.access$setCellValueByGuessedType(cell, any);
                    void var17_18 = any;
                    if (var17_18 instanceof LocalDate ? true : var17_18 instanceof kotlinx.datetime.LocalDate) {
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (var17_18 instanceof Calendar ? true : var17_18 instanceof Date) {
                        cell.setCellStyle(cellStyle2);
                        continue;
                    }
                    if (var17_18 instanceof LocalDateTime) {
                        if (((LocalDateTime)any).getYear() < 1900) {
                            cell.setCellStyle(cellStyle3);
                            continue;
                        }
                        cell.setCellStyle(cellStyle2);
                        continue;
                    }
                    if (!(var17_18 instanceof kotlinx.datetime.LocalDateTime)) continue;
                    if (((kotlinx.datetime.LocalDateTime)any).getYear() < 1900) {
                        cell.setCellStyle(cellStyle3);
                        continue;
                    }
                    cell.setCellStyle(cellStyle2);
                }
                int n = this.$i.element;
                this.$i.element = n + 1;
            }
        });
        Intrinsics.checkNotNull((Object)sheet);
        return sheet;
    }

    public static /* synthetic */ Sheet writeExcel$default(DataFrame dataFrame, Workbook workbook, Function2 function2, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.5.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return XlsxKt.writeExcel(dataFrame, workbook, function2, string, bl);
    }

    private static final void setCellValueByGuessedType(Cell $this$setCellValueByGuessedType, Object any) {
        Object object = any;
        if (object instanceof DataRow) {
            $this$setCellValueByGuessedType.setCellValue(JsonKt.toJson$default((DataRow)((DataRow)any), (boolean)false, (boolean)false, (int)3, null));
        } else if (object instanceof DataFrame) {
            $this$setCellValueByGuessedType.setCellValue(JsonKt.toJson$default((DataFrame)((DataFrame)any), (boolean)false, (boolean)false, (int)3, null));
        } else if (object instanceof Number) {
            $this$setCellValueByGuessedType.setCellValue(((Number)any).doubleValue());
        } else if (object instanceof LocalDate) {
            $this$setCellValueByGuessedType.setCellValue((LocalDate)any);
        } else if (object instanceof LocalDateTime) {
            XlsxKt.setTime($this$setCellValueByGuessedType, (LocalDateTime)any);
        } else if (object instanceof Boolean) {
            $this$setCellValueByGuessedType.setCellValue(((Boolean)any).booleanValue());
        } else if (object instanceof Calendar) {
            Date date = ((Calendar)any).getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
            XlsxKt.setDate($this$setCellValueByGuessedType, date);
        } else if (object instanceof Date) {
            XlsxKt.setDate($this$setCellValueByGuessedType, (Date)any);
        } else if (object instanceof RichTextString) {
            $this$setCellValueByGuessedType.setCellValue((RichTextString)any);
        } else if (object instanceof String) {
            $this$setCellValueByGuessedType.setCellValue((String)any);
        } else if (object instanceof kotlinx.datetime.LocalDate) {
            $this$setCellValueByGuessedType.setCellValue(ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)((kotlinx.datetime.LocalDate)any)));
        } else if (object instanceof kotlinx.datetime.LocalDateTime) {
            XlsxKt.setTime($this$setCellValueByGuessedType, ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)any)));
        } else {
            $this$setCellValueByGuessedType.setCellValue(any.toString());
        }
    }

    private static final void setTime(Cell $this$setTime, LocalDateTime localDateTime) {
        $this$setTime.setCellValue(DateUtil.getExcelDate((LocalDateTime)localDateTime.plusDays(1L)) - 1.0);
    }

    private static final void setDate(Cell $this$setDate, Date date) {
        Calendar calStart = LocaleUtil.getLocaleCalendar();
        calStart.setTime(date);
        LocalDateTime localDateTime = calStart.toInstant().atZone(LocaleUtil.getUserTimeZone().toZoneId()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        XlsxKt.setTime($this$setDate, localDateTime);
    }

    public static final /* synthetic */ void access$setCellValueByGuessedType(Cell $receiver, Object any) {
        XlsxKt.setCellValueByGuessedType($receiver, any);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NameRepairStrategy.values().length];
            try {
                nArray[NameRepairStrategy.DO_NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NameRepairStrategy.CHECK_UNIQUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NameRepairStrategy.MAKE_UNIQUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CellType.values().length];
            try {
                nArray[CellType._NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.NUMERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.FORMULA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.BLANK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.BOOLEAN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WorkBookType.values().length];
            try {
                nArray[WorkBookType.XLS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkBookType.XLSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

