/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.annotations.Interpretable;
import org.jetbrains.kotlinx.dataframe.annotations.Refine;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.SelectKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.exceptions.DuplicateColumnNamesException;
import org.jetbrains.kotlinx.dataframe.impl.columns.TransformableColumnSet;
import org.jetbrains.kotlinx.dataframe.io.CsvKt;
import org.jetbrains.kotlinx.dataframe.io.FormattingOptions;
import org.jetbrains.kotlinx.dataframe.io.JsonKt;
import org.jetbrains.kotlinx.dataframe.io.NameRepairStrategy;
import org.jetbrains.kotlinx.dataframe.io.WorkBookType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001ae\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001ae\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007*\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0018\u001ag\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007*\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u001a\u001ae\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007*\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u001d\u001ac\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007*\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\"\u001a\u001b\u0010#\u001a\u00020!*\u00020\u00102\b\b\u0002\u0010$\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'\u001aW\u0010\u0005\u001a\n\u0012\u0002\b\u00030\u0006j\u0002`\u0007*\u00020\b2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010*\u001a\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0,2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a,\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u00012\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r002\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u00101\u001a\u0004\u0018\u000102*\u0004\u0018\u0001032\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0096\u0001\u00104\u001a\u00020\u0004\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H50\u00062\u0006\u00106\u001a\u00020\u00012L\b\u0002\u00107\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H509\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H509\u00a2\u0006\f\b:\u0012\b\b;\u0012\u0004\b\b(<\u0012\b\u0012\u0006\u0012\u0002\b\u00030=08j\f\u0012\u0004\u0012\u0002H5\u0012\u0002\b\u0003`?\u00a2\u0006\u0002\b>2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010@\u001a\u00020A2\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020A\u001a\u0096\u0001\u00104\u001a\u00020\u0004\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H50\u00062\u0006\u0010\u0016\u001a\u00020\u00172L\b\u0002\u00107\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H509\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H509\u00a2\u0006\f\b:\u0012\b\b;\u0012\u0004\b\b(<\u0012\b\u0012\u0006\u0012\u0002\b\u00030=08j\f\u0012\u0004\u0012\u0002H5\u0012\u0002\b\u0003`?\u00a2\u0006\u0002\b>2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010@\u001a\u00020A2\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020A\u001a\u008a\u0001\u00104\u001a\u00020\u0004\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H50\u00062\u0006\u0010E\u001a\u00020F2L\b\u0002\u00107\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H509\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H509\u00a2\u0006\f\b:\u0012\b\b;\u0012\u0004\b\b(<\u0012\b\u0012\u0006\u0012\u0002\b\u00030=08j\f\u0012\u0004\u0012\u0002H5\u0012\u0002\b\u0003`?\u00a2\u0006\u0002\b>2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010@\u001a\u00020A2\u0006\u0010G\u001a\u00020\u001f\u001a\u0082\u0001\u00104\u001a\u00020)\"\u0004\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H50\u00062\u0006\u0010\u001e\u001a\u00020\u001f2L\b\u0002\u00107\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H509\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H509\u00a2\u0006\f\b:\u0012\b\b;\u0012\u0004\b\b(<\u0012\b\u0012\u0006\u0012\u0002\b\u00030=08j\f\u0012\u0004\u0012\u0002H5\u0012\u0002\b\u0003`?\u00a2\u0006\u0002\b>2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010@\u001a\u00020A\u001a\u0014\u0010H\u001a\u00020\u0004*\u0002032\u0006\u0010I\u001a\u000202H\u0002\u001a\u0014\u0010J\u001a\u00020\u0004*\u0002032\u0006\u0010K\u001a\u00020LH\u0002\u001a\u0014\u0010M\u001a\u00020\u0004*\u0002032\u0006\u0010N\u001a\u00020OH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"READ_EXCEL", "", "READ_EXCEL_TEMP_FOLDER_PREFIX", "setWorkbookTempDirectory", "", "readExcel", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "url", "Ljava/net/URL;", "sheetName", "skipRows", "", "columns", "stringColumns", "Lorg/jetbrains/kotlinx/dataframe/io/StringColumns;", "rowsCount", "nameRepairStrategy", "Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;", "readExcel-CWg63oo", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/net/URL;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "file", "Ljava/io/File;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/File;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "fileOrUrl", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "inputStream", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/InputStream;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "wb", "Lorg/apache/poi/ss/usermodel/Workbook;", "formattingOptions", "Lorg/jetbrains/kotlinx/dataframe/io/FormattingOptions;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Lorg/apache/poi/ss/usermodel/Workbook;Ljava/lang/String;ILjava/lang/String;Lorg/jetbrains/kotlinx/dataframe/io/FormattingOptions;Ljava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "toFormattingOptions", "formatter", "Lorg/apache/poi/ss/usermodel/DataFormatter;", "toFormattingOptions-lk1XfQA", "(Ljava/lang/String;Lorg/apache/poi/ss/usermodel/DataFormatter;)Lorg/jetbrains/kotlinx/dataframe/io/FormattingOptions;", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Lorg/apache/poi/ss/usermodel/Sheet;Ljava/lang/String;Lorg/jetbrains/kotlinx/dataframe/io/FormattingOptions;ILjava/lang/Integer;Lorg/jetbrains/kotlinx/dataframe/io/NameRepairStrategy;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getColumnIndices", "", "repairNameIfRequired", "nameFromCell", "columnNameCounters", "", "cellValue", "", "Lorg/apache/poi/ss/usermodel/Cell;", "writeExcel", "T", "path", "columnsSelector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "writeHeader", "", "workBookType", "Lorg/jetbrains/kotlinx/dataframe/io/WorkBookType;", "keepFile", "outputStream", "Ljava/io/OutputStream;", "factory", "setCellValueByGuessedType", "any", "setTime", "localDateTime", "Ljava/time/LocalDateTime;", "setDate", "date", "Ljava/util/Date;", "dataframe-excel"})
@SourceDebugExtension(value={"SMAP\nxlsx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 xlsx.kt\norg/jetbrains/kotlinx/dataframe/io/XlsxKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 forEach.kt\norg/jetbrains/kotlinx/dataframe/api/ForEachKt\n*L\n1#1,565:1\n1#2:566\n1557#3:567\n1628#3,2:568\n1557#3:570\n1628#3,3:571\n1630#3:574\n1368#3:575\n1454#3,2:576\n1557#3:578\n1628#3,3:579\n1456#3,3:582\n1872#3,3:585\n1863#3:589\n1872#3,3:590\n1864#3:593\n18#4:588\n*S KotlinDebug\n*F\n+ 1 xlsx.kt\norg/jetbrains/kotlinx/dataframe/io/XlsxKt\n*L\n271#1:567\n271#1:568,2\n290#1:570\n290#1:571,3\n271#1:574\n301#1:575\n301#1:576,2\n303#1:578\n303#1:579,3\n301#1:582,3\n453#1:585,3\n468#1:589\n470#1:590,3\n468#1:593\n468#1:588\n*E\n"})
public final class XlsxKt {
    @NotNull
    private static final String READ_EXCEL = "readExcel";
    @NotNull
    private static final String READ_EXCEL_TEMP_FOLDER_PREFIX = "dataframe-excel";

    private static final void setWorkbookTempDirectory() {
        File file;
        try {
            File it = file = Files.createTempDirectory(READ_EXCEL_TEMP_FOLDER_PREFIX, new FileAttribute[0]).toFile();
            boolean bl = false;
            it.deleteOnExit();
        }
        catch (Exception e) {
            return;
        }
        File tempDir = file;
        TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(tempDir)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel-CWg63oo(@NotNull DataFrame.Companion $this$readExcel_u2dCWg63oo, @NotNull URL url, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable String stringColumns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel_u2dCWg63oo, (String)"$this$readExcel");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        XlsxKt.setWorkbookTempDirectory();
        Workbook wb = WorkbookFactory.create((InputStream)url.openStream());
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)wb);
            String string = stringColumns;
            dataFrame = XlsxKt.readExcel($this$readExcel_u2dCWg63oo, wb, sheetName, skipRows, columns, string != null ? XlsxKt.toFormattingOptions-lk1XfQA$default(string, null, 1, null) : null, rowsCount, nameRepairStrategy);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel-CWg63oo$default(DataFrame.Companion companion, URL uRL, String string, int n, String string2, String string3, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            string3 = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel-CWg63oo(companion, uRL, string, n, string2, string3, n2, nameRepairStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel-CWg63oo(@NotNull DataFrame.Companion $this$readExcel_u2dCWg63oo, @NotNull File file, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable String stringColumns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel_u2dCWg63oo, (String)"$this$readExcel");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        XlsxKt.setWorkbookTempDirectory();
        Workbook wb = WorkbookFactory.create((File)file);
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string = stringColumns;
            dataFrame = XlsxKt.readExcel($this$readExcel_u2dCWg63oo, it, sheetName, skipRows, columns, string != null ? XlsxKt.toFormattingOptions-lk1XfQA$default(string, null, 1, null) : null, rowsCount, nameRepairStrategy);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel-CWg63oo$default(DataFrame.Companion companion, File file, String string, int n, String string2, String string3, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            string3 = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel-CWg63oo(companion, file, string, n, string2, string3, n2, nameRepairStrategy);
    }

    @Refine
    @Interpretable(interpreter="ReadExcel")
    @NotNull
    public static final DataFrame<?> readExcel-CWg63oo(@NotNull DataFrame.Companion $this$readExcel_u2dCWg63oo, @NotNull String fileOrUrl, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable String stringColumns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        Intrinsics.checkNotNullParameter((Object)$this$readExcel_u2dCWg63oo, (String)"$this$readExcel");
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        return XlsxKt.readExcel-CWg63oo($this$readExcel_u2dCWg63oo, CsvKt.asURL((String)fileOrUrl), sheetName, skipRows, columns, stringColumns, rowsCount, nameRepairStrategy);
    }

    public static /* synthetic */ DataFrame readExcel-CWg63oo$default(DataFrame.Companion companion, String string, String string2, int n, String string3, String string4, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string3 = null;
        }
        if ((n3 & 0x10) != 0) {
            string4 = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel-CWg63oo(companion, string, string2, n, string3, string4, n2, nameRepairStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel-CWg63oo(@NotNull DataFrame.Companion $this$readExcel_u2dCWg63oo, @NotNull InputStream inputStream, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable String stringColumns, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel_u2dCWg63oo, (String)"$this$readExcel");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        XlsxKt.setWorkbookTempDirectory();
        Workbook wb = WorkbookFactory.create((InputStream)inputStream);
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string = stringColumns;
            dataFrame = XlsxKt.readExcel($this$readExcel_u2dCWg63oo, it, sheetName, skipRows, columns, string != null ? XlsxKt.toFormattingOptions-lk1XfQA$default(string, null, 1, null) : null, rowsCount, nameRepairStrategy);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel-CWg63oo$default(DataFrame.Companion companion, InputStream inputStream, String string, int n, String string2, String string3, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            string3 = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel-CWg63oo(companion, inputStream, string, n, string2, string3, n2, nameRepairStrategy);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull Workbook wb, @Nullable String sheetName, int skipRows, @Nullable String columns, @Nullable FormattingOptions formattingOptions, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        if (sheetName == null) ** GOTO lbl-1000
        it = sheetName;
        $i$a$-let-XlsxKt$readExcel$sheet$1 = false;
        v0 = wb.getSheet(it);
        if (v0 == null) {
            throw new IllegalStateException(("Sheet with name " + sheetName + " not found").toString());
        }
        var9_10 = v0;
        if (var9_10 != null) {
            v1 = var9_10;
        } else lbl-1000:
        // 2 sources

        {
            v2 = wb.getSheetAt(0);
            v1 = v2;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getSheetAt(...)");
        }
        sheet = v1;
        return XlsxKt.readExcel($this$readExcel, sheet, columns, formattingOptions, skipRows, rowsCount, nameRepairStrategy);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, Workbook workbook, String string, int n, String string2, FormattingOptions formattingOptions, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            formattingOptions = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, workbook, string, n, string2, formattingOptions, n2, nameRepairStrategy);
    }

    @NotNull
    public static final FormattingOptions toFormattingOptions-lk1XfQA(@NotNull String $this$toFormattingOptions_u2dlk1XfQA, @NotNull DataFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)$this$toFormattingOptions_u2dlk1XfQA, (String)"$this$toFormattingOptions");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        return new FormattingOptions($this$toFormattingOptions_u2dlk1XfQA, formatter);
    }

    public static /* synthetic */ FormattingOptions toFormattingOptions-lk1XfQA$default(String string, DataFormatter dataFormatter, int n, Object object) {
        if ((n & 1) != 0) {
            dataFormatter = new DataFormatter();
        }
        return XlsxKt.toFormattingOptions-lk1XfQA(string, dataFormatter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull Sheet sheet, @Nullable String columns, @Nullable FormattingOptions formattingOptions, int skipRows, @Nullable Integer rowsCount, @NotNull NameRepairStrategy nameRepairStrategy) {
        void $this$mapTo$iv$iv;
        int n;
        Row headerRow;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        Intrinsics.checkNotNullParameter((Object)nameRepairStrategy, (String)"nameRepairStrategy");
        if (columns != null) {
            iterable = XlsxKt.getColumnIndices(columns);
        } else {
            Row row = sheet.getRow(skipRows);
            if (row == null) {
                boolean $i$a$-checkNotNull-XlsxKt$readExcel$columnIndexes$headerRow$22 = false;
                String $i$a$-checkNotNull-XlsxKt$readExcel$columnIndexes$headerRow$22 = "Row number " + (skipRows + 1) + " (1-based index) is not defined on the sheet " + sheet.getSheetName();
                throw new IllegalStateException($i$a$-checkNotNull-XlsxKt$readExcel$columnIndexes$headerRow$22.toString());
            }
            headerRow = row;
            short firstCellNum = headerRow.getFirstCellNum();
            if (!(firstCellNum != -1)) {
                boolean $i$a$-check-XlsxKt$readExcel$columnIndexes$22 = false;
                String $i$a$-check-XlsxKt$readExcel$columnIndexes$22 = "There are no defined cells on header row number " + (skipRows + 1) + " (1-based index). Pass `columns` argument to specify what columns to read or make sure the index is correct";
                throw new IllegalStateException($i$a$-check-XlsxKt$readExcel$columnIndexes$22.toString());
            }
            iterable = (Iterable)RangesKt.until((short)headerRow.getFirstCellNum(), (short)headerRow.getLastCellNum());
        }
        Iterable columnIndexes = iterable;
        headerRow = sheet.getRow(skipRows);
        int first = skipRows + 1;
        Integer n2 = rowsCount;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = first + it - 1;
        } else {
            n = sheet.getLastRowNum();
        }
        int last = n;
        IntRange valueRowsRange = new IntRange(first, last);
        Map columnNameCounters = new LinkedHashMap();
        Iterable $this$map$iv = columnIndexes;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            Object object;
            void index;
            Cell headerCell;
            int n3 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Row row = headerRow;
            Cell cell = headerCell = row != null ? row.getCell((int)index) : null;
            if ((cell != null ? cell.getCellType() : null) == CellType.NUMERIC) {
                object = String.valueOf(headerCell.getNumericCellValue());
            } else {
                object = headerCell;
                if (object == null || (object = object.getStringCellValue()) == null) {
                    object = CellReference.convertNumToColString((int)index);
                }
            }
            Object nameFromCell = object;
            Intrinsics.checkNotNull((Object)nameFromCell);
            String name = XlsxKt.repairNameIfRequired((String)nameFromCell, columnNameCounters, nameRepairStrategy);
            columnNameCounters.put(nameFromCell, ((Number)columnNameCounters.getOrDefault(nameFromCell, 0)).intValue() + 1);
            Function1 getCellValue = formattingOptions != null && formattingOptions.getColumnIndices().contains((int)index) ? arg_0 -> XlsxKt.readExcel$lambda$11$lambda$8(formattingOptions, arg_0) : arg_0 -> XlsxKt.readExcel$lambda$11$lambda$9(sheet, arg_0);
            Iterable $this$map$iv2 = (Iterable)valueRowsRange;
            boolean $i$f$map2 = false;
            Iterable iterable3 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it;
                Row row2;
                int item$iv$iv2;
                int n4 = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Row row3 = row2 = sheet.getRow((int)it);
                Cell cell2 = row3 != null ? row3.getCell((int)index) : null;
                collection2.add(getCellValue.invoke((Object)cell2));
            }
            List values = (List)destination$iv$iv2;
            collection.add(DataColumn.Companion.createWithTypeInference$default((DataColumn.Companion)DataColumn.Companion, (String)name, (List)values, null, (int)4, null));
        }
        List columns2 = (List)destination$iv$iv;
        return ConstructorsKt.dataFrameOf((Iterable)columns2);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, Sheet sheet, String string, FormattingOptions formattingOptions, int n, Integer n2, NameRepairStrategy nameRepairStrategy, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string = null;
        }
        if ((n3 & 4) != 0) {
            formattingOptions = null;
        }
        if ((n3 & 8) != 0) {
            n = 0;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            nameRepairStrategy = NameRepairStrategy.CHECK_UNIQUE;
        }
        return XlsxKt.readExcel(companion, sheet, string, formattingOptions, n, n2, nameRepairStrategy);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Integer> getColumnIndices(String columns) {
        void $this$flatMapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$flatMap$iv = StringsKt.split$default((CharSequence)columns, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)":", (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                String[] stringArray2 = new String[]{":"};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(CellReference.convertColStringToIndex((String)it2));
                }
                List list = (List)destination$iv$iv2;
                int start = ((Number)list.get(0)).intValue();
                int end = ((Number)list.get(1)).intValue();
                iterable2 = (Iterable)new IntRange(start, end);
            } else {
                iterable2 = CollectionsKt.listOf((Object)CellReference.convertColStringToIndex((String)it));
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final String repairNameIfRequired(String nameFromCell, Map<String, Integer> columnNameCounters, NameRepairStrategy nameRepairStrategy) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[nameRepairStrategy.ordinal()]) {
            case 1: {
                string = nameFromCell;
                break;
            }
            case 2: {
                if (columnNameCounters.containsKey(nameFromCell)) {
                    throw new DuplicateColumnNamesException(CollectionsKt.toList((Iterable)columnNameCounters.keySet()));
                }
                string = nameFromCell;
                break;
            }
            case 3: {
                if (((CharSequence)nameFromCell).length() == 0) {
                    void var3_3;
                    String emptyName = "Unknown column";
                    if (columnNameCounters.containsKey(emptyName)) {
                        string = emptyName + columnNameCounters.get(emptyName);
                        break;
                    }
                    string = var3_3;
                    break;
                }
                if (columnNameCounters.containsKey(nameFromCell)) {
                    string = nameFromCell + columnNameCounters.get(nameFromCell);
                    break;
                }
                string = nameFromCell;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final Object cellValue(Cell $this$cellValue, String sheetName) {
        if ($this$cellValue == null) {
            return null;
        }
        return XlsxKt.cellValue$getValueFromType($this$cellValue, sheetName, $this$cellValue.getCellType());
    }

    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull String path, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull WorkBookType workBookType, boolean keepFile) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter((Object)((Object)workBookType), (String)"workBookType");
        XlsxKt.writeExcel($this$writeExcel, new File(path), columnsSelector, sheetName, writeHeader, workBookType, keepFile);
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, String string, Function2 function2, String string2, boolean bl, WorkBookType workBookType, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = XlsxKt::writeExcel$lambda$14;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            workBookType = WorkBookType.XLSX;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        XlsxKt.writeExcel(dataFrame, string, function2, string2, bl, workBookType, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull File file, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull WorkBookType workBookType, boolean keepFile) {
        Workbook workbook;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
                Intrinsics.checkNotNullParameter((Object)((Object)workBookType), (String)"workBookType");
                if (!keepFile) break block14;
                switch (WhenMappings.$EnumSwitchMapping$2[workBookType.ordinal()]) {
                    case 1: {
                        workbook = (Workbook)new HSSFWorkbook((InputStream)new FileInputStream(file));
                        break block15;
                    }
                    case 2: {
                        workbook = (Workbook)new XSSFWorkbook((InputStream)new FileInputStream(file));
                        break block15;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$2[workBookType.ordinal()]) {
                case 1: {
                    workbook = (Workbook)new HSSFWorkbook();
                    break;
                }
                case 2: {
                    workbook = (Workbook)new XSSFWorkbook();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Workbook factory = workbook;
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            XlsxKt.writeExcel($this$writeExcel, it, columnsSelector, sheetName, writeHeader, factory);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, File file, Function2 function2, String string, boolean bl, WorkBookType workBookType, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = XlsxKt::writeExcel$lambda$15;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            workBookType = WorkBookType.XLSX;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        XlsxKt.writeExcel(dataFrame, file, function2, string, bl, workBookType, bl2);
    }

    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull OutputStream outputStream, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull Workbook factory) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Workbook wb = factory;
        XlsxKt.writeExcel($this$writeExcel, wb, columnsSelector, sheetName, writeHeader);
        wb.write(outputStream);
        wb.close();
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, OutputStream outputStream, Function2 function2, String string, boolean bl, Workbook workbook, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = XlsxKt::writeExcel$lambda$17;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        XlsxKt.writeExcel(dataFrame, outputStream, function2, string, bl, workbook);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Sheet writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull Workbook wb, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Sheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
        int i = 0;
        DataFrame columns = SelectKt.select($this$writeExcel, columnsSelector);
        if (writeHeader) {
            Row row = sheet.createRow(i);
            Iterable $this$forEachIndexed$iv22 = columns.columnNames();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv22) {
                void s;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                Cell cell = row.createCell(index);
                cell.setCellValue((String)s);
            }
            int $this$forEachIndexed$iv22 = i;
            i = $this$forEachIndexed$iv22 + 1;
        }
        CreationHelper createHelper = wb.getCreationHelper();
        CellStyle cellStyleDate = wb.createCellStyle();
        CellStyle cellStyleDateTime = wb.createCellStyle();
        CellStyle cellStyleTime = wb.createCellStyle();
        cellStyleDate.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy"));
        cellStyleDateTime.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy hh:mm:ss"));
        cellStyleTime.setDataFormat(createHelper.createDataFormat().getFormat("hh:mm:ss"));
        DataFrame $this$forEach$iv = columns;
        boolean $i$f$forEach = false;
        Iterable $this$forEach$iv$iv = DataFrameGetKt.rows((DataFrame)$this$forEach$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            void it;
            DataRow it$iv = (DataRow)element$iv$iv;
            boolean bl = false;
            DataRow dataRow = it$iv;
            DataRow $this$writeExcel_u24lambda_u2421 = it$iv;
            boolean bl2 = false;
            Row row = sheet.createRow(i);
            Iterable $this$forEachIndexed$iv = it.values();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void any;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int index = n;
                boolean bl3 = false;
                if (any == null) continue;
                Cell cell = row.createCell(index);
                Intrinsics.checkNotNull((Object)cell);
                XlsxKt.setCellValueByGuessedType(cell, any);
                void var34_43 = any;
                if (var34_43 instanceof LocalDate || var34_43 instanceof kotlinx.datetime.LocalDate) {
                    cell.setCellStyle(cellStyleDate);
                    continue;
                }
                if (var34_43 instanceof Calendar || var34_43 instanceof Date) {
                    cell.setCellStyle(cellStyleDateTime);
                    continue;
                }
                if (var34_43 instanceof LocalDateTime) {
                    if (((LocalDateTime)any).getYear() < 1900) {
                        cell.setCellStyle(cellStyleTime);
                        continue;
                    }
                    cell.setCellStyle(cellStyleDateTime);
                    continue;
                }
                if (!(var34_43 instanceof kotlinx.datetime.LocalDateTime)) continue;
                if (((kotlinx.datetime.LocalDateTime)any).getYear() < 1900) {
                    cell.setCellStyle(cellStyleTime);
                    continue;
                }
                cell.setCellStyle(cellStyleDateTime);
            }
            ++i;
        }
        Intrinsics.checkNotNull((Object)sheet);
        return sheet;
    }

    public static /* synthetic */ Sheet writeExcel$default(DataFrame dataFrame, Workbook workbook, Function2 function2, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = XlsxKt::writeExcel$lambda$18;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return XlsxKt.writeExcel(dataFrame, workbook, function2, string, bl);
    }

    private static final void setCellValueByGuessedType(Cell $this$setCellValueByGuessedType, Object any) {
        Object object = any;
        if (object instanceof DataRow) {
            $this$setCellValueByGuessedType.setCellValue(JsonKt.toJson$default((DataRow)((DataRow)any), (boolean)false, (int)1, null));
        } else if (object instanceof DataFrame) {
            $this$setCellValueByGuessedType.setCellValue(JsonKt.toJson$default((DataFrame)((DataFrame)any), (boolean)false, (int)1, null));
        } else if (object instanceof Number) {
            $this$setCellValueByGuessedType.setCellValue(((Number)any).doubleValue());
        } else if (object instanceof LocalDate) {
            $this$setCellValueByGuessedType.setCellValue((LocalDate)any);
        } else if (object instanceof LocalDateTime) {
            XlsxKt.setTime($this$setCellValueByGuessedType, (LocalDateTime)any);
        } else if (object instanceof Boolean) {
            $this$setCellValueByGuessedType.setCellValue(((Boolean)any).booleanValue());
        } else if (object instanceof Calendar) {
            Date date = ((Calendar)any).getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
            XlsxKt.setDate($this$setCellValueByGuessedType, date);
        } else if (object instanceof Date) {
            XlsxKt.setDate($this$setCellValueByGuessedType, (Date)any);
        } else if (object instanceof RichTextString) {
            $this$setCellValueByGuessedType.setCellValue((RichTextString)any);
        } else if (object instanceof String) {
            $this$setCellValueByGuessedType.setCellValue((String)any);
        } else if (object instanceof kotlinx.datetime.LocalDate) {
            $this$setCellValueByGuessedType.setCellValue(ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)((kotlinx.datetime.LocalDate)any)));
        } else if (object instanceof kotlinx.datetime.LocalDateTime) {
            XlsxKt.setTime($this$setCellValueByGuessedType, ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)any)));
        } else {
            $this$setCellValueByGuessedType.setCellValue(any.toString());
        }
    }

    private static final void setTime(Cell $this$setTime, LocalDateTime localDateTime) {
        $this$setTime.setCellValue(DateUtil.getExcelDate((LocalDateTime)localDateTime.plusDays(1L)) - 1.0);
    }

    private static final void setDate(Cell $this$setDate, Date date) {
        Calendar calStart = LocaleUtil.getLocaleCalendar();
        calStart.setTime(date);
        LocalDateTime localDateTime = calStart.toInstant().atZone(LocaleUtil.getUserTimeZone().toZoneId()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        XlsxKt.setTime($this$setDate, localDateTime);
    }

    private static final String readExcel$lambda$11$lambda$8(FormattingOptions $formattingOptions, Cell cell) {
        return $formattingOptions.getFormatter().formatCellValue(cell);
    }

    private static final Object readExcel$lambda$11$lambda$9(Sheet $sheet, Cell cell) {
        String string = $sheet.getSheetName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSheetName(...)");
        return XlsxKt.cellValue(cell, string);
    }

    private static final Object cellValue$getValueFromType(Cell $this_cellValue, String $sheetName, CellType type) {
        Object object;
        CellType cellType = type;
        switch (cellType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cellType.ordinal()]) {
            case 1: {
                throw new IllegalStateException(("Cell " + $this_cellValue.getAddress() + " of sheet " + $sheetName + " has a CellType that should only be used internally. This is a bug, please report https://github.com/Kotlin/dataframe/issues").toString());
            }
            case 2: {
                double number = $this_cellValue.getNumericCellValue();
                if (DateUtil.isCellDateFormatted((Cell)$this_cellValue)) {
                    LocalDateTime localDateTime = DateUtil.getLocalDateTime((double)number);
                    Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getLocalDateTime(...)");
                    object = (Comparable)ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
                    break;
                }
                object = number;
                break;
            }
            case 3: {
                object = $this_cellValue.getStringCellValue();
                break;
            }
            case 4: {
                object = XlsxKt.cellValue$getValueFromType($this_cellValue, $sheetName, $this_cellValue.getCachedFormulaResultType());
                break;
            }
            case 5: {
                object = $this_cellValue.getStringCellValue();
                break;
            }
            case 6: {
                object = $this_cellValue.getBooleanCellValue();
                break;
            }
            case 7: {
                object = $this_cellValue.getErrorCellValue();
                break;
            }
            case -1: {
                object = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private static final TransformableColumnSet writeExcel$lambda$14(ColumnsSelectionDsl columnsSelectionDsl, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)columnsSelectionDsl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return columnsSelectionDsl.all(columnsSelectionDsl);
    }

    private static final TransformableColumnSet writeExcel$lambda$15(ColumnsSelectionDsl columnsSelectionDsl, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)columnsSelectionDsl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return columnsSelectionDsl.all(columnsSelectionDsl);
    }

    private static final TransformableColumnSet writeExcel$lambda$17(ColumnsSelectionDsl columnsSelectionDsl, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)columnsSelectionDsl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return columnsSelectionDsl.all(columnsSelectionDsl);
    }

    private static final TransformableColumnSet writeExcel$lambda$18(ColumnsSelectionDsl columnsSelectionDsl, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)columnsSelectionDsl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return columnsSelectionDsl.all(columnsSelectionDsl);
    }

    public static final /* synthetic */ List access$getColumnIndices(String columns) {
        return XlsxKt.getColumnIndices(columns);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NameRepairStrategy.values().length];
            try {
                nArray[NameRepairStrategy.DO_NOTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NameRepairStrategy.CHECK_UNIQUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NameRepairStrategy.MAKE_UNIQUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CellType.values().length];
            try {
                nArray[CellType._NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.NUMERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.FORMULA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.BLANK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.BOOLEAN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WorkBookType.values().length];
            try {
                nArray[WorkBookType.XLS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkBookType.XLSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

