/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.codeGen.DefaultReadDfMethod;
import org.jetbrains.kotlinx.dataframe.io.DefaultReadExcelMethod;
import org.jetbrains.kotlinx.dataframe.io.SupportedFormat;
import org.jetbrains.kotlinx.dataframe.io.XlsxKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000e\u001a\n\u0012\u0002\b\u00030\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016J&\u0010\u000e\u001a\n\u0012\u0002\b\u00030\u000fj\u0002`\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/Excel;", "Lorg/jetbrains/kotlinx/dataframe/io/SupportedFormat;", "()V", "testOrder", "", "getTestOrder", "()I", "acceptsExtension", "", "ext", "", "createDefaultReadMethod", "Lorg/jetbrains/kotlinx/dataframe/codeGen/DefaultReadDfMethod;", "pathRepresentation", "readDataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "file", "Ljava/io/File;", "header", "", "stream", "Ljava/io/InputStream;", "dataframe-excel"})
public final class Excel
implements SupportedFormat {
    private final int testOrder;

    public Excel() {
        this.testOrder = 40000;
    }

    @NotNull
    public DataFrame<?> readDataFrame(@NotNull InputStream stream, @NotNull List<String> header) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        return XlsxKt.readExcel$default(DataFrame.Companion, stream, null, null, null, 14, null);
    }

    @NotNull
    public DataFrame<?> readDataFrame(@NotNull File file, @NotNull List<String> header) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        return XlsxKt.readExcel$default(DataFrame.Companion, file, null, null, null, 14, null);
    }

    public boolean acceptsExtension(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return Intrinsics.areEqual((Object)ext, (Object)"xls") || Intrinsics.areEqual((Object)ext, (Object)"xlsx");
    }

    public int getTestOrder() {
        return this.testOrder;
    }

    @NotNull
    public DefaultReadDfMethod createDefaultReadMethod(@Nullable String pathRepresentation) {
        return (DefaultReadDfMethod)new DefaultReadExcelMethod(pathRepresentation);
    }
}

