/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.LocaleUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.ForEachKt;
import org.jetbrains.kotlinx.dataframe.api.SelectKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnSet;
import org.jetbrains.kotlinx.dataframe.io.CsvKt;
import org.jetbrains.kotlinx.dataframe.io.JsonKt;
import org.jetbrains.kotlinx.dataframe.io.WorkBookType;
import org.jetbrains.kotlinx.dataframe.io.XlsxKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aC\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u001aC\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000e\u001aC\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0011\u001aC\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0013\u001a7\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0016\u001aC\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0014\u0010\"\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002\u001a}\u0010%\u001a\u00020\u001b\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0\u00022\u0006\u0010\u0005\u001a\u00020\u00062=\b\u0002\u0010'\u001a7\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0(j\f\u0012\u0004\u0012\u0002H&\u0012\u0002\b\u0003`+\u00a2\u0006\u0002\b,2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u000200\u001a\u0081\u0001\u0010%\u001a\u00020\u001b\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0\u00022\u0006\u00101\u001a\u0002022=\b\u0002\u0010'\u001a7\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0(j\f\u0012\u0004\u0012\u0002H&\u0012\u0002\b\u0003`+\u00a2\u0006\u0002\b,2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010-\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001804\u001a}\u0010%\u001a\u00020\u001b\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0\u00022\u0006\u00105\u001a\u00020\u00012=\b\u0002\u0010'\u001a7\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0(j\f\u0012\u0004\u0012\u0002H&\u0012\u0002\b\u0003`+\u00a2\u0006\u0002\b,2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u000200\u001as\u0010%\u001a\u00020\u0015\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0\u00022\u0006\u0010\u0017\u001a\u00020\u00182=\b\u0002\u0010'\u001a7\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0)\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0(j\f\u0012\u0004\u0012\u0002H&\u0012\u0002\b\u0003`+\u00a2\u0006\u0002\b,2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010-\u001a\u00020.\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"readExcel", "", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "file", "Ljava/io/File;", "sheetName", "columns", "rowsCount", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "inputStream", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/io/InputStream;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "url", "Ljava/net/URL;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/net/URL;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "fileOrUrl", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Lorg/apache/poi/ss/usermodel/Sheet;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "wb", "Lorg/apache/poi/ss/usermodel/Workbook;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;Lorg/apache/poi/ss/usermodel/Workbook;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "setCellValueByGuessedType", "", "Lorg/apache/poi/ss/usermodel/Cell;", "any", "", "setDate", "date", "Ljava/util/Date;", "setTime", "localDateTime", "Ljava/time/LocalDateTime;", "writeExcel", "T", "columnsSelector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnSet;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "Lkotlin/ExtensionFunctionType;", "writeHeader", "", "workBookType", "Lorg/jetbrains/kotlinx/dataframe/io/WorkBookType;", "outputStream", "Ljava/io/OutputStream;", "factory", "Lkotlin/Function0;", "path", "dataframe-excel"})
public final class XlsxKt {
    @NotNull
    private static final String readExcel = "readExcel";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull URL url, @Nullable String sheetName, @Nullable String columns, @Nullable Integer rowsCount) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Workbook wb = WorkbookFactory.create((InputStream)url.openStream());
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)wb, (String)"wb");
            dataFrame = XlsxKt.readExcel($this$readExcel, wb, sheetName, columns, rowsCount);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, URL uRL, String string, String string2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return XlsxKt.readExcel(companion, uRL, string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull File file, @Nullable String sheetName, @Nullable String columns, @Nullable Integer rowsCount) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Workbook wb = WorkbookFactory.create((File)file);
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            dataFrame = XlsxKt.readExcel($this$readExcel, it, sheetName, columns, rowsCount);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, File file, String string, String string2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return XlsxKt.readExcel(companion, file, string, string2, n);
    }

    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull String fileOrUrl, @Nullable String sheetName, @Nullable String columns, @Nullable Integer rowsCount) {
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        return XlsxKt.readExcel($this$readExcel, CsvKt.asURL((String)fileOrUrl), sheetName, columns, rowsCount);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, String string, String string2, String string3, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return XlsxKt.readExcel(companion, string, string2, string3, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull InputStream inputStream, @Nullable String sheetName, @Nullable String columns, @Nullable Integer rowsCount) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Workbook wb = WorkbookFactory.create((InputStream)inputStream);
        Closeable closeable = (Closeable)wb;
        Throwable throwable = null;
        try {
            Workbook it = (Workbook)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            dataFrame = XlsxKt.readExcel($this$readExcel, it, sheetName, columns, rowsCount);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, InputStream inputStream, String string, String string2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return XlsxKt.readExcel(companion, inputStream, string, string2, n);
    }

    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull Workbook wb, @Nullable String sheetName, @Nullable String columns, @Nullable Integer rowsCount) {
        Sheet sheet;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        if (sheetName != null) {
            Sheet sheet2;
            String it = sheetName;
            boolean bl = false;
            Sheet sheet3 = sheet2 = wb.getSheet(it);
            if (sheet3 == null) {
                throw new IllegalStateException(("Sheet with name " + sheetName + " not found").toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)sheet3, (String)"wb.getSheet(it) ?: error\u2026me $sheetName not found\")");
            sheet = sheet2;
        } else {
            Sheet sheet4 = wb.getSheetAt(0);
            sheet = sheet4;
            Intrinsics.checkNotNullExpressionValue((Object)sheet4, (String)"wb.getSheetAt(0)");
        }
        Sheet sheet5 = sheet;
        return XlsxKt.readExcel($this$readExcel, sheet5, columns, rowsCount);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, Workbook workbook, String string, String string2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        return XlsxKt.readExcel(companion, workbook, string, string2, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataFrame<?> readExcel(@NotNull DataFrame.Companion $this$readExcel, @NotNull Sheet sheet, @Nullable String columns, @Nullable Integer rowsCount) {
        void $this$mapTo$iv$iv;
        Collection collection;
        List list;
        Object list$iv$iv;
        int end;
        Iterable it;
        String it2;
        Iterable $this$flatMapTo$iv$iv;
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        if (columns != null) {
            String[] stringArray = new String[]{","};
            Iterable $this$flatMap$iv = StringsKt.split$default((CharSequence)columns, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Iterable iterable2;
                it2 = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it2, (CharSequence)":", (boolean)false, (int)2, null)) {
                    void $this$mapTo$iv$iv2;
                    String[] stringArray2 = new String[]{":"};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)it2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable3 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(CellReference.convertColStringToIndex((String)((Object)it)));
                    }
                    List list2 = (List)destination$iv$iv2;
                    int start = ((Number)list2.get(0)).intValue();
                    end = ((Number)list2.get(1)).intValue();
                    iterable2 = (Iterable)new IntRange(start, end);
                } else {
                    iterable2 = CollectionsKt.listOf((Object)CellReference.convertColStringToIndex((String)it2));
                }
                list$iv$iv = iterable2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv3;
            Row row = sheet.getRow(0);
            Intrinsics.checkNotNullExpressionValue((Object)row, (String)"sheet.getRow(0)");
            Iterable $this$map$iv = (Iterable)row;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                list$iv$iv = (Cell)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getColumnIndex());
            }
            list = (List)destination$iv$iv;
        }
        List columnIndexes = list;
        Row headerRow = sheet.getRow(0);
        List it3 = CollectionsKt.drop((Iterable)((Iterable)sheet), (int)1);
        boolean bl = false;
        List valueRows = rowsCount != null ? CollectionsKt.take((Iterable)it3, (int)rowsCount) : it3;
        Iterable $this$map$iv = columnIndexes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv4;
            Object object;
            void index;
            Cell headerCell;
            end = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv3;
            boolean bl3 = false;
            Cell cell = headerCell = headerRow.getCell((int)index);
            if ((cell != null ? cell.getCellType() : null) == CellType.NUMERIC) {
                object = String.valueOf(headerCell.getNumericCellValue());
            } else {
                object = headerCell;
                if (object == null || (object = object.getStringCellValue()) == null) {
                    object = CellReference.convertNumToColString((int)index);
                }
            }
            Object name = object;
            Iterable $this$map$iv2 = valueRows;
            boolean $i$f$map2 = false;
            it = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                Comparable comparable;
                void it4;
                Cell cell2;
                Row row = (Row)item$iv$iv2;
                Collection collection3 = destination$iv$iv4;
                boolean bl4 = false;
                Cell cell3 = cell2 = it4.getCell((int)index);
                Object object2 = cell3 != null ? cell3.getCellType() : null;
                switch (object2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object2.ordinal()]) {
                    case 1: {
                        throw new IllegalStateException(("Cell " + cell2.getAddress() + " of sheet " + sheet.getSheetName() + " has a CellType that should only be used internally. This is a bug, please report https://github.com/Kotlin/dataframe/issues").toString());
                    }
                    case 2: {
                        double number = cell2.getNumericCellValue();
                        if (DateUtil.isCellDateFormatted((Cell)cell2)) {
                            LocalDateTime localDateTime = DateUtil.getLocalDateTime((double)number);
                            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getLocalDateTime(number)");
                            comparable = (Comparable)ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
                            break;
                        }
                        comparable = Double.valueOf(number);
                        break;
                    }
                    case 3: {
                        comparable = (Comparable)((Object)cell2.getStringCellValue());
                        break;
                    }
                    case 4: {
                        comparable = Double.valueOf(cell2.getNumericCellValue());
                        break;
                    }
                    case 5: {
                        comparable = (Comparable)((Object)cell2.getStringCellValue());
                        break;
                    }
                    case 6: {
                        comparable = Boolean.valueOf(cell2.getBooleanCellValue());
                        break;
                    }
                    case 7: {
                        comparable = Byte.valueOf(cell2.getErrorCellValue());
                        break;
                    }
                    case -1: {
                        comparable = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                collection3.add(comparable);
            }
            List values = (List)destination$iv$iv4;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            collection.add(DataColumn.Companion.createWithTypeInference$default((DataColumn.Companion)DataColumn.Companion, (String)name, (List)values, null, (int)4, null));
        }
        List columns2 = (List)destination$iv$iv3;
        return ConstructorsKt.dataFrameOf((Iterable)columns2);
    }

    public static /* synthetic */ DataFrame readExcel$default(DataFrame.Companion companion, Sheet sheet, String string, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return XlsxKt.readExcel(companion, sheet, string, n);
    }

    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull String path, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull WorkBookType workBookType) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter((Object)((Object)workBookType), (String)"workBookType");
        XlsxKt.writeExcel($this$writeExcel, new File(path), columnsSelector, sheetName, writeHeader, workBookType);
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, String string, Function2 function2, String string2, boolean bl, WorkBookType workBookType, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            workBookType = WorkBookType.XLSX;
        }
        XlsxKt.writeExcel(dataFrame, string, function2, string2, bl, workBookType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull File file, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull WorkBookType workBookType) {
        Function0 function0;
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter((Object)((Object)workBookType), (String)"workBookType");
        switch (WhenMappings.$EnumSwitchMapping$1[workBookType.ordinal()]) {
            case 1: {
                function0 = writeExcel.factory.1.INSTANCE;
                break;
            }
            case 2: {
                function0 = writeExcel.factory.2.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Function0 factory2 = function0;
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            XlsxKt.writeExcel($this$writeExcel, it, columnsSelector, sheetName, writeHeader, (Function0<? extends Workbook>)factory2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, File file, Function2 function2, String string, boolean bl, WorkBookType workBookType, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.2.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            workBookType = WorkBookType.XLSX;
        }
        XlsxKt.writeExcel(dataFrame, file, function2, string, bl, workBookType);
    }

    public static final <T> void writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull OutputStream outputStream, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader, @NotNull Function0<? extends Workbook> factory2) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        Workbook wb = (Workbook)factory2.invoke();
        XlsxKt.writeExcel($this$writeExcel, wb, columnsSelector, sheetName, writeHeader);
        wb.write(outputStream);
        wb.close();
    }

    public static /* synthetic */ void writeExcel$default(DataFrame dataFrame, OutputStream outputStream, Function2 function2, String string, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.4.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        XlsxKt.writeExcel(dataFrame, outputStream, function2, string, bl, (Function0<? extends Workbook>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Sheet writeExcel(@NotNull DataFrame<? extends T> $this$writeExcel, @NotNull Workbook wb, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnSet<?>> columnsSelector, @Nullable String sheetName, boolean writeHeader) {
        Intrinsics.checkNotNullParameter($this$writeExcel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wb, (String)"wb");
        Intrinsics.checkNotNullParameter(columnsSelector, (String)"columnsSelector");
        Sheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
        Ref.IntRef i = new Ref.IntRef();
        DataFrame columns = SelectKt.select($this$writeExcel, columnsSelector);
        if (writeHeader) {
            Row row = sheet.createRow(i.element);
            Iterable $this$forEachIndexed$iv22 = columns.columnNames();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv22) {
                void s;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                Cell cell = row.createCell(index);
                cell.setCellValue((String)s);
            }
            int $this$forEachIndexed$iv22 = i.element;
            i.element = $this$forEachIndexed$iv22 + 1;
        }
        CreationHelper createHelper = wb.getCreationHelper();
        CellStyle cellStyleDate = wb.createCellStyle();
        CellStyle cellStyleDateTime = wb.createCellStyle();
        CellStyle cellStyleTime = wb.createCellStyle();
        cellStyleDate.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy"));
        cellStyleDateTime.setDataFormat(createHelper.createDataFormat().getFormat("dd.mm.yyyy hh:mm:ss"));
        cellStyleTime.setDataFormat(createHelper.createDataFormat().getFormat("hh:mm:ss"));
        ForEachKt.forEach((DataFrame)columns, (Function2)new Function2<DataRow<? extends T>, DataRow<? extends T>, Unit>(sheet, i, cellStyleDate, cellStyleDateTime, cellStyleTime){
            final /* synthetic */ Sheet $sheet;
            final /* synthetic */ Ref.IntRef $i;
            final /* synthetic */ CellStyle $cellStyleDate;
            final /* synthetic */ CellStyle $cellStyleDateTime;
            final /* synthetic */ CellStyle $cellStyleTime;
            {
                this.$sheet = $sheet;
                this.$i = $i;
                this.$cellStyleDate = $cellStyleDate;
                this.$cellStyleDateTime = $cellStyleDateTime;
                this.$cellStyleTime = $cellStyleTime;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DataRow<? extends T> $this$forEach, @NotNull DataRow<? extends T> it) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter($this$forEach, (String)"$this$forEach");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Row row = this.$sheet.createRow(this.$i.element);
                Iterable iterable = it.values();
                CellStyle cellStyle = this.$cellStyleDate;
                CellStyle cellStyle2 = this.$cellStyleDateTime;
                CellStyle cellStyle3 = this.$cellStyleTime;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void any;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T t = item$iv;
                    int index = n;
                    boolean bl = false;
                    if (any == null) continue;
                    Cell cell = row.createCell(index);
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    XlsxKt.access$setCellValueByGuessedType(cell, any);
                    void var17_18 = any;
                    if (var17_18 instanceof LocalDate ? true : var17_18 instanceof kotlinx.datetime.LocalDate) {
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (var17_18 instanceof Calendar ? true : var17_18 instanceof Date) {
                        cell.setCellStyle(cellStyle2);
                        continue;
                    }
                    if (var17_18 instanceof LocalDateTime) {
                        if (((LocalDateTime)any).getYear() < 1900) {
                            cell.setCellStyle(cellStyle3);
                            continue;
                        }
                        cell.setCellStyle(cellStyle2);
                        continue;
                    }
                    if (!(var17_18 instanceof kotlinx.datetime.LocalDateTime)) continue;
                    if (((kotlinx.datetime.LocalDateTime)any).getYear() < 1900) {
                        cell.setCellStyle(cellStyle3);
                        continue;
                    }
                    cell.setCellStyle(cellStyle2);
                }
                int n = this.$i.element;
                this.$i.element = n + 1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)sheet, (String)"sheet");
        return sheet;
    }

    public static /* synthetic */ Sheet writeExcel$default(DataFrame dataFrame, Workbook workbook, Function2 function2, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = writeExcel.5.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return XlsxKt.writeExcel(dataFrame, workbook, function2, string, bl);
    }

    private static final void setCellValueByGuessedType(Cell $this$setCellValueByGuessedType, Object any) {
        Object object = any;
        if (object instanceof DataRow) {
            $this$setCellValueByGuessedType.setCellValue(JsonKt.toJson$default((DataRow)((DataRow)any), (boolean)false, (boolean)false, (int)3, null));
        } else if (object instanceof DataFrame) {
            $this$setCellValueByGuessedType.setCellValue(JsonKt.toJson$default((DataFrame)((DataFrame)any), (boolean)false, (boolean)false, (int)3, null));
        } else if (object instanceof Number) {
            $this$setCellValueByGuessedType.setCellValue(((Number)any).doubleValue());
        } else if (object instanceof LocalDate) {
            $this$setCellValueByGuessedType.setCellValue((LocalDate)any);
        } else if (object instanceof LocalDateTime) {
            XlsxKt.setTime($this$setCellValueByGuessedType, (LocalDateTime)any);
        } else if (object instanceof Boolean) {
            $this$setCellValueByGuessedType.setCellValue(((Boolean)any).booleanValue());
        } else if (object instanceof Calendar) {
            Date date = ((Calendar)any).getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"any.time");
            XlsxKt.setDate($this$setCellValueByGuessedType, date);
        } else if (object instanceof Date) {
            XlsxKt.setDate($this$setCellValueByGuessedType, (Date)any);
        } else if (object instanceof RichTextString) {
            $this$setCellValueByGuessedType.setCellValue((RichTextString)any);
        } else if (object instanceof String) {
            $this$setCellValueByGuessedType.setCellValue((String)any);
        } else if (object instanceof kotlinx.datetime.LocalDate) {
            $this$setCellValueByGuessedType.setCellValue(ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)((kotlinx.datetime.LocalDate)any)));
        } else if (object instanceof kotlinx.datetime.LocalDateTime) {
            XlsxKt.setTime($this$setCellValueByGuessedType, ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)any)));
        } else {
            $this$setCellValueByGuessedType.setCellValue(any.toString());
        }
    }

    private static final void setTime(Cell $this$setTime, LocalDateTime localDateTime) {
        $this$setTime.setCellValue(DateUtil.getExcelDate((LocalDateTime)localDateTime.plusDays(1L)) - 1.0);
    }

    private static final void setDate(Cell $this$setDate, Date date) {
        Calendar calStart = LocaleUtil.getLocaleCalendar();
        calStart.setTime(date);
        LocalDateTime localDateTime = calStart.toInstant().atZone(LocaleUtil.getUserTimeZone().toZoneId()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"calStart.toInstant().atZ\u2026neId()).toLocalDateTime()");
        XlsxKt.setTime($this$setDate, localDateTime);
    }

    public static final /* synthetic */ void access$setCellValueByGuessedType(Cell $receiver, Object any) {
        XlsxKt.setCellValueByGuessedType($receiver, any);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CellType.values().length];
            nArray[CellType._NONE.ordinal()] = 1;
            nArray[CellType.NUMERIC.ordinal()] = 2;
            nArray[CellType.STRING.ordinal()] = 3;
            nArray[CellType.FORMULA.ordinal()] = 4;
            nArray[CellType.BLANK.ordinal()] = 5;
            nArray[CellType.BOOLEAN.ordinal()] = 6;
            nArray[CellType.ERROR.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WorkBookType.values().length];
            nArray[WorkBookType.XLS.ordinal()] = 1;
            nArray[WorkBookType.XLSX.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

