/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.schema.DataFrameSchemaImpl;
import org.jetbrains.kotlinx.dataframe.io.DatabaseConfiguration;
import org.jetbrains.kotlinx.dataframe.io.ReadJdbcKt;
import org.jetbrains.kotlinx.dataframe.io.TableColumnMetadata;
import org.jetbrains.kotlinx.dataframe.io.TableMetadata;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.io.db.UtilKt;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001aH\u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0014\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\n0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u001a6\u0010\u0018\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002\u001a\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bH\u0002\u001a$\u0010%\u001a\u00020\u00032\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010'\u001a\u00020\u0003H\u0002\u001a\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u0011*\u00020)2\u0006\u0010*\u001a\u00020+\u001a\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u0011*\u00020)2\u0006\u0010,\u001a\u00020-\u001a\u001a\u0010.\u001a\u00020\b*\u00020)2\u0006\u0010/\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+\u001a\u001a\u0010.\u001a\u00020\b*\u00020)2\u0006\u0010/\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u00100\u001a\u00020\b*\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020\u0003\u001a\u001a\u00100\u001a\u00020\b*\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020\u0003\u001a\u001a\u00101\u001a\u00020\b*\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00102\u001a\u00020\u0003\u001a\u001a\u00101\u001a\u00020\b*\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u00020\u0003\u001a6\u00103\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a0\u0011*\u00020)2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a6\u00103\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a0\u0011*\u00020)2\u0006\u0010,\u001a\u00020-2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a,\u00105\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a*\u00020)2\u0006\u0010/\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a,\u00105\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a*\u00020)2\u0006\u0010/\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a,\u00106\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a*\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a,\u00106\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a*\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a,\u00107\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a*\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00102\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a,\u00107\u001a\n\u0012\u0002\b\u00030\u0019j\u0002`\u001a*\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"DEFAULT_LIMIT", "", "MULTIPLE_SQL_QUERY_SEPARATOR", "", "START_OF_READ_SQL_QUERY", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "buildSchemaByTableColumns", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "tableColumns", "", "Lorg/jetbrains/kotlinx/dataframe/io/TableColumnMetadata;", "dbType", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "extractNewRowFromResultSetAndAddToData", "", "data", "", "", "rs", "Ljava/sql/ResultSet;", "kotlinTypesForSqlColumns", "", "Lkotlin/reflect/KType;", "fetchAndConvertDataFromResultSet", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "limit", "generateColumnSchemaValue", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "tableColumnMetadata", "generateKType", "getTableColumnsMetadata", "isValid", "", "sqlQuery", "makeCommonSqlToKTypeMapping", "manageColumnNameDuplication", "columnNameCounter", "originalName", "getSchemaForAllSqlTables", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "connection", "Ljava/sql/Connection;", "dbConfig", "Lorg/jetbrains/kotlinx/dataframe/io/DatabaseConfiguration;", "getSchemaForResultSet", "resultSet", "getSchemaForSqlQuery", "getSchemaForSqlTable", "tableName", "readAllSqlTables", "catalogue", "readResultSet", "readSqlQuery", "readSqlTable", "dataframe-jdbc"})
@SourceDebugExtension(value={"SMAP\nreadJdbc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 readJdbc.kt\norg/jetbrains/kotlinx/dataframe/io/ReadJdbcKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,690:1\n1#2:691\n1179#3,2:692\n1253#3,4:694\n1559#3:698\n1590#3,4:699\n*S KotlinDebug\n*F\n+ 1 readJdbc.kt\norg/jetbrains/kotlinx/dataframe/io/ReadJdbcKt\n*L\n479#1:692,2\n479#1:694,4\n595#1:698\n595#1:699,4\n*E\n"})
public final class ReadJdbcKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final int DEFAULT_LIMIT = Integer.MIN_VALUE;
    @NotNull
    private static final String START_OF_READ_SQL_QUERY = "SELECT";
    @NotNull
    private static final String MULTIPLE_SQL_QUERY_SEPARATOR = ";";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlTable(@NotNull DataFrame.Companion $this$readSqlTable, @NotNull DatabaseConfiguration dbConfig, @NotNull String tableName, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrame<?> dataFrame = ReadJdbcKt.readSqlTable($this$readSqlTable, connection, tableName, limit);
            return dataFrame;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlTable$default(DataFrame.Companion companion, DatabaseConfiguration databaseConfiguration, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readSqlTable(companion, databaseConfiguration, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlTable(@NotNull DataFrame.Companion $this$readSqlTable, @NotNull Connection connection, @NotNull String tableName, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        String preparedQuery = null;
        preparedQuery = "SELECT * FROM " + tableName;
        if (limit > 0) {
            preparedQuery = preparedQuery + " LIMIT " + limit;
        }
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrame<?> dataFrame;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            logger.debug((Function0)new Function0<Object>(url){
                final /* synthetic */ String $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Connection with url:" + this.$url + " is established successfully.";
                }
            });
            AutoCloseable autoCloseable2 = st.executeQuery(preparedQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrame = ReadJdbcKt.fetchAndConvertDataFromResultSet(tableColumns, rs, dbType, limit);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrame<?> dataFrame2 = dataFrame;
            return dataFrame2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlTable$default(DataFrame.Companion companion, Connection connection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readSqlTable(companion, connection, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlQuery(@NotNull DataFrame.Companion $this$readSqlQuery, @NotNull DatabaseConfiguration dbConfig, @NotNull String sqlQuery, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrame<?> dataFrame = ReadJdbcKt.readSqlQuery($this$readSqlQuery, connection, sqlQuery, limit);
            return dataFrame;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlQuery$default(DataFrame.Companion companion, DatabaseConfiguration databaseConfiguration, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readSqlQuery(companion, databaseConfiguration, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlQuery(@NotNull DataFrame.Companion $this$readSqlQuery, @NotNull Connection connection, @NotNull String sqlQuery, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        if (!ReadJdbcKt.isValid(sqlQuery)) {
            boolean $i$a$-require-ReadJdbcKt$readSqlQuery$32 = false;
            String $i$a$-require-ReadJdbcKt$readSqlQuery$32 = "SQL query should start from SELECT and contain one query for reading data without any manipulation. ";
            throw new IllegalArgumentException($i$a$-require-ReadJdbcKt$readSqlQuery$32.toString());
        }
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        Ref.ObjectRef internalSqlQuery = new Ref.ObjectRef();
        internalSqlQuery.element = sqlQuery;
        if (limit > 0) {
            internalSqlQuery.element = (String)internalSqlQuery.element + " LIMIT " + limit;
        }
        logger.debug((Function0)new Function0<Object>((Ref.ObjectRef<String>)internalSqlQuery){
            final /* synthetic */ Ref.ObjectRef<String> $internalSqlQuery;
            {
                this.$internalSqlQuery = $internalSqlQuery;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Executing SQL query: " + (String)this.$internalSqlQuery.element;
            }
        });
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrame<?> dataFrame;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery((String)internalSqlQuery.element);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrame = ReadJdbcKt.fetchAndConvertDataFromResultSet(tableColumns, rs, dbType, Integer.MIN_VALUE);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrame<?> dataFrame2 = dataFrame;
            return dataFrame2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlQuery$default(DataFrame.Companion companion, Connection connection, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readSqlQuery(companion, connection, string, n);
    }

    private static final boolean isValid(String sqlQuery) {
        String string = ((Object)StringsKt.trim((CharSequence)sqlQuery)).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String normalizedSqlQuery = string;
        return StringsKt.startsWith$default((String)normalizedSqlQuery, (String)START_OF_READ_SQL_QUERY, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)normalizedSqlQuery, (CharSequence)MULTIPLE_SQL_QUERY_SEPARATOR, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final DataFrame<?> readResultSet(@NotNull DataFrame.Companion $this$readResultSet, @NotNull ResultSet resultSet, @NotNull DbType dbType, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(resultSet);
        return ReadJdbcKt.fetchAndConvertDataFromResultSet(tableColumns, resultSet, dbType, limit);
    }

    public static /* synthetic */ DataFrame readResultSet$default(DataFrame.Companion companion, ResultSet resultSet, DbType dbType, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readResultSet(companion, resultSet, dbType, n);
    }

    @NotNull
    public static final DataFrame<?> readResultSet(@NotNull DataFrame.Companion $this$readResultSet, @NotNull ResultSet resultSet, @NotNull Connection connection, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        return ReadJdbcKt.readResultSet($this$readResultSet, resultSet, dbType, limit);
    }

    public static /* synthetic */ DataFrame readResultSet$default(DataFrame.Companion companion, ResultSet resultSet, Connection connection, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readResultSet(companion, resultSet, connection, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<DataFrame<?>> readAllSqlTables(@NotNull DataFrame.Companion $this$readAllSqlTables, @NotNull DatabaseConfiguration dbConfig, @Nullable String catalogue, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            List<DataFrame<?>> list = ReadJdbcKt.readAllSqlTables($this$readAllSqlTables, connection, catalogue, limit);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ List readAllSqlTables$default(DataFrame.Companion companion, DatabaseConfiguration databaseConfiguration, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readAllSqlTables(companion, databaseConfiguration, string, n);
    }

    @NotNull
    public static final List<DataFrame<?>> readAllSqlTables(@NotNull DataFrame.Companion $this$readAllSqlTables, @NotNull Connection connection, @Nullable String catalogue, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DatabaseMetaData metaData = connection.getMetaData();
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        String[] stringArray = new String[]{"TABLE"};
        ResultSet tables = metaData.getTables(catalogue, null, null, stringArray);
        List dataFrames = new ArrayList();
        while (tables.next()) {
            Intrinsics.checkNotNull((Object)tables);
            TableMetadata table = dbType.buildTableMetadata(tables);
            if (dbType.isSystemTable(table)) continue;
            String tableName = catalogue != null ? catalogue + '.' + table.getName() : table.getName();
            logger.debug((Function0)new Function0<Object>(tableName){
                final /* synthetic */ String $tableName;
                {
                    this.$tableName = $tableName;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Reading table: " + this.$tableName;
                }
            });
            DataFrame<?> dataFrame = ReadJdbcKt.readSqlTable($this$readAllSqlTables, connection, tableName, limit);
            ((Collection)dataFrames).add(dataFrame);
            logger.debug((Function0)new Function0<Object>(tableName){
                final /* synthetic */ String $tableName;
                {
                    this.$tableName = $tableName;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Finished reading table: " + this.$tableName;
                }
            });
        }
        return dataFrames;
    }

    public static /* synthetic */ List readAllSqlTables$default(DataFrame.Companion companion, Connection connection, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        return ReadJdbcKt.readAllSqlTables(companion, connection, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlTable(@NotNull DataFrame.Companion $this$getSchemaForSqlTable, @NotNull DatabaseConfiguration dbConfig, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrameSchema dataFrameSchema = ReadJdbcKt.getSchemaForSqlTable($this$getSchemaForSqlTable, connection, tableName);
            return dataFrameSchema;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlTable(@NotNull DataFrame.Companion $this$getSchemaForSqlTable, @NotNull Connection connection, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        String preparedQuery = "SELECT * FROM " + tableName + " LIMIT 1";
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrameSchema dataFrameSchema;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery(preparedQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrameSchema = ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrameSchema dataFrameSchema2 = dataFrameSchema;
            return dataFrameSchema2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlQuery(@NotNull DataFrame.Companion $this$getSchemaForSqlQuery, @NotNull DatabaseConfiguration dbConfig, @NotNull String sqlQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrameSchema dataFrameSchema = ReadJdbcKt.getSchemaForSqlQuery($this$getSchemaForSqlQuery, connection, sqlQuery);
            return dataFrameSchema;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlQuery(@NotNull DataFrame.Companion $this$getSchemaForSqlQuery, @NotNull Connection connection, @NotNull String sqlQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrameSchema dataFrameSchema;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery(sqlQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrameSchema = ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrameSchema dataFrameSchema2 = dataFrameSchema;
            return dataFrameSchema2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final DataFrameSchema getSchemaForResultSet(@NotNull DataFrame.Companion $this$getSchemaForResultSet, @NotNull ResultSet resultSet, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(resultSet);
        return ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
    }

    @NotNull
    public static final DataFrameSchema getSchemaForResultSet(@NotNull DataFrame.Companion $this$getSchemaForResultSet, @NotNull ResultSet resultSet, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(resultSet);
        return ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<DataFrameSchema> getSchemaForAllSqlTables(@NotNull DataFrame.Companion $this$getSchemaForAllSqlTables, @NotNull DatabaseConfiguration dbConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            List<DataFrameSchema> list = ReadJdbcKt.getSchemaForAllSqlTables($this$getSchemaForAllSqlTables, connection);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<DataFrameSchema> getSchemaForAllSqlTables(@NotNull DataFrame.Companion $this$getSchemaForAllSqlTables, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DatabaseMetaData metaData = connection.getMetaData();
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        String[] stringArray = new String[]{"TABLE"};
        String[] tableTypes = stringArray;
        ResultSet tables = metaData.getTables(null, null, null, tableTypes);
        List dataFrameSchemas = new ArrayList();
        while (tables.next()) {
            Intrinsics.checkNotNull((Object)tables);
            TableMetadata jdbcTable = dbType.buildTableMetadata(tables);
            if (dbType.isSystemTable(jdbcTable)) continue;
            DataFrameSchema dataFrameSchema = ReadJdbcKt.getSchemaForSqlTable($this$getSchemaForAllSqlTables, connection, jdbcTable.getName());
            ((Collection)dataFrameSchemas).add(dataFrameSchema);
        }
        return dataFrameSchemas;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataFrameSchema buildSchemaByTableColumns(List<TableColumnMetadata> tableColumns, DbType dbType) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = tableColumns;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            TableColumnMetadata it = (TableColumnMetadata)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getName(), (Object)ReadJdbcKt.generateColumnSchemaValue(dbType, it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map schemaColumns = destination$iv$iv;
        return (DataFrameSchema)new DataFrameSchemaImpl(schemaColumns);
    }

    private static final ColumnSchema generateColumnSchemaValue(DbType dbType, TableColumnMetadata tableColumnMetadata) {
        ColumnSchema columnSchema = dbType.convertSqlTypeToColumnSchemaValue(tableColumnMetadata);
        if (columnSchema == null) {
            columnSchema = (ColumnSchema)new ColumnSchema.Value(ReadJdbcKt.makeCommonSqlToKTypeMapping(tableColumnMetadata));
        }
        return columnSchema;
    }

    private static final List<TableColumnMetadata> getTableColumnsMetadata(ResultSet rs) {
        String string;
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"getMetaData(...)");
        ResultSetMetaData metaData = resultSetMetaData;
        int numberOfColumns = metaData.getColumnCount();
        List tableColumns = new ArrayList();
        Map columnNameCounter = new LinkedHashMap();
        DatabaseMetaData databaseMetaData = rs.getStatement().getConnection().getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"getMetaData(...)");
        DatabaseMetaData databaseMetaData2 = databaseMetaData;
        String it = string = rs.getStatement().getConnection().getCatalog();
        boolean bl = false;
        CharSequence charSequence = it;
        String catalog = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        String it2 = it = rs.getStatement().getConnection().getSchema();
        boolean bl2 = false;
        CharSequence charSequence2 = it2;
        String schema = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? it : null;
        int n = numberOfColumns + 1;
        for (int i = 1; i < n; ++i) {
            ResultSet columnResultSet;
            Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData2.getColumns(catalog, schema, metaData.getTableName(i), metaData.getColumnName(i)), (String)"getColumns(...)");
            boolean isNullable = columnResultSet.next() ? Intrinsics.areEqual((Object)columnResultSet.getString("IS_NULLABLE"), (Object)"YES") : true;
            String string2 = metaData.getColumnName(i);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getColumnName(...)");
            String name = ReadJdbcKt.manageColumnNameDuplication(columnNameCounter, string2);
            int size = metaData.getColumnDisplaySize(i);
            String type = metaData.getColumnTypeName(i);
            int jdbcType = metaData.getColumnType(i);
            String javaClassName = metaData.getColumnClassName(i);
            Collection collection = tableColumns;
            Intrinsics.checkNotNull((Object)type);
            Intrinsics.checkNotNull((Object)javaClassName);
            collection.add(new TableColumnMetadata(name, type, jdbcType, size, javaClassName, isNullable));
        }
        return tableColumns;
    }

    private static final String manageColumnNameDuplication(Map<String, Integer> columnNameCounter, String originalName) {
        String name = originalName;
        Integer count = columnNameCounter.get(originalName);
        if (count != null) {
            int incrementedCount = count + 1;
            while (columnNameCounter.containsKey(originalName + '_' + incrementedCount)) {
                ++incrementedCount;
            }
            Integer n = incrementedCount;
            columnNameCounter.put(originalName, n);
            name = originalName + '_' + incrementedCount;
        } else {
            columnNameCounter.put(originalName, 0);
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataFrame<?> fetchAndConvertDataFromResultSet(List<TableColumnMetadata> tableColumns, ResultSet rs, DbType dbType, int limit) {
        void $this$mapIndexedTo$iv$iv;
        int counter;
        int n;
        Collection<ValueColumn> collection;
        int n2;
        int n3 = tableColumns.size();
        ArrayList arrayList = new ArrayList(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 = n4++;
            collection = arrayList;
            n = 0;
            ((ArrayList)collection).add((ValueColumn)new ArrayList());
        }
        List data = arrayList;
        Map kotlinTypesForSqlColumns = new LinkedHashMap();
        int n6 = tableColumns.size();
        ArrayList arrayList2 = new ArrayList(n6);
        n2 = 0;
        while (n2 < n6) {
            void index;
            int it;
            n = it = n2++;
            collection = arrayList2;
            boolean bl = false;
            Integer n7 = (int)index;
            kotlinTypesForSqlColumns.put(n7, ReadJdbcKt.generateKType(dbType, tableColumns.get((int)index)));
            ((ArrayList)collection).add((ValueColumn)Unit.INSTANCE);
        }
        if (limit > 0) {
            for (counter = 0; counter < limit && rs.next(); ++counter) {
                ReadJdbcKt.extractNewRowFromResultSetAndAddToData(tableColumns, data, rs, kotlinTypesForSqlColumns);
            }
        } else {
            while (rs.next()) {
                ReadJdbcKt.extractNewRowFromResultSetAndAddToData(tableColumns, data, rs, kotlinTypesForSqlColumns);
                ++counter;
            }
        }
        Iterable $this$mapIndexed$iv = data;
        boolean $i$f$mapIndexed = false;
        Iterable index = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void values;
            void index2;
            int n8;
            if ((n8 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n9 = n8;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = tableColumns.get((int)index2).getName();
            Object v = kotlinTypesForSqlColumns.get((int)index2);
            Intrinsics.checkNotNull(v);
            collection.add(DataColumn.Companion.createValueColumn$default((DataColumn.Companion)DataColumn.Companion, (String)string, (List)values, (KType)((KType)v), null, null, (int)24, null));
        }
        DataFrame dataFrame = ToDataFrameKt.toDataFrameAnyColumn((Iterable)((List)destination$iv$iv));
        logger.debug((Function0)new Function0<Object>(dataFrame){
            final /* synthetic */ DataFrame<?> $dataFrame;
            {
                this.$dataFrame = $dataFrame;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "DataFrame with " + this.$dataFrame.rowsCount() + " rows and " + this.$dataFrame.columnsCount() + " columns created as a result of SQL query.";
            }
        });
        return dataFrame;
    }

    private static final void extractNewRowFromResultSetAndAddToData(List<TableColumnMetadata> tableColumns, List<? extends List<Object>> data, ResultSet rs, Map<Integer, KType> kotlinTypesForSqlColumns) {
        int n = tableColumns.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            List<Object> list;
            int i2 = i;
            boolean bl = false;
            List<Object> list2 = data.get(i2);
            try {
                list = list2;
                object = rs.getObject(i2 + 1);
            }
            catch (Throwable throwable) {
                KType kType;
                list = list2;
                Intrinsics.checkNotNull((Object)kotlinTypesForSqlColumns.get(i2));
                object = KTypes.isSupertypeOf((KType)kType, (KType)KClassifiers.getStarProjectedType((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(String.class)))) ? rs.getString(i2 + 1) : rs.getString(i2 + 1);
            }
            list.add(object);
        }
    }

    private static final KType generateKType(DbType dbType, TableColumnMetadata tableColumnMetadata) {
        KType kType = dbType.convertSqlTypeToKType(tableColumnMetadata);
        if (kType == null) {
            kType = ReadJdbcKt.makeCommonSqlToKTypeMapping(tableColumnMetadata);
        }
        return kType;
    }

    private static final KType makeCommonSqlToKTypeMapping(TableColumnMetadata tableColumnMetadata) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)-7, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)), TuplesKt.to((Object)-6, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)5, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)4, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)-5, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)), TuplesKt.to((Object)6, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)), TuplesKt.to((Object)7, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)), TuplesKt.to((Object)8, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)), TuplesKt.to((Object)2, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class)), TuplesKt.to((Object)3, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class)), TuplesKt.to((Object)1, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)), TuplesKt.to((Object)12, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)-1, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)91, (Object)Reflection.getOrCreateKotlinClass(Date.class)), TuplesKt.to((Object)92, (Object)Reflection.getOrCreateKotlinClass(Time.class)), TuplesKt.to((Object)93, (Object)Reflection.getOrCreateKotlinClass(Timestamp.class)), TuplesKt.to((Object)-2, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)-3, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)-4, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)0, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)1111, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2000, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2001, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2002, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2003, (Object)Reflection.getOrCreateKotlinClass(Object[].class)), TuplesKt.to((Object)2004, (Object)Reflection.getOrCreateKotlinClass(Blob.class)), TuplesKt.to((Object)2005, (Object)Reflection.getOrCreateKotlinClass(Clob.class)), TuplesKt.to((Object)2006, (Object)Reflection.getOrCreateKotlinClass(Ref.class)), TuplesKt.to((Object)70, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)16, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)), TuplesKt.to((Object)-8, (Object)Reflection.getOrCreateKotlinClass(RowId.class)), TuplesKt.to((Object)-15, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)), TuplesKt.to((Object)-9, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)-16, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)2011, (Object)Reflection.getOrCreateKotlinClass(NClob.class)), TuplesKt.to((Object)2009, (Object)Reflection.getOrCreateKotlinClass(SQLXML.class)), TuplesKt.to((Object)2012, (Object)Reflection.getOrCreateKotlinClass(Ref.class)), TuplesKt.to((Object)2013, (Object)Reflection.getOrCreateKotlinClass(Time.class)), TuplesKt.to((Object)2014, (Object)Reflection.getOrCreateKotlinClass(Timestamp.class))};
        Map jdbcTypeToKTypeMapping = MapsKt.mapOf((Pair[])pairArray);
        KClass kClass = (KClass)jdbcTypeToKTypeMapping.get(tableColumnMetadata.getJdbcType());
        if (kClass == null) {
            kClass = Reflection.getOrCreateKotlinClass(String.class);
        }
        KClass kClass2 = kClass;
        return KClassifiers.createType$default((KClassifier)((KClassifier)kClass2), null, (boolean)tableColumnMetadata.isNullable(), null, (int)5, null);
    }
}

