/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.schema.DataFrameSchemaImpl;
import org.jetbrains.kotlinx.dataframe.io.DbConnectionConfig;
import org.jetbrains.kotlinx.dataframe.io.TableColumnMetadata;
import org.jetbrains.kotlinx.dataframe.io.TableMetadata;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.io.db.UtilKt;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00a0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0007\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a6\u0010\u0007\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a6\u0010\u0013\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a6\u0010\u0013\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a.\u0010\u0015\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a.\u0010\u0015\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a6\u0010\u001a\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a.\u0010\u0015\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a6\u0010\u001a\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a.\u0010\u0015\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t*\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001aF\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0002\b\u00030\bj\u0002`\t0 *\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001aF\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0002\b\u00030\bj\u0002`\t0 *\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\"\u001a\u00020#*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005\u001a\u001a\u0010\"\u001a\u00020#*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0005\u001a\u001a\u0010$\u001a\u00020#*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005\u001a\u001a\u0010$\u001a\u00020#*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005\u001a\u0012\u0010%\u001a\u00020#*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0005\u001a\u0012\u0010%\u001a\u00020#*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0005\u001a\u001a\u0010&\u001a\u00020#*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010%\u001a\u00020#*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001a\u0010&\u001a\u00020#*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010%\u001a\u00020#*\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020#0 *\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020#0 *\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010(\u001a\u00020#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020+H\u0002\u001a\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u00100\u001a\u00020\u001cH\u0002\u001a$\u00101\u001a\u00020\u00052\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0003032\u0006\u00104\u001a\u00020\u0005H\u0002\u001a7\u00105\u001a\b\u0012\u0004\u0012\u0002H706\"\b\b\u0000\u00107*\u0002082\n\u00109\u001a\u0006\u0012\u0002\b\u00030:2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70<H\u0002\u00a2\u0006\u0002\u0010=\u001a>\u0010>\u001a\n\u0012\u0002\b\u00030\bj\u0002`\t2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u00100\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010?\u001a\b\u0012\u0004\u0012\u000208062\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001080*H\u0002\u001a\u0010\u0010A\u001a\u00020B2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001aH\u0010C\u001a\u00020D2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0014\u0010E\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001080*062\u0006\u00100\u001a\u00020\u001c2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020G03H\u0002\u001a\u0018\u0010H\u001a\u00020G2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020+H\u0002\u001a\u0010\u0010I\u001a\u00020G2\u0006\u0010.\u001a\u00020+H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "DEFAULT_LIMIT", "", "START_OF_READ_SQL_QUERY", "", "MULTIPLE_SQL_QUERY_SEPARATOR", "readSqlTable", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "dbConfig", "Lorg/jetbrains/kotlinx/dataframe/io/DbConnectionConfig;", "tableName", "limit", "inferNullability", "", "connection", "Ljava/sql/Connection;", "readSqlQuery", "sqlQuery", "readDataFrame", "sqlQueryOrTableName", "isSqlQuery", "isSqlTableName", "isValid", "readResultSet", "resultSet", "Ljava/sql/ResultSet;", "dbType", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "readAllSqlTables", "", "catalogue", "getSchemaForSqlTable", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "getSchemaForSqlQuery", "getDataFrameSchema", "getSchemaForResultSet", "getSchemaForAllSqlTables", "buildSchemaByTableColumns", "tableColumns", "", "Lorg/jetbrains/kotlinx/dataframe/io/TableColumnMetadata;", "generateColumnSchemaValue", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "tableColumnMetadata", "getTableColumnsMetadata", "rs", "manageColumnNameDuplication", "columnNameCounter", "", "originalName", "castArray", "", "T", "", "array", "", "elementType", "Lkotlin/reflect/KClass;", "([Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/util/List;", "fetchAndConvertDataFromResultSet", "handleArrayValues", "values", "convertNullabilityInference", "Lorg/jetbrains/kotlinx/dataframe/api/Infer;", "extractNewRowFromResultSetAndAddToData", "", "data", "kotlinTypesForSqlColumns", "Lkotlin/reflect/KType;", "generateKType", "makeCommonSqlToKTypeMapping", "dataframe-jdbc"})
@SourceDebugExtension(value={"SMAP\nreadJdbc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 readJdbc.kt\norg/jetbrains/kotlinx/dataframe/io/ReadJdbcKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1001:1\n1187#2,2:1002\n1261#2,4:1004\n1567#2:1022\n1598#2,4:1023\n1611#2,9:1027\n1863#2:1036\n1864#2:1038\n1620#2:1039\n1368#2:1040\n1454#2,5:1041\n1557#2:1046\n1628#2,2:1047\n1630#2:1051\n1#3:1008\n1#3:1019\n1#3:1037\n11483#4,9:1009\n13409#4:1018\n13410#4:1020\n11492#4:1021\n37#5,2:1049\n*S KotlinDebug\n*F\n+ 1 readJdbc.kt\norg/jetbrains/kotlinx/dataframe/io/ReadJdbcKt\n*L\n705#1:1002,2\n705#1:1004,4\n828#1:1022\n828#1:1023,4\n852#1:1027,9\n852#1:1036\n852#1:1038\n852#1:1039\n858#1:1040\n858#1:1041,5\n869#1:1046\n869#1:1047,2\n869#1:1051\n786#1:1019\n852#1:1037\n786#1:1009,9\n786#1:1018\n786#1:1020\n786#1:1021\n869#1:1049,2\n*E\n"})
public final class ReadJdbcKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ReadJdbcKt::logger$lambda$0);
    private static final int DEFAULT_LIMIT = Integer.MIN_VALUE;
    @NotNull
    private static final String START_OF_READ_SQL_QUERY = "SELECT";
    @NotNull
    private static final String MULTIPLE_SQL_QUERY_SEPARATOR = ";";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlTable(@NotNull DataFrame.Companion $this$readSqlTable, @NotNull DbConnectionConfig dbConfig, @NotNull String tableName, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrame<?> dataFrame = ReadJdbcKt.readSqlTable($this$readSqlTable, connection, tableName, limit, inferNullability);
            return dataFrame;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlTable$default(DataFrame.Companion companion, DbConnectionConfig dbConnectionConfig, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readSqlTable(companion, dbConnectionConfig, string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlTable(@NotNull DataFrame.Companion $this$readSqlTable, @NotNull Connection connection, @NotNull String tableName, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        String url = connection.getMetaData().getURL();
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        String selectAllQuery = limit > 0 ? dbType.sqlQueryLimit("SELECT * FROM " + tableName, limit) : "SELECT * FROM " + tableName;
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrame<?> dataFrame;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            logger.debug(() -> ReadJdbcKt.readSqlTable$lambda$4$lambda$2(url));
            AutoCloseable autoCloseable2 = st.executeQuery(selectAllQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrame = ReadJdbcKt.fetchAndConvertDataFromResultSet(tableColumns, rs, dbType, limit, inferNullability);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrame<?> dataFrame2 = dataFrame;
            return dataFrame2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlTable$default(DataFrame.Companion companion, Connection connection, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readSqlTable(companion, connection, string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlQuery(@NotNull DataFrame.Companion $this$readSqlQuery, @NotNull DbConnectionConfig dbConfig, @NotNull String sqlQuery, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrame<?> dataFrame = ReadJdbcKt.readSqlQuery($this$readSqlQuery, connection, sqlQuery, limit, inferNullability);
            return dataFrame;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlQuery$default(DataFrame.Companion companion, DbConnectionConfig dbConnectionConfig, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readSqlQuery(companion, dbConnectionConfig, string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> readSqlQuery(@NotNull DataFrame.Companion $this$readSqlQuery, @NotNull Connection connection, @NotNull String sqlQuery, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        if (!ReadJdbcKt.isValid(sqlQuery)) {
            boolean $i$a$-require-ReadJdbcKt$readSqlQuery$32 = false;
            String $i$a$-require-ReadJdbcKt$readSqlQuery$32 = "SQL query should start from SELECT and contain one query for reading data without any manipulation. Also it should not contain any separators like `;`.";
            throw new IllegalArgumentException($i$a$-require-ReadJdbcKt$readSqlQuery$32.toString());
        }
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        String internalSqlQuery = limit > 0 ? dbType.sqlQueryLimit(sqlQuery, limit) : sqlQuery;
        logger.debug(() -> ReadJdbcKt.readSqlQuery$lambda$7(internalSqlQuery));
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrame<?> dataFrame;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery(internalSqlQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrame = ReadJdbcKt.fetchAndConvertDataFromResultSet(tableColumns, rs, dbType, limit, inferNullability);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrame<?> dataFrame2 = dataFrame;
            return dataFrame2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ DataFrame readSqlQuery$default(DataFrame.Companion companion, Connection connection, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readSqlQuery(companion, connection, string, n, bl);
    }

    @NotNull
    public static final DataFrame<?> readDataFrame(@NotNull DbConnectionConfig $this$readDataFrame, @NotNull String sqlQueryOrTableName, int limit, boolean inferNullability) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readDataFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sqlQueryOrTableName, (String)"sqlQueryOrTableName");
        if (ReadJdbcKt.isSqlQuery(sqlQueryOrTableName)) {
            dataFrame = ReadJdbcKt.readSqlQuery(DataFrame.Companion, $this$readDataFrame, sqlQueryOrTableName, limit, inferNullability);
        } else if (ReadJdbcKt.isSqlTableName(sqlQueryOrTableName)) {
            dataFrame = ReadJdbcKt.readSqlTable(DataFrame.Companion, $this$readDataFrame, sqlQueryOrTableName, limit, inferNullability);
        } else {
            throw new IllegalArgumentException(sqlQueryOrTableName + " should be SQL query or name of one of the existing SQL tables!");
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readDataFrame$default(DbConnectionConfig dbConnectionConfig, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readDataFrame(dbConnectionConfig, string, n, bl);
    }

    private static final boolean isSqlQuery(String sqlQueryOrTableName) {
        Regex queryPattern = new Regex("(?i)\\b(SELECT)\\b");
        return queryPattern.containsMatchIn((CharSequence)((Object)StringsKt.trim((CharSequence)sqlQueryOrTableName)).toString());
    }

    private static final boolean isSqlTableName(String sqlQueryOrTableName) {
        Regex tableNamePattern = new Regex("^[a-zA-Z_][a-zA-Z0-9_]*(\\.[a-zA-Z_][a-zA-Z0-9_]*){0,2}$");
        return tableNamePattern.matches((CharSequence)((Object)StringsKt.trim((CharSequence)sqlQueryOrTableName)).toString());
    }

    @NotNull
    public static final DataFrame<?> readDataFrame(@NotNull Connection $this$readDataFrame, @NotNull String sqlQueryOrTableName, int limit, boolean inferNullability) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$readDataFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sqlQueryOrTableName, (String)"sqlQueryOrTableName");
        if (ReadJdbcKt.isSqlQuery(sqlQueryOrTableName)) {
            dataFrame = ReadJdbcKt.readSqlQuery(DataFrame.Companion, $this$readDataFrame, sqlQueryOrTableName, limit, inferNullability);
        } else if (ReadJdbcKt.isSqlTableName(sqlQueryOrTableName)) {
            dataFrame = ReadJdbcKt.readSqlTable(DataFrame.Companion, $this$readDataFrame, sqlQueryOrTableName, limit, inferNullability);
        } else {
            throw new IllegalArgumentException(sqlQueryOrTableName + " should be SQL query or name of one of the existing SQL tables!");
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame readDataFrame$default(Connection connection, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readDataFrame(connection, string, n, bl);
    }

    private static final boolean isValid(String sqlQuery) {
        String string = ((Object)StringsKt.trim((CharSequence)sqlQuery)).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String normalizedSqlQuery = string;
        return StringsKt.startsWith$default((String)normalizedSqlQuery, (String)START_OF_READ_SQL_QUERY, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)normalizedSqlQuery, (CharSequence)MULTIPLE_SQL_QUERY_SEPARATOR, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final DataFrame<?> readResultSet(@NotNull DataFrame.Companion $this$readResultSet, @NotNull ResultSet resultSet, @NotNull DbType dbType, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(resultSet);
        return ReadJdbcKt.fetchAndConvertDataFromResultSet(tableColumns, resultSet, dbType, limit, inferNullability);
    }

    public static /* synthetic */ DataFrame readResultSet$default(DataFrame.Companion companion, ResultSet resultSet, DbType dbType, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readResultSet(companion, resultSet, dbType, n, bl);
    }

    @NotNull
    public static final DataFrame<?> readDataFrame(@NotNull ResultSet $this$readDataFrame, @NotNull DbType dbType, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readDataFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        return ReadJdbcKt.readResultSet(DataFrame.Companion, $this$readDataFrame, dbType, limit, inferNullability);
    }

    public static /* synthetic */ DataFrame readDataFrame$default(ResultSet resultSet, DbType dbType, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readDataFrame(resultSet, dbType, n, bl);
    }

    @NotNull
    public static final DataFrame<?> readResultSet(@NotNull DataFrame.Companion $this$readResultSet, @NotNull ResultSet resultSet, @NotNull Connection connection, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        return ReadJdbcKt.readResultSet($this$readResultSet, resultSet, dbType, limit, inferNullability);
    }

    public static /* synthetic */ DataFrame readResultSet$default(DataFrame.Companion companion, ResultSet resultSet, Connection connection, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readResultSet(companion, resultSet, connection, n, bl);
    }

    @NotNull
    public static final DataFrame<?> readDataFrame(@NotNull ResultSet $this$readDataFrame, @NotNull Connection connection, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readDataFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return ReadJdbcKt.readResultSet(DataFrame.Companion, $this$readDataFrame, connection, limit, inferNullability);
    }

    public static /* synthetic */ DataFrame readDataFrame$default(ResultSet resultSet, Connection connection, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readDataFrame(resultSet, connection, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, DataFrame<?>> readAllSqlTables(@NotNull DataFrame.Companion $this$readAllSqlTables, @NotNull DbConnectionConfig dbConfig, @Nullable String catalogue, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            Map<String, DataFrame<?>> map = ReadJdbcKt.readAllSqlTables($this$readAllSqlTables, connection, catalogue, limit, inferNullability);
            return map;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Map readAllSqlTables$default(DataFrame.Companion companion, DbConnectionConfig dbConnectionConfig, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readAllSqlTables(companion, dbConnectionConfig, string, n, bl);
    }

    @NotNull
    public static final Map<String, DataFrame<?>> readAllSqlTables(@NotNull DataFrame.Companion $this$readAllSqlTables, @NotNull Connection connection, @Nullable String catalogue, int limit, boolean inferNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$readAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DatabaseMetaData metaData = connection.getMetaData();
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        String[] stringArray = new String[]{"TABLE"};
        ResultSet tables = metaData.getTables(catalogue, null, null, stringArray);
        Map dataFrames = new LinkedHashMap();
        while (tables.next()) {
            Intrinsics.checkNotNull((Object)tables);
            TableMetadata table = dbType.buildTableMetadata(tables);
            if (dbType.isSystemTable(table)) continue;
            String tableName = catalogue != null && table.getSchemaName() != null ? catalogue + '.' + table.getSchemaName() + '.' + table.getName() : (catalogue != null && table.getSchemaName() == null ? catalogue + '.' + table.getName() : table.getName());
            logger.debug(() -> ReadJdbcKt.readAllSqlTables$lambda$11(tableName));
            DataFrame<?> dataFrame = ReadJdbcKt.readSqlTable($this$readAllSqlTables, connection, tableName, limit, inferNullability);
            Map map = dataFrames;
            Pair pair = TuplesKt.to((Object)tableName, dataFrame);
            map.put(pair.getFirst(), pair.getSecond());
            logger.debug(() -> ReadJdbcKt.readAllSqlTables$lambda$12(tableName));
        }
        return dataFrames;
    }

    public static /* synthetic */ Map readAllSqlTables$default(DataFrame.Companion companion, Connection connection, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return ReadJdbcKt.readAllSqlTables(companion, connection, string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlTable(@NotNull DataFrame.Companion $this$getSchemaForSqlTable, @NotNull DbConnectionConfig dbConfig, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrameSchema dataFrameSchema = ReadJdbcKt.getSchemaForSqlTable($this$getSchemaForSqlTable, connection, tableName);
            return dataFrameSchema;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlTable(@NotNull DataFrame.Companion $this$getSchemaForSqlTable, @NotNull Connection connection, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        String sqlQuery = "SELECT * FROM " + tableName;
        String selectFirstRowQuery = dbType.sqlQueryLimit(sqlQuery, 1);
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrameSchema dataFrameSchema;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery(selectFirstRowQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrameSchema = ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrameSchema dataFrameSchema2 = dataFrameSchema;
            return dataFrameSchema2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlQuery(@NotNull DataFrame.Companion $this$getSchemaForSqlQuery, @NotNull DbConnectionConfig dbConfig, @NotNull String sqlQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            DataFrameSchema dataFrameSchema = ReadJdbcKt.getSchemaForSqlQuery($this$getSchemaForSqlQuery, connection, sqlQuery);
            return dataFrameSchema;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrameSchema getSchemaForSqlQuery(@NotNull DataFrame.Companion $this$getSchemaForSqlQuery, @NotNull Connection connection, @NotNull String sqlQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForSqlQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            DataFrameSchema dataFrameSchema;
            Statement st = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = st.executeQuery(sqlQuery);
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)rs);
                List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(rs);
                dataFrameSchema = ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            DataFrameSchema dataFrameSchema2 = dataFrameSchema;
            return dataFrameSchema2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final DataFrameSchema getDataFrameSchema(@NotNull DbConnectionConfig $this$getDataFrameSchema, @NotNull String sqlQueryOrTableName) {
        DataFrameSchema dataFrameSchema;
        Intrinsics.checkNotNullParameter((Object)$this$getDataFrameSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sqlQueryOrTableName, (String)"sqlQueryOrTableName");
        if (ReadJdbcKt.isSqlQuery(sqlQueryOrTableName)) {
            dataFrameSchema = ReadJdbcKt.getSchemaForSqlQuery(DataFrame.Companion, $this$getDataFrameSchema, sqlQueryOrTableName);
        } else if (ReadJdbcKt.isSqlTableName(sqlQueryOrTableName)) {
            dataFrameSchema = ReadJdbcKt.getSchemaForSqlTable(DataFrame.Companion, $this$getDataFrameSchema, sqlQueryOrTableName);
        } else {
            throw new IllegalArgumentException(sqlQueryOrTableName + " should be SQL query or name of one of the existing SQL tables!");
        }
        return dataFrameSchema;
    }

    @NotNull
    public static final DataFrameSchema getDataFrameSchema(@NotNull Connection $this$getDataFrameSchema, @NotNull String sqlQueryOrTableName) {
        DataFrameSchema dataFrameSchema;
        Intrinsics.checkNotNullParameter((Object)$this$getDataFrameSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sqlQueryOrTableName, (String)"sqlQueryOrTableName");
        if (ReadJdbcKt.isSqlQuery(sqlQueryOrTableName)) {
            dataFrameSchema = ReadJdbcKt.getSchemaForSqlQuery(DataFrame.Companion, $this$getDataFrameSchema, sqlQueryOrTableName);
        } else if (ReadJdbcKt.isSqlTableName(sqlQueryOrTableName)) {
            dataFrameSchema = ReadJdbcKt.getSchemaForSqlTable(DataFrame.Companion, $this$getDataFrameSchema, sqlQueryOrTableName);
        } else {
            throw new IllegalArgumentException(sqlQueryOrTableName + " should be SQL query or name of one of the existing SQL tables!");
        }
        return dataFrameSchema;
    }

    @NotNull
    public static final DataFrameSchema getSchemaForResultSet(@NotNull DataFrame.Companion $this$getSchemaForResultSet, @NotNull ResultSet resultSet, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(resultSet);
        return ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
    }

    @NotNull
    public static final DataFrameSchema getDataFrameSchema(@NotNull ResultSet $this$getDataFrameSchema, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFrameSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        return ReadJdbcKt.getSchemaForResultSet(DataFrame.Companion, $this$getDataFrameSchema, dbType);
    }

    @NotNull
    public static final DataFrameSchema getSchemaForResultSet(@NotNull DataFrame.Companion $this$getSchemaForResultSet, @NotNull ResultSet resultSet, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForResultSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        List<TableColumnMetadata> tableColumns = ReadJdbcKt.getTableColumnsMetadata(resultSet);
        return ReadJdbcKt.buildSchemaByTableColumns(tableColumns, dbType);
    }

    @NotNull
    public static final DataFrameSchema getDataFrameSchema(@NotNull ResultSet $this$getDataFrameSchema, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFrameSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return ReadJdbcKt.getSchemaForResultSet(DataFrame.Companion, $this$getDataFrameSchema, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, DataFrameSchema> getSchemaForAllSqlTables(@NotNull DataFrame.Companion $this$getSchemaForAllSqlTables, @NotNull DbConnectionConfig dbConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dbConfig, (String)"dbConfig");
        AutoCloseable autoCloseable = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword());
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            Map<String, DataFrameSchema> map = ReadJdbcKt.getSchemaForAllSqlTables($this$getSchemaForAllSqlTables, connection);
            return map;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Map<String, DataFrameSchema> getSchemaForAllSqlTables(@NotNull DataFrame.Companion $this$getSchemaForAllSqlTables, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaForAllSqlTables, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        DatabaseMetaData metaData = connection.getMetaData();
        DbType dbType = UtilKt.extractDBTypeFromConnection(connection);
        String[] stringArray = new String[]{"TABLE"};
        String[] tableTypes = stringArray;
        ResultSet tables = metaData.getTables(null, null, null, tableTypes);
        Map dataFrameSchemas = new LinkedHashMap();
        while (tables.next()) {
            Intrinsics.checkNotNull((Object)tables);
            TableMetadata jdbcTable = dbType.buildTableMetadata(tables);
            if (dbType.isSystemTable(jdbcTable)) continue;
            String tableName = jdbcTable.getName();
            DataFrameSchema dataFrameSchema = ReadJdbcKt.getSchemaForSqlTable($this$getSchemaForAllSqlTables, connection, tableName);
            Map map = dataFrameSchemas;
            Pair pair = TuplesKt.to((Object)tableName, (Object)dataFrameSchema);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return dataFrameSchemas;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataFrameSchema buildSchemaByTableColumns(List<TableColumnMetadata> tableColumns, DbType dbType) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = tableColumns;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            TableColumnMetadata it = (TableColumnMetadata)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getName(), (Object)ReadJdbcKt.generateColumnSchemaValue(dbType, it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map schemaColumns = destination$iv$iv;
        return (DataFrameSchema)new DataFrameSchemaImpl(schemaColumns);
    }

    private static final ColumnSchema generateColumnSchemaValue(DbType dbType, TableColumnMetadata tableColumnMetadata) {
        ColumnSchema columnSchema = dbType.convertSqlTypeToColumnSchemaValue(tableColumnMetadata);
        if (columnSchema == null) {
            columnSchema = (ColumnSchema)new ColumnSchema.Value(ReadJdbcKt.makeCommonSqlToKTypeMapping(tableColumnMetadata));
        }
        return columnSchema;
    }

    private static final List<TableColumnMetadata> getTableColumnsMetadata(ResultSet rs) {
        String string;
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"getMetaData(...)");
        ResultSetMetaData metaData = resultSetMetaData;
        int numberOfColumns = metaData.getColumnCount();
        List tableColumns = new ArrayList();
        Map columnNameCounter = new LinkedHashMap();
        DatabaseMetaData databaseMetaData = rs.getStatement().getConnection().getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"getMetaData(...)");
        DatabaseMetaData databaseMetaData2 = databaseMetaData;
        String it = string = rs.getStatement().getConnection().getCatalog();
        boolean bl = false;
        CharSequence charSequence = it;
        String catalog = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        String it2 = it = rs.getStatement().getConnection().getSchema();
        boolean bl2 = false;
        CharSequence charSequence2 = it2;
        String schema = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? it : null;
        int n = numberOfColumns + 1;
        for (int i = 1; i < n; ++i) {
            ResultSet columnResultSet;
            String tableName = metaData.getTableName(i);
            String columnName = metaData.getColumnName(i);
            Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData2.getColumns(catalog, schema, tableName, columnName), (String)"getColumns(...)");
            boolean isNullable = columnResultSet.next() ? Intrinsics.areEqual((Object)columnResultSet.getString("IS_NULLABLE"), (Object)"YES") : true;
            Intrinsics.checkNotNull((Object)columnName);
            String name = ReadJdbcKt.manageColumnNameDuplication(columnNameCounter, columnName);
            int size = metaData.getColumnDisplaySize(i);
            String type = metaData.getColumnTypeName(i);
            int jdbcType = metaData.getColumnType(i);
            String javaClassName = metaData.getColumnClassName(i);
            Collection collection = tableColumns;
            Intrinsics.checkNotNull((Object)type);
            Intrinsics.checkNotNull((Object)javaClassName);
            collection.add(new TableColumnMetadata(name, type, jdbcType, size, javaClassName, isNullable));
        }
        return tableColumns;
    }

    private static final String manageColumnNameDuplication(Map<String, Integer> columnNameCounter, String originalName) {
        String name = originalName;
        Integer count = columnNameCounter.get(originalName);
        if (count != null) {
            int incrementedCount = count + 1;
            while (columnNameCounter.containsKey(originalName + '_' + incrementedCount)) {
                ++incrementedCount;
            }
            Integer n = incrementedCount;
            columnNameCounter.put(originalName, n);
            name = originalName + '_' + incrementedCount;
        } else {
            columnNameCounter.put(originalName, 0);
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> castArray(Object[] array, KClass<T> elementType) {
        void $this$mapNotNullTo$iv$iv;
        Object[] $this$mapNotNull$iv = array;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (KClasses.safeCast(elementType, (Object)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final DataFrame<?> fetchAndConvertDataFromResultSet(List<TableColumnMetadata> tableColumns, ResultSet rs, DbType dbType, int limit, boolean inferNullability) {
        void $this$mapIndexedTo$iv$iv;
        int counter;
        int n;
        Collection<ValueColumn> collection;
        int n2;
        int n3 = tableColumns.size();
        ArrayList arrayList = new ArrayList(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 = n4++;
            collection = arrayList;
            n = 0;
            ((ArrayList)collection).add((ValueColumn)new ArrayList());
        }
        List data = arrayList;
        Map kotlinTypesForSqlColumns = new LinkedHashMap();
        int n6 = tableColumns.size();
        ArrayList arrayList2 = new ArrayList(n6);
        n2 = 0;
        while (n2 < n6) {
            void index;
            int it;
            n = it = n2++;
            collection = arrayList2;
            boolean bl = false;
            Integer n7 = (int)index;
            kotlinTypesForSqlColumns.put(n7, ReadJdbcKt.generateKType(dbType, tableColumns.get((int)index)));
            ((ArrayList)collection).add((ValueColumn)Unit.INSTANCE);
        }
        if (limit > 0) {
            for (counter = 0; counter < limit && rs.next(); ++counter) {
                ReadJdbcKt.extractNewRowFromResultSetAndAddToData(tableColumns, data, rs, kotlinTypesForSqlColumns);
            }
        } else {
            while (rs.next()) {
                ReadJdbcKt.extractNewRowFromResultSetAndAddToData(tableColumns, data, rs, kotlinTypesForSqlColumns);
                ++counter;
            }
        }
        Iterable $this$mapIndexed$iv = data;
        boolean $i$f$mapIndexed = false;
        Iterable index = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void values;
            void index2;
            int n8;
            if ((n8 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n9 = n8;
            collection = destination$iv$iv;
            boolean bl = false;
            Object v = kotlinTypesForSqlColumns.get((int)index2);
            Intrinsics.checkNotNull(v);
            List<Object> correctedValues = Intrinsics.areEqual((Object)((KType)v).getClassifier(), (Object)Reflection.getOrCreateKotlinClass(Object[].class)) ? ReadJdbcKt.handleArrayValues((List<Object>)values) : values;
            DataColumn.Companion companion = DataColumn.Companion;
            String string = tableColumns.get((int)index2).getName();
            Infer infer = ReadJdbcKt.convertNullabilityInference(inferNullability);
            Object v2 = kotlinTypesForSqlColumns.get((int)index2);
            Intrinsics.checkNotNull(v2);
            KType kType = (KType)v2;
            collection.add(DataColumn.Companion.createValueColumn$default((DataColumn.Companion)companion, (String)string, correctedValues, (KType)kType, (Infer)infer, null, (int)16, null));
        }
        DataFrame dataFrame = ToDataFrameKt.toDataFrameAnyColumn((Iterable)((List)destination$iv$iv));
        logger.debug(() -> ReadJdbcKt.fetchAndConvertDataFromResultSet$lambda$27(dataFrame));
        return dataFrame;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Object> handleArrayValues(List<Object> values) {
        List list;
        KClass commonElementType;
        void $this$flatMapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = values;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Object[]> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            Object object = it instanceof Array ? (Array)it : null;
            if (object != null && (object = object.getArray()) != null) {
                Object array = object;
                boolean bl3 = false;
                objectArray = array instanceof Object[] ? (Object[])array : null;
            } else {
                objectArray = null;
            }
            if (objectArray == null) continue;
            Object[] it$iv$iv = objectArray;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List sqlArrays = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = sqlArrays;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block12: {
                block11: {
                    Object[] array = (Object[])element$iv$iv;
                    boolean bl = false;
                    object = array.getClass().getComponentType();
                    if (object == null || (object = JvmClassMappingKt.getKotlinClass(object)) == null) break block11;
                    Object it = object;
                    boolean bl5 = false;
                    List list2 = CollectionsKt.listOf((Object)it);
                    object = list2;
                    if (list2 != null) break block12;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List allElementTypes = (List)destination$iv$iv2;
        KClass kClass = (KClass)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)allElementTypes));
        if (kClass == null) {
            kClass = Reflection.getOrCreateKotlinClass(Object.class);
        }
        if (!Intrinsics.areEqual((Object)(commonElementType = kClass), (Object)Reflection.getOrCreateKotlinClass(Object.class))) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sqlArrays;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object[] bl = (Object[])item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl6 = false;
                Collection $this$toTypedArray$iv = ReadJdbcKt.castArray((Object[])it, commonElementType);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                collection.add(thisCollection$iv.toArray(new Object[0]));
            }
            list = (List)destination$iv$iv3;
        } else {
            list = sqlArrays;
        }
        return list;
    }

    private static final Infer convertNullabilityInference(boolean inferNullability) {
        return inferNullability ? Infer.Nulls : Infer.None;
    }

    private static final void extractNewRowFromResultSetAndAddToData(List<TableColumnMetadata> tableColumns, List<? extends List<Object>> data, ResultSet rs, Map<Integer, KType> kotlinTypesForSqlColumns) {
        int n = tableColumns.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            List<Object> list;
            int i2 = i;
            boolean bl = false;
            List<Object> list2 = data.get(i2);
            try {
                list = list2;
                object = rs.getObject(i2 + 1);
            }
            catch (Throwable throwable) {
                KType kType;
                list = list2;
                Intrinsics.checkNotNull((Object)kotlinTypesForSqlColumns.get(i2));
                object = KTypes.isSupertypeOf((KType)kType, (KType)KClassifiers.getStarProjectedType((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(String.class)))) ? rs.getString(i2 + 1) : rs.getString(i2 + 1);
            }
            list.add(object);
        }
    }

    private static final KType generateKType(DbType dbType, TableColumnMetadata tableColumnMetadata) {
        KType kType = dbType.convertSqlTypeToKType(tableColumnMetadata);
        if (kType == null) {
            kType = ReadJdbcKt.makeCommonSqlToKTypeMapping(tableColumnMetadata);
        }
        return kType;
    }

    private static final KType makeCommonSqlToKTypeMapping(TableColumnMetadata tableColumnMetadata) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)-7, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)), TuplesKt.to((Object)-6, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)5, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)4, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)), TuplesKt.to((Object)-5, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)), TuplesKt.to((Object)6, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)), TuplesKt.to((Object)7, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)), TuplesKt.to((Object)8, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)), TuplesKt.to((Object)2, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class)), TuplesKt.to((Object)3, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class)), TuplesKt.to((Object)1, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)12, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)-1, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)91, (Object)Reflection.getOrCreateKotlinClass(Date.class)), TuplesKt.to((Object)92, (Object)Reflection.getOrCreateKotlinClass(Time.class)), TuplesKt.to((Object)93, (Object)Reflection.getOrCreateKotlinClass(Timestamp.class)), TuplesKt.to((Object)-2, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)-3, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)-4, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)0, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)2000, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2001, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2002, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)2003, (Object)Reflection.getOrCreateKotlinClass(Object[].class)), TuplesKt.to((Object)2004, (Object)Reflection.getOrCreateKotlinClass(byte[].class)), TuplesKt.to((Object)2005, (Object)Reflection.getOrCreateKotlinClass(Clob.class)), TuplesKt.to((Object)2006, (Object)Reflection.getOrCreateKotlinClass(Ref.class)), TuplesKt.to((Object)70, (Object)Reflection.getOrCreateKotlinClass(Object.class)), TuplesKt.to((Object)16, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)), TuplesKt.to((Object)-8, (Object)Reflection.getOrCreateKotlinClass(RowId.class)), TuplesKt.to((Object)-15, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)-9, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)-16, (Object)Reflection.getOrCreateKotlinClass(String.class)), TuplesKt.to((Object)2011, (Object)Reflection.getOrCreateKotlinClass(NClob.class)), TuplesKt.to((Object)2009, (Object)Reflection.getOrCreateKotlinClass(SQLXML.class)), TuplesKt.to((Object)2012, (Object)Reflection.getOrCreateKotlinClass(Ref.class)), TuplesKt.to((Object)2013, (Object)Reflection.getOrCreateKotlinClass(OffsetTime.class)), TuplesKt.to((Object)2014, (Object)Reflection.getOrCreateKotlinClass(OffsetDateTime.class))};
        Map jdbcTypeToKTypeMapping = MapsKt.mapOf((Pair[])pairArray);
        KClass<?> kClass = ReadJdbcKt.makeCommonSqlToKTypeMapping$determineKotlinClass(jdbcTypeToKTypeMapping, tableColumnMetadata);
        KType kType = ReadJdbcKt.makeCommonSqlToKTypeMapping$createArrayTypeIfNeeded(kClass, tableColumnMetadata.isNullable());
        return kType;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object readSqlTable$lambda$4$lambda$2(String $url) {
        return "Connection with url:" + $url + " is established successfully.";
    }

    private static final Object readSqlQuery$lambda$7(String $internalSqlQuery) {
        return "Executing SQL query: " + $internalSqlQuery;
    }

    private static final Object readAllSqlTables$lambda$11(String $tableName) {
        return "Reading table: " + $tableName;
    }

    private static final Object readAllSqlTables$lambda$12(String $tableName) {
        return "Finished reading table: " + $tableName;
    }

    private static final Object fetchAndConvertDataFromResultSet$lambda$27(DataFrame $dataFrame) {
        return "DataFrame with " + $dataFrame.rowsCount() + " rows and " + $dataFrame.columnsCount() + " columns created as a result of SQL query.";
    }

    private static final KClass<?> makeCommonSqlToKTypeMapping$determineKotlinClass(Map<Integer, ? extends KClass<? extends Object>> jdbcTypeToKTypeMapping, TableColumnMetadata tableColumnMetadata) {
        KClass kClass;
        if (tableColumnMetadata.getJdbcType() == 1111) {
            kClass = Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"[B") ? Reflection.getOrCreateKotlinClass(byte[].class) : Reflection.getOrCreateKotlinClass(Object.class);
        } else if (Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"[B")) {
            kClass = Reflection.getOrCreateKotlinClass(byte[].class);
        } else if (Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.sql.Blob")) {
            kClass = Reflection.getOrCreateKotlinClass(Blob.class);
        } else if (tableColumnMetadata.getJdbcType() == 93 && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.time.LocalDateTime")) {
            kClass = Reflection.getOrCreateKotlinClass(LocalDateTime.class);
        } else if (tableColumnMetadata.getJdbcType() == -2 && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.util.UUID")) {
            kClass = Reflection.getOrCreateKotlinClass(UUID.class);
        } else if (tableColumnMetadata.getJdbcType() == 7 && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.lang.Double")) {
            kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
        } else if (tableColumnMetadata.getJdbcType() == 6 && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.lang.Double")) {
            kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
        } else if (tableColumnMetadata.getJdbcType() == 2 && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.lang.Double")) {
            kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
        } else {
            kClass = jdbcTypeToKTypeMapping.get(tableColumnMetadata.getJdbcType());
            if (kClass == null) {
                kClass = Reflection.getOrCreateKotlinClass(String.class);
            }
        }
        return kClass;
    }

    private static final KType makeCommonSqlToKTypeMapping$createArrayTypeIfNeeded(KClass<?> kClass, boolean isNullable) {
        KType kType;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Object[].class))) {
            KType typeParam = KClassifiers.createType$default((KClassifier)((KClassifier)kClass.getTypeParameters().get(0)), null, (boolean)false, null, (int)7, null);
            kType = KClassifiers.createType$default((KClassifier)((KClassifier)kClass), (List)CollectionsKt.listOf((Object)KTypeProjection.Companion.invariant(typeParam)), (boolean)isNullable, null, (int)4, null);
        } else {
            kType = KClassifiers.createType$default((KClassifier)((KClassifier)kClass), null, (boolean)isNullable, null, (int)5, null);
        }
        return kType;
    }
}

