/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io.db;

import java.sql.ResultSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.TableColumnMetadata;
import org.jetbrains.kotlinx.dataframe.io.TableMetadata;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.io.db.MySql;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/db/H2;", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "dialect", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;)V", "getDialect", "()Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "driverClassName", "", "getDriverClassName", "()Ljava/lang/String;", "convertSqlTypeToColumnSchemaValue", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "tableColumnMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableColumnMetadata;", "isSystemTable", "", "tableMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableMetadata;", "buildTableMetadata", "tables", "Ljava/sql/ResultSet;", "convertSqlTypeToKType", "Lkotlin/reflect/KType;", "sqlQueryLimit", "sqlQuery", "limit", "", "Companion", "dataframe-jdbc"})
@SourceDebugExtension(value={"SMAP\nH2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2.kt\norg/jetbrains/kotlinx/dataframe/io/db/H2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class H2
extends DbType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbType dialect;
    @NotNull
    public static final String MODE_MYSQL = "MySQL";
    @NotNull
    public static final String MODE_POSTGRESQL = "PostgreSQL";
    @NotNull
    public static final String MODE_MSSQLSERVER = "MSSQLServer";
    @NotNull
    public static final String MODE_MARIADB = "MariaDB";

    public H2(@NotNull DbType dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        super("h2");
        this.dialect = dialect;
        if (!(this.dialect.getClass() != H2.class)) {
            boolean bl = false;
            String string = "H2 database could not be specified with H2 dialect!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ H2(DbType dbType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dbType = MySql.INSTANCE;
        }
        this(dbType);
    }

    @NotNull
    public final DbType getDialect() {
        return this.dialect;
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return "org.h2.Driver";
    }

    @Override
    @Nullable
    public ColumnSchema convertSqlTypeToColumnSchemaValue(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        return this.dialect.convertSqlTypeToColumnSchemaValue(tableColumnMetadata);
    }

    @Override
    public boolean isSystemTable(@NotNull TableMetadata tableMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableMetadata, (String)"tableMetadata");
        Locale locale = Locale.getDefault();
        String schemaName = tableMetadata.getSchemaName();
        boolean isH2SystemTable = H2.isSystemTable$containsWithLowercase(schemaName, locale, "information_schema");
        return isH2SystemTable || this.dialect.isSystemTable(tableMetadata);
    }

    @Override
    @NotNull
    public TableMetadata buildTableMetadata(@NotNull ResultSet tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return this.dialect.buildTableMetadata(tables);
    }

    @Override
    @Nullable
    public KType convertSqlTypeToKType(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        return this.dialect.convertSqlTypeToKType(tableColumnMetadata);
    }

    @Override
    @NotNull
    public String sqlQueryLimit(@NotNull String sqlQuery, int limit) {
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        return this.dialect.sqlQueryLimit(sqlQuery, limit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSystemTable$containsWithLowercase(String $this$isSystemTable_u24containsWithLowercase, Locale locale, String substr) {
        String string = $this$isSystemTable_u24containsWithLowercase;
        String string2 = string;
        if (string == null) return false;
        Intrinsics.checkNotNull((Object)locale);
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        string2 = string3;
        if (string3 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)substr, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public H2() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/db/H2$Companion;", "", "<init>", "()V", "MODE_MYSQL", "", "MODE_POSTGRESQL", "MODE_MSSQLSERVER", "MODE_MARIADB", "dataframe-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

