/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io.db;

import java.sql.ResultSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.TableColumnMetadata;
import org.jetbrains.kotlinx.dataframe.io.TableMetadata;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/db/MsSql;", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "<init>", "()V", "driverClassName", "", "getDriverClassName", "()Ljava/lang/String;", "convertSqlTypeToColumnSchemaValue", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "tableColumnMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableColumnMetadata;", "isSystemTable", "", "tableMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableMetadata;", "buildTableMetadata", "tables", "Ljava/sql/ResultSet;", "convertSqlTypeToKType", "Lkotlin/reflect/KType;", "sqlQueryLimit", "sqlQuery", "limit", "", "dataframe-jdbc"})
public final class MsSql
extends DbType {
    @NotNull
    public static final MsSql INSTANCE = new MsSql();

    private MsSql() {
        super("sqlserver");
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    @Nullable
    public ColumnSchema convertSqlTypeToColumnSchemaValue(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        return null;
    }

    @Override
    public boolean isSystemTable(@NotNull TableMetadata tableMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableMetadata, (String)"tableMetadata");
        Locale locale = Locale.getDefault();
        String schemaName = tableMetadata.getSchemaName();
        String tableName = tableMetadata.getName();
        String catalogName = tableMetadata.getCatalogue();
        return MsSql.isSystemTable$containsWithLowercase(schemaName, locale, "sys") || MsSql.isSystemTable$containsWithLowercase(schemaName, locale, "information_schema") || StringsKt.startsWith$default((String)tableName, (String)"sys", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tableName, (String)"dt", (boolean)false, (int)2, null) || MsSql.isSystemTable$containsWithLowercase(tableName, locale, "sys_config") || MsSql.isSystemTable$containsWithLowercase(catalogName, locale, "system") || MsSql.isSystemTable$containsWithLowercase(catalogName, locale, "master") || MsSql.isSystemTable$containsWithLowercase(catalogName, locale, "model") || MsSql.isSystemTable$containsWithLowercase(catalogName, locale, "msdb") || MsSql.isSystemTable$containsWithLowercase(catalogName, locale, "tempdb");
    }

    @Override
    @NotNull
    public TableMetadata buildTableMetadata(@NotNull ResultSet tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        String string = tables.getString("table_name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return new TableMetadata(string, tables.getString("table_schem"), tables.getString("table_cat"));
    }

    @Override
    @Nullable
    public KType convertSqlTypeToKType(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        return null;
    }

    @Override
    @NotNull
    public String sqlQueryLimit(@NotNull String sqlQuery, int limit) {
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        StringsKt.replace((String)sqlQuery, (String)"SELECT", (String)("SELECT TOP " + limit), (boolean)true);
        return sqlQuery;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSystemTable$containsWithLowercase(String $this$isSystemTable_u24containsWithLowercase, Locale locale, String substr) {
        String string = $this$isSystemTable_u24containsWithLowercase;
        String string2 = string;
        if (string == null) return false;
        Intrinsics.checkNotNull((Object)locale);
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        string2 = string3;
        if (string3 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)substr, (boolean)false, (int)2, null)) return false;
        return true;
    }
}

