/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io.db;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.io.db.H2;
import org.jetbrains.kotlinx.dataframe.io.db.MariaDb;
import org.jetbrains.kotlinx.dataframe.io.db.MsSql;
import org.jetbrains.kotlinx.dataframe.io.db.MySql;
import org.jetbrains.kotlinx.dataframe.io.db.PostgreSql;
import org.jetbrains.kotlinx.dataframe.io.db.Sqlite;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "extractDBTypeFromConnection", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "connection", "Ljava/sql/Connection;", "extractDBTypeFromUrl", "url", "", "createH2Instance", "driverClassNameFromUrl", "dataframe-jdbc"})
public final class UtilKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(UtilKt::logger$lambda$0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final DbType extractDBTypeFromConnection(@NotNull Connection connection) {
        DbType dbType;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Object object = connection.getMetaData();
        if (object == null || (object = object.getURL()) == null) {
            throw new IllegalStateException("URL information is missing in connection meta data!");
        }
        Object url = object;
        logger.info(() -> UtilKt.extractDBTypeFromConnection$lambda$1((String)url));
        if (StringsKt.contains$default((CharSequence)((CharSequence)url), (CharSequence)new H2(null, 1, null).getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
            H2 h2;
            String modeQuery = "SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'MODE'";
            Ref.ObjectRef mode = new Ref.ObjectRef();
            mode.element = "";
            Object object2 = connection.createStatement();
            Object object3 = null;
            try {
                Statement st = (Statement)object2;
                boolean bl = false;
                AutoCloseable autoCloseable = st.executeQuery(modeQuery);
                Throwable throwable = null;
                try {
                    ResultSet rs = (ResultSet)autoCloseable;
                    boolean bl2 = false;
                    if (!rs.next()) {
                        throw new IllegalStateException("The information about H2 mode is not found in the H2 meta-data!");
                    }
                    mode.element = rs.getString("SETTING_VALUE");
                    logger.debug(() -> UtilKt.extractDBTypeFromConnection$lambda$4$lambda$3$lambda$2(mode));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object3);
            }
            object3 = (String)mode.element;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = ((String)object3).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            object2 = string;
            object3 = "MySQL";
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string2 = ((String)object3).toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)object2, (Object)string2)) {
                h2 = new H2(MySql.INSTANCE);
            } else {
                object3 = "MSSQLServer";
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
                String string3 = ((String)object3).toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)object2, (Object)string3)) {
                    h2 = new H2(MsSql.INSTANCE);
                } else {
                    object3 = "PostgreSQL";
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                    String string4 = ((String)object3).toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)object2, (Object)string4)) {
                        h2 = new H2(PostgreSql.INSTANCE);
                    } else {
                        object3 = "MariaDB";
                        Locale locale5 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale5, (String)"getDefault(...)");
                        String string5 = ((String)object3).toLowerCase(locale5);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                        if (Intrinsics.areEqual((Object)object2, (Object)string5)) {
                            h2 = new H2(MariaDb.INSTANCE);
                        } else {
                            String message = "Unsupported database type in the url: " + (String)url + ". Only MySQL, MariaDB, MSSQL and PostgreSQL are supported!";
                            logger.error(() -> UtilKt.extractDBTypeFromConnection$lambda$5(message));
                            throw new IllegalArgumentException(message);
                        }
                    }
                }
            }
            dbType = h2;
        } else {
            void var2_3;
            DbType dbType2 = UtilKt.extractDBTypeFromUrl((String)url);
            logger.info(() -> UtilKt.extractDBTypeFromConnection$lambda$6(dbType2, (String)url));
            dbType = var2_3;
        }
        return dbType;
    }

    @NotNull
    public static final DbType extractDBTypeFromUrl(@Nullable String url) {
        if (url != null) {
            DbType dbType;
            H2 helperH2Instance = new H2(null, 1, null);
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)helperH2Instance.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = UtilKt.createH2Instance(url);
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)MariaDb.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = MariaDb.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)MySql.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = MySql.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)Sqlite.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = Sqlite.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)PostgreSql.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = PostgreSql.INSTANCE;
            } else if (StringsKt.contains$default((CharSequence)url, (CharSequence)MsSql.INSTANCE.getDbTypeInJdbcUrl(), (boolean)false, (int)2, null)) {
                dbType = MsSql.INSTANCE;
            } else {
                throw new IllegalArgumentException("Unsupported database type in the url: " + url + ". Only H2, MariaDB, MySQL, MSSQL, SQLite and PostgreSQL are supported!");
            }
            return dbType;
        }
        throw new SQLException("Database URL could not be null. The existing value is " + url);
    }

    private static final DbType createH2Instance(String url) {
        DbType dbType;
        String mode;
        Regex modePattern = new Regex("MODE=(.*?);");
        MatchResult matchResult = Regex.find$default((Regex)modePattern, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null || matchResult.getGroupValues().size() != 2) {
            throw new IllegalArgumentException("The provided URL `" + url + "` does not contain a valid mode.");
        }
        String string = mode = (String)matchResult.getGroupValues().get(1);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = string2;
        string = "MySQL";
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string4 = string.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string3, (Object)string4)) {
            dbType = new H2(MySql.INSTANCE);
        } else {
            string = "MSSQLServer";
            Locale locale3 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault(...)");
            String string5 = string.toLowerCase(locale3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string3, (Object)string5)) {
                dbType = new H2(MsSql.INSTANCE);
            } else {
                string = "PostgreSQL";
                Locale locale4 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"getDefault(...)");
                String string6 = string.toLowerCase(locale4);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string3, (Object)string6)) {
                    dbType = new H2(PostgreSql.INSTANCE);
                } else {
                    string = "MariaDB";
                    Locale locale5 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale5, (String)"getDefault(...)");
                    String string7 = string.toLowerCase(locale5);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string3, (Object)string7)) {
                        dbType = new H2(MariaDb.INSTANCE);
                    } else {
                        throw new IllegalArgumentException("Unsupported database mode: " + mode + ". Only MySQL, MariaDB, MSSQL, PostgreSQL modes are supported!");
                    }
                }
            }
        }
        return dbType;
    }

    @NotNull
    public static final String driverClassNameFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DbType dbType = UtilKt.extractDBTypeFromUrl(url);
        return dbType.getDriverClassName();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object extractDBTypeFromConnection$lambda$1(String $url) {
        return "Processing DB type extraction for connection url: " + $url;
    }

    private static final Object extractDBTypeFromConnection$lambda$4$lambda$3$lambda$2(Ref.ObjectRef $mode) {
        return "Fetched H2 DB mode: " + (String)$mode.element;
    }

    private static final Object extractDBTypeFromConnection$lambda$5(String $message) {
        return $message;
    }

    private static final Object extractDBTypeFromConnection$lambda$6(DbType $dbType, String $url) {
        return "Identified DB type as " + $dbType + " from url: " + $url;
    }
}

