/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io.db;

import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.TableColumnMetadata;
import org.jetbrains.kotlinx.dataframe.io.TableMetadata;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.io.db.MySql;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/db/MariaDb;", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "<init>", "()V", "driverClassName", "", "getDriverClassName", "()Ljava/lang/String;", "convertSqlTypeToColumnSchemaValue", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "tableColumnMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableColumnMetadata;", "isSystemTable", "", "tableMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableMetadata;", "buildTableMetadata", "tables", "Ljava/sql/ResultSet;", "convertSqlTypeToKType", "Lkotlin/reflect/KType;", "dataframe-jdbc"})
public final class MariaDb
extends DbType {
    @NotNull
    public static final MariaDb INSTANCE = new MariaDb();

    private MariaDb() {
        super("mariadb");
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return "org.mariadb.jdbc.Driver";
    }

    @Override
    @Nullable
    public ColumnSchema convertSqlTypeToColumnSchemaValue(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        if (Intrinsics.areEqual((Object)tableColumnMetadata.getSqlTypeName(), (Object)"SMALLINT") && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.lang.Short")) {
            KType kType = KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Short.TYPE)), null, (boolean)tableColumnMetadata.isNullable(), null, (int)5, null);
            return (ColumnSchema)new ColumnSchema.Value(kType);
        }
        return null;
    }

    @Override
    public boolean isSystemTable(@NotNull TableMetadata tableMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableMetadata, (String)"tableMetadata");
        return MySql.INSTANCE.isSystemTable(tableMetadata);
    }

    @Override
    @NotNull
    public TableMetadata buildTableMetadata(@NotNull ResultSet tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        String string = tables.getString("table_name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return new TableMetadata(string, tables.getString("table_schem"), tables.getString("table_cat"));
    }

    @Override
    @Nullable
    public KType convertSqlTypeToKType(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        if (Intrinsics.areEqual((Object)tableColumnMetadata.getSqlTypeName(), (Object)"SMALLINT") && Intrinsics.areEqual((Object)tableColumnMetadata.getJavaClassName(), (Object)"java.lang.Short")) {
            return KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Short.TYPE)), null, (boolean)tableColumnMetadata.isNullable(), null, (int)5, null);
        }
        return null;
    }
}

