/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io.db;

import java.sql.ResultSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.TableColumnMetadata;
import org.jetbrains.kotlinx.dataframe.io.TableMetadata;
import org.jetbrains.kotlinx.dataframe.io.db.DbType;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/db/MySql;", "Lorg/jetbrains/kotlinx/dataframe/io/db/DbType;", "<init>", "()V", "driverClassName", "", "getDriverClassName", "()Ljava/lang/String;", "convertSqlTypeToColumnSchemaValue", "Lorg/jetbrains/kotlinx/dataframe/schema/ColumnSchema;", "tableColumnMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableColumnMetadata;", "isSystemTable", "", "tableMetadata", "Lorg/jetbrains/kotlinx/dataframe/io/TableMetadata;", "buildTableMetadata", "tables", "Ljava/sql/ResultSet;", "convertSqlTypeToKType", "Lkotlin/reflect/KType;", "dataframe-jdbc"})
public final class MySql
extends DbType {
    @NotNull
    public static final MySql INSTANCE = new MySql();

    private MySql() {
        super("mysql");
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    @Nullable
    public ColumnSchema convertSqlTypeToColumnSchemaValue(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        if (Intrinsics.areEqual((Object)tableColumnMetadata.getSqlTypeName(), (Object)"INT UNSIGNED")) {
            KType kType = KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Long.TYPE)), null, (boolean)tableColumnMetadata.isNullable(), null, (int)5, null);
            return (ColumnSchema)new ColumnSchema.Value(kType);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSystemTable(@NotNull TableMetadata tableMetadata) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tableMetadata, (String)"tableMetadata");
        Locale locale = Locale.getDefault();
        String schemaName = tableMetadata.getSchemaName();
        String name = tableMetadata.getName();
        if (MySql.isSystemTable$containsWithLowercase(schemaName, locale, "information_schema")) return true;
        if (MySql.isSystemTable$containsWithLowercase(tableMetadata.getCatalogue(), locale, "performance_schema")) return true;
        if (MySql.isSystemTable$containsWithLowercase(tableMetadata.getCatalogue(), locale, "mysql")) return true;
        String string = schemaName;
        if (string != null) {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"mysql.", (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"mysql.", (boolean)false, (int)2, null)) return true;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"sys_config", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @NotNull
    public TableMetadata buildTableMetadata(@NotNull ResultSet tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        String string = tables.getString("table_name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return new TableMetadata(string, tables.getString("table_schem"), tables.getString("table_cat"));
    }

    @Override
    @Nullable
    public KType convertSqlTypeToKType(@NotNull TableColumnMetadata tableColumnMetadata) {
        Intrinsics.checkNotNullParameter((Object)tableColumnMetadata, (String)"tableColumnMetadata");
        if (Intrinsics.areEqual((Object)tableColumnMetadata.getSqlTypeName(), (Object)"INT UNSIGNED")) {
            return KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Long.TYPE)), null, (boolean)tableColumnMetadata.isNullable(), null, (int)5, null);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSystemTable$containsWithLowercase(String $this$isSystemTable_u24containsWithLowercase, Locale locale, String substr) {
        String string = $this$isSystemTable_u24containsWithLowercase;
        String string2 = string;
        if (string == null) return false;
        Intrinsics.checkNotNull((Object)locale);
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        string2 = string3;
        if (string3 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)substr, (boolean)false, (int)2, null)) return false;
        return true;
    }
}

