/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.codeGen.DefaultReadDfMethod;
import org.jetbrains.kotlinx.dataframe.io.DefaultReadOpenApiMethod;
import org.jetbrains.kotlinx.dataframe.io.IsOpenApiKt;
import org.jetbrains.kotlinx.dataframe.io.ReadOpenapiKt;
import org.jetbrains.kotlinx.dataframe.io.SupportedCodeGenerationFormat;
import org.jetbrains.kotlinx.dataframe.io.SupportedFormatSample;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ$\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016J*\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ$\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016J*\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/OpenApi;", "Lorg/jetbrains/kotlinx/dataframe/io/SupportedCodeGenerationFormat;", "<init>", "()V", "readCodeForGeneration", "", "Lorg/jetbrains/kotlinx/dataframe/codeGen/Code;", "text", "name", "extensionProperties", "", "generateHelperCompanionObject", "stream", "Ljava/io/InputStream;", "file", "Ljava/io/File;", "acceptsExtension", "ext", "acceptsSample", "sample", "Lorg/jetbrains/kotlinx/dataframe/io/SupportedFormatSample;", "testOrder", "", "getTestOrder", "()I", "createDefaultReadMethod", "Lorg/jetbrains/kotlinx/dataframe/codeGen/DefaultReadDfMethod;", "pathRepresentation", "dataframe-openapi-generator"})
public final class OpenApi
implements SupportedCodeGenerationFormat {
    private final int testOrder;

    public OpenApi() {
        this.testOrder = 9000;
    }

    @NotNull
    public final String readCodeForGeneration(@NotNull String text, @NotNull String name, boolean extensionProperties, boolean generateHelperCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ReadOpenapiKt.readOpenApiAsString$default(text, name, null, null, extensionProperties, generateHelperCompanionObject, null, 76, null);
    }

    public static /* synthetic */ String readCodeForGeneration$default(OpenApi openApi, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return openApi.readCodeForGeneration(string, string2, bl, bl2);
    }

    @NotNull
    public String readCodeForGeneration(@NotNull InputStream stream, @NotNull String name, boolean generateHelperCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InputStream inputStream = stream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        return ReadOpenapiKt.readOpenApiAsString$default(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), name, null, null, false, generateHelperCompanionObject, null, 76, null);
    }

    @NotNull
    public final String readCodeForGeneration(@NotNull InputStream stream, @NotNull String name, boolean extensionProperties, boolean generateHelperCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InputStream inputStream = stream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        return ReadOpenapiKt.readOpenApiAsString$default(TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), name, null, null, extensionProperties, generateHelperCompanionObject, null, 76, null);
    }

    @NotNull
    public String readCodeForGeneration(@NotNull File file, @NotNull String name, boolean generateHelperCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ReadOpenapiKt.readOpenApiAsString$default(FilesKt.readText$default((File)file, null, (int)1, null), name, null, null, false, generateHelperCompanionObject, null, 76, null);
    }

    @NotNull
    public final String readCodeForGeneration(@NotNull File file, @NotNull String name, boolean extensionProperties, boolean generateHelperCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ReadOpenapiKt.readOpenApiAsString$default(FilesKt.readText$default((File)file, null, (int)1, null), name, null, null, extensionProperties, generateHelperCompanionObject, null, 76, null);
    }

    public boolean acceptsExtension(@NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Object[] objectArray = new String[]{"yaml", "yml", "json"};
        return CollectionsKt.listOf((Object[])objectArray).contains(ext);
    }

    public boolean acceptsSample(@NotNull SupportedFormatSample sample) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        try {
            boolean bl2;
            SupportedFormatSample supportedFormatSample = sample;
            if (supportedFormatSample instanceof SupportedFormatSample.DataString) {
                bl2 = IsOpenApiKt.isOpenApiStr(((SupportedFormatSample.DataString)sample).unbox-impl());
            } else if (supportedFormatSample instanceof SupportedFormatSample.DataFile) {
                bl2 = IsOpenApiKt.isOpenApi(((SupportedFormatSample.DataFile)sample).unbox-impl());
            } else if (supportedFormatSample instanceof SupportedFormatSample.PathString) {
                bl2 = IsOpenApiKt.isOpenApi(((SupportedFormatSample.PathString)sample).unbox-impl());
            } else if (supportedFormatSample instanceof SupportedFormatSample.DataUrl) {
                bl2 = IsOpenApiKt.isOpenApi(((SupportedFormatSample.DataUrl)sample).unbox-impl());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            bl = bl2;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public int getTestOrder() {
        return this.testOrder;
    }

    @NotNull
    public DefaultReadDfMethod createDefaultReadMethod(@Nullable String pathRepresentation) {
        return (DefaultReadDfMethod)DefaultReadOpenApiMethod.INSTANCE;
    }
}

