/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jupyter.parser.notebook;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jupyter.parser.notebook.CellMetadata;
import org.jetbrains.jupyter.parser.notebook.serializers.CellSerializer;

@Serializable(with=CellSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/jupyter/parser/notebook/Cell;", "", "()V", "id", "", "getId", "()Ljava/lang/String;", "metadata", "Lorg/jetbrains/jupyter/parser/notebook/CellMetadata;", "getMetadata", "()Lorg/jetbrains/jupyter/parser/notebook/CellMetadata;", "source", "getSource", "type", "Lorg/jetbrains/jupyter/parser/notebook/Cell$Type;", "getType", "()Lorg/jetbrains/jupyter/parser/notebook/Cell$Type;", "verify", "", "Companion", "Type", "Lorg/jetbrains/jupyter/parser/notebook/CellWithAttachments;", "Lorg/jetbrains/jupyter/parser/notebook/CodeCell;", "jupyter-notebooks-parser"})
public abstract class Cell {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final Regex CELL_ID_REGEX = new Regex("^[a-zA-Z0-9-_]+$");

    private Cell() {
        this.verify();
    }

    @Nullable
    public abstract String getId();

    @NotNull
    public abstract CellMetadata getMetadata();

    @NotNull
    public abstract String getSource();

    @NotNull
    public abstract Type getType();

    private final void verify() {
        String string = this.getId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            int n = it.length();
            if (!(1 <= n ? n < 65 : false)) {
                boolean $i$a$-require-Cell$verify$1$32 = false;
                String $i$a$-require-Cell$verify$1$32 = Intrinsics.stringPlus((String)"id length not in range 1..64 - ", (Object)it.length());
                throw new IllegalArgumentException($i$a$-require-Cell$verify$1$32.toString());
            }
            if (!CELL_ID_REGEX.containsMatchIn((CharSequence)it)) {
                boolean bl2 = false;
                String string2 = "id does not match pattern " + CELL_ID_REGEX + " - " + it;
                throw new IllegalArgumentException(string2.toString());
            }
        }
    }

    public /* synthetic */ Cell(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/jupyter/parser/notebook/Cell$Type;", "", "(Ljava/lang/String;I)V", "CODE", "MARKDOWN", "RAW", "jupyter-notebooks-parser"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type CODE = new Type();
        public static final /* enum */ Type MARKDOWN = new Type();
        public static final /* enum */ Type RAW = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.CODE, Type.MARKDOWN, Type.RAW};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jupyter/parser/notebook/Cell$Companion;", "", "()V", "CELL_ID_REGEX", "Lkotlin/text/Regex;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/jupyter/parser/notebook/Cell;", "jupyter-notebooks-parser"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Cell> serializer() {
            return CellSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

