/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jupyter.parser.notebook;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jupyter.parser.notebook.Cell;
import org.jetbrains.jupyter.parser.notebook.CodeCellMetadata;
import org.jetbrains.jupyter.parser.notebook.Output;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fR\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/jupyter/parser/notebook/CodeCell;", "Lorg/jetbrains/jupyter/parser/notebook/Cell;", "id", "", "metadata", "Lorg/jetbrains/jupyter/parser/notebook/CodeCellMetadata;", "source", "outputs", "", "Lorg/jetbrains/jupyter/parser/notebook/Output;", "executionCount", "", "(Ljava/lang/String;Lorg/jetbrains/jupyter/parser/notebook/CodeCellMetadata;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;)V", "getExecutionCount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getId", "()Ljava/lang/String;", "getMetadata", "()Lorg/jetbrains/jupyter/parser/notebook/CodeCellMetadata;", "getOutputs", "()Ljava/util/List;", "getSource", "type", "Lorg/jetbrains/jupyter/parser/notebook/Cell$Type;", "getType", "()Lorg/jetbrains/jupyter/parser/notebook/Cell$Type;", "jupyter-notebooks-parser"})
public final class CodeCell
extends Cell {
    @Nullable
    private final String id;
    @NotNull
    private final CodeCellMetadata metadata;
    @NotNull
    private final String source;
    @NotNull
    private final List<Output> outputs;
    @Nullable
    private final Long executionCount;

    public CodeCell(@Nullable String id, @NotNull CodeCellMetadata metadata, @NotNull String source, @NotNull List<? extends Output> outputs, @Nullable Long executionCount) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        super(null);
        this.id = id;
        this.metadata = metadata;
        this.source = source;
        this.outputs = outputs;
        this.executionCount = executionCount;
        if (this.executionCount != null && !(this.executionCount >= 0L)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"execution_count < minimum 0 - ", (Object)this.getExecutionCount());
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public CodeCellMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public String getSource() {
        return this.source;
    }

    @NotNull
    public final List<Output> getOutputs() {
        return this.outputs;
    }

    @Nullable
    public final Long getExecutionCount() {
        return this.executionCount;
    }

    @Override
    @NotNull
    public Cell.Type getType() {
        return Cell.Type.CODE;
    }
}

