/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jupyter.parser.notebook.serializers;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jupyter.parser.notebook.Cell;
import org.jetbrains.jupyter.parser.notebook.CellMetadata;
import org.jetbrains.jupyter.parser.notebook.CellWithAttachments;
import org.jetbrains.jupyter.parser.notebook.CodeCell;
import org.jetbrains.jupyter.parser.notebook.CodeCellMetadata;
import org.jetbrains.jupyter.parser.notebook.MarkdownCell;
import org.jetbrains.jupyter.parser.notebook.MarkdownCellMetadata;
import org.jetbrains.jupyter.parser.notebook.Output;
import org.jetbrains.jupyter.parser.notebook.RawCell;
import org.jetbrains.jupyter.parser.notebook.RawCellMetadata;
import org.jetbrains.jupyter.parser.notebook.serializers.SerializationUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/jupyter/parser/notebook/serializers/CellSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/jupyter/parser/notebook/Cell;", "()V", "ATTACHMENTS", "", "CELL_TYPE", "EXECUTION_COUNT", "ID", "METADATA", "OUTPUTS", "SOURCE", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "jupyter-notebooks-parser"})
public final class CellSerializer
implements KSerializer<Cell> {
    @NotNull
    public static final CellSerializer INSTANCE;
    @NotNull
    private static final SerialDescriptor descriptor;
    @NotNull
    private static final String ID = "id";
    @NotNull
    private static final String CELL_TYPE = "cell_type";
    @NotNull
    private static final String SOURCE = "source";
    @NotNull
    private static final String METADATA = "metadata";
    @NotNull
    private static final String OUTPUTS = "outputs";
    @NotNull
    private static final String EXECUTION_COUNT = "execution_count";
    @NotNull
    private static final String ATTACHMENTS = "attachments";

    private CellSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Cell deserialize(@NotNull Decoder decoder) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof JsonDecoder)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        JsonObject element = JsonElementKt.getJsonObject((JsonElement)((JsonDecoder)decoder).decodeJsonElement());
        Json format = ((JsonDecoder)decoder).getJson();
        JsonElement jsonElement = (JsonElement)element.get((Object)ID);
        if (jsonElement == null) {
            string2 = null;
        } else {
            JsonElement $this$decode$iv = jsonElement;
            boolean $i$f$decode = false;
            Json $this$decodeFromJsonElement$iv$iv = format;
            boolean $i$f$decodeFromJsonElement = false;
            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(String.class));
            boolean $i$f$cast = false;
            string2 = (String)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
        }
        String id = string2;
        JsonElement jsonElement2 = (JsonElement)element.get((Object)CELL_TYPE);
        if (jsonElement2 == null) {
            string = null;
        } else {
            JsonElement $this$decode$iv = jsonElement2;
            boolean $i$f$decode = false;
            Json $this$decodeFromJsonElement$iv$iv = format;
            boolean $i$f$decodeFromJsonElement = false;
            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(String.class));
            boolean $i$f$cast = false;
            string = (String)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
        }
        String cellTypeString = string;
        String source = SerializationUtilKt.decodeMultilineText((JsonElement)element.get((Object)SOURCE), format);
        JsonElement metadataJson = (JsonElement)element.get((Object)METADATA);
        String string4 = cellTypeString;
        if (string4 == null) throw new SerializationException(Intrinsics.stringPlus((String)"Unknown cell type: ", (Object)cellTypeString));
        int n = -1;
        switch (string4.hashCode()) {
            case 3059181: {
                if (string4.equals("code")) {
                    n = 1;
                }
                break;
            }
            case 246938863: {
                if (string4.equals("markdown")) {
                    n = 2;
                }
                break;
            }
            case 112680: {
                if (string4.equals("raw")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Long l;
                List list;
                List list2;
                CodeCellMetadata codeCellMetadata;
                boolean $i$f$cast;
                KSerializer $this$cast$iv$iv$iv$iv;
                boolean $i$f$serializer;
                SerializersModule $this$serializer$iv$iv$iv;
                boolean $i$f$decodeFromJsonElement;
                boolean $i$f$decode;
                JsonElement $this$decode$iv;
                CodeCellMetadata codeCellMetadata2;
                JsonElement jsonElement3 = metadataJson;
                if (jsonElement3 == null) {
                    codeCellMetadata2 = null;
                } else {
                    $this$decode$iv = jsonElement3;
                    $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.nullableTypeOf(CodeCellMetadata.class));
                    $i$f$cast = false;
                    codeCellMetadata2 = codeCellMetadata = (CodeCellMetadata)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                if (codeCellMetadata2 == null) {
                    codeCellMetadata = new CodeCellMetadata(null, null, null, null, null, null, 63, null);
                }
                CodeCellMetadata metadata = codeCellMetadata;
                JsonElement jsonElement4 = (JsonElement)element.get((Object)OUTPUTS);
                if (jsonElement4 == null) {
                    list2 = null;
                } else {
                    $this$decode$iv = jsonElement4;
                    $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Output.class))));
                    $i$f$cast = false;
                    list2 = list = (List)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                if (list2 == null) {
                    list = CollectionsKt.emptyList();
                }
                List outputs = list;
                JsonElement jsonElement5 = (JsonElement)element.get((Object)EXECUTION_COUNT);
                if (jsonElement5 == null) {
                    l = null;
                } else {
                    JsonElement $this$decode$iv2 = jsonElement5;
                    boolean $i$f$decode2 = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    boolean $i$f$decodeFromJsonElement2 = false;
                    SerializersModule $this$serializer$iv$iv$iv2 = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv2 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv2, (KType)Reflection.nullableTypeOf(Long.class));
                    boolean $i$f$cast2 = false;
                    l = (Long)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv2, $this$decode$iv2);
                }
                Long executionCount = l;
                Cell cell = new CodeCell(id, metadata, source, outputs, executionCount);
                return cell;
            }
            case 2: {
                JsonObject jsonObject;
                MarkdownCellMetadata markdownCellMetadata;
                boolean $i$f$cast;
                KSerializer $this$cast$iv$iv$iv$iv;
                boolean $i$f$serializer;
                SerializersModule $this$serializer$iv$iv$iv;
                boolean $i$f$decodeFromJsonElement;
                MarkdownCellMetadata markdownCellMetadata2;
                boolean $i$f$decode;
                JsonElement $this$decode$iv;
                JsonElement jsonElement6 = metadataJson;
                if (jsonElement6 == null) {
                    markdownCellMetadata2 = null;
                } else {
                    $this$decode$iv = jsonElement6;
                    $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.nullableTypeOf(MarkdownCellMetadata.class));
                    $i$f$cast = false;
                    markdownCellMetadata2 = markdownCellMetadata = (MarkdownCellMetadata)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                if (markdownCellMetadata2 == null) {
                    markdownCellMetadata = new MarkdownCellMetadata(null, null, null, 7, null);
                }
                MarkdownCellMetadata metadata = markdownCellMetadata;
                JsonElement jsonElement7 = (JsonElement)element.get((Object)ATTACHMENTS);
                if (jsonElement7 == null) {
                    jsonObject = null;
                } else {
                    $this$decode$iv = jsonElement7;
                    $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.nullableTypeOf(JsonObject.class));
                    $i$f$cast = false;
                    jsonObject = (JsonObject)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                JsonObject attachments = jsonObject;
                Cell cell = new MarkdownCell(id, metadata, source, attachments);
                return cell;
            }
            case 3: {
                JsonObject jsonObject;
                RawCellMetadata rawCellMetadata;
                boolean $i$f$cast;
                KSerializer $this$cast$iv$iv$iv$iv;
                boolean $i$f$serializer;
                SerializersModule $this$serializer$iv$iv$iv;
                boolean $i$f$decodeFromJsonElement;
                RawCellMetadata rawCellMetadata2;
                boolean $i$f$decode;
                JsonElement $this$decode$iv;
                JsonElement jsonElement8 = metadataJson;
                if (jsonElement8 == null) {
                    rawCellMetadata2 = null;
                } else {
                    $this$decode$iv = jsonElement8;
                    $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.nullableTypeOf(RawCellMetadata.class));
                    $i$f$cast = false;
                    rawCellMetadata2 = rawCellMetadata = (RawCellMetadata)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                if (rawCellMetadata2 == null) {
                    rawCellMetadata = new RawCellMetadata(null, null, null, null, 15, null);
                }
                RawCellMetadata metadata = rawCellMetadata;
                JsonElement jsonElement9 = (JsonElement)element.get((Object)ATTACHMENTS);
                if (jsonElement9 == null) {
                    jsonObject = null;
                } else {
                    $this$decode$iv = jsonElement9;
                    $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.nullableTypeOf(JsonObject.class));
                    $i$f$cast = false;
                    jsonObject = (JsonObject)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                JsonObject attachments = jsonObject;
                Cell cell = new RawCell(id, metadata, source, attachments);
                return cell;
            }
            default: {
                throw new SerializationException(Intrinsics.stringPlus((String)"Unknown cell type: ", (Object)cellTypeString));
            }
        }
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Cell value) {
        Json $this$encodeToJsonElement$iv;
        Object value$iv;
        JsonElement jsonElement;
        boolean $i$f$cast;
        KSerializer $this$cast$iv$iv$iv;
        boolean $i$f$serializer;
        SerializersModule $this$serializer$iv$iv;
        Json $this$encodeToJsonElement$iv2;
        boolean $i$f$encodeToJsonElement;
        CellMetadata value$iv2;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(encoder instanceof JsonEncoder)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Json format = ((JsonEncoder)encoder).getJson();
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$serialize_u24lambda_u2d0 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        if (value.getId() != null) {
            $this$serialize_u24lambda_u2d0.put(ID, (JsonElement)JsonElementKt.JsonPrimitive((String)value.getId()));
        }
        Object object = value.getType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$serialize_u24lambda_u2d0.put(CELL_TYPE, (JsonElement)JsonElementKt.JsonPrimitive((String)object));
        $this$serialize_u24lambda_u2d0.put(SOURCE, SerializationUtilKt.encodeMultilineText(format, value.getSource()));
        object = value;
        if (object instanceof CodeCell) {
            Json json = format;
            value$iv2 = ((CodeCell)value).getMetadata();
            $i$f$encodeToJsonElement = false;
            $this$serializer$iv$iv = $this$encodeToJsonElement$iv2.getSerializersModule();
            $i$f$serializer = false;
            $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(CodeCellMetadata.class));
            $i$f$cast = false;
            jsonElement = $this$encodeToJsonElement$iv2.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv2);
        } else if (object instanceof MarkdownCell) {
            $this$encodeToJsonElement$iv2 = format;
            value$iv2 = ((MarkdownCell)value).getMetadata();
            $i$f$encodeToJsonElement = false;
            $this$serializer$iv$iv = $this$encodeToJsonElement$iv2.getSerializersModule();
            $i$f$serializer = false;
            $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(MarkdownCellMetadata.class));
            $i$f$cast = false;
            jsonElement = $this$encodeToJsonElement$iv2.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv2);
        } else if (object instanceof RawCell) {
            $this$encodeToJsonElement$iv2 = format;
            value$iv2 = ((RawCell)value).getMetadata();
            $i$f$encodeToJsonElement = false;
            $this$serializer$iv$iv = $this$encodeToJsonElement$iv2.getSerializersModule();
            $i$f$serializer = false;
            $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(RawCellMetadata.class));
            $i$f$cast = false;
            jsonElement = $this$encodeToJsonElement$iv2.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv2);
        } else {
            throw new IllegalStateException("Impossible situation: there are no more types of cells");
        }
        JsonElement metadata = jsonElement;
        $this$serialize_u24lambda_u2d0.put(METADATA, metadata);
        if (value instanceof CodeCell) {
            object = format;
            value$iv = ((CodeCell)value).getOutputs();
            boolean $i$f$encodeToJsonElement2 = false;
            SerializersModule $this$serializer$iv$iv2 = $this$encodeToJsonElement$iv.getSerializersModule();
            boolean $i$f$serializer2 = false;
            KSerializer $this$cast$iv$iv$iv2 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv2, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Output.class))));
            boolean $i$f$cast2 = false;
            $this$serialize_u24lambda_u2d0.put(OUTPUTS, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv2, value$iv));
            $this$encodeToJsonElement$iv = format;
            value$iv = ((CodeCell)value).getExecutionCount();
            $i$f$encodeToJsonElement2 = false;
            $this$serializer$iv$iv2 = $this$encodeToJsonElement$iv.getSerializersModule();
            $i$f$serializer2 = false;
            $this$cast$iv$iv$iv2 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv2, (KType)Reflection.nullableTypeOf(Long.class));
            $i$f$cast2 = false;
            $this$serialize_u24lambda_u2d0.put(EXECUTION_COUNT, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv2, value$iv));
        } else if (value instanceof CellWithAttachments) {
            $this$encodeToJsonElement$iv = format;
            value$iv = ((CellWithAttachments)value).getAttachments();
            boolean $i$f$encodeToJsonElement3 = false;
            SerializersModule $this$serializer$iv$iv3 = $this$encodeToJsonElement$iv.getSerializersModule();
            boolean $i$f$serializer3 = false;
            KSerializer $this$cast$iv$iv$iv3 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv3, (KType)Reflection.nullableTypeOf(JsonObject.class));
            boolean $i$f$cast3 = false;
            $this$serialize_u24lambda_u2d0.put(ATTACHMENTS, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv3, value$iv));
        }
        JsonObject json = builder$iv.build();
        ((JsonEncoder)encoder).encodeJsonElement((JsonElement)json);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        INSTANCE = new CellSerializer();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv = SerializersKt.serializer((KType)Reflection.typeOf(JsonObject.class));
        boolean $i$f$cast = false;
        descriptor = var1_1.getDescriptor();
    }
}

