/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jupyter.parser.notebook.serializers;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jupyter.parser.notebook.DisplayData;
import org.jetbrains.jupyter.parser.notebook.Error;
import org.jetbrains.jupyter.parser.notebook.ExecuteResult;
import org.jetbrains.jupyter.parser.notebook.Output;
import org.jetbrains.jupyter.parser.notebook.Stream;
import org.jetbrains.jupyter.parser.notebook.serializers.SerializationUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/jupyter/parser/notebook/serializers/OutputSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/jupyter/parser/notebook/Output;", "()V", "DATA", "", "ENAME", "EVALUE", "EXECUTION_COUNT", "METADATA", "NAME", "OUTPUT_TYPE", "TEXT", "TRACEBACK", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "jupyter-notebooks-parser"})
public final class OutputSerializer
implements KSerializer<Output> {
    @NotNull
    public static final OutputSerializer INSTANCE;
    @NotNull
    private static final SerialDescriptor descriptor;
    @NotNull
    private static final String OUTPUT_TYPE = "output_type";
    @NotNull
    private static final String DATA = "data";
    @NotNull
    private static final String METADATA = "metadata";
    @NotNull
    private static final String EXECUTION_COUNT = "execution_count";
    @NotNull
    private static final String NAME = "name";
    @NotNull
    private static final String TEXT = "text";
    @NotNull
    private static final String ENAME = "ename";
    @NotNull
    private static final String EVALUE = "evalue";
    @NotNull
    private static final String TRACEBACK = "traceback";

    private OutputSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Output deserialize(@NotNull Decoder decoder) {
        String outputTypeString;
        String string;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof JsonDecoder)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        JsonObject element = JsonElementKt.getJsonObject((JsonElement)((JsonDecoder)decoder).decodeJsonElement());
        Json format = ((JsonDecoder)decoder).getJson();
        JsonElement jsonElement = (JsonElement)element.get((Object)OUTPUT_TYPE);
        if (jsonElement == null) {
            string = null;
        } else {
            JsonElement $this$decode$iv = jsonElement;
            boolean $i$f$decode = false;
            Json $this$decodeFromJsonElement$iv$iv = format;
            boolean $i$f$decodeFromJsonElement = false;
            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(String.class));
            boolean $i$f$cast = false;
            string = outputTypeString = (String)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
        }
        if (outputTypeString == null) throw new SerializationException(Intrinsics.stringPlus((String)"Unknown output type: ", (Object)outputTypeString));
        int n = -1;
        switch (outputTypeString.hashCode()) {
            case -891990144: {
                if (outputTypeString.equals("stream")) {
                    n = 1;
                }
                break;
            }
            case 1614788871: {
                if (outputTypeString.equals("display_data")) {
                    n = 2;
                }
                break;
            }
            case 96784904: {
                if (outputTypeString.equals("error")) {
                    n = 3;
                }
                break;
            }
            case -1046843353: {
                if (outputTypeString.equals("execute_result")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 4: {
                Long l;
                boolean $i$f$serializer;
                SerializersModule $this$serializer$iv$iv$iv;
                boolean $i$f$decodeFromJsonElement;
                Json $this$decodeFromJsonElement$iv$iv;
                boolean $i$f$decode;
                JsonElement $this$decode$iv;
                JsonObject jsonObject;
                Map<String, String> data = SerializationUtilKt.decodeDisplayMap((JsonElement)element.get((Object)DATA), format);
                JsonElement jsonElement2 = (JsonElement)element.get((Object)METADATA);
                if (jsonElement2 == null) {
                    jsonObject = null;
                } else {
                    $this$decode$iv = jsonElement2;
                    $i$f$decode = false;
                    $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
                    boolean $i$f$cast = false;
                    jsonObject = (JsonObject)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                JsonObject metadata = SerializationUtilKt.orEmptyObject(jsonObject);
                JsonElement jsonElement3 = (JsonElement)element.get((Object)EXECUTION_COUNT);
                if (jsonElement3 == null) {
                    l = null;
                } else {
                    JsonElement $this$decode$iv2 = jsonElement3;
                    boolean $i$f$decode2 = false;
                    Json $this$decodeFromJsonElement$iv$iv2 = format;
                    boolean $i$f$decodeFromJsonElement2 = false;
                    SerializersModule $this$serializer$iv$iv$iv2 = $this$decodeFromJsonElement$iv$iv2.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv2, (KType)Reflection.typeOf(Long.TYPE));
                    boolean $i$f$cast = false;
                    l = (Long)$this$decodeFromJsonElement$iv$iv2.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv2);
                }
                Long executionCount = l;
                Output output = new ExecuteResult(data, metadata, executionCount);
                return output;
            }
            case 2: {
                JsonObject jsonObject;
                boolean $i$f$serializer;
                SerializersModule $this$serializer$iv$iv$iv;
                boolean $i$f$decodeFromJsonElement;
                Json $this$decodeFromJsonElement$iv$iv;
                boolean $i$f$decode;
                JsonElement $this$decode$iv;
                Map<String, String> data = SerializationUtilKt.decodeDisplayMap((JsonElement)element.get((Object)DATA), format);
                JsonElement jsonElement4 = (JsonElement)element.get((Object)METADATA);
                if (jsonElement4 == null) {
                    jsonObject = null;
                } else {
                    $this$decode$iv = jsonElement4;
                    $i$f$decode = false;
                    $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
                    boolean $i$f$cast = false;
                    jsonObject = (JsonObject)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                JsonObject metadata = SerializationUtilKt.orEmptyObject(jsonObject);
                Output output = new DisplayData(data, metadata);
                return output;
            }
            case 1: {
                String string3;
                String string4;
                JsonElement jsonElement5 = (JsonElement)element.get((Object)NAME);
                if (jsonElement5 == null) {
                    string4 = null;
                } else {
                    JsonElement $this$decode$iv = jsonElement5;
                    boolean $i$f$decode = false;
                    Json $this$decodeFromJsonElement$iv$iv = format;
                    boolean $i$f$decodeFromJsonElement = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    boolean $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(String.class));
                    boolean $i$f$cast = false;
                    string4 = string3 = (String)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                if (string4 == null) {
                    string3 = "";
                }
                String name = string3;
                String text = SerializationUtilKt.decodeMultilineText((JsonElement)element.get((Object)TEXT), format);
                Output output = new Stream(name, text);
                return output;
            }
            case 3: {
                List list;
                List list2;
                String string5;
                String string6;
                String string7;
                String string8;
                boolean $i$f$serializer;
                SerializersModule $this$serializer$iv$iv$iv;
                boolean $i$f$decodeFromJsonElement;
                Json $this$decodeFromJsonElement$iv$iv;
                boolean $i$f$decode;
                JsonElement $this$decode$iv;
                JsonElement jsonElement6 = (JsonElement)element.get((Object)ENAME);
                if (jsonElement6 == null) {
                    string8 = null;
                } else {
                    JsonElement $this$decode$iv3 = jsonElement6;
                    boolean $i$f$decode3 = false;
                    Json $this$decodeFromJsonElement$iv$iv3 = format;
                    boolean $i$f$decodeFromJsonElement3 = false;
                    SerializersModule $this$serializer$iv$iv$iv3 = $this$decodeFromJsonElement$iv$iv3.getSerializersModule();
                    boolean $i$f$serializer3 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv3, (KType)Reflection.typeOf(String.class));
                    boolean $i$f$cast = false;
                    string8 = string7 = (String)$this$decodeFromJsonElement$iv$iv3.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv3);
                }
                if (string8 == null) {
                    string7 = "";
                }
                String ename = string7;
                JsonElement jsonElement7 = (JsonElement)element.get((Object)EVALUE);
                if (jsonElement7 == null) {
                    string6 = null;
                } else {
                    $this$decode$iv = jsonElement7;
                    $i$f$decode = false;
                    $this$decodeFromJsonElement$iv$iv = format;
                    $i$f$decodeFromJsonElement = false;
                    $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                    $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(String.class));
                    boolean $i$f$cast = false;
                    string6 = string5 = (String)$this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv);
                }
                if (string6 == null) {
                    string5 = "";
                }
                String evalue = string5;
                JsonElement jsonElement8 = (JsonElement)element.get((Object)TRACEBACK);
                if (jsonElement8 == null) {
                    list2 = null;
                } else {
                    JsonElement $this$decode$iv4 = jsonElement8;
                    boolean $i$f$decode4 = false;
                    Json $this$decodeFromJsonElement$iv$iv4 = format;
                    boolean $i$f$decodeFromJsonElement4 = false;
                    SerializersModule $this$serializer$iv$iv$iv4 = $this$decodeFromJsonElement$iv$iv4.getSerializersModule();
                    boolean $i$f$serializer4 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv4, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))));
                    boolean $i$f$cast = false;
                    list2 = list = (List)$this$decodeFromJsonElement$iv$iv4.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, $this$decode$iv4);
                }
                if (list2 == null) {
                    list = CollectionsKt.emptyList();
                }
                List traceback = list;
                Output output = new Error(ename, evalue, traceback);
                return output;
            }
            default: {
                throw new SerializationException(Intrinsics.stringPlus((String)"Unknown output type: ", (Object)outputTypeString));
            }
        }
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Output value) {
        Json $this$encodeToJsonElement$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(encoder instanceof JsonEncoder)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Json format = ((JsonEncoder)encoder).getJson();
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$serialize_u24lambda_u2d0 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        String string = value.getType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$serialize_u24lambda_u2d0.put(OUTPUT_TYPE, (JsonElement)JsonElementKt.JsonPrimitive((String)string));
        Output output = value;
        if (output instanceof DisplayData) {
            $this$serialize_u24lambda_u2d0.put(DATA, (JsonElement)SerializationUtilKt.encodeDisplayMap(format, ((DisplayData)value).getData()));
            string = format;
            Object value$iv = ((DisplayData)value).getMetadata();
            boolean $i$f$encodeToJsonElement = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToJsonElement$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
            boolean $i$f$cast = false;
            $this$serialize_u24lambda_u2d0.put(METADATA, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, value$iv));
            if (value instanceof ExecuteResult) {
                $this$encodeToJsonElement$iv = format;
                value$iv = ((ExecuteResult)value).getExecutionCount();
                $i$f$encodeToJsonElement = false;
                $this$serializer$iv$iv = $this$encodeToJsonElement$iv.getSerializersModule();
                $i$f$serializer = false;
                $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.nullableTypeOf(Long.class));
                $i$f$cast = false;
                $this$serialize_u24lambda_u2d0.put(EXECUTION_COUNT, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, value$iv));
            }
        } else if (output instanceof Stream) {
            $this$encodeToJsonElement$iv = format;
            String value$iv = ((Stream)value).getName();
            boolean $i$f$encodeToJsonElement = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToJsonElement$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(String.class));
            boolean $i$f$cast = false;
            $this$serialize_u24lambda_u2d0.put(NAME, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv));
            $this$serialize_u24lambda_u2d0.put(TEXT, SerializationUtilKt.encodeMultilineText(format, ((Stream)value).getText()));
        } else if (output instanceof Error) {
            $this$encodeToJsonElement$iv = format;
            Object value$iv = ((Error)value).getErrorName();
            boolean $i$f$encodeToJsonElement = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToJsonElement$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(String.class));
            boolean $i$f$cast = false;
            $this$serialize_u24lambda_u2d0.put(ENAME, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, value$iv));
            $this$encodeToJsonElement$iv = format;
            value$iv = ((Error)value).getErrorValue();
            $i$f$encodeToJsonElement = false;
            $this$serializer$iv$iv = $this$encodeToJsonElement$iv.getSerializersModule();
            $i$f$serializer = false;
            $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(String.class));
            $i$f$cast = false;
            $this$serialize_u24lambda_u2d0.put(EVALUE, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, value$iv));
            $this$encodeToJsonElement$iv = format;
            value$iv = ((Error)value).getTraceback();
            $i$f$encodeToJsonElement = false;
            $this$serializer$iv$iv = $this$encodeToJsonElement$iv.getSerializersModule();
            $i$f$serializer = false;
            $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))));
            $i$f$cast = false;
            $this$serialize_u24lambda_u2d0.put(TRACEBACK, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)$this$cast$iv$iv$iv, value$iv));
        }
        JsonObject json = builder$iv.build();
        ((JsonEncoder)encoder).encodeJsonElement((JsonElement)json);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        INSTANCE = new OutputSerializer();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv = SerializersKt.serializer((KType)Reflection.typeOf(JsonObject.class));
        boolean $i$f$cast = false;
        descriptor = var1_1.getDescriptor();
    }
}

