/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.kandy.dsl.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.kandy.dsl.internal.BindingCollector;
import org.jetbrains.kotlinx.kandy.dsl.internal.DatasetBuilder;
import org.jetbrains.kotlinx.kandy.ir.aes.Aes;
import org.jetbrains.kotlinx.kandy.ir.bindings.NonPositionalMapping;
import org.jetbrains.kotlinx.kandy.ir.bindings.NonPositionalMappingParameters;
import org.jetbrains.kotlinx.kandy.ir.bindings.NonPositionalSetting;
import org.jetbrains.kotlinx.kandy.ir.bindings.PositionalMapping;
import org.jetbrains.kotlinx.kandy.ir.bindings.PositionalMappingParameters;
import org.jetbrains.kotlinx.kandy.ir.bindings.PositionalSetting;
import org.jetbrains.kotlinx.kandy.ir.scale.PositionalFreeScale;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005JD\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u001cJT\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u001cJ'\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00150!\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u00020%\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00150&J2\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00150(\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010&JB\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00150(\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010&J'\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u00150*\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/kandy/dsl/internal/BindingHandler;", "", "datasetBuilderAccessor", "Lkotlin/Function0;", "Lorg/jetbrains/kotlinx/kandy/dsl/internal/DatasetBuilder;", "(Lkotlin/jvm/functions/Function0;)V", "bindingCollector", "Lorg/jetbrains/kotlinx/kandy/dsl/internal/BindingCollector;", "getBindingCollector", "()Lorg/jetbrains/kotlinx/kandy/dsl/internal/BindingCollector;", "datasetBuilder", "getDatasetBuilder", "()Lorg/jetbrains/kotlinx/kandy/dsl/internal/DatasetBuilder;", "firstMapping", "", "getFirstMapping", "()Z", "setFirstMapping", "(Z)V", "addNonPositionalMapping", "Lorg/jetbrains/kotlinx/kandy/ir/bindings/NonPositionalMapping;", "DomainType", "RangeType", "aes", "Lorg/jetbrains/kotlinx/kandy/ir/aes/Aes;", "columnID", "", "parameters", "Lorg/jetbrains/kotlinx/kandy/ir/bindings/NonPositionalMappingParameters;", "values", "", "name", "addNonPositionalSetting", "Lorg/jetbrains/kotlinx/kandy/ir/bindings/NonPositionalSetting;", "value", "(Lorg/jetbrains/kotlinx/kandy/ir/aes/Aes;Ljava/lang/Object;)Lorg/jetbrains/kotlinx/kandy/ir/bindings/NonPositionalSetting;", "addPositionalFreeScale", "", "Lorg/jetbrains/kotlinx/kandy/ir/bindings/PositionalMappingParameters;", "addPositionalMapping", "Lorg/jetbrains/kotlinx/kandy/ir/bindings/PositionalMapping;", "addPositionalSetting", "Lorg/jetbrains/kotlinx/kandy/ir/bindings/PositionalSetting;", "(Lorg/jetbrains/kotlinx/kandy/ir/aes/Aes;Ljava/lang/Object;)Lorg/jetbrains/kotlinx/kandy/ir/bindings/PositionalSetting;", "checkMappingSourceSize", "size", "", "kandy-api"})
public class BindingHandler {
    @NotNull
    private final Function0<DatasetBuilder> datasetBuilderAccessor;
    @NotNull
    private final BindingCollector bindingCollector;
    private boolean firstMapping;

    public BindingHandler(@NotNull Function0<? extends DatasetBuilder> datasetBuilderAccessor) {
        Intrinsics.checkNotNullParameter(datasetBuilderAccessor, (String)"datasetBuilderAccessor");
        this.datasetBuilderAccessor = datasetBuilderAccessor;
        this.bindingCollector = new BindingCollector();
        this.firstMapping = true;
    }

    @NotNull
    public final BindingCollector getBindingCollector() {
        return this.bindingCollector;
    }

    public final boolean getFirstMapping() {
        return this.firstMapping;
    }

    public final void setFirstMapping(boolean bl) {
        this.firstMapping = bl;
    }

    @NotNull
    public final DatasetBuilder getDatasetBuilder() {
        return (DatasetBuilder)this.datasetBuilderAccessor.invoke();
    }

    public void checkMappingSourceSize(int size) {
        int rowsCount = this.getDatasetBuilder().rowsCount();
        if (rowsCount == 0) {
            return;
        }
        if (rowsCount != size) {
            throw new IllegalStateException(("Unexpected size of mapping source: excepted " + rowsCount + ", but received " + size).toString());
        }
    }

    @NotNull
    public final <DomainType> NonPositionalSetting<DomainType> addNonPositionalSetting(@NotNull Aes aes, DomainType value) {
        NonPositionalSetting<DomainType> nonPositionalSetting;
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        NonPositionalSetting<DomainType> it = nonPositionalSetting = new NonPositionalSetting<DomainType>(aes, value);
        boolean bl = false;
        this.bindingCollector.getSettings().put(aes, it);
        return nonPositionalSetting;
    }

    @NotNull
    public final <DomainType> PositionalSetting<DomainType> addPositionalSetting(@NotNull Aes aes, DomainType value) {
        PositionalSetting<DomainType> positionalSetting;
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        PositionalSetting<DomainType> it = positionalSetting = new PositionalSetting<DomainType>(aes, value);
        boolean bl = false;
        this.bindingCollector.getSettings().put(aes, it);
        return positionalSetting;
    }

    @NotNull
    public final <DomainType> PositionalMapping<DomainType> addPositionalMapping(@NotNull Aes aes, @NotNull List<? extends DomainType> values, @Nullable String name, @Nullable PositionalMappingParameters<DomainType> parameters) {
        PositionalMapping<DomainType> positionalMapping;
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.checkMappingSourceSize(values.size());
        DatasetBuilder datasetBuilder = this.getDatasetBuilder();
        String string = name;
        if (string == null) {
            string = aes.getName();
        }
        String columnID = datasetBuilder.addColumn(values, string);
        PositionalMapping<DomainType> it = positionalMapping = new PositionalMapping<DomainType>(aes, columnID, parameters);
        boolean bl = false;
        this.bindingCollector.getMappings().put(aes, it);
        it = positionalMapping;
        boolean bl2 = false;
        this.firstMapping = false;
        return positionalMapping;
    }

    @NotNull
    public final <DomainType> PositionalMapping<DomainType> addPositionalMapping(@NotNull Aes aes, @NotNull String columnID, @Nullable PositionalMappingParameters<DomainType> parameters) {
        PositionalMapping<DomainType> positionalMapping;
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)columnID, (String)"columnID");
        String newColumnID = this.getDatasetBuilder().takeColumn(columnID);
        PositionalMapping<DomainType> it = positionalMapping = new PositionalMapping<DomainType>(aes, newColumnID, parameters);
        boolean bl = false;
        this.bindingCollector.getMappings().put(aes, it);
        it = positionalMapping;
        boolean bl2 = false;
        this.firstMapping = false;
        return positionalMapping;
    }

    @NotNull
    public final <DomainType, RangeType> NonPositionalMapping<DomainType, RangeType> addNonPositionalMapping(@NotNull Aes aes, @NotNull List<? extends DomainType> values, @Nullable String name, @Nullable NonPositionalMappingParameters<DomainType, RangeType> parameters) {
        NonPositionalMapping<DomainType, RangeType> nonPositionalMapping;
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.checkMappingSourceSize(values.size());
        DatasetBuilder datasetBuilder = this.getDatasetBuilder();
        String string = name;
        if (string == null) {
            string = aes.getName();
        }
        String columnID = datasetBuilder.addColumn(values, string);
        NonPositionalMapping<DomainType, RangeType> it = nonPositionalMapping = new NonPositionalMapping<DomainType, RangeType>(aes, columnID, parameters);
        boolean bl = false;
        this.bindingCollector.getMappings().put(aes, it);
        it = nonPositionalMapping;
        boolean bl2 = false;
        this.firstMapping = false;
        return nonPositionalMapping;
    }

    @NotNull
    public final <DomainType, RangeType> NonPositionalMapping<DomainType, RangeType> addNonPositionalMapping(@NotNull Aes aes, @NotNull String columnID, @Nullable NonPositionalMappingParameters<DomainType, RangeType> parameters) {
        NonPositionalMapping<DomainType, RangeType> nonPositionalMapping;
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)columnID, (String)"columnID");
        String newColumnID = this.getDatasetBuilder().takeColumn(columnID);
        NonPositionalMapping<DomainType, RangeType> it = nonPositionalMapping = new NonPositionalMapping<DomainType, RangeType>(aes, newColumnID, parameters);
        boolean bl = false;
        this.bindingCollector.getMappings().put(aes, it);
        it = nonPositionalMapping;
        boolean bl2 = false;
        this.firstMapping = false;
        return nonPositionalMapping;
    }

    public final <DomainType> void addPositionalFreeScale(@NotNull Aes aes, @NotNull PositionalMappingParameters<DomainType> parameters) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.bindingCollector.getFreeScales().put(aes, new PositionalFreeScale<DomainType>(aes, parameters));
    }
}

