/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.kandy.dsl.internal.dataframe;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.AddKt;
import org.jetbrains.kotlinx.dataframe.api.CopyKt;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.IsEmptyKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnAccessor;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.kandy.dsl.internal.DatasetBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b!\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0012\u0010\u0012\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0012\u0010\u001b\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001cR\u001e\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00058 X\u00a1\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0007\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/DatasetBuilderImpl;", "Lorg/jetbrains/kotlinx/kandy/dsl/internal/DatasetBuilder;", "initialBuilder", "(Lorg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/DatasetBuilderImpl;)V", "baseDataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getBaseDataFrame$annotations", "()V", "getBaseDataFrame", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "buffer", "getBuffer$annotations", "getBuffer", "setBuffer", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)V", "referredColumns", "", "", "addColumn", "values", "", "name", "column", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "rowsCount", "", "takeColumn", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnAccessor;", "kandy-api"})
@PublishedApi
@SourceDebugExtension(value={"SMAP\nDatasetBuilderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasetBuilderImpl.kt\norg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/DatasetBuilderImpl\n+ 2 DataColumn.kt\norg/jetbrains/kotlinx/dataframe/DataColumn$Companion\n*L\n1#1,93:1\n98#2,6:94\n*S KotlinDebug\n*F\n+ 1 DatasetBuilderImpl.kt\norg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/DatasetBuilderImpl\n*L\n69#1:94,6\n*E\n"})
public abstract class DatasetBuilderImpl
implements DatasetBuilder {
    @NotNull
    private final Map<String, String> referredColumns;
    @NotNull
    private DataFrame<?> buffer;

    public DatasetBuilderImpl(@Nullable DatasetBuilderImpl initialBuilder) {
        this.referredColumns = new LinkedHashMap();
        DataFrame dataFrame = initialBuilder;
        if (dataFrame == null || (dataFrame = dataFrame.buffer) == null || (dataFrame = CopyKt.copy((DataFrame)dataFrame)) == null) {
            dataFrame = DataFrame.Companion.getEmpty();
        }
        this.buffer = dataFrame;
    }

    public /* synthetic */ DatasetBuilderImpl(DatasetBuilderImpl datasetBuilderImpl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            datasetBuilderImpl = null;
        }
        this(datasetBuilderImpl);
    }

    @NotNull
    public abstract DataFrame<?> getBaseDataFrame();

    @PublishedApi
    public static /* synthetic */ void getBaseDataFrame$annotations() {
    }

    @NotNull
    public final DataFrame<?> getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull DataFrame<?> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"<set-?>");
        this.buffer = dataFrame;
    }

    @PublishedApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public int rowsCount() {
        return IsEmptyKt.isEmpty(this.getBaseDataFrame()) ? this.buffer.rowsCount() : this.getBaseDataFrame().rowsCount();
    }

    @Override
    @NotNull
    public String takeColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.referredColumns.get(name);
        if (string == null) {
            DatasetBuilderImpl $this$takeColumn_u24lambda_u240 = this;
            boolean bl = false;
            DataColumn dataColumn = $this$takeColumn_u24lambda_u240.getBaseDataFrame().getColumnOrNull(name);
            if (dataColumn == null) {
                throw new IllegalStateException(("invalid column id: " + name).toString());
            }
            String columnId = $this$takeColumn_u24lambda_u240.addColumn(dataColumn);
            $this$takeColumn_u24lambda_u240.referredColumns.put(name, columnId);
            string = name;
        }
        return string;
    }

    @NotNull
    public final String takeColumn(@NotNull ColumnAccessor<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.takeColumn(column.name());
    }

    @NotNull
    public final String addColumn(@NotNull ColumnReference<?> column) {
        String string;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        ColumnReference<?> columnReference = column;
        if (columnReference instanceof ColumnAccessor) {
            string = this.takeColumn((ColumnAccessor)column);
        } else if (columnReference instanceof DataColumn) {
            string = this.addColumn((DataColumn)column);
        } else {
            throw new IllegalStateException(("Unexpected column reference type: " + Reflection.getOrCreateKotlinClass(column.getClass())).toString());
        }
        return string;
    }

    @NotNull
    public final String addColumn(@NotNull DataColumn<?> column) {
        String string;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (this.buffer.containsColumn(column.name())) {
            string = Intrinsics.areEqual((Object)this.buffer.get(column.name()), column) ? column.name() : this.addColumn(column.rename(column.name() + "*"));
        } else {
            BaseColumn[] baseColumnArray = new BaseColumn[]{column};
            this.buffer = AddKt.add(this.buffer, (BaseColumn[])baseColumnArray);
            string = column.name();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String addColumn(@NotNull List<?> values, @NotNull String name) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DataColumn.Companion companion = DataColumn.Companion;
        Infer infer$iv = Infer.Type;
        boolean $i$f$createValueColumn = false;
        String columnId = this.addColumn((DataColumn)DataColumn.Companion.createValueColumn$default((DataColumn.Companion)this_$iv, (String)name, values, (KType)Reflection.nullableTypeOf(Object.class), (Infer)infer$iv, null, (int)16, null));
        this.referredColumns.put(name, columnId);
        return columnId;
    }

    public DatasetBuilderImpl() {
        this(null, 1, null);
    }
}

