/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.kandy.dsl.internal.dataframe;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.GroupBy;
import org.jetbrains.kotlinx.dataframe.api.GroupByKt;
import org.jetbrains.kotlinx.kandy.dsl.internal.dataframe.ConcatFixedKt;
import org.jetbrains.kotlinx.kandy.dsl.internal.dataframe.NamedData;
import org.jetbrains.kotlinx.kandy.ir.data.TableData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nB\u001f\u0012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\f\b\u0002\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/GroupedData;", "Lorg/jetbrains/kotlinx/kandy/ir/data/TableData;", "origin", "Lorg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/NamedData;", "keys", "", "", "(Lorg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/NamedData;Ljava/util/List;)V", "groupBy", "Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", "(Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;)V", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Ljava/util/List;)V", "getDataFrame", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "getGroupBy", "()Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", "getKeys", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kandy-api"})
@SourceDebugExtension(value={"SMAP\nGroupedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupedData.kt\norg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/GroupedData\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n37#2,2:47\n*S KotlinDebug\n*F\n+ 1 GroupedData.kt\norg/jetbrains/kotlinx/kandy/dsl/internal/dataframe/GroupedData\n*L\n26#1:47,2\n*E\n"})
public final class GroupedData
implements TableData {
    @NotNull
    private final DataFrame<?> dataFrame;
    @NotNull
    private final List<String> keys;

    public GroupedData(@NotNull DataFrame<?> dataFrame, @NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.dataFrame = dataFrame;
        this.keys = keys;
    }

    @NotNull
    public final DataFrame<?> getDataFrame() {
        return this.dataFrame;
    }

    @NotNull
    public final List<String> getKeys() {
        return this.keys;
    }

    @NotNull
    public final GroupBy<?, ?> getGroupBy() {
        Collection $this$toTypedArray$iv = this.keys;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return GroupByKt.groupBy(this.dataFrame, (String[])Arrays.copyOf(stringArray, stringArray.length));
    }

    public GroupedData(@NotNull NamedData origin, @NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this(origin.getDataFrame(), keys);
    }

    public GroupedData(@NotNull GroupBy<?, ?> groupBy) {
        Intrinsics.checkNotNullParameter(groupBy, (String)"groupBy");
        this(ConcatFixedKt.concatFixed(groupBy), (List<String>)groupBy.getKeys().columnNames());
    }

    @NotNull
    public final DataFrame<?> component1() {
        return this.dataFrame;
    }

    @NotNull
    public final List<String> component2() {
        return this.keys;
    }

    @NotNull
    public final GroupedData copy(@NotNull DataFrame<?> dataFrame, @NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        return new GroupedData(dataFrame, keys);
    }

    public static /* synthetic */ GroupedData copy$default(GroupedData groupedData, DataFrame dataFrame, List list, int n, Object object) {
        if ((n & 1) != 0) {
            dataFrame = groupedData.dataFrame;
        }
        if ((n & 2) != 0) {
            list = groupedData.keys;
        }
        return groupedData.copy(dataFrame, list);
    }

    @NotNull
    public String toString() {
        return "GroupedData(dataFrame=" + this.dataFrame + ", keys=" + this.keys + ")";
    }

    public int hashCode() {
        int result = this.dataFrame.hashCode();
        result = result * 31 + ((Object)this.keys).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GroupedData)) {
            return false;
        }
        GroupedData groupedData = (GroupedData)other;
        if (!Intrinsics.areEqual(this.dataFrame, groupedData.dataFrame)) {
            return false;
        }
        return Intrinsics.areEqual(this.keys, groupedData.keys);
    }
}

