/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.kandy.util.color;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.kandy.util.color.Color;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\u0006\u0007\b\t\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor;", "Lorg/jetbrains/kotlinx/kandy/util/color/Color;", "description", "", "getDescription", "()Ljava/lang/String;", "AsHexColor", "Hex", "Named", "RGB", "RGBA", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$AsHexColor;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Named;", "kandy-api"})
public interface StandardColor
extends Color {
    @NotNull
    public String getDescription();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u0082\u0001\u0003\u0007\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$AsHexColor;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor;", "description", "", "getDescription", "()Ljava/lang/String;", "hex", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "getHex", "()Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "hexString", "getHexString", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGB;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGBA;", "kandy-api"})
    public static interface AsHexColor
    extends StandardColor {
        @NotNull
        public Hex getHex();

        @NotNull
        public String getHexString();

        @Override
        @NotNull
        public String getDescription();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static String getHexString(@NotNull AsHexColor $this) {
                return $this.getHex().getHexString();
            }

            @NotNull
            public static String getDescription(@NotNull AsHexColor $this) {
                return $this.getHexString();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$AsHexColor;", "hexString", "", "(Ljava/lang/String;)V", "hex", "getHex", "()Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "getHexString", "()Ljava/lang/String;", "compareTo", "", "other", "Lorg/jetbrains/kotlinx/kandy/util/color/Color;", "component1", "copy", "equals", "", "", "hashCode", "toString", "kandy-api"})
    public static final class Hex
    implements AsHexColor {
        @NotNull
        private final String hexString;
        @NotNull
        private final Hex hex;

        public Hex(@NotNull String hexString) {
            Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
            this.hexString = hexString;
            this.hex = this;
            CharSequence charSequence = this.getHexString();
            if (!new Regex("^#([a-fA-F0-9]{3}|[a-fA-F0-9]{4}|[a-fA-F0-9]{6}|[a-fA-F0-9]{8})$").matches(charSequence)) {
                boolean bl = false;
                String string = "Invalid hex string format: '" + this.getHexString() + "'. A valid hex string must start with '#' followed by either 6 or 8 hexadecimal characters.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public String getHexString() {
            return this.hexString;
        }

        @Override
        @NotNull
        public Hex getHex() {
            return this.hex;
        }

        @Override
        public int compareTo(@NotNull Color other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return 1;
        }

        @Override
        @NotNull
        public String getDescription() {
            return AsHexColor.DefaultImpls.getDescription(this);
        }

        @NotNull
        public final String component1() {
            return this.hexString;
        }

        @NotNull
        public final Hex copy(@NotNull String hexString) {
            Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
            return new Hex(hexString);
        }

        public static /* synthetic */ Hex copy$default(Hex hex2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = hex2.hexString;
            }
            return hex2.copy(string);
        }

        @NotNull
        public String toString() {
            return "Hex(hexString=" + this.hexString + ")";
        }

        public int hashCode() {
            return this.hexString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Hex)) {
                return false;
            }
            Hex hex2 = (Hex)other;
            return Intrinsics.areEqual((Object)this.hexString, (Object)hex2.hexString);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Named;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor;", "name", "", "(Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "getName", "compareTo", "", "other", "Lorg/jetbrains/kotlinx/kandy/util/color/Color;", "component1", "copy", "equals", "", "", "hashCode", "toString", "kandy-api"})
    public static final class Named
    implements StandardColor {
        @NotNull
        private final String name;

        public Named(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            if (!(((CharSequence)this.name).length() > 0)) {
                boolean bl = false;
                String string = "Name property in `StandardColor.Named` must not be empty. Please provide a valid color name.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.name;
        }

        @Override
        public int compareTo(@NotNull Color other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return 1;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Named copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Named(name);
        }

        public static /* synthetic */ Named copy$default(Named named, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = named.name;
            }
            return named.copy(string);
        }

        @NotNull
        public String toString() {
            return "Named(name=" + this.name + ")";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Named)) {
                return false;
            }
            Named named = (Named)other;
            return Intrinsics.areEqual((Object)this.name, (Object)named.name);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGB;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$AsHexColor;", "r", "", "g", "b", "(III)V", "getB", "()I", "getG", "hex", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "getHex", "()Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "hex$delegate", "Lkotlin/Lazy;", "getR", "compareTo", "other", "Lorg/jetbrains/kotlinx/kandy/util/color/Color;", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toRGBA", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGBA;", "a", "", "toString", "", "kandy-api"})
    public static final class RGB
    implements AsHexColor {
        private final int r;
        private final int g;
        private final int b;
        @NotNull
        private final Lazy hex$delegate;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.hex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Hex>(this){
                final /* synthetic */ RGB this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Hex invoke() {
                    String string = "#%02X%02X%02X";
                    Object[] objectArray = new Object[]{this.this$0.getR(), this.this$0.getG(), this.this$0.getB()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return new Hex(string2);
                }
            }));
            int n = this.r;
            boolean bl = 0 <= n ? n < 256 : false;
            if (bl) {
                n = this.g;
                boolean bl2 = 0 <= n ? n < 256 : false;
                if (bl2) {
                    boolean bl3;
                    n = this.b;
                    if (0 <= n) {
                        if (n < 256) {
                            return;
                        }
                        bl3 = false;
                    } else {
                        bl3 = false;
                    }
                    if (bl3) {
                        return;
                    }
                }
            }
            boolean bl4 = false;
            if (bl4) return;
            boolean bl5 = false;
            String string = "RGB components must be in the range of 0 to 255. Received: r=" + this.r + ", g=" + this.g + ", b=" + this.b;
            throw new IllegalArgumentException(string.toString());
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        @NotNull
        public final RGBA toRGBA(double a) {
            return new RGBA(RGB.copy$default(this, 0, 0, 0, 7, null), a);
        }

        public static /* synthetic */ RGBA toRGBA$default(RGB rGB, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = 1.0;
            }
            return rGB.toRGBA(d);
        }

        @Override
        @NotNull
        public Hex getHex() {
            Lazy lazy = this.hex$delegate;
            return (Hex)lazy.getValue();
        }

        @Override
        public int compareTo(@NotNull Color other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return 1;
        }

        @Override
        @NotNull
        public String getHexString() {
            return AsHexColor.DefaultImpls.getHexString(this);
        }

        @Override
        @NotNull
        public String getDescription() {
            return AsHexColor.DefaultImpls.getDescription(this);
        }

        public final int component1() {
            return this.r;
        }

        public final int component2() {
            return this.g;
        }

        public final int component3() {
            return this.b;
        }

        @NotNull
        public final RGB copy(int r, int g, int b) {
            return new RGB(r, g, b);
        }

        public static /* synthetic */ RGB copy$default(RGB rGB, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = rGB.r;
            }
            if ((n4 & 2) != 0) {
                n2 = rGB.g;
            }
            if ((n4 & 4) != 0) {
                n3 = rGB.b;
            }
            return rGB.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "RGB(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.r);
            result = result * 31 + Integer.hashCode(this.g);
            result = result * 31 + Integer.hashCode(this.b);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RGB)) {
                return false;
            }
            RGB rGB = (RGB)other;
            if (this.r != rGB.r) {
                return false;
            }
            if (this.g != rGB.g) {
                return false;
            }
            return this.b == rGB.b;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGBA;", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$AsHexColor;", "rgb", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGB;", "a", "", "(Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGB;D)V", "getA", "()D", "hex", "Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "getHex", "()Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$Hex;", "hex$delegate", "Lkotlin/Lazy;", "getRgb", "()Lorg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGB;", "compareTo", "", "other", "Lorg/jetbrains/kotlinx/kandy/util/color/Color;", "component1", "component2", "copy", "equals", "", "", "hashCode", "toRGB", "toString", "", "kandy-api"})
    @SourceDebugExtension(value={"SMAP\nStandardColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardColor.kt\norg/jetbrains/kotlinx/kandy/util/color/StandardColor$RGBA\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    public static final class RGBA
    implements AsHexColor {
        @NotNull
        private final RGB rgb;
        private final double a;
        @NotNull
        private final Lazy hex$delegate;

        public RGBA(@NotNull RGB rgb, double a) {
            Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
            this.rgb = rgb;
            this.a = a;
            this.hex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Hex>(this){
                final /* synthetic */ RGBA this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Hex invoke() {
                    StringBuilder stringBuilder;
                    RGBA rGBA = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.append(rGBA.getRgb().getHexString());
                    String string = Integer.toString(MathKt.roundToInt((double)(rGBA.getA() * (double)255)) | 0, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    $this$invoke_u24lambda_u240.append(string);
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String string3 = string2;
                    return new Hex(string3);
                }
            }));
            double d = this.a;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl = false;
                String string = "Alpha component must be in the range of 0.0 to 1.0. Received: a=" + this.a;
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final RGB getRgb() {
            return this.rgb;
        }

        public final double getA() {
            return this.a;
        }

        @NotNull
        public final RGB toRGB() {
            return RGB.copy$default(this.rgb, 0, 0, 0, 7, null);
        }

        @Override
        @NotNull
        public Hex getHex() {
            Lazy lazy = this.hex$delegate;
            return (Hex)lazy.getValue();
        }

        @Override
        public int compareTo(@NotNull Color other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return 1;
        }

        @Override
        @NotNull
        public String getHexString() {
            return AsHexColor.DefaultImpls.getHexString(this);
        }

        @Override
        @NotNull
        public String getDescription() {
            return AsHexColor.DefaultImpls.getDescription(this);
        }

        @NotNull
        public final RGB component1() {
            return this.rgb;
        }

        public final double component2() {
            return this.a;
        }

        @NotNull
        public final RGBA copy(@NotNull RGB rgb, double a) {
            Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
            return new RGBA(rgb, a);
        }

        public static /* synthetic */ RGBA copy$default(RGBA rGBA, RGB rGB, double d, int n, Object object) {
            if ((n & 1) != 0) {
                rGB = rGBA.rgb;
            }
            if ((n & 2) != 0) {
                d = rGBA.a;
            }
            return rGBA.copy(rGB, d);
        }

        @NotNull
        public String toString() {
            return "RGBA(rgb=" + this.rgb + ", a=" + this.a + ")";
        }

        public int hashCode() {
            int result = this.rgb.hashCode();
            result = result * 31 + Double.hashCode(this.a);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RGBA)) {
                return false;
            }
            RGBA rGBA = (RGBA)other;
            if (!Intrinsics.areEqual((Object)this.rgb, (Object)rGBA.rgb)) {
                return false;
            }
            return Double.compare(this.a, rGBA.a) == 0;
        }
    }
}

