/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.kandy.letsplot.translator;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.kandy.dsl.internal.dataframe.GroupedData;
import org.jetbrains.kotlinx.kandy.dsl.internal.dataframe.NamedData;
import org.jetbrains.kotlinx.kandy.ir.Layer;
import org.jetbrains.kotlinx.kandy.ir.Plot;
import org.jetbrains.kotlinx.kandy.ir.aes.Aes;
import org.jetbrains.kotlinx.kandy.ir.bindings.Mapping;
import org.jetbrains.kotlinx.kandy.ir.bindings.MappingParameters;
import org.jetbrains.kotlinx.kandy.ir.data.TableData;
import org.jetbrains.kotlinx.kandy.ir.scale.FreeScale;
import org.jetbrains.kotlinx.kandy.letsplot.data.GeoSpatialData;
import org.jetbrains.kotlinx.kandy.letsplot.internal.LetsPlotPositionalMappingParameters;
import org.jetbrains.kotlinx.kandy.letsplot.scales.guide.model.Axis;
import org.jetbrains.kotlinx.kandy.letsplot.settings.LineType;
import org.jetbrains.kotlinx.kandy.letsplot.settings.Symbol;
import org.jetbrains.kotlinx.kandy.letsplot.util.SimpleValueWrapper;
import org.jetbrains.kotlinx.kandy.util.color.Color;
import org.jetbrains.kotlinx.kandy.util.color.StandardColor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u001c\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004*\u00020\u0007H\u0000\u001a\u001c\u0010\b\u001a\u00020\t*\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\nH\u0000\u001a*\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\n*\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\nH\u0000\u001a\u0010\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e*\u00020\u000fH\u0000\u001a\"\u0010\u0010\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u0006H\u0000\u001a(\u0010\u0012\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\n*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\nH\u0000\u001a \u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\n*\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0014*\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"wrapValue", "", "value", "axes", "", "Lorg/jetbrains/kotlinx/kandy/ir/aes/Aes;", "Lorg/jetbrains/kotlinx/kandy/letsplot/scales/guide/model/Axis;", "Lorg/jetbrains/kotlinx/kandy/ir/Plot;", "bothNull", "", "Lkotlin/Pair;", "computeRange", "", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/kandy/ir/data/TableData;", "limits", "", "wrap", "Lkotlin/ranges/ClosedRange;", "", "Lorg/jetbrains/kotlinx/kandy/util/color/Color;", "kandy-lets-plot"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/jetbrains/kotlinx/kandy/letsplot/translator/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,108:1\n1#2:109\n1863#3:110\n1864#3:115\n216#4,2:111\n216#4,2:113\n216#4,2:116\n216#4,2:118\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/jetbrains/kotlinx/kandy/letsplot/translator/UtilKt\n*L\n76#1:110\n76#1:115\n77#1:111,2\n82#1:113,2\n88#1:116,2\n93#1:118,2\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final DataFrame<?> dataFrame(@NotNull TableData $this$dataFrame) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter((Object)$this$dataFrame, (String)"<this>");
        TableData tableData = $this$dataFrame;
        if (tableData instanceof NamedData) {
            dataFrame = ((NamedData)$this$dataFrame).getDataFrame();
        } else if (tableData instanceof GroupedData) {
            dataFrame = ((GroupedData)$this$dataFrame).getDataFrame();
        } else if (tableData instanceof GeoSpatialData) {
            dataFrame = ((GeoSpatialData)$this$dataFrame).getDataFrame();
        } else {
            throw new IllegalStateException(("Unexpected data format: " + Reflection.getOrCreateKotlinClass($this$dataFrame.getClass())).toString());
        }
        return dataFrame;
    }

    @NotNull
    public static final String wrap(@NotNull Color $this$wrap) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$wrap, (String)"<this>");
        Color color2 = $this$wrap;
        if (color2 instanceof StandardColor.Hex) {
            string = ((StandardColor.Hex)$this$wrap).getHexString();
        } else if (color2 instanceof StandardColor.Named) {
            string = ((StandardColor.Named)$this$wrap).getName();
        } else if (color2 instanceof StandardColor.RGB) {
            string = ((StandardColor.RGB)$this$wrap).getHexString();
        } else {
            if (color2 instanceof StandardColor.RGBA) {
                throw new IllegalStateException("RGBA color not supported".toString());
            }
            throw new IllegalStateException(("Unexpected color type: " + Reflection.getOrCreateKotlinClass($this$wrap.getClass())).toString());
        }
        return string;
    }

    @Nullable
    public static final Object wrapValue(@Nullable Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).toString();
        }
        if (value instanceof SimpleValueWrapper) {
            return ((SimpleValueWrapper)value).getValue();
        }
        if (value instanceof Color) {
            return UtilKt.wrap((Color)value);
        }
        if (value instanceof Symbol) {
            return ((Symbol)value).getShape();
        }
        if (value instanceof LineType) {
            return ((LineType)value).getDescription();
        }
        return value;
    }

    @Nullable
    public static final Pair<Number, Number> wrap(@Nullable ClosedRange<?> $this$wrap) {
        Pair pair;
        ClosedRange<?> closedRange = $this$wrap;
        if (closedRange != null) {
            ClosedRange<?> it = closedRange;
            boolean bl = false;
            Comparable comparable = it.getStart();
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Number");
            Number number = (Number)((Object)comparable);
            Comparable comparable2 = it.getEndInclusive();
            Intrinsics.checkNotNull((Object)comparable2, (String)"null cannot be cast to non-null type kotlin.Number");
            pair = TuplesKt.to((Object)number, (Object)((Number)((Object)comparable2)));
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public static final Pair<Number, Number> wrap(@Nullable Pair<?, ?> $this$wrap) {
        Pair pair;
        Pair<?, ?> pair2 = $this$wrap;
        if (pair2 != null) {
            Pair<?, ?> it = pair2;
            boolean bl = false;
            Object object = it.getFirst();
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            object = it.getSecond();
            pair = TuplesKt.to((Object)number, (Object)(object instanceof Number ? (Number)((Number)object) : (Number)null));
        } else {
            pair = null;
        }
        return pair;
    }

    public static final boolean bothNull(@NotNull Pair<? extends Object, ? extends Object> $this$bothNull) {
        Intrinsics.checkNotNullParameter($this$bothNull, (String)"<this>");
        return $this$bothNull.getFirst() == null && $this$bothNull.getSecond() == null;
    }

    @Nullable
    public static final Pair<Double, Double> computeRange(@NotNull Pair<? extends Object, ? extends Object> $this$computeRange) {
        Pair pair;
        Intrinsics.checkNotNullParameter($this$computeRange, (String)"<this>");
        if ($this$computeRange.getFirst() == null && $this$computeRange.getSecond() == null) {
            pair = null;
        } else if ($this$computeRange.getSecond() == null && $this$computeRange.getFirst() instanceof Double) {
            Object object = $this$computeRange.getFirst();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            double it = ((Number)((Double)object)).doubleValue();
            boolean bl = false;
            pair = TuplesKt.to((Object)it, (Object)(it + 7.0));
        } else if ($this$computeRange.getFirst() == null && $this$computeRange.getSecond() instanceof Double) {
            Object object = $this$computeRange.getSecond();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            double it = ((Number)((Double)object)).doubleValue();
            boolean bl = false;
            pair = TuplesKt.to((Object)RangesKt.coerceAtLeast((double)(it - 7.0), (double)0.2), (Object)it);
        } else {
            Object object = $this$computeRange.getFirst();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            Double d = (Double)object;
            Object object2 = $this$computeRange.getSecond();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Double");
            pair = TuplesKt.to((Object)d, (Object)((Double)object2));
        }
        return pair;
    }

    @NotNull
    public static final Map<Aes, Axis<?>> axes(@NotNull Plot $this$axes) {
        Object it;
        Aes aes;
        Object object;
        MappingParameters mappingParameters;
        Object element$iv;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)$this$axes, (String)"<this>");
        Map $this$axes_u24lambda_u2413 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        Object $this$forEach$iv = $this$axes.getLayers();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object it2;
            MappingParameters mappingParameters2;
            Aes aes2;
            Map.Entry entry;
            Map.Entry element$iv2;
            element$iv = iterator.next();
            Layer layer = (Layer)element$iv;
            boolean bl2 = false;
            Map $this$forEach$iv2 = layer.getMappings();
            boolean $i$f$forEach2 = false;
            mappingParameters = $this$forEach$iv2.entrySet().iterator();
            while (mappingParameters.hasNext()) {
                entry = element$iv2 = mappingParameters.next();
                boolean bl3 = false;
                aes2 = (Aes)entry.getKey();
                Mapping mapping = (Mapping)entry.getValue();
                mappingParameters2 = mapping.getParameters();
                Object object2 = mappingParameters2 instanceof LetsPlotPositionalMappingParameters ? (LetsPlotPositionalMappingParameters)mappingParameters2 : null;
                if (object2 == null || (object2 = object2.getAxis()) == null) continue;
                it2 = object2;
                boolean bl4 = false;
                $this$axes_u24lambda_u2413.put(aes2, it2);
            }
            $this$forEach$iv2 = layer.getFreeScales();
            $i$f$forEach2 = false;
            mappingParameters = $this$forEach$iv2.entrySet().iterator();
            while (mappingParameters.hasNext()) {
                entry = element$iv2 = (Map.Entry)mappingParameters.next();
                boolean bl5 = false;
                aes2 = (Aes)entry.getKey();
                FreeScale freeScale = (FreeScale)entry.getValue();
                mappingParameters2 = freeScale.getParameters();
                Object object3 = mappingParameters2 instanceof LetsPlotPositionalMappingParameters ? (LetsPlotPositionalMappingParameters)mappingParameters2 : null;
                if (object3 == null || (object3 = object3.getAxis()) == null) continue;
                it2 = object3;
                boolean bl6 = false;
                $this$axes_u24lambda_u2413.put(aes2, it2);
            }
        }
        $this$forEach$iv = $this$axes.getGlobalMappings();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            object = element$iv = (Map.Entry)iterator.next();
            boolean bl7 = false;
            aes = (Aes)object.getKey();
            Mapping mapping = (Mapping)object.getValue();
            mappingParameters = mapping.getParameters();
            Object object4 = mappingParameters instanceof LetsPlotPositionalMappingParameters ? (LetsPlotPositionalMappingParameters)mappingParameters : null;
            if (object4 == null || (object4 = object4.getAxis()) == null) continue;
            it = object4;
            boolean bl8 = false;
            $this$axes_u24lambda_u2413.put(aes, it);
        }
        $this$forEach$iv = $this$axes.getFreeScales();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            object = element$iv = (Map.Entry)iterator.next();
            boolean bl9 = false;
            aes = (Aes)object.getKey();
            FreeScale freeScale = (FreeScale)object.getValue();
            mappingParameters = freeScale.getParameters();
            Object object5 = mappingParameters instanceof LetsPlotPositionalMappingParameters ? (LetsPlotPositionalMappingParameters)mappingParameters : null;
            if (object5 == null || (object5 = object5.getAxis()) == null) continue;
            it = object5;
            boolean bl10 = false;
            $this$axes_u24lambda_u2413.put(aes, it);
        }
        return MapsKt.build((Map)map2);
    }

    @Nullable
    public static final Pair<Number, Number> limits(@NotNull Axis<?> $this$limits) {
        Intrinsics.checkNotNullParameter($this$limits, (String)"<this>");
        if ($this$limits.getMin() == null && $this$limits.getMax() == null) {
            return null;
        }
        return TuplesKt.to((Object)((Number)$this$limits.getMin()), (Object)((Number)$this$limits.getMax()));
    }
}

