/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.kandy.util.serialization;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\u0002\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tj\u0002`\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0010\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u000b2\u000e\u0010\u0012\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u00032\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tj\u0002`\u000f*\"\u0010\u0017\"\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a8\u0006\u0018"}, d2={"deserializeAny", "", "json", "Lkotlinx/serialization/json/JsonElement;", "deserializeList", "", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "deserializeMap", "", "", "Lkotlinx/serialization/json/JsonObject;", "deserializePrimitive", "Lkotlinx/serialization/json/JsonPrimitive;", "deserializeSpec", "Lorg/jetbrains/kotlinx/kandy/util/serialization/LetsPlotSpec;", "serialize", "list", "map", "serializeAny", "obj", "serializeSpec", "spec", "LetsPlotSpec", "kandy-util"})
@SourceDebugExtension(value={"SMAP\nspecSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 specSerialization.kt\norg/jetbrains/kotlinx/kandy/util/serialization/SpecSerializationKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n28#2,3:90\n31#2:94\n51#2,4:95\n1#3:93\n*S KotlinDebug\n*F\n+ 1 specSerialization.kt\norg/jetbrains/kotlinx/kandy/util/serialization/SpecSerializationKt\n*L\n28#1:90,3\n28#1:94\n37#1:95,4\n*E\n"})
public final class SpecSerializationKt {
    @NotNull
    public static final JsonElement serializeSpec(@NotNull Map<String, ? extends Object> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        return (JsonElement)SpecSerializationKt.serialize(spec);
    }

    private static final JsonElement serializeAny(Object obj) {
        JsonElement jsonElement;
        Object object = obj;
        if (object == null) {
            jsonElement = (JsonElement)JsonNull.INSTANCE;
        } else if (object instanceof Map) {
            jsonElement = (JsonElement)SpecSerializationKt.serialize((Map)obj);
        } else if (object instanceof List) {
            jsonElement = (JsonElement)SpecSerializationKt.serialize((List)obj);
        } else if (object instanceof String) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((String)((String)obj));
        } else if (object instanceof Boolean) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Boolean)((Boolean)obj));
        } else if (object instanceof Number) {
            jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)((Number)obj));
        } else {
            throw new IllegalStateException(("Don't know how to parse object [" + obj + "] of class " + Reflection.getOrCreateKotlinClass(obj.getClass())).toString());
        }
        return jsonElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonObject serialize(Map<?, ?> map) {
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$serialize_u24lambda_u241 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) {
                KClass kClass;
                Object obj = key;
                Object obj2 = key;
                if (obj2 != null) {
                    void it;
                    Object obj3 = obj2;
                    Object obj4 = obj;
                    boolean bl2 = false;
                    kClass = Reflection.getOrCreateKotlinClass(it.getClass());
                    obj = obj4;
                } else {
                    kClass = null;
                }
                String string = "Map key [" + obj + "] is of type " + kClass + ". Don't know how to serialize it.";
                throw new IllegalStateException(string.toString());
            }
            $this$serialize_u24lambda_u241.put((String)key, SpecSerializationKt.serializeAny(value));
        }
        return builder$iv.build();
    }

    private static final JsonArray serialize(List<?> list) {
        JsonArrayBuilder builder$iv;
        boolean $i$f$buildJsonArray = false;
        JsonArrayBuilder $this$serialize_u24lambda_u242 = builder$iv = new JsonArrayBuilder();
        boolean bl = false;
        for (Object value : list) {
            $this$serialize_u24lambda_u242.add(SpecSerializationKt.serializeAny(value));
        }
        return builder$iv.build();
    }

    @NotNull
    public static final Map<String, Object> deserializeSpec(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!(json instanceof JsonObject)) {
            throw new IllegalStateException(("LetsPlot spec should be a key-value object, but it's " + json).toString());
        }
        Map<String, Object> map = SpecSerializationKt.deserializeMap((JsonObject)json);
        for (Object value : map.values()) {
            if (value != null) continue;
            throw new IllegalStateException("LetsPlot spec shouldn't have null values on the top level".toString());
        }
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>{ org.jetbrains.kotlinx.kandy.util.serialization.SpecSerializationKt.LetsPlotSpec }");
        return map;
    }

    private static final Object deserializeAny(JsonElement json) {
        Object object;
        JsonElement jsonElement = json;
        if (jsonElement instanceof JsonObject) {
            object = SpecSerializationKt.deserializeMap((JsonObject)json);
        } else if (jsonElement instanceof JsonArray) {
            object = SpecSerializationKt.deserializeList((JsonArray)json);
        } else if (jsonElement instanceof JsonPrimitive) {
            object = SpecSerializationKt.deserializePrimitive((JsonPrimitive)json);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final Object deserializePrimitive(JsonPrimitive json) {
        Object object;
        if (json instanceof JsonNull) {
            object = null;
        } else if (json.isString()) {
            object = json.getContent();
        } else {
            object = JsonElementKt.getBooleanOrNull((JsonPrimitive)json);
            if (object == null && (object = JsonElementKt.getDoubleOrNull((JsonPrimitive)json)) == null) {
                throw new IllegalStateException(("Unknown JSON primitive type: [" + json + "]").toString());
            }
        }
        return object;
    }

    private static final Map<String, Object> deserializeMap(JsonObject json) {
        Map map;
        Map $this$deserializeMap_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Map.Entry entry : ((Map)json).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            $this$deserializeMap_u24lambda_u243.put(key, SpecSerializationKt.deserializeAny(value));
        }
        return MapsKt.build((Map)map);
    }

    private static final List<Object> deserializeList(JsonArray jsonArray) {
        List list;
        List $this$deserializeList_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (JsonElement el : jsonArray) {
            $this$deserializeList_u24lambda_u244.add(SpecSerializationKt.deserializeAny(el));
        }
        return CollectionsKt.build((List)list);
    }
}

