/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.DataBatch;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H$J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0006H&J\b\u0010\u0010\u001a\u00020\u0000H&J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0006H&\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/Dataset;", "", "()V", "batchIterator", "Lorg/jetbrains/kotlinx/dl/dataset/Dataset$BatchIterator;", "batchSize", "", "createDataBatch", "Lorg/jetbrains/kotlinx/dl/dataset/DataBatch;", "batchStart", "batchLength", "getX", "", "idx", "getY", "", "shuffle", "split", "Lkotlin/Pair;", "splitRatio", "", "xSize", "BatchIterator", "dataset"})
public abstract class Dataset {
    @NotNull
    public abstract Pair<Dataset, Dataset> split(double var1);

    public abstract int xSize();

    @NotNull
    public abstract float[] getX(int var1);

    public abstract float getY(int var1);

    @NotNull
    public abstract Dataset shuffle();

    @NotNull
    protected abstract DataBatch createDataBatch(int var1, int var2);

    @NotNull
    public final BatchIterator batchIterator(int batchSize) {
        return new BatchIterator(batchSize);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0007\u001a\u00020\bH\u0096\u0002J\t\u0010\t\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/Dataset$BatchIterator;", "", "Lorg/jetbrains/kotlinx/dl/dataset/DataBatch;", "batchSize", "", "(Lorg/jetbrains/kotlinx/dl/dataset/Dataset;I)V", "batchStart", "hasNext", "", "next", "dataset"})
    public final class BatchIterator
    implements Iterator<DataBatch>,
    KMappedMarker {
        private final int batchSize;
        private int batchStart;

        public BatchIterator(int batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public boolean hasNext() {
            return this.batchStart < Dataset.this.xSize();
        }

        @Override
        @NotNull
        public DataBatch next() {
            int batchLength = Math.min(this.batchSize, Dataset.this.xSize() - this.batchStart);
            DataBatch batch = Dataset.this.createDataBatch(this.batchStart, batchLength);
            this.batchStart += this.batchSize;
            return batch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

