/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.metric.Metrics;
import org.jetbrains.kotlinx.dl.api.inference.InferenceModel;
import org.jetbrains.kotlinx.dl.dataset.Dataset;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0003"}, d2={"evaluate", "", "Lorg/jetbrains/kotlinx/dl/api/inference/InferenceModel;", "dataset", "Lorg/jetbrains/kotlinx/dl/dataset/Dataset;", "metric", "Lorg/jetbrains/kotlinx/dl/api/core/metric/Metrics;", "predict", "", ""})
public final class InferenceModelExtensionsKt {
    @NotNull
    public static final List<Integer> predict(@NotNull InferenceModel $this$predict, @NotNull Dataset dataset) {
        Intrinsics.checkNotNullParameter((Object)$this$predict, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        List predictedLabels = new ArrayList();
        int n = dataset.xSize();
        for (int i = 0; i < n; ++i) {
            int predictedLabel = $this$predict.predict(dataset.getX(i));
            predictedLabels.add(predictedLabel);
        }
        return predictedLabels;
    }

    public static final double evaluate(@NotNull InferenceModel $this$evaluate, @NotNull Dataset dataset, @NotNull Metrics metric) {
        double d;
        Intrinsics.checkNotNullParameter((Object)$this$evaluate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dataset, (String)"dataset");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        if (metric == Metrics.ACCURACY) {
            int counter = 0;
            int n = dataset.xSize();
            for (int i = 0; i < n; ++i) {
                int predictedLabel = $this$evaluate.predict(dataset.getX(i));
                if (predictedLabel != (int)dataset.getY(i)) continue;
                ++counter;
            }
            d = (double)counter / (double)dataset.xSize();
        } else {
            d = Double.NaN;
        }
        return d;
    }
}

