/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.preprocessing.Operation;
import org.jetbrains.kotlinx.dl.dataset.DataBatch;
import org.jetbrains.kotlinx.dl.dataset.DataLoader;
import org.jetbrains.kotlinx.dl.dataset.Dataset;
import org.jetbrains.kotlinx.dl.dataset.OnHeapDataset;
import org.jetbrains.kotlinx.dl.dataset.generator.LabelGenerator;
import org.jetbrains.kotlinx.dl.dataset.preprocessing.PreprocessingDataLoaderKt;
import org.jetbrains.kotlinx.dl.impl.preprocessing.image.ConvertToFloatArray;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 B+\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J1\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J(\u0010\u001b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/OnFlyImageDataset;", "D", "Lorg/jetbrains/kotlinx/dl/dataset/Dataset;", "x", "", "y", "", "dataLoader", "Lorg/jetbrains/kotlinx/dl/dataset/DataLoader;", "([Ljava/lang/Object;[FLorg/jetbrains/kotlinx/dl/dataset/DataLoader;)V", "[Ljava/lang/Object;", "copyLabelsToBatch", "src", "start", "", "length", "copySourcesToBatch", "([Ljava/lang/Object;II)[[F", "createDataBatch", "Lorg/jetbrains/kotlinx/dl/dataset/DataBatch;", "batchStart", "batchLength", "getX", "idx", "getY", "", "shuffle", "split", "Lkotlin/Pair;", "splitRatio", "", "xSize", "Companion", "dataset"})
@SourceDebugExtension(value={"SMAP\nOnFlyImageDataset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnFlyImageDataset.kt\norg/jetbrains/kotlinx/dl/dataset/OnFlyImageDataset\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class OnFlyImageDataset<D>
extends Dataset {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final D[] x;
    @NotNull
    private final float[] y;
    @NotNull
    private final DataLoader<D> dataLoader;

    public OnFlyImageDataset(@NotNull D[] x, @NotNull float[] y, @NotNull DataLoader<D> dataLoader) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter(dataLoader, (String)"dataLoader");
        this.x = x;
        this.y = y;
        this.dataLoader = dataLoader;
    }

    private final float[][] copySourcesToBatch(D[] src, int start, int length) {
        int n = 0;
        float[][] fArrayArray = new float[length][];
        while (n < length) {
            int n2 = n++;
            fArrayArray[n2] = (float[])this.dataLoader.load(src[start + n2]).getFirst();
        }
        return fArrayArray;
    }

    private final float[] copyLabelsToBatch(float[] src, int start, int length) {
        int n = 0;
        float[] fArray = new float[length];
        while (n < length) {
            int n2 = n++;
            fArray[n2] = src[start + n2];
        }
        return fArray;
    }

    @NotNull
    public Pair<OnFlyImageDataset<D>, OnFlyImageDataset<D>> split(double splitRatio) {
        if (!(0.0 <= splitRatio ? splitRatio <= 1.0 : false)) {
            boolean $i$a$-require-OnFlyImageDataset$split$22 = false;
            String $i$a$-require-OnFlyImageDataset$split$22 = "'Split ratio' argument value must be in range [0.0; 1.0].";
            throw new IllegalArgumentException($i$a$-require-OnFlyImageDataset$split$22.toString());
        }
        int trainDatasetLastIndex = (int)MathKt.truncate((double)((double)this.x.length * splitRatio));
        Object[] objectArray = this.x;
        int n = 0;
        Object[] objectArray2 = ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)trainDatasetLastIndex);
        objectArray = this.y;
        n = 0;
        OnFlyImageDataset<Object> train = new OnFlyImageDataset<Object>(objectArray2, ArraysKt.copyOfRange((float[])objectArray, (int)n, (int)trainDatasetLastIndex), this.dataLoader);
        Object[] objectArray3 = this.x;
        int n2 = this.x.length;
        Object[] objectArray4 = ArraysKt.copyOfRange((Object[])objectArray3, (int)trainDatasetLastIndex, (int)n2);
        objectArray3 = this.y;
        n2 = this.y.length;
        OnFlyImageDataset<Object> test = new OnFlyImageDataset<Object>(objectArray4, ArraysKt.copyOfRange((float[])objectArray3, (int)trainDatasetLastIndex, (int)n2), this.dataLoader);
        return new Pair(train, test);
    }

    @Override
    public int xSize() {
        return this.x.length;
    }

    @Override
    @NotNull
    public float[] getX(int idx) {
        return (float[])this.dataLoader.load(this.x[idx]).getFirst();
    }

    @Override
    public float getY(int idx) {
        return this.y[idx];
    }

    @Override
    @NotNull
    public OnFlyImageDataset<D> shuffle() {
        ArraysKt.shuffle((Object[])this.x, (Random)RandomKt.Random((long)12L));
        ArraysKt.shuffle((float[])this.y, (Random)RandomKt.Random((long)12L));
        return this;
    }

    @Override
    @NotNull
    protected DataBatch createDataBatch(int batchStart, int batchLength) {
        return new DataBatch(this.copySourcesToBatch(this.x, batchStart, batchLength), this.copyLabelsToBatch(this.y, batchStart, batchLength), batchLength);
    }

    @JvmStatic
    @NotNull
    public static final float[] toOneHotVector(int numClasses, byte label) {
        return Companion.toOneHotVector(numClasses, label);
    }

    @JvmStatic
    @NotNull
    public static final float[] toNormalizedVector(@NotNull byte[] bytes) {
        return Companion.toNormalizedVector(bytes);
    }

    @JvmStatic
    @NotNull
    public static final float[] toRawVector(@NotNull byte[] bytes) {
        return Companion.toRawVector(bytes);
    }

    @JvmStatic
    @NotNull
    public static final OnFlyImageDataset<File> create(@NotNull File pathToData, @NotNull float[] labels, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
        return Companion.create(pathToData, labels, preprocessing);
    }

    @JvmStatic
    @NotNull
    public static final OnFlyImageDataset<File> create(@NotNull File pathToData, @NotNull LabelGenerator<File> labelGenerator, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
        return Companion.create(pathToData, labelGenerator, preprocessing);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2 \b\u0002\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0007JF\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2 \b\u0002\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/OnFlyImageDataset$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlinx/dl/dataset/OnFlyImageDataset;", "Ljava/io/File;", "pathToData", "labels", "", "preprocessing", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Ljava/awt/image/BufferedImage;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "labelGenerator", "Lorg/jetbrains/kotlinx/dl/dataset/generator/LabelGenerator;", "toNormalizedVector", "bytes", "", "toOneHotVector", "numClasses", "", "label", "", "toRawVector", "dataset"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final float[] toOneHotVector(int numClasses, byte label) {
            float[] ret = new float[numClasses];
            ret[label & 0xFF] = 1.0f;
            return ret;
        }

        @JvmStatic
        @NotNull
        public final float[] toNormalizedVector(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int n = 0;
            int n2 = bytes.length;
            float[] fArray = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray[n3] = (float)(bytes[n3] & 0xFF) / 255.0f;
            }
            return fArray;
        }

        @JvmStatic
        @NotNull
        public final float[] toRawVector(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int n = 0;
            int n2 = bytes.length;
            float[] fArray = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray[n3] = bytes[n3] & 0xFF;
            }
            return fArray;
        }

        @JvmStatic
        @NotNull
        public final OnFlyImageDataset<File> create(@NotNull File pathToData, @NotNull float[] labels, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pathToData, (String)"pathToData");
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            Intrinsics.checkNotNullParameter(preprocessing, (String)"preprocessing");
            return new OnFlyImageDataset<File>(OnHeapDataset.Companion.prepareFileNames$dataset(pathToData), labels, PreprocessingDataLoaderKt.fileLoader(preprocessing));
        }

        public static /* synthetic */ OnFlyImageDataset create$default(Companion companion, File file, float[] fArray, Operation operation, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                operation = (Operation)new ConvertToFloatArray();
            }
            return companion.create(file, fArray, (Operation<BufferedImage, Pair<float[], TensorShape>>)operation);
        }

        @JvmStatic
        @NotNull
        public final OnFlyImageDataset<File> create(@NotNull File pathToData, @NotNull LabelGenerator<File> labelGenerator, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pathToData, (String)"pathToData");
            Intrinsics.checkNotNullParameter(labelGenerator, (String)"labelGenerator");
            Intrinsics.checkNotNullParameter(preprocessing, (String)"preprocessing");
            File[] xFiles = OnHeapDataset.Companion.prepareFileNames$dataset(pathToData);
            float[] y = LabelGenerator.Companion.prepareY$dataset(labelGenerator, xFiles);
            return new OnFlyImageDataset<File>(xFiles, y, PreprocessingDataLoaderKt.fileLoader(preprocessing));
        }

        public static /* synthetic */ OnFlyImageDataset create$default(Companion companion, File file, LabelGenerator labelGenerator, Operation operation, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                operation = (Operation)new ConvertToFloatArray();
            }
            return companion.create(file, labelGenerator, (Operation<BufferedImage, Pair<float[], TensorShape>>)operation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

