/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.preprocessing.Operation;
import org.jetbrains.kotlinx.dl.dataset.DataBatch;
import org.jetbrains.kotlinx.dl.dataset.DataLoader;
import org.jetbrains.kotlinx.dl.dataset.Dataset;
import org.jetbrains.kotlinx.dl.dataset.OnHeapDataset;
import org.jetbrains.kotlinx.dl.dataset.generator.LabelGenerator;
import org.jetbrains.kotlinx.dl.dataset.preprocessing.PreprocessingDataLoaderKt;
import org.jetbrains.kotlinx.dl.impl.preprocessing.image.ConvertToFloatArray;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J1\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0014J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\n\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/OnHeapDataset;", "Lorg/jetbrains/kotlinx/dl/dataset/Dataset;", "x", "", "", "y", "([[F[F)V", "getX", "()[[F", "[[F", "getY", "()[F", "copyLabelsToBatch", "src", "start", "", "length", "copyXToBatch", "([[FII)[[F", "createDataBatch", "Lorg/jetbrains/kotlinx/dl/dataset/DataBatch;", "batchStart", "batchLength", "idx", "", "shuffle", "split", "Lkotlin/Pair;", "splitRatio", "", "xSize", "Companion", "dataset"})
@SourceDebugExtension(value={"SMAP\nOnHeapDataset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnHeapDataset.kt\norg/jetbrains/kotlinx/dl/dataset/OnHeapDataset\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1#2:232\n*E\n"})
public final class OnHeapDataset
extends Dataset {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[][] x;
    @NotNull
    private final float[] y;

    public OnHeapDataset(@NotNull float[][] x, @NotNull float[] y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.x = x;
        this.y = y;
    }

    @NotNull
    public final float[][] getX() {
        return this.x;
    }

    @NotNull
    public final float[] getY() {
        return this.y;
    }

    private final float[][] copyXToBatch(float[][] src, int start, int length) {
        int n = 0;
        float[][] fArrayArray = new float[length][];
        while (n < length) {
            int n2 = n++;
            float[] fArray = src[n2 + start];
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(fArray, fArray.length), (String)"copyOf(this, size)");
        }
        float[][] dataForBatch = fArrayArray;
        return dataForBatch;
    }

    private final float[] copyLabelsToBatch(float[] src, int start, int length) {
        int n = 0;
        float[] fArray = new float[length];
        while (n < length) {
            int n2 = n++;
            fArray[n2] = 0.0f;
        }
        float[] dataForBatch = fArray;
        int n3 = start + length;
        for (int i = start; i < n3; ++i) {
            dataForBatch[i - start] = src[i];
        }
        return dataForBatch;
    }

    @NotNull
    public Pair<OnHeapDataset, OnHeapDataset> split(double splitRatio) {
        if (!(0.0 <= splitRatio ? splitRatio <= 1.0 : false)) {
            boolean bl = false;
            String string = "'Split ratio' argument value must be in range [0.0; 1.0].";
            throw new IllegalArgumentException(string.toString());
        }
        int trainDatasetLastIndex = (int)MathKt.truncate((double)((double)((Object[])this.x).length * splitRatio));
        Object[] objectArray = (Object[])this.x;
        int n = 0;
        float[][] fArray = (float[][])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)trainDatasetLastIndex);
        objectArray = this.y;
        n = 0;
        OnHeapDataset onHeapDataset = new OnHeapDataset(fArray, ArraysKt.copyOfRange((float[])objectArray, (int)n, (int)trainDatasetLastIndex));
        objectArray = (Object[])this.x;
        n = ((Object[])this.x).length;
        float[][] fArray2 = (float[][])ArraysKt.copyOfRange((Object[])objectArray, (int)trainDatasetLastIndex, (int)n);
        objectArray = this.y;
        n = this.y.length;
        return new Pair((Object)onHeapDataset, (Object)new OnHeapDataset(fArray2, ArraysKt.copyOfRange((float[])objectArray, (int)trainDatasetLastIndex, (int)n)));
    }

    @Override
    public int xSize() {
        return ((Object[])this.x).length;
    }

    @Override
    @NotNull
    public float[] getX(int idx) {
        return this.x[idx];
    }

    @Override
    public float getY(int idx) {
        return this.y[idx];
    }

    @Override
    @NotNull
    public OnHeapDataset shuffle() {
        ArraysKt.shuffle((Object[])((Object[])this.x), (Random)RandomKt.Random((long)12L));
        ArraysKt.shuffle((float[])this.y, (Random)RandomKt.Random((long)12L));
        return this;
    }

    @Override
    @NotNull
    protected DataBatch createDataBatch(int batchStart, int batchLength) {
        return new DataBatch(this.copyXToBatch(this.x, batchStart, batchLength), this.copyLabelsToBatch(this.y, batchStart, batchLength), batchLength);
    }

    @JvmStatic
    @NotNull
    public static final float[] toOneHotVector(int numClasses, byte label) {
        return Companion.toOneHotVector(numClasses, label);
    }

    @JvmStatic
    public static final float convertByteToFloat(byte label) {
        return Companion.convertByteToFloat(label);
    }

    @JvmStatic
    @NotNull
    public static final Pair<OnHeapDataset, OnHeapDataset> createTrainAndTestDatasets(@NotNull String trainFeaturesPath, @NotNull String trainLabelsPath, @NotNull String testFeaturesPath, @NotNull String testLabelsPath, int numClasses, @NotNull Function1<? super String, float[][]> featuresExtractor, @NotNull Function2<? super String, ? super Integer, float[]> labelExtractor) {
        return Companion.createTrainAndTestDatasets(trainFeaturesPath, trainLabelsPath, testFeaturesPath, testLabelsPath, numClasses, featuresExtractor, labelExtractor);
    }

    @JvmStatic
    @NotNull
    public static final OnHeapDataset create(@NotNull String featuresPath, @NotNull String labelsPath, int numClasses, @NotNull Function1<? super String, float[][]> featuresExtractor, @NotNull Function2<? super String, ? super Integer, float[]> labelExtractor) {
        return Companion.create(featuresPath, labelsPath, numClasses, featuresExtractor, labelExtractor);
    }

    @JvmStatic
    @NotNull
    public static final OnHeapDataset create(@NotNull Function0<float[][]> featuresGenerator, @NotNull Function0<float[]> labelGenerator) {
        return Companion.create(featuresGenerator, labelGenerator);
    }

    @JvmStatic
    @NotNull
    public static final OnHeapDataset create(@NotNull float[][] features, @NotNull float[] labels) {
        return Companion.create(features, labels);
    }

    @JvmStatic
    @NotNull
    public static final OnHeapDataset create(@NotNull File pathToData, @NotNull float[] labels, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
        return Companion.create(pathToData, labels, preprocessing);
    }

    @JvmStatic
    @NotNull
    public static final OnHeapDataset create(@NotNull File pathToData, @NotNull LabelGenerator<File> labelGenerator, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
        return Companion.create(pathToData, labelGenerator, preprocessing);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J*\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0007J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u00140\u0012H\u0007J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162 \b\u0002\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u00140\u0012H\u0007J#\u0010\u0007\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0018JT\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\f0!H\u0007Jp\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\f0!H\u0007J\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b(\u0010)J\u0018\u0010*\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/OnHeapDataset$Companion;", "", "()V", "convertByteToFloat", "", "label", "", "create", "Lorg/jetbrains/kotlinx/dl/dataset/OnHeapDataset;", "featuresGenerator", "Lkotlin/Function0;", "", "", "labelGenerator", "pathToData", "Ljava/io/File;", "labels", "preprocessing", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Ljava/awt/image/BufferedImage;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "Lorg/jetbrains/kotlinx/dl/dataset/generator/LabelGenerator;", "features", "([[F[F)Lorg/jetbrains/kotlinx/dl/dataset/OnHeapDataset;", "featuresPath", "", "labelsPath", "numClasses", "", "featuresExtractor", "Lkotlin/Function1;", "labelExtractor", "Lkotlin/Function2;", "createTrainAndTestDatasets", "trainFeaturesPath", "trainLabelsPath", "testFeaturesPath", "testLabelsPath", "prepareFileNames", "prepareFileNames$dataset", "(Ljava/io/File;)[Ljava/io/File;", "toOneHotVector", "dataset"})
    @SourceDebugExtension(value={"SMAP\nOnHeapDataset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnHeapDataset.kt\norg/jetbrains/kotlinx/dl/dataset/OnHeapDataset$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,231:1\n1#2:232\n37#3,2:233\n*S KotlinDebug\n*F\n+ 1 OnHeapDataset.kt\norg/jetbrains/kotlinx/dl/dataset/OnHeapDataset$Companion\n*L\n225#1:233,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final float[] toOneHotVector(int numClasses, byte label) {
            float[] ret = new float[numClasses];
            ret[label & 0xFF] = 1.0f;
            return ret;
        }

        @JvmStatic
        public final float convertByteToFloat(byte label) {
            return label & 0xFF;
        }

        @JvmStatic
        @NotNull
        public final Pair<OnHeapDataset, OnHeapDataset> createTrainAndTestDatasets(@NotNull String trainFeaturesPath, @NotNull String trainLabelsPath, @NotNull String testFeaturesPath, @NotNull String testLabelsPath, int numClasses, @NotNull Function1<? super String, float[][]> featuresExtractor, @NotNull Function2<? super String, ? super Integer, float[]> labelExtractor) {
            Intrinsics.checkNotNullParameter((Object)trainFeaturesPath, (String)"trainFeaturesPath");
            Intrinsics.checkNotNullParameter((Object)trainLabelsPath, (String)"trainLabelsPath");
            Intrinsics.checkNotNullParameter((Object)testFeaturesPath, (String)"testFeaturesPath");
            Intrinsics.checkNotNullParameter((Object)testLabelsPath, (String)"testLabelsPath");
            Intrinsics.checkNotNullParameter(featuresExtractor, (String)"featuresExtractor");
            Intrinsics.checkNotNullParameter(labelExtractor, (String)"labelExtractor");
            float[][] xTrain = (float[][])featuresExtractor.invoke((Object)trainFeaturesPath);
            float[] yTrain = (float[])labelExtractor.invoke((Object)trainLabelsPath, (Object)numClasses);
            float[][] xTest = (float[][])featuresExtractor.invoke((Object)testFeaturesPath);
            float[] yTest = (float[])labelExtractor.invoke((Object)testLabelsPath, (Object)numClasses);
            return TuplesKt.to((Object)new OnHeapDataset(xTrain, yTrain), (Object)new OnHeapDataset(xTest, yTest));
        }

        @JvmStatic
        @NotNull
        public final OnHeapDataset create(@NotNull String featuresPath, @NotNull String labelsPath, int numClasses, @NotNull Function1<? super String, float[][]> featuresExtractor, @NotNull Function2<? super String, ? super Integer, float[]> labelExtractor) {
            Intrinsics.checkNotNullParameter((Object)featuresPath, (String)"featuresPath");
            Intrinsics.checkNotNullParameter((Object)labelsPath, (String)"labelsPath");
            Intrinsics.checkNotNullParameter(featuresExtractor, (String)"featuresExtractor");
            Intrinsics.checkNotNullParameter(labelExtractor, (String)"labelExtractor");
            float[][] features = (float[][])featuresExtractor.invoke((Object)featuresPath);
            float[] labels = (float[])labelExtractor.invoke((Object)labelsPath, (Object)numClasses);
            if (!(((Object[])features).length == labels.length)) {
                boolean bl = false;
                String string = "The amount of labels is not equal to the amount of images.";
                throw new IllegalStateException(string.toString());
            }
            return new OnHeapDataset(features, labels);
        }

        @JvmStatic
        @NotNull
        public final OnHeapDataset create(@NotNull Function0<float[][]> featuresGenerator, @NotNull Function0<float[]> labelGenerator) {
            Intrinsics.checkNotNullParameter(featuresGenerator, (String)"featuresGenerator");
            Intrinsics.checkNotNullParameter(labelGenerator, (String)"labelGenerator");
            float[][] features = (float[][])featuresGenerator.invoke();
            float[] labels = (float[])labelGenerator.invoke();
            if (!(((Object[])features).length == labels.length)) {
                boolean bl = false;
                String string = "The amount of labels is not equal to the amount of images.";
                throw new IllegalStateException(string.toString());
            }
            return new OnHeapDataset(features, labels);
        }

        @JvmStatic
        @NotNull
        public final OnHeapDataset create(@NotNull float[][] features, @NotNull float[] labels) {
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            if (!(((Object[])features).length == labels.length)) {
                boolean bl = false;
                String string = "The amount of labels is not equal to the amount of images.";
                throw new IllegalStateException(string.toString());
            }
            return new OnHeapDataset(features, labels);
        }

        @JvmStatic
        @NotNull
        public final OnHeapDataset create(@NotNull File pathToData, @NotNull float[] labels, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pathToData, (String)"pathToData");
            Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
            Intrinsics.checkNotNullParameter(preprocessing, (String)"preprocessing");
            File[] xFiles = this.prepareFileNames$dataset(pathToData);
            float[][] x = DataLoader.Companion.prepareX$dataset(PreprocessingDataLoaderKt.fileLoader(preprocessing), xFiles);
            return new OnHeapDataset(x, labels);
        }

        @JvmStatic
        @NotNull
        public final OnHeapDataset create(@NotNull File pathToData, @NotNull LabelGenerator<File> labelGenerator, @NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pathToData, (String)"pathToData");
            Intrinsics.checkNotNullParameter(labelGenerator, (String)"labelGenerator");
            Intrinsics.checkNotNullParameter(preprocessing, (String)"preprocessing");
            File[] xFiles = this.prepareFileNames$dataset(pathToData);
            float[][] x = DataLoader.Companion.prepareX$dataset(PreprocessingDataLoaderKt.fileLoader(preprocessing), xFiles);
            float[] y = LabelGenerator.Companion.prepareY$dataset(labelGenerator, xFiles);
            return new OnHeapDataset(x, y);
        }

        public static /* synthetic */ OnHeapDataset create$default(Companion companion, File file, LabelGenerator labelGenerator, Operation operation, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                operation = (Operation)new ConvertToFloatArray();
            }
            return companion.create(file, labelGenerator, (Operation<BufferedImage, Pair<float[], TensorShape>>)operation);
        }

        @NotNull
        public final File[] prepareFileNames$dataset(@NotNull File pathToData) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pathToData, (String)"pathToData");
            Stream<File> stream = Files.walk(pathToData.toPath(), new FileVisitOption[0]).filter(arg_0 -> Companion.prepareFileNames$lambda$3(prepareFileNames.1.INSTANCE, arg_0)).filter(arg_0 -> Companion.prepareFileNames$lambda$4(prepareFileNames.2.INSTANCE, arg_0)).map(arg_0 -> Companion.prepareFileNames$lambda$5(prepareFileNames.3.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(pathToData.toPath()\u2026j: Path -> obj.toFile() }");
            Collection $this$toTypedArray$iv = StreamsKt.toList(stream);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new File[0]);
        }

        private static final boolean prepareFileNames$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean prepareFileNames$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final File prepareFileNames$lambda$5(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (File)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

