/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.audio.wav;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFileException;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFileFormat;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFileKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J+\u0010\u001c\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\"J\u0011\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/audio/wav/WavFile;", "Ljava/lang/AutoCloseable;", "file", "Ljava/io/File;", "bufferSize", "", "(Ljava/io/File;I)V", "buffer", "", "bufferPointer", "bytesRead", "format", "Lorg/jetbrains/kotlinx/dl/dataset/audio/wav/WavFileFormat;", "getFormat", "()Lorg/jetbrains/kotlinx/dl/dataset/audio/wav/WavFileFormat;", "frameCounter", "", "frames", "getFrames", "()J", "inputStream", "Ljava/io/FileInputStream;", "ioState", "Lorg/jetbrains/kotlinx/dl/dataset/audio/wav/WavFile$IOState;", "remainingFrames", "getRemainingFrames", "close", "", "readFrames", "returnBuffer", "", "", "count", "offset", "([[FII)I", "readRemainingFrames", "()[[F", "readSingleSample", "IOState", "dataset"})
public final class WavFile
implements AutoCloseable {
    private final int bufferSize;
    @NotNull
    private final WavFileFormat format;
    private final long frames;
    @NotNull
    private IOState ioState;
    @NotNull
    private final FileInputStream inputStream;
    @NotNull
    private final byte[] buffer;
    private int bufferPointer;
    private int bytesRead;
    private long frameCounter;

    public WavFile(@NotNull File file, int bufferSize) {
        WavFileFormat format;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.bufferSize = bufferSize;
        this.ioState = IOState.READING;
        this.inputStream = new FileInputStream(file);
        this.buffer = new byte[this.bufferSize];
        WavFileKt.access$readWavHeader(file, this.inputStream, this.buffer);
        long chunkSize = 0L;
        WavFileFormat fileFormatChunk = null;
        Long numFrames = null;
        while (true) {
            long numChunkBytes;
            this.bytesRead = this.inputStream.read(this.buffer, 0, 8);
            if (this.bytesRead != 8) {
                throw new WavFileException("Could not read chunk header");
            }
            long chunkID = WavFileKt.readLittleEndian(this.buffer, 0, 4);
            chunkSize = WavFileKt.readLittleEndian(this.buffer, 4, 4);
            long l = numChunkBytes = chunkSize % (long)2 == 1L ? chunkSize + 1L : chunkSize;
            if (chunkID == 544501094L) {
                this.bytesRead = this.inputStream.read(this.buffer, 0, 16);
                int compressionCode = (int)WavFileKt.readLittleEndian(this.buffer, 0, 2);
                if (compressionCode != 1) {
                    throw new WavFileException("Compression Code " + compressionCode + " not supported");
                }
                fileFormatChunk = new WavFileFormat(this.buffer);
                if ((numChunkBytes -= (long)16) <= 0L) continue;
                this.inputStream.skip(numChunkBytes);
                continue;
            }
            if (chunkID == 1635017060L) {
                WavFileFormat wavFileFormat = fileFormatChunk;
                if (wavFileFormat == null) {
                    throw new WavFileException("Data chunk found before Format chunk");
                }
                format = wavFileFormat;
                if (chunkSize % (long)format.getBlockAlign() != 0L) {
                    throw new WavFileException("Data chunk size is not multiple of Block Align");
                }
                break;
            }
            this.inputStream.skip(numChunkBytes);
        }
        numFrames = chunkSize / (long)format.getBlockAlign();
        WavFileFormat wavFileFormat = fileFormatChunk;
        if (wavFileFormat == null) {
            throw new WavFileException("Did not find a Format chunk");
        }
        this.format = wavFileFormat;
        this.frames = numFrames;
    }

    public /* synthetic */ WavFile(File file, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        this(file, n);
    }

    public final long getRemainingFrames() {
        return this.frames - this.frameCounter;
    }

    @NotNull
    public final WavFileFormat getFormat() {
        return this.format;
    }

    public final long getFrames() {
        return this.frames;
    }

    @Override
    public void close() {
        this.ioState = IOState.CLOSED;
        this.inputStream.close();
    }

    @NotNull
    public final float[][] readRemainingFrames() {
        long count = this.getRemainingFrames();
        if (count > Integer.MAX_VALUE) {
            throw new WavFileException("Cannot read more at once than array of size 2147483647");
        }
        int n = 0;
        int n2 = this.format.getNumChannels();
        float[][] fArrayArray = new float[n2][];
        while (n < n2) {
            int n3 = n++;
            fArrayArray[n3] = new float[(int)count];
        }
        float[][] buffer = fArrayArray;
        int readCount = WavFile.readFrames$default(this, buffer, (int)count, 0, 4, null);
        if (!(readCount == (int)count)) {
            boolean bl = false;
            String string = "Internal error: Should read all remaining data from wav file.";
            throw new IllegalStateException(string.toString());
        }
        return buffer;
    }

    public final int readFrames(@NotNull float[][] returnBuffer, int count, int offset) {
        Intrinsics.checkNotNullParameter((Object)returnBuffer, (String)"returnBuffer");
        int myOffset = offset;
        if (this.ioState != IOState.READING) {
            throw new IOException("Cannot read from closed WavFile instance");
        }
        for (int f = 0; f < count; ++f) {
            if (this.frameCounter == this.frames) {
                return f;
            }
            int n = this.format.getNumChannels();
            for (int c = 0; c < n; ++c) {
                returnBuffer[c][myOffset] = this.format.getFloatOffset() + (float)this.readSingleSample() / this.format.getFloatScale();
            }
            ++myOffset;
            long l = this.frameCounter;
            this.frameCounter = l + 1L;
        }
        return count;
    }

    public static /* synthetic */ int readFrames$default(WavFile wavFile, float[][] fArray, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return wavFile.readFrames(fArray, n, n2);
    }

    private final long readSingleSample() {
        long resultSample = 0L;
        int n = this.format.getBytesPerSample();
        for (int b = 0; b < n; ++b) {
            if (this.bufferPointer == this.bytesRead) {
                int read = this.inputStream.read(this.buffer, 0, this.bufferSize);
                if (read == -1) {
                    throw new WavFileException("Not enough data available");
                }
                this.bytesRead = read;
                this.bufferPointer = 0;
            }
            long v = this.buffer[this.bufferPointer];
            if (b < this.format.getBytesPerSample() - 1 || this.format.getBytesPerSample() == 1) {
                v &= 0xFFL;
            }
            resultSample += v << b * 8;
            int n2 = this.bufferPointer;
            this.bufferPointer = n2 + 1;
        }
        return resultSample;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/audio/wav/WavFile$IOState;", "", "(Ljava/lang/String;I)V", "READING", "CLOSED", "dataset"})
    private static final class IOState
    extends Enum<IOState> {
        public static final /* enum */ IOState READING = new IOState();
        public static final /* enum */ IOState CLOSED = new IOState();
        private static final /* synthetic */ IOState[] $VALUES;

        public static IOState[] values() {
            return (IOState[])$VALUES.clone();
        }

        public static IOState valueOf(String value) {
            return Enum.valueOf(IOState.class, value);
        }

        static {
            $VALUES = iOStateArray = new IOState[]{IOState.READING, IOState.CLOSED};
        }
    }
}

