/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.audio.wav;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFileException;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFileKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/audio/wav/WavFileFormat;", "", "buffer", "", "([B)V", "blockAlign", "", "getBlockAlign", "()I", "bytesPerSample", "getBytesPerSample", "floatOffset", "", "getFloatOffset", "()F", "floatScale", "getFloatScale", "numChannels", "getNumChannels", "sampleRate", "", "getSampleRate", "()J", "validBits", "toString", "", "dataset"})
public final class WavFileFormat {
    private final int numChannels;
    private final long sampleRate;
    private final int blockAlign;
    private final int validBits;
    private final int bytesPerSample;
    private final float floatScale;
    private final float floatOffset;

    public WavFileFormat(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.numChannels = (int)WavFileKt.readLittleEndian(buffer, 2, 2);
        this.sampleRate = WavFileKt.readLittleEndian(buffer, 4, 4);
        this.blockAlign = (int)WavFileKt.readLittleEndian(buffer, 12, 2);
        this.validBits = (int)WavFileKt.readLittleEndian(buffer, 14, 2);
        this.bytesPerSample = (this.validBits + 7) / 8;
        if (this.bytesPerSample * this.numChannels != this.blockAlign) {
            throw new WavFileException("Block Align does not agree with bytes required for validBits and number of channels");
        }
        if (this.numChannels == 0) {
            throw new WavFileException("Number of channels specified in header is equal to zero");
        }
        if (this.blockAlign == 0) {
            throw new WavFileException("Block Align specified in header is equal to zero");
        }
        if (this.validBits < 2) {
            throw new WavFileException("Valid Bits specified in header is less than 2");
        }
        if (this.validBits > 64) {
            throw new WavFileException("Valid Bits specified in header is greater than 64, this is greater than a long can hold");
        }
        if (this.validBits > 8) {
            this.floatOffset = 0.0f;
            this.floatScale = 1 << this.validBits - 1;
        } else {
            this.floatOffset = -1.0f;
            this.floatScale = 0.5f * (float)((1 << this.validBits) - 1);
        }
    }

    public final int getNumChannels() {
        return this.numChannels;
    }

    public final long getSampleRate() {
        return this.sampleRate;
    }

    public final int getBlockAlign() {
        return this.blockAlign;
    }

    public final int getBytesPerSample() {
        return this.bytesPerSample;
    }

    public final float getFloatScale() {
        return this.floatScale;
    }

    public final float getFloatOffset() {
        return this.floatOffset;
    }

    @NotNull
    public String toString() {
        return "WavFileFormat(numChannels=" + this.numChannels + ", sampleRate=" + this.sampleRate + ", blockAlign=" + this.blockAlign + ", bytesPerSample=" + this.bytesPerSample + ", floatScale=" + this.floatScale + ", floatOffset=" + this.floatOffset + ')';
    }
}

