/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.audio.wav;

import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFileException;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"CHUNK_HEADER_LENGTH", "", "DATA_CHUNK_ID", "", "FMT_CHUNK_ID", "HEADER_LENGTH", "RIFF_CHUNK_ID", "RIFF_TYPE_ID", "readLittleEndian", "buffer", "", "position", "count", "readWavHeader", "", "file", "Ljava/io/File;", "inputStream", "Ljava/io/InputStream;", "dataset"})
public final class WavFileKt {
    private static final int HEADER_LENGTH = 12;
    private static final int CHUNK_HEADER_LENGTH = 8;
    private static final long FMT_CHUNK_ID = 544501094L;
    private static final long DATA_CHUNK_ID = 1635017060L;
    private static final long RIFF_CHUNK_ID = 1179011410L;
    private static final long RIFF_TYPE_ID = 1163280727L;

    public static final long readLittleEndian(@NotNull byte[] buffer, int position, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int currPosition = position + count - 1;
        long returnValue = (long)buffer[currPosition] & 0xFFL;
        int n = count - 1;
        for (int b = 0; b < n; ++b) {
            returnValue = (returnValue << 8) + ((long)buffer[--currPosition] & 0xFFL);
        }
        return returnValue;
    }

    private static final void readWavHeader(File file, InputStream inputStream, byte[] buffer) {
        int bytesRead = inputStream.read(buffer, 0, 12);
        if (bytesRead != 12) {
            throw new WavFileException("Not enough wav file bytes for header");
        }
        long riffChunkID = WavFileKt.readLittleEndian(buffer, 0, 4);
        long chunkSize = WavFileKt.readLittleEndian(buffer, 4, 4);
        long riffTypeID = WavFileKt.readLittleEndian(buffer, 8, 4);
        if (riffChunkID != 1179011410L) {
            throw new WavFileException("Invalid Wav Header data, incorrect riff chunk ID");
        }
        if (riffTypeID != 1163280727L) {
            throw new WavFileException("Invalid Wav Header data, incorrect riff type ID");
        }
        if (file.length() < chunkSize + (long)8) {
            throw new WavFileException("Header chunk size (" + chunkSize + ") does not match file size (" + file.length() + ')');
        }
    }

    public static final /* synthetic */ void access$readWavHeader(File file, InputStream inputStream, byte[] buffer) {
        WavFileKt.readWavHeader(file, inputStream, buffer);
    }
}

