/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.embedded;

import com.github.doyaaaaaken.kotlincsv.client.CsvFileReader;
import com.github.doyaaaaaken.kotlincsv.dsl.CsvReaderDslKt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.OnHeapDataset;
import org.jetbrains.kotlinx.dl.impl.preprocessing.image.ColorMode;
import org.jetbrains.kotlinx.dl.impl.preprocessing.image.ImageConverter;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u001a\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001\u001a#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DATASET_SIZE", "", "extractCifar10Images", "", "", "archiveName", "", "(Ljava/lang/String;)[[F", "extractCifar10Labels", "pathToLabels", "numClasses", "extractCifar10LabelsAnsSort", "loadImagesFromDirectory", "subDatasetSize", "(ILjava/lang/String;)[[F", "dataset"})
public final class Cifar10UtilKt {
    private static final int DATASET_SIZE = 50000;

    @NotNull
    public static final float[][] extractCifar10Images(@NotNull String archiveName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
        return Cifar10UtilKt.loadImagesFromDirectory(50000, archiveName);
    }

    private static final float[][] loadImagesFromDirectory(int subDatasetSize, String archiveName) {
        int n = 0;
        float[][] fArrayArray = new float[subDatasetSize][];
        while (n < subDatasetSize) {
            int n2 = n++;
            fArrayArray[n2] = ImageConverter.INSTANCE.toNormalizedFloatArray(new File(archiveName, n2 + 1 + ".png"), ColorMode.BGR);
        }
        float[][] images = fArrayArray;
        return images;
    }

    @NotNull
    public static final float[] extractCifar10Labels(@NotNull String pathToLabels, int numClasses) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pathToLabels, (String)"pathToLabels");
        int labelCount = 50000;
        String string = "Extracting %d labels from %s";
        Object[] objectArray = new Object[]{labelCount, pathToLabels};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String string3 = string2;
        System.out.println((Object)string3);
        byte[] labelBuffer = new byte[labelCount];
        objectArray = new Pair[]{TuplesKt.to((Object)"airplane", (Object)0), TuplesKt.to((Object)"automobile", (Object)1), TuplesKt.to((Object)"bird", (Object)2), TuplesKt.to((Object)"cat", (Object)3), TuplesKt.to((Object)"deer", (Object)4), TuplesKt.to((Object)"dog", (Object)5), TuplesKt.to((Object)"frog", (Object)6), TuplesKt.to((Object)"horse", (Object)7), TuplesKt.to((Object)"ship", (Object)8), TuplesKt.to((Object)"truck", (Object)9)};
        Map dictionary = MapsKt.mapOf((Pair[])objectArray);
        Ref.IntRef cnt = new Ref.IntRef();
        CsvReaderDslKt.csvReader$default(null, (int)1, null).open(pathToLabels, (Function1)new Function1<CsvFileReader, Unit>(labelBuffer, cnt, (Map<String, Integer>)dictionary){
            final /* synthetic */ byte[] $labelBuffer;
            final /* synthetic */ Ref.IntRef $cnt;
            final /* synthetic */ Map<String, Integer> $dictionary;
            {
                this.$labelBuffer = $labelBuffer;
                this.$cnt = $cnt;
                this.$dictionary = $dictionary;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CsvFileReader $this$open) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$open, (String)"$this$open");
                Sequence sequence = $this$open.readAllAsSequence();
                byte[] byArray = this.$labelBuffer;
                Ref.IntRef intRef = this.$cnt;
                Map<String, Integer> map = this.$dictionary;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    List row = (List)element$iv;
                    boolean bl = false;
                    byte[] byArray2 = byArray;
                    int n = intRef.element;
                    Map<String, Integer> map2 = map;
                    Integer n2 = map2.get(row.get(1));
                    if (n2 == null) {
                        int n3 = n;
                        byte[] byArray3 = byArray2;
                        boolean bl2 = false;
                        Integer n4 = 1;
                        byArray2 = byArray3;
                        n = n3;
                        n2 = n4;
                    }
                    byArray2[n] = (byte)((Number)n2).intValue();
                    int n5 = intRef.element;
                    intRef.element = n5 + 1;
                }
            }
        });
        float[] floats = new float[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            floats[i] = OnHeapDataset.Companion.convertByteToFloat(labelBuffer[i]);
        }
        return floats;
    }

    @NotNull
    public static final float[] extractCifar10LabelsAnsSort(@NotNull String pathToLabels, int numClasses) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pathToLabels, (String)"pathToLabels");
        int labelCount = 50000;
        String string = "Extracting %d labels from %s";
        Object[] objectArray = new Object[]{labelCount, pathToLabels};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String string3 = string2;
        System.out.println((Object)string3);
        Map labelSorter = new LinkedHashMap();
        objectArray = new Pair[]{TuplesKt.to((Object)"airplane", (Object)0), TuplesKt.to((Object)"automobile", (Object)1), TuplesKt.to((Object)"bird", (Object)2), TuplesKt.to((Object)"cat", (Object)3), TuplesKt.to((Object)"deer", (Object)4), TuplesKt.to((Object)"dog", (Object)5), TuplesKt.to((Object)"frog", (Object)6), TuplesKt.to((Object)"horse", (Object)7), TuplesKt.to((Object)"ship", (Object)8), TuplesKt.to((Object)"truck", (Object)9)};
        Map dictionary = MapsKt.mapOf((Pair[])objectArray);
        CsvReaderDslKt.csvReader$default(null, (int)1, null).open(pathToLabels, (Function1)new Function1<CsvFileReader, Unit>((Map<String, Integer>)labelSorter, (Map<String, Integer>)dictionary){
            final /* synthetic */ Map<String, Integer> $labelSorter;
            final /* synthetic */ Map<String, Integer> $dictionary;
            {
                this.$labelSorter = $labelSorter;
                this.$dictionary = $dictionary;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CsvFileReader $this$open) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$open, (String)"$this$open");
                Sequence sequence = $this$open.readAllAsSequence();
                Map<String, Integer> map = this.$labelSorter;
                Map<String, Integer> map2 = this.$dictionary;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    List row = (List)element$iv;
                    boolean bl = false;
                    Map<String, Integer> map3 = map;
                    E e = row.get(0);
                    Map<String, Integer> map4 = map2;
                    Integer n = map4.get(row.get(1));
                    if (n == null) {
                        boolean bl2 = false;
                        n = 1;
                    }
                    map4 = n;
                    map3.put((String)e, (Integer)((Object)map4));
                }
            }
        });
        SortedMap sortedMap = MapsKt.toSortedMap((Map)labelSorter);
        Collection collection = sortedMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"sortedMap.values");
        int[] labelBuffer = CollectionsKt.toIntArray(collection);
        float[] floats = new float[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            floats[i] = OnHeapDataset.Companion.convertByteToFloat((byte)labelBuffer[i]);
        }
        return floats;
    }
}

