/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.embedded;

import io.jhdf.HdfFile;
import io.jhdf.api.Dataset;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.inference.loaders.LoadingMode;
import org.jetbrains.kotlinx.dl.dataset.OnHeapDataset;
import org.jetbrains.kotlinx.dl.dataset.audio.wav.WavFile;
import org.jetbrains.kotlinx.dl.dataset.embedded.EmbeddedDatasetsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0010\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\r\u001a\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0000\u001a.\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160\u000b2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160\u001aH\u0002\u001a\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 \u001a\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a.\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u000b2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160\u001aH\u0002\u001a(\u0010#\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00160\u001a0$2\u0006\u0010%\u001a\u00020\rH\u0002\u001a\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u0010\u0010(\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\r\u001a&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010*\u001a\u00020\u0016\u001a8\u0010+\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u00012\u0014\b\u0002\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010.2\b\b\u0002\u0010/\u001a\u000200H\u0002\u001a\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\u001c\u00102\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a \u00103\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0001H\u0002\u001a\f\u00106\u001a\u00020\u0011*\u00020\rH\u0000\u001a&\u00107\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001d\u0012\u0004\u0012\u00020\u001b0\u000b*\u0002082\u0006\u00109\u001a\u00020\u0001H\u0002\u001aG\u0010:\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H;0\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H;0\u001d0\u000b\"\u0006\b\u0000\u0010;\u0018\u0001*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H;\u0012\u0004\u0012\u00020\u00160\u000b0$2\u0006\u0010*\u001a\u00020\u0016H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"CIFAR_10_IMAGES_ARCHIVE", "", "CIFAR_10_LABELS_ARCHIVE", "DOGS_CATS_IMAGES_ARCHIVE", "DOGS_CATS_SMALL_IMAGES_ARCHIVE", "FSDD_SOUNDS_ARCHIVE", "FSDD_SOUND_DATA_SIZE", "", "FSS_SOUNDS_SOURCE", "MNIST_3D_DATASET", "cifar10Paths", "Lkotlin/Pair;", "cacheDirectory", "Ljava/io/File;", "dogsCatsDatasetPath", "dogsCatsSmallDatasetPath", "extractFromZipArchiveToFolder", "", "zipArchivePath", "Ljava/nio/file/Path;", "toFolder", "bufferSize", "", "extractLabelWithIndex", "", "dataLabelIndex", "Lkotlin/Triple;", "", "extractMnist3DData", "", "dataset", "Lio/jhdf/api/Dataset;", "(Lio/jhdf/api/Dataset;)[[F", "extractMnist3DLabels", "extractPaddedDataWithIndex", "extractWavFileSamples", "", "file", "fashionMnist", "Lorg/jetbrains/kotlinx/dl/dataset/OnHeapDataset;", "freeSpokenDigitDatasetPath", "freeSpokenDigits", "maxTestIndex", "loadFile", "relativePathToFile", "downloadURLFromRelativePath", "Lkotlin/Function1;", "loadingMode", "Lorg/jetbrains/kotlinx/dl/api/inference/loaders/LoadingMode;", "mnist", "mnist3D", "unzipDatasetPath", "archive", "dirRelativePath", "existsOrMkdirs", "extractMnist3DDataset", "Lio/jhdf/HdfFile;", "label", "splitToTrainAndTestByIndex", "T"})
@SourceDebugExtension(value={"SMAP\nembeddedDatasets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 embeddedDatasets.kt\norg/jetbrains/kotlinx/dl/dataset/embedded/EmbeddedDatasetsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n232#1:448\n233#1:458\n234#1:466\n232#1:467\n233#1:477\n234#1:485\n11335#2:419\n11670#2,2:420\n11395#2:422\n11730#2,3:423\n11672#2:426\n11375#2:429\n11710#2,3:430\n10242#2:433\n10664#2,5:434\n11335#2:486\n11670#2,3:487\n37#3,2:427\n37#3,2:456\n37#3,2:475\n37#3,2:497\n37#3,2:506\n1#4:439\n1549#5:440\n1620#5,3:441\n1549#5:444\n1620#5,3:445\n766#5:449\n857#5,2:450\n1549#5:452\n1620#5,3:453\n766#5:459\n857#5,2:460\n1549#5:462\n1620#5,3:463\n766#5:468\n857#5,2:469\n1549#5:471\n1620#5,3:472\n766#5:478\n857#5,2:479\n1549#5:481\n1620#5,3:482\n766#5:490\n857#5,2:491\n1549#5:493\n1620#5,3:494\n766#5:499\n857#5,2:500\n1549#5:502\n1620#5,3:503\n*S KotlinDebug\n*F\n+ 1 embeddedDatasets.kt\norg/jetbrains/kotlinx/dl/dataset/embedded/EmbeddedDatasetsKt\n*L\n200#1:448\n200#1:458\n200#1:466\n201#1:467\n201#1:477\n201#1:485\n145#1:419\n145#1:420,2\n145#1:422\n145#1:423,3\n145#1:426\n150#1:429\n150#1:430,3\n190#1:433\n190#1:434,5\n222#1:486\n222#1:487,3\n146#1:427,2\n200#1:456,2\n201#1:475,2\n232#1:497,2\n233#1:506,2\n197#1:440\n197#1:441,3\n198#1:444\n198#1:445,3\n200#1:449\n200#1:450,2\n200#1:452\n200#1:453,3\n200#1:459\n200#1:460,2\n200#1:462\n200#1:463,3\n201#1:468\n201#1:469,2\n201#1:471\n201#1:472,3\n201#1:478\n201#1:479,2\n201#1:481\n201#1:482,3\n232#1:490\n232#1:491,2\n232#1:493\n232#1:494,3\n233#1:499\n233#1:500,2\n233#1:502\n233#1:503,3\n*E\n"})
public final class EmbeddedDatasetsKt {
    @NotNull
    public static final String MNIST_3D_DATASET = "datasets/mnist-3d/dataset.h5";
    public static final long FSDD_SOUND_DATA_SIZE = 20480L;
    @NotNull
    private static final String CIFAR_10_IMAGES_ARCHIVE = "datasets/cifar10/images.zip";
    @NotNull
    private static final String CIFAR_10_LABELS_ARCHIVE = "datasets/cifar10/trainLabels.csv";
    @NotNull
    private static final String DOGS_CATS_IMAGES_ARCHIVE = "datasets/dogs-vs-cats/data.zip";
    @NotNull
    private static final String DOGS_CATS_SMALL_IMAGES_ARCHIVE = "datasets/small-dogs-vs-cats/data.zip";
    @NotNull
    private static final String FSDD_SOUNDS_ARCHIVE = "datasets/fsdd.zip";
    @NotNull
    private static final String FSS_SOUNDS_SOURCE = "https://codeload.github.com/Jakobovski/free-spoken-digit-dataset/zip/refs/heads/master";

    @NotNull
    public static final Pair<OnHeapDataset, OnHeapDataset> mnist(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        EmbeddedDatasetsKt.existsOrMkdirs(cacheDirectory);
        String trainXpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/mnist/train-images-idx3-ubyte.gz", null, null, 12, null).getAbsolutePath();
        String trainYpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/mnist/train-labels-idx1-ubyte.gz", null, null, 12, null).getAbsolutePath();
        String testXpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/mnist/t10k-images-idx3-ubyte.gz", null, null, 12, null).getAbsolutePath();
        String testYpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/mnist/t10k-labels-idx1-ubyte.gz", null, null, 12, null).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)trainXpath, (String)"trainXpath");
        Intrinsics.checkNotNullExpressionValue((Object)trainYpath, (String)"trainYpath");
        Intrinsics.checkNotNullExpressionValue((Object)testXpath, (String)"testXpath");
        Intrinsics.checkNotNullExpressionValue((Object)testYpath, (String)"testYpath");
        return OnHeapDataset.Companion.createTrainAndTestDatasets(trainXpath, trainYpath, testXpath, testYpath, 10, (Function1<? super String, float[][]>)((Function1)mnist.1.INSTANCE), (Function2<? super String, ? super Integer, float[]>)((Function2)mnist.2.INSTANCE));
    }

    public static /* synthetic */ Pair mnist$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.mnist(file);
    }

    @NotNull
    public static final Pair<OnHeapDataset, OnHeapDataset> fashionMnist(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        EmbeddedDatasetsKt.existsOrMkdirs(cacheDirectory);
        String trainXpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/fashionmnist/train-images-idx3-ubyte.gz", null, null, 12, null).getAbsolutePath();
        String trainYpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/fashionmnist/train-labels-idx1-ubyte.gz", null, null, 12, null).getAbsolutePath();
        String testXpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/fashionmnist/t10k-images-idx3-ubyte.gz", null, null, 12, null).getAbsolutePath();
        String testYpath = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, "datasets/fashionmnist/t10k-labels-idx1-ubyte.gz", null, null, 12, null).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)trainXpath, (String)"trainXpath");
        Intrinsics.checkNotNullExpressionValue((Object)trainYpath, (String)"trainYpath");
        Intrinsics.checkNotNullExpressionValue((Object)testXpath, (String)"testXpath");
        Intrinsics.checkNotNullExpressionValue((Object)testYpath, (String)"testYpath");
        return OnHeapDataset.Companion.createTrainAndTestDatasets(trainXpath, trainYpath, testXpath, testYpath, 10, (Function1<? super String, float[][]>)((Function1)fashionMnist.1.INSTANCE), (Function2<? super String, ? super Integer, float[]>)((Function2)fashionMnist.2.INSTANCE));
    }

    public static /* synthetic */ Pair fashionMnist$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.fashionMnist(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Pair<OnHeapDataset, OnHeapDataset> mnist3D(@NotNull File cacheDirectory) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        EmbeddedDatasetsKt.existsOrMkdirs(cacheDirectory);
        AutoCloseable autoCloseable = (AutoCloseable)new HdfFile(EmbeddedDatasetsKt.loadFile$default(cacheDirectory, MNIST_3D_DATASET, null, null, 12, null));
        Throwable throwable = null;
        try {
            HdfFile it = (HdfFile)autoCloseable;
            boolean bl = false;
            Pair<float[][], float[]> pair2 = EmbeddedDatasetsKt.extractMnist3DDataset(it, "train");
            float[][] trainData = (float[][])pair2.component1();
            float[] trainLabels = (float[])pair2.component2();
            Pair<float[][], float[]> pair3 = EmbeddedDatasetsKt.extractMnist3DDataset(it, "test");
            float[][] testData = (float[][])pair3.component1();
            float[] testLabels = (float[])pair3.component2();
            pair = new Pair((Object)OnHeapDataset.Companion.create(trainData, trainLabels), (Object)OnHeapDataset.Companion.create(testData, testLabels));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return pair;
    }

    public static /* synthetic */ Pair mnist3D$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.mnist3D(file);
    }

    /*
     * WARNING - void declaration
     */
    private static final float[][] extractMnist3DData(Dataset dataset) {
        void $this$mapTo$iv$iv;
        Object object = dataset.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<*>");
        Object[] $this$map$iv = (Object[])object;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv2;
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.DoubleArray");
            double[] $this$map$iv2 = (double[])it;
            boolean $i$f$map2 = false;
            double[] dArray = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            int n2 = ((void)$this$mapTo$iv$iv2).length;
            for (int j = 0; j < n2; ++j) {
                void p0;
                void item$iv$iv2;
                void var20_19 = item$iv$iv2 = $this$mapTo$iv$iv2[j];
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(Float.valueOf((float)p0));
            }
            collection.add(CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv2)));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (float[][])thisCollection$iv.toArray((T[])new float[0][]);
    }

    /*
     * WARNING - void declaration
     */
    private static final float[] extractMnist3DLabels(Dataset dataset) {
        void $this$mapTo$iv$iv;
        Object object = dataset.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.LongArray");
        long[] $this$map$iv = (long[])object;
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var10_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)p0));
        }
        return CollectionsKt.toFloatArray((Collection)((List)destination$iv$iv));
    }

    private static final Pair<float[][], float[]> extractMnist3DDataset(HdfFile $this$extractMnist3DDataset, String label) {
        Dataset dataset = $this$extractMnist3DDataset.getDatasetByPath("X_" + label);
        Intrinsics.checkNotNullExpressionValue((Object)dataset, (String)"getDatasetByPath(\"X_$label\")");
        float[][] fArray = EmbeddedDatasetsKt.extractMnist3DData(dataset);
        Dataset dataset2 = $this$extractMnist3DDataset.getDatasetByPath("y_" + label);
        Intrinsics.checkNotNullExpressionValue((Object)dataset2, (String)"getDatasetByPath(\"y_$label\")");
        return new Pair((Object)fArray, (Object)EmbeddedDatasetsKt.extractMnist3DLabels(dataset2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<OnHeapDataset, OnHeapDataset> freeSpokenDigits(@NotNull File cacheDirectory, int maxTestIndex) {
        void $this$toTypedArray$iv$iv;
        void $this$mapTo$iv$iv$iv;
        Collection $this$map$iv$iv;
        void $this$filterTo$iv$iv$iv;
        void $this$toTypedArray$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv$iv2;
        Collection $this$map$iv$iv2;
        Pair it$iv;
        void $this$filterTo$iv$iv$iv2;
        void $this$toTypedArray$iv$iv3;
        void $this$mapTo$iv$iv$iv3;
        Collection $this$map$iv$iv3;
        void $this$filterTo$iv$iv$iv3;
        void $this$toTypedArray$iv$iv4;
        Iterator iterator;
        void $this$mapTo$iv$iv$iv4;
        Collection $this$map$iv$iv4;
        Pair it$iv2;
        void $this$filterTo$iv$iv$iv4;
        void $this$mapTo$iv$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Object it;
        Object object;
        Iterable destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        EmbeddedDatasetsKt.existsOrMkdirs(cacheDirectory);
        String path = EmbeddedDatasetsKt.freeSpokenDigitDatasetPath(cacheDirectory);
        File[] fileArray = new File(path).listFiles();
        if (fileArray != null) {
            void $this$flatMapTo$iv$iv;
            File[] $this$flatMap$iv = fileArray;
            boolean $i$f$flatMap = false;
            File[] fileArray2 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Triple element$iv$iv : $this$flatMapTo$iv$iv) {
                void p0 = element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = EmbeddedDatasetsKt.extractWavFileSamples((File)p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
        } else {
            throw new IllegalStateException("Cannot find Free Spoken Digits Dataset files in " + path);
        }
        List dataset = (List)destination$iv$iv;
        Iterator $i$f$flatMap = ((Iterable)dataset).iterator();
        if (!$i$f$flatMap.hasNext()) {
            object = null;
        } else {
            it = (Triple)$i$f$flatMap.next();
            boolean bl = false;
            it = ((float[])it.getFirst()).length;
            while ($i$f$flatMap.hasNext()) {
                Object it2 = (Triple)$i$f$flatMap.next();
                $i$a$-maxOfOrNull-EmbeddedDatasetsKt$freeSpokenDigits$maxDataSize$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(((float[])it2.getFirst()).length)) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        if (n == null) {
            throw new IllegalStateException("Empty Free Spoken Digits Dataset");
        }
        int maxDataSize = n;
        if (!((long)maxDataSize <= 20480L)) {
            boolean $i$a$-check-EmbeddedDatasetsKt$freeSpokenDigits$22 = false;
            String $i$a$-check-EmbeddedDatasetsKt$freeSpokenDigits$22 = "Sound data should be limited to 20480 values but has " + maxDataSize;
            throw new IllegalStateException($i$a$-check-EmbeddedDatasetsKt$freeSpokenDigits$22.toString());
        }
        Iterable $this$map$iv = dataset;
        boolean $i$f$map = false;
        it = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Triple element$iv$iv;
            element$iv$iv = (Triple)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(EmbeddedDatasetsKt.extractPaddedDataWithIndex((Triple<float[], Float, Integer>)p0));
        }
        List data = (List)destination$iv$iv;
        Iterable $this$map$iv2 = dataset;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Triple bl = (Triple)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(EmbeddedDatasetsKt.extractLabelWithIndex((Triple<float[], Float, Integer>)p0));
        }
        List labels = (List)destination$iv$iv2;
        List $this$splitToTrainAndTestByIndex$iv = data;
        boolean $i$f$splitToTrainAndTestByIndex = false;
        Iterable $this$filter$iv$iv = $this$splitToTrainAndTestByIndex$iv;
        boolean $i$f$filter = false;
        Iterable item$iv$iv = $this$filter$iv$iv;
        Iterable destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv4) {
            it$iv2 = (Pair)element$iv$iv$iv;
            boolean bl = false;
            if (!(((Number)it$iv2.getSecond()).intValue() < maxTestIndex)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        $this$filter$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv$iv4 = $this$map$iv$iv4;
        destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv4, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv4) {
            it$iv2 = (Pair)item$iv$iv$iv;
            iterator = destination$iv$iv$iv;
            boolean bl = false;
            iterator.add(it$iv2.getFirst());
        }
        $this$map$iv$iv4 = (List)destination$iv$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv$iv = $this$toTypedArray$iv$iv4;
        T[] test$iv = thisCollection$iv$iv.toArray((T[])new float[0][]);
        Iterable $this$filter$iv$iv2 = $this$splitToTrainAndTestByIndex$iv;
        boolean $i$f$filter2 = false;
        destination$iv$iv$iv = $this$filter$iv$iv2;
        Collection destination$iv$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv3) {
            Pair it$iv3 = (Pair)element$iv$iv$iv;
            boolean bl = false;
            if (!(((Number)it$iv3.getSecond()).intValue() >= maxTestIndex)) continue;
            destination$iv$iv$iv2.add(element$iv$iv$iv);
        }
        $this$filter$iv$iv2 = (List)destination$iv$iv$iv2;
        boolean $i$f$map4 = false;
        $this$filterTo$iv$iv$iv3 = $this$map$iv$iv3;
        destination$iv$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv3, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv3) {
            Pair it$iv3 = (Pair)item$iv$iv$iv;
            iterator = destination$iv$iv$iv2;
            boolean bl = false;
            iterator.add(it$iv3.getFirst());
        }
        $this$map$iv$iv3 = (List)destination$iv$iv$iv2;
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv$iv2 = $this$toTypedArray$iv$iv3;
        T[] train$iv = thisCollection$iv$iv2.toArray((T[])new float[0][]);
        Pair pair = new Pair(train$iv, test$iv);
        float[][] trainData = (float[][])pair.component1();
        float[][] testData = (float[][])pair.component2();
        List $this$splitToTrainAndTestByIndex$iv2 = labels;
        boolean $i$f$splitToTrainAndTestByIndex2 = false;
        Iterable $this$filter$iv$iv3 = $this$splitToTrainAndTestByIndex$iv2;
        boolean $i$f$filter3 = false;
        Iterable $i$f$mapTo222 = $this$filter$iv$iv3;
        Iterable destination$iv$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv2) {
            it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            if (!(((Number)it$iv.getSecond()).intValue() < maxTestIndex)) continue;
            destination$iv$iv$iv3.add(element$iv$iv$iv);
        }
        $this$filter$iv$iv3 = (List)destination$iv$iv$iv3;
        boolean $i$f$map5 = false;
        $this$filterTo$iv$iv$iv2 = $this$map$iv$iv2;
        destination$iv$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv2) {
            it$iv = (Pair)item$iv$iv$iv;
            collection = destination$iv$iv$iv3;
            boolean bl = false;
            collection.add(it$iv.getFirst());
        }
        $this$map$iv$iv2 = (List)destination$iv$iv$iv3;
        boolean $i$f$toTypedArray3 = false;
        void thisCollection$iv$iv3 = $this$toTypedArray$iv$iv2;
        Float[] test$iv2 = thisCollection$iv$iv3.toArray(new Float[0]);
        Iterable $this$filter$iv$iv4 = $this$splitToTrainAndTestByIndex$iv2;
        boolean $i$f$filter4 = false;
        destination$iv$iv$iv3 = $this$filter$iv$iv4;
        Collection destination$iv$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            Pair it$iv4 = (Pair)element$iv$iv$iv;
            boolean bl = false;
            if (!(((Number)it$iv4.getSecond()).intValue() >= maxTestIndex)) continue;
            destination$iv$iv$iv4.add(element$iv$iv$iv);
        }
        $this$filter$iv$iv4 = (List)destination$iv$iv$iv4;
        boolean $i$f$map6 = false;
        $this$filterTo$iv$iv$iv = $this$map$iv$iv;
        destination$iv$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            Pair it$iv4 = (Pair)item$iv$iv$iv;
            collection = destination$iv$iv$iv4;
            boolean bl = false;
            collection.add(it$iv4.getFirst());
        }
        $this$map$iv$iv = (List)destination$iv$iv$iv4;
        boolean $i$f$toTypedArray4 = false;
        void thisCollection$iv$iv4 = $this$toTypedArray$iv$iv;
        Float[] train$iv2 = thisCollection$iv$iv4.toArray(new Float[0]);
        Pair pair2 = new Pair((Object)train$iv2, (Object)test$iv2);
        Float[] trainLabels = (Float[])pair2.component1();
        Float[] testLabels = (Float[])pair2.component2();
        return new Pair((Object)OnHeapDataset.Companion.create(trainData, ArraysKt.toFloatArray((Float[])trainLabels)), (Object)OnHeapDataset.Companion.create(testData, ArraysKt.toFloatArray((Float[])testLabels)));
    }

    public static /* synthetic */ Pair freeSpokenDigits$default(File file, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = new File("cache");
        }
        if ((n2 & 2) != 0) {
            n = 5;
        }
        return EmbeddedDatasetsKt.freeSpokenDigits(file, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<Triple<float[], Float, Integer>> extractWavFileSamples(File file) {
        List list;
        AutoCloseable autoCloseable = new WavFile(file, 0, 2, null);
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            WavFile it = (WavFile)autoCloseable;
            boolean bl = false;
            float[][] data = it.readRemainingFrames();
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            String[] stringArray = new String[]{"_"};
            List parts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            float label = Float.parseFloat((String)parts.get(0));
            String[] stringArray2 = new String[]{"."};
            int index = Integer.parseInt((String)StringsKt.split$default((CharSequence)((CharSequence)parts.get(2)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0));
            Object[] $this$map$iv = (Object[])data;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void channel;
                float[] fArray = (float[])item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Triple((Object)channel, (Object)Float.valueOf(label), (Object)index));
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    private static final Pair<float[], Integer> extractPaddedDataWithIndex(Triple<float[], Float, Integer> dataLabelIndex) {
        return new Pair((Object)ArraysKt.copyInto$default((float[])((float[])dataLabelIndex.getFirst()), (float[])new float[20480], (int)0, (int)0, (int)0, (int)14, null), dataLabelIndex.getThird());
    }

    private static final Pair<Float, Integer> extractLabelWithIndex(Triple<float[], Float, Integer> dataLabelIndex) {
        return new Pair(dataLabelIndex.getSecond(), dataLabelIndex.getThird());
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ <T> Pair<T[], T[]> splitToTrainAndTestByIndex(List<? extends Pair<? extends T, Integer>> $this$splitToTrainAndTestByIndex, int maxTestIndex) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$toTypedArray$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Collection $this$map$iv2;
        Pair it;
        void $this$filterTo$iv$iv2;
        boolean $i$f$splitToTrainAndTestByIndex = false;
        Iterable $this$filter$iv = $this$splitToTrainAndTestByIndex;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).intValue() < maxTestIndex)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFirst());
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = (Collection)$this$toTypedArray$iv2;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        Object[] test = thisCollection$iv.toArray(new Object[0]);
        Iterable $this$filter$iv2 = $this$splitToTrainAndTestByIndex;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it2.getSecond()).intValue() >= maxTestIndex)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair it2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getFirst());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = (Collection)$this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        Object[] train = thisCollection$iv2.toArray(new Object[0]);
        return new Pair((Object)train, (Object)test);
    }

    @NotNull
    public static final Pair<String, String> cifar10Paths(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        EmbeddedDatasetsKt.existsOrMkdirs(cacheDirectory);
        String pathToLabel = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, CIFAR_10_LABELS_ARCHIVE, null, null, 12, null).getAbsolutePath();
        File datasetDirectory = new File(cacheDirectory.getAbsolutePath() + "/datasets/cifar10");
        Path toFolder = datasetDirectory.toPath();
        File imageDataDirectory = new File(cacheDirectory.getAbsolutePath() + "/datasets/cifar10/images");
        if (!imageDataDirectory.exists()) {
            Files.createDirectories(imageDataDirectory.toPath(), new FileAttribute[0]);
            File pathToImageArchive = EmbeddedDatasetsKt.loadFile$default(cacheDirectory, CIFAR_10_IMAGES_ARCHIVE, null, null, 12, null);
            Path path = pathToImageArchive.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pathToImageArchive.toPath()");
            Intrinsics.checkNotNullExpressionValue((Object)toFolder, (String)"toFolder");
            EmbeddedDatasetsKt.extractFromZipArchiveToFolder$default(path, toFolder, 0, 4, null);
            boolean deleted = pathToImageArchive.delete();
            if (!deleted) {
                throw new Exception("Archive " + pathToImageArchive.getAbsolutePath() + " could not be deleted! Create this archive manually.");
            }
        }
        return new Pair((Object)((Object)imageDataDirectory.toPath().toAbsolutePath()).toString(), (Object)pathToLabel);
    }

    public static /* synthetic */ Pair cifar10Paths$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.cifar10Paths(file);
    }

    @NotNull
    public static final String dogsCatsDatasetPath(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        return EmbeddedDatasetsKt.unzipDatasetPath(cacheDirectory, EmbeddedDatasetsKt.loadFile$default(cacheDirectory, DOGS_CATS_IMAGES_ARCHIVE, null, null, 12, null), "/datasets/dogs-vs-cats");
    }

    public static /* synthetic */ String dogsCatsDatasetPath$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.dogsCatsDatasetPath(file);
    }

    @NotNull
    public static final String dogsCatsSmallDatasetPath(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        return EmbeddedDatasetsKt.unzipDatasetPath(cacheDirectory, EmbeddedDatasetsKt.loadFile$default(cacheDirectory, DOGS_CATS_SMALL_IMAGES_ARCHIVE, null, null, 12, null), "/datasets/small-dogs-vs-cats");
    }

    public static /* synthetic */ String dogsCatsSmallDatasetPath$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.dogsCatsSmallDatasetPath(file);
    }

    @NotNull
    public static final String freeSpokenDigitDatasetPath(@NotNull File cacheDirectory) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        String $this$freeSpokenDigitDatasetPath_u24lambda_u2414 = EmbeddedDatasetsKt.unzipDatasetPath(cacheDirectory, EmbeddedDatasetsKt.loadFile$default(cacheDirectory, FSDD_SOUNDS_ARCHIVE, freeSpokenDigitDatasetPath.1.INSTANCE, null, 8, null), "/datasets/free-spoken-digit");
        boolean bl = false;
        return $this$freeSpokenDigitDatasetPath_u24lambda_u2414 + "/free-spoken-digit-dataset-master/recordings";
    }

    public static /* synthetic */ String freeSpokenDigitDatasetPath$default(File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = new File("cache");
        }
        return EmbeddedDatasetsKt.freeSpokenDigitDatasetPath(file);
    }

    private static final String unzipDatasetPath(File cacheDirectory, File archive, String dirRelativePath) {
        EmbeddedDatasetsKt.existsOrMkdirs(cacheDirectory);
        File dataDirectory = new File(cacheDirectory.getAbsolutePath() + dirRelativePath);
        Path toFolder = dataDirectory.toPath();
        if (!dataDirectory.exists()) {
            Files.createDirectories(dataDirectory.toPath(), new FileAttribute[0]);
        }
        if (archive.exists()) {
            Path path = archive.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"archive.toPath()");
            Intrinsics.checkNotNullExpressionValue((Object)toFolder, (String)"toFolder");
            EmbeddedDatasetsKt.extractFromZipArchiveToFolder$default(path, toFolder, 0, 4, null);
            boolean deleted = archive.delete();
            if (!deleted) {
                throw new Exception("Archive " + archive.getAbsolutePath() + " could not be deleted! Delete this archive manually.");
            }
        } else {
            throw new Exception("No archive file " + archive.getAbsolutePath() + " in the cache folder!");
        }
        return ((Object)toFolder.toAbsolutePath()).toString();
    }

    private static final File loadFile(File cacheDirectory, String relativePathToFile, Function1<? super String, String> downloadURLFromRelativePath, LoadingMode loadingMode) {
        String fileName = cacheDirectory.getAbsolutePath() + '/' + relativePathToFile;
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        if (!file.exists() || loadingMode == LoadingMode.OVERRIDE_IF_EXISTS) {
            String urlString = (String)downloadURLFromRelativePath.invoke((Object)relativePathToFile);
            InputStream inputStream = new URL(urlString).openStream();
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(inputStream, Paths.get(fileName, new String[0]), copyOptionArray);
        }
        return file;
    }

    static /* synthetic */ File loadFile$default(File file, String string, Function1 function1, LoadingMode loadingMode, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = loadFile.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            loadingMode = LoadingMode.SKIP_LOADING_IF_EXISTS;
        }
        return EmbeddedDatasetsKt.loadFile(file, string, (Function1<? super String, String>)function1, loadingMode);
    }

    public static final void extractFromZipArchiveToFolder(@NotNull Path zipArchivePath, @NotNull Path toFolder, int bufferSize) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipArchivePath, (String)"zipArchivePath");
        Intrinsics.checkNotNullParameter((Object)toFolder, (String)"toFolder");
        ZipFile zipFile = new ZipFile(zipArchivePath.toFile());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry;
            String currentEntry;
            Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
            String string = currentEntry = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentEntry");
            currentEntry = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            File destFile = new File(toFolder.toFile(), currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory() || destFile.exists()) continue;
            BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
            int currentByte = 0;
            byte[] data = new byte[bufferSize];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, bufferSize);
            while (true) {
                int n;
                int it = n = inputStream.read(data, 0, bufferSize);
                boolean bl = false;
                currentByte = it;
                if (n == -1) break;
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            inputStream.close();
        }
        zipFile.close();
    }

    public static /* synthetic */ void extractFromZipArchiveToFolder$default(Path path, Path path2, int n, int n2, Object object) throws IOException {
        if ((n2 & 4) != 0) {
            n = 4096;
        }
        EmbeddedDatasetsKt.extractFromZipArchiveToFolder(path, path2, n);
    }

    public static final void existsOrMkdirs(@NotNull File $this$existsOrMkdirs) {
        boolean created;
        Intrinsics.checkNotNullParameter((Object)$this$existsOrMkdirs, (String)"<this>");
        if (!$this$existsOrMkdirs.exists() && !(created = $this$existsOrMkdirs.mkdirs())) {
            throw new Exception("Directory " + $this$existsOrMkdirs.getAbsolutePath() + " could not be created! Create this directory manually.");
        }
    }
}

