/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.embedded;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.OnHeapDataset;
import org.jetbrains.kotlinx.dl.impl.util.ByteArrayUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0006\u001a\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\f\u001a!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"FASHION_TEST_IMAGES_ARCHIVE", "", "FASHION_TEST_LABELS_ARCHIVE", "FASHION_TRAIN_IMAGES_ARCHIVE", "FASHION_TRAIN_LABELS_ARCHIVE", "IMAGE_ARCHIVE_MAGIC", "", "LABEL_ARCHIVE_MAGIC", "extractFashionImages", "", "", "archivePath", "(Ljava/lang/String;)[[F", "extractFashionLabels", "numClasses", "(Ljava/lang/String;I)[[F", "dataset"})
@SourceDebugExtension(value={"SMAP\nFashionMnistUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FashionMnistUtil.kt\norg/jetbrains/kotlinx/dl/dataset/embedded/FashionMnistUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class FashionMnistUtilKt {
    private static final int IMAGE_ARCHIVE_MAGIC = 2051;
    private static final int LABEL_ARCHIVE_MAGIC = 2049;
    @NotNull
    public static final String FASHION_TRAIN_IMAGES_ARCHIVE = "datasets/fashionmnist/train-images-idx3-ubyte.gz";
    @NotNull
    public static final String FASHION_TRAIN_LABELS_ARCHIVE = "datasets/fashionmnist/train-labels-idx1-ubyte.gz";
    @NotNull
    public static final String FASHION_TEST_IMAGES_ARCHIVE = "datasets/fashionmnist/t10k-images-idx3-ubyte.gz";
    @NotNull
    public static final String FASHION_TEST_LABELS_ARCHIVE = "datasets/fashionmnist/t10k-labels-idx1-ubyte.gz";

    @NotNull
    public static final float[][] extractFashionImages(@NotNull String archivePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
        DataInputStream archiveStream = new DataInputStream(new GZIPInputStream(OnHeapDataset.class.getClassLoader().getResourceAsStream(archivePath)));
        int magic = archiveStream.readInt();
        if (!(2051 == magic)) {
            boolean $i$a$-require-FashionMnistUtilKt$extractFashionImages$22 = false;
            String $i$a$-require-FashionMnistUtilKt$extractFashionImages$22 = '\"' + archivePath + "\" is not a valid image archive";
            throw new IllegalArgumentException($i$a$-require-FashionMnistUtilKt$extractFashionImages$22.toString());
        }
        int imageCount = archiveStream.readInt();
        int imageRows = archiveStream.readInt();
        int imageCols = archiveStream.readInt();
        String string = "Extracting %d images of %dx%d from %s";
        Object[] objectArray = new Object[]{imageCount, imageRows, imageCols, archivePath};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String string3 = string2;
        System.out.println((Object)string3);
        byte[] imageBuffer = new byte[imageRows * imageCols];
        int n = 0;
        float[][] fArrayArray = new float[imageCount][];
        while (n < imageCount) {
            int n2 = n++;
            archiveStream.readFully(imageBuffer);
            fArrayArray[n2] = ByteArrayUtilKt.toNormalizedVector((byte[])imageBuffer);
        }
        float[][] images = fArrayArray;
        return images;
    }

    @NotNull
    public static final float[][] extractFashionLabels(@NotNull String archivePath, int numClasses) throws IOException {
        Intrinsics.checkNotNullParameter((Object)archivePath, (String)"archivePath");
        DataInputStream archiveStream = new DataInputStream(new GZIPInputStream(OnHeapDataset.class.getClassLoader().getResourceAsStream(archivePath)));
        int magic = archiveStream.readInt();
        if (!(2049 == magic)) {
            boolean $i$a$-require-FashionMnistUtilKt$extractFashionLabels$22 = false;
            String $i$a$-require-FashionMnistUtilKt$extractFashionLabels$22 = '\"' + archivePath + "\" is not a valid image archive";
            throw new IllegalArgumentException($i$a$-require-FashionMnistUtilKt$extractFashionLabels$22.toString());
        }
        int labelCount = archiveStream.readInt();
        String string = "Extracting %d labels from %s";
        Object[] objectArray = new Object[]{labelCount, archivePath};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String $i$a$-require-FashionMnistUtilKt$extractFashionLabels$22 = string2;
        System.out.println((Object)$i$a$-require-FashionMnistUtilKt$extractFashionLabels$22);
        byte[] labelBuffer = new byte[labelCount];
        archiveStream.readFully(labelBuffer);
        int n = 0;
        float[][] fArrayArray = new float[labelCount][];
        while (n < labelCount) {
            int n2 = n++;
            fArrayArray[n2] = OnHeapDataset.Companion.toOneHotVector(numClasses, labelBuffer[n2]);
        }
        float[][] floats = fArrayArray;
        return floats;
    }
}

