/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.generator;

import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.dataset.generator.LabelGenerator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/generator/FromFolders;", "Lorg/jetbrains/kotlinx/dl/dataset/generator/LabelGenerator;", "Ljava/io/File;", "mapping", "", "", "", "(Ljava/util/Map;)V", "getMapping", "()Ljava/util/Map;", "getLabel", "", "dataSource", "dataset"})
public final class FromFolders
implements LabelGenerator<File> {
    @NotNull
    private final Map<String, Integer> mapping;

    public FromFolders(@NotNull Map<String, Integer> mapping) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        this.mapping = mapping;
    }

    @NotNull
    public final Map<String, Integer> getMapping() {
        return this.mapping;
    }

    @Override
    public float getLabel(@NotNull File dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Integer n = this.mapping.get(dataSource.getParentFile().getName());
        if (n == null) {
            throw new IllegalStateException(("The parent directory of " + dataSource.getAbsolutePath() + " is " + dataSource.getParentFile().getName() + ". No such class name in mapping " + this.mapping).toString());
        }
        int label = n;
        return label;
    }
}

