/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dl.dataset.preprocessing;

import java.awt.image.BufferedImage;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dl.api.core.shape.TensorShape;
import org.jetbrains.kotlinx.dl.api.preprocessing.Operation;
import org.jetbrains.kotlinx.dl.dataset.DataLoader;
import org.jetbrains.kotlinx.dl.impl.preprocessing.image.ImageConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u001e\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/dl/dataset/preprocessing/PreprocessingFileDataLoader;", "Lorg/jetbrains/kotlinx/dl/dataset/DataLoader;", "Ljava/io/File;", "preprocessing", "Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;", "Ljava/awt/image/BufferedImage;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlinx/dl/api/core/shape/TensorShape;", "(Lorg/jetbrains/kotlinx/dl/api/preprocessing/Operation;)V", "load", "dataSource", "dataset"})
@SourceDebugExtension(value={"SMAP\nPreprocessingDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreprocessingDataLoader.kt\norg/jetbrains/kotlinx/dl/dataset/preprocessing/PreprocessingFileDataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
final class PreprocessingFileDataLoader
implements DataLoader<File> {
    @NotNull
    private final Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing;

    public PreprocessingFileDataLoader(@NotNull Operation<BufferedImage, Pair<float[], TensorShape>> preprocessing) {
        Intrinsics.checkNotNullParameter(preprocessing, (String)"preprocessing");
        this.preprocessing = preprocessing;
    }

    @Override
    @NotNull
    public Pair<float[], TensorShape> load(@NotNull File dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (!dataSource.exists()) {
            boolean $i$a$-require-PreprocessingFileDataLoader$load$32 = false;
            String $i$a$-require-PreprocessingFileDataLoader$load$32 = "File '" + dataSource + "' does not exist.";
            throw new IllegalArgumentException($i$a$-require-PreprocessingFileDataLoader$load$32.toString());
        }
        if (!dataSource.isFile()) {
            boolean bl = false;
            String string = dataSource.isDirectory() ? "File '" + dataSource + "' is a directory." : "File '" + dataSource + "' is not a normal file.";
            throw new IllegalArgumentException(string.toString());
        }
        return (Pair)this.preprocessing.apply((Object)ImageConverter.INSTANCE.toBufferedImage(dataSource));
    }
}

