/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.common;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.common.ReplCommand;
import org.jetbrains.kotlinx.jupyter.common.ReplEnum;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"replCommandRegex", "Lkotlin/text/Regex;", "assertLooksLikeReplCommand", "", "code", "", "looksLikeReplCommand", "", "replCommandOrNull", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/jupyter/common/ReplCommand;", "common-dependencies"})
@SourceDebugExtension(value={"SMAP\ncommandsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commandsUtil.kt\norg/jetbrains/kotlinx/jupyter/common/CommandsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class CommandsUtilKt {
    private static final Regex replCommandRegex = new Regex("^([\\r\\n\\t ]*\\n)?:([A-Za-z0-9]*)[\\n\\t\\r ]*$");

    public static final boolean looksLikeReplCommand(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return replCommandRegex.matches((CharSequence)code);
    }

    public static final void assertLooksLikeReplCommand(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        boolean bl = CommandsUtilKt.looksLikeReplCommand(code);
        if (!bl) {
            boolean bl2 = false;
            String string = "Code snippet is not a REPL command: " + code;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final Pair<ReplCommand, String> replCommandOrNull(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        CommandsUtilKt.assertLooksLikeReplCommand(code);
        MatchResult matchResult = replCommandRegex.matchEntire((CharSequence)code);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult match = matchResult;
        String commandString = (String)match.getGroupValues().get(2);
        ReplEnum.CodeInsightValue<ReplCommand> codeInsightValue = ReplCommand.Companion.valueOfOrNull(commandString);
        return TuplesKt.to((Object)((Object)(codeInsightValue != null ? codeInsightValue.getValue() : null)), (Object)commandString);
    }
}

