/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.DisplayContainerImpl;
import org.jetbrains.kotlinx.jupyter.DisplayResultWrapper;
import org.jetbrains.kotlinx.jupyter.MutableCodeCell;
import org.jetbrains.kotlinx.jupyter.NotebookImpl;
import org.jetbrains.kotlinx.jupyter.api.CodeCell;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010!\"\u0004\b$\u0010%R\u0012\u0010&\u001a\u00060'j\u0002`(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000e\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlinx/jupyter/CodeCellImpl;", "Lorg/jetbrains/kotlinx/jupyter/MutableCodeCell;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;", "id", "", "internalId", "code", "", "preprocessedCode", "prevCell", "Lorg/jetbrains/kotlinx/jupyter/api/CodeCell;", "(Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;IILjava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/api/CodeCell;)V", "getCode", "()Ljava/lang/String;", "collectedStreamOutput", "displays", "Lorg/jetbrains/kotlinx/jupyter/DisplayContainerImpl;", "getDisplays", "()Lorg/jetbrains/kotlinx/jupyter/DisplayContainerImpl;", "getId", "()I", "getInternalId", "isStreamOutputUpToDate", "", "getNotebook", "()Lorg/jetbrains/kotlinx/jupyter/NotebookImpl;", "getPreprocessedCode", "getPrevCell", "()Lorg/jetbrains/kotlinx/jupyter/api/CodeCell;", "result", "", "getResult", "()Ljava/lang/Object;", "resultVal", "getResultVal", "setResultVal", "(Ljava/lang/Object;)V", "streamBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "streamOutput", "getStreamOutput", "addDisplay", "", "display", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "appendStreamOutput", "output", "kotlin-jupyter-kernel"})
public final class CodeCellImpl
implements MutableCodeCell {
    @NotNull
    private final NotebookImpl notebook;
    private final int id;
    private final int internalId;
    @NotNull
    private final String code;
    @NotNull
    private final String preprocessedCode;
    @Nullable
    private final CodeCell prevCell;
    @Nullable
    private Object resultVal;
    private boolean isStreamOutputUpToDate;
    @NotNull
    private String collectedStreamOutput;
    @NotNull
    private final StringBuilder streamBuilder;
    @NotNull
    private final DisplayContainerImpl displays;

    public CodeCellImpl(@NotNull NotebookImpl notebook2, int id, int internalId, @NotNull String code, @NotNull String preprocessedCode, @Nullable CodeCell prevCell) {
        Intrinsics.checkNotNullParameter((Object)notebook2, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)preprocessedCode, (String)"preprocessedCode");
        this.notebook = notebook2;
        this.id = id;
        this.internalId = internalId;
        this.code = code;
        this.preprocessedCode = preprocessedCode;
        this.prevCell = prevCell;
        this.isStreamOutputUpToDate = true;
        this.collectedStreamOutput = "";
        this.streamBuilder = new StringBuilder();
        this.displays = new DisplayContainerImpl();
    }

    @NotNull
    public NotebookImpl getNotebook() {
        return this.notebook;
    }

    public int getId() {
        return this.id;
    }

    public int getInternalId() {
        return this.internalId;
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @NotNull
    public String getPreprocessedCode() {
        return this.preprocessedCode;
    }

    @Nullable
    public CodeCell getPrevCell() {
        return this.prevCell;
    }

    @Override
    @Nullable
    public Object getResultVal() {
        return this.resultVal;
    }

    @Override
    public void setResultVal(@Nullable Object object) {
        this.resultVal = object;
    }

    @Nullable
    public Object getResult() {
        return this.getResultVal();
    }

    @Override
    public void appendStreamOutput(@NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.isStreamOutputUpToDate = false;
        this.streamBuilder.append(output);
    }

    @NotNull
    public String getStreamOutput() {
        if (!this.isStreamOutputUpToDate) {
            this.isStreamOutputUpToDate = true;
            String string = this.streamBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"streamBuilder.toString()");
            this.collectedStreamOutput = string;
        }
        return this.collectedStreamOutput;
    }

    @Override
    @NotNull
    public DisplayContainerImpl getDisplays() {
        return this.displays;
    }

    @Override
    public void addDisplay(@NotNull DisplayResult display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        DisplayResultWrapper wrapper = DisplayResultWrapper.Companion.create(display, this);
        this.getDisplays().add(wrapper);
        this.getNotebook().getDisplays().add(wrapper);
    }
}

